/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.kdgcsoft.web.core.entity.base.AuditEntity;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.Table;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dromara.x.file.storage.core.FileInfo;

@Schema(name="\u6587\u4ef6\u8868", title="")
@Table(value="base_file")
public class BaseFile
extends AuditEntity {
    public static final String META_DIR_ID = "dirId";
    public static final String META_MODEL_CODE = "modelCode";
    public static final String META_MODEL_PK = "modelPk";
    public static final String META_GROUP = "group";
    @Schema(name="\u6587\u4ef6ID", title="")
    @Id
    private String id;
    @Schema(name="\u6587\u4ef6\u8bbf\u95ee\u5730\u5740", title="")
    private String url;
    @Schema(name="\u6587\u4ef6\u76ee\u5f55ID", title="")
    private String dirId;
    @Schema(name="\u6a21\u578b\u7f16\u7801", title="")
    private String modelCode;
    @Schema(name="\u6a21\u578b\u6570\u636e\u4e3b\u952e", title="")
    private String modelPk;
    @Schema(name="\u6587\u4ef6\u5206\u7ec4", title="")
    private String group;
    @Schema(name="\u6587\u4ef6\u5927\u5c0f(\u5b57\u8282)", title="")
    private Long size;
    @Schema(name="\u6587\u4ef6\u540d", title="")
    private String fileName;
    @Schema(name="\u539f\u59cb\u6587\u4ef6\u540d", title="")
    private String originalFileName;
    @Schema(name="\u57fa\u7840\u5b58\u50a8\u8def\u5f84", title="")
    private String basePath;
    @Schema(name="\u5b58\u50a8\u8def\u5f84", title="")
    private String path;
    @Schema(name="\u6269\u5c55\u540d", title="")
    private String ext;
    @Schema(name="mime\u7c7b\u578b", title="")
    private String contentType;
    @Schema(name="\u5b58\u50a8\u5e73\u53f0", title="")
    private String platform;
    @Schema(name="\u6587\u4ef6\u54c8\u5e0c\u7801", title="")
    private String hashcode;
    @Schema(name="\u6587\u4ef6\u5143\u6570\u636e", title="")
    private String metadata;
    @Schema(name="\u4e0a\u4f20\u65f6\u95f4", title="")
    private Date uploadTime;
    @Schema(name="\u4e0a\u4f20\u4eba", title="")
    private String uploadBy;

    public static BaseFile of(FileInfo fileInfo, Map<String, String> metadata) {
        BaseFile baseFile = new BaseFile();
        baseFile.setId(fileInfo.getId()).setFileName(fileInfo.getFilename()).setOriginalFileName(fileInfo.getOriginalFilename()).setSize(fileInfo.getSize());
        baseFile.setBasePath(fileInfo.getBasePath()).setPath(fileInfo.getPath()).setExt(fileInfo.getExt()).setContentType(fileInfo.getContentType()).setPlatform(fileInfo.getPlatform());
        baseFile.setHashcode(fileInfo.getHashInfo().getMd5());
        baseFile.setUrl(fileInfo.getUrl());
        if (ObjectUtil.isNotEmpty(metadata)) {
            baseFile.setMetadata(JSON.toJSONString(metadata));
            baseFile.setDirId(metadata.get(META_DIR_ID));
            baseFile.setModelCode(metadata.get(META_MODEL_CODE));
            baseFile.setModelPk(metadata.get(META_MODEL_PK));
            baseFile.setGroup(metadata.get(META_GROUP));
        }
        return baseFile;
    }

    public FileInfo toFileInfo() {
        FileInfo fileInfo = (FileInfo)BeanUtil.toBeanIgnoreCase((Object)this, FileInfo.class, (boolean)true);
        if (ObjectUtil.isNotEmpty((Object)fileInfo.getMetadata())) {
            fileInfo.getMetadata().put(META_DIR_ID, this.getDirId());
            fileInfo.getMetadata().put(META_MODEL_CODE, this.getModelCode());
            fileInfo.getMetadata().put(META_MODEL_PK, this.getModelPk());
            fileInfo.getMetadata().put(META_GROUP, this.getGroup());
        }
        return fileInfo;
    }

    public BaseFile setId(String id) {
        this.id = id;
        return this;
    }

    public BaseFile setUrl(String url) {
        this.url = url;
        return this;
    }

    public BaseFile setDirId(String dirId) {
        this.dirId = dirId;
        return this;
    }

    public BaseFile setModelCode(String modelCode) {
        this.modelCode = modelCode;
        return this;
    }

    public BaseFile setModelPk(String modelPk) {
        this.modelPk = modelPk;
        return this;
    }

    public BaseFile setGroup(String group) {
        this.group = group;
        return this;
    }

    public BaseFile setSize(Long size) {
        this.size = size;
        return this;
    }

    public BaseFile setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public BaseFile setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName;
        return this;
    }

    public BaseFile setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public BaseFile setPath(String path) {
        this.path = path;
        return this;
    }

    public BaseFile setExt(String ext) {
        this.ext = ext;
        return this;
    }

    public BaseFile setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public BaseFile setPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public BaseFile setHashcode(String hashcode) {
        this.hashcode = hashcode;
        return this;
    }

    public BaseFile setMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public BaseFile setUploadTime(Date uploadTime) {
        this.uploadTime = uploadTime;
        return this;
    }

    public BaseFile setUploadBy(String uploadBy) {
        this.uploadBy = uploadBy;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDirId() {
        return this.dirId;
    }

    public String getModelCode() {
        return this.modelCode;
    }

    public String getModelPk() {
        return this.modelPk;
    }

    public String getGroup() {
        return this.group;
    }

    public Long getSize() {
        return this.size;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getPath() {
        return this.path;
    }

    public String getExt() {
        return this.ext;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getHashcode() {
        return this.hashcode;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public Date getUploadTime() {
        return this.uploadTime;
    }

    public String getUploadBy() {
        return this.uploadBy;
    }

    public static final class Fields {
        public static final String id = "id";
        public static final String url = "url";
        public static final String dirId = "dirId";
        public static final String modelCode = "modelCode";
        public static final String modelPk = "modelPk";
        public static final String group = "group";
        public static final String size = "size";
        public static final String fileName = "fileName";
        public static final String originalFileName = "originalFileName";
        public static final String basePath = "basePath";
        public static final String path = "path";
        public static final String ext = "ext";
        public static final String contentType = "contentType";
        public static final String platform = "platform";
        public static final String hashcode = "hashcode";
        public static final String metadata = "metadata";
        public static final String uploadTime = "uploadTime";
        public static final String uploadBy = "uploadBy";
    }

    public static class FileMeta {
        private String dirId;
        private String modelCode;
        private String modelPk;
        private String group;

        public static FileMeta of(String dirId) {
            return new FileMeta().setDirId(dirId);
        }

        public static FileMeta of(String dirId, String modelCode, String modelPk) {
            return new FileMeta().setDirId(dirId).setModelCode(modelCode).setModelPk(modelPk);
        }

        public static FileMeta of(String modelCode, String modelPk) {
            return new FileMeta().setModelCode(modelCode).setModelPk(modelPk);
        }

        public Map<String, String> toMetaData() {
            Map map = BeanUtil.beanToMap((Object)this, (boolean)false, (boolean)true);
            LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
            map.forEach((k, v) -> {
                if (v != null) {
                    metadata.put((String)k, v.toString());
                }
            });
            return metadata;
        }

        public String getDirId() {
            return this.dirId;
        }

        public String getModelCode() {
            return this.modelCode;
        }

        public String getModelPk() {
            return this.modelPk;
        }

        public String getGroup() {
            return this.group;
        }

        public FileMeta setDirId(String dirId) {
            this.dirId = dirId;
            return this;
        }

        public FileMeta setModelCode(String modelCode) {
            this.modelCode = modelCode;
            return this;
        }

        public FileMeta setModelPk(String modelPk) {
            this.modelPk = modelPk;
            return this;
        }

        public FileMeta setGroup(String group) {
            this.group = group;
            return this;
        }
    }
}

