/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.entity;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.fhs.core.trans.anno.Trans;
import com.kdgcsoft.web.core.entity.BaseDictItem;
import com.kdgcsoft.web.core.entity.base.AuditEntity;
import com.kdgcsoft.web.core.enums.DictType;
import com.kdgcsoft.web.core.enums.YesNo;
import com.kdgcsoft.web.core.pojo.ScannedDict;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.RelationOneToMany;
import com.mybatisflex.annotation.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Table(value="base_dict")
public class BaseDict
extends AuditEntity {
    @Id
    private String id;
    private String dictName;
    private String dictCode;
    private String description;
    @Trans(type="dictionary", key="DictType")
    private DictType dictType;
    @Trans(type="dictionary", key="YesNo")
    private YesNo embed;
    @RelationOneToMany(selfField="dictCode", targetField="dictCode", orderBy="order_no")
    private List<BaseDictItem> items;

    public BaseDictItem addItem(String dictCode, String value, String text, Integer orderNo) {
        if (this.items == null) {
            this.items = new ArrayList<BaseDictItem>();
        }
        BaseDictItem item = new BaseDictItem(dictCode, value, text, orderNo);
        this.items.add(item);
        return item;
    }

    public BaseDict updateByScannedDict(ScannedDict scannedDict) {
        this.setDictCode(scannedDict.getCode()).setDictType(DictType.LIST).setEmbed(YesNo.Y).setDictName(scannedDict.getName()).setDescription(scannedDict.getDescription());
        this.items = new ArrayList<BaseDictItem>();
        CollUtil.forEach(scannedDict.getItems(), (CollUtil.Consumer & Serializable)(item, index) -> this.addItem(scannedDict.getCode(), item.getValue(), item.getText(), index));
        return this;
    }

    public boolean equalTo(ScannedDict scannedDict) {
        ArrayList itemsList1 = new ArrayList();
        CollUtil.forEach(this.items, (CollUtil.Consumer & Serializable)(item, index) -> itemsList1.add(StrUtil.join((CharSequence)",", (Object[])new Object[]{item.getValue(), item.getLabel()})));
        ArrayList itemsList2 = new ArrayList();
        CollUtil.forEach(scannedDict.getItems(), (CollUtil.Consumer & Serializable)(item, index) -> itemsList2.add(StrUtil.join((CharSequence)",", (Object[])new Object[]{item.getValue(), item.getText()})));
        return StrUtil.equals((CharSequence)this.dictName, (CharSequence)scannedDict.getName()) && StrUtil.equals((CharSequence)this.dictCode, (CharSequence)scannedDict.getCode()) && StrUtil.equals((CharSequence)this.embed.name(), (CharSequence)YesNo.Y.name()) && StrUtil.equals((CharSequence)this.description, (CharSequence)scannedDict.getDescription()) && CollUtil.disjunction(itemsList1, itemsList2).isEmpty();
    }

    public static BaseDict buildWith(ScannedDict scannedDict) {
        BaseDict baseDict = new BaseDict();
        baseDict.setDictCode(scannedDict.getCode()).setDictType(DictType.LIST).setEmbed(YesNo.Y).setDictName(scannedDict.getName()).setDescription(scannedDict.getDescription());
        CollUtil.forEach(scannedDict.getItems(), (CollUtil.Consumer & Serializable)(item, index) -> baseDict.addItem(scannedDict.getCode(), item.getValue(), item.getText(), index));
        return baseDict;
    }

    public String getId() {
        return this.id;
    }

    public String getDictName() {
        return this.dictName;
    }

    public String getDictCode() {
        return this.dictCode;
    }

    public String getDescription() {
        return this.description;
    }

    public DictType getDictType() {
        return this.dictType;
    }

    public YesNo getEmbed() {
        return this.embed;
    }

    public List<BaseDictItem> getItems() {
        return this.items;
    }

    public BaseDict setId(String id) {
        this.id = id;
        return this;
    }

    public BaseDict setDictName(String dictName) {
        this.dictName = dictName;
        return this;
    }

    public BaseDict setDictCode(String dictCode) {
        this.dictCode = dictCode;
        return this;
    }

    public BaseDict setDescription(String description) {
        this.description = description;
        return this;
    }

    public BaseDict setDictType(DictType dictType) {
        this.dictType = dictType;
        return this;
    }

    public BaseDict setEmbed(YesNo embed) {
        this.embed = embed;
        return this;
    }

    public BaseDict setItems(List<BaseDictItem> items) {
        this.items = items;
        return this;
    }

    public static final class Fields {
        public static final String id = "id";
        public static final String dictName = "dictName";
        public static final String dictCode = "dictCode";
        public static final String description = "description";
        public static final String dictType = "dictType";
        public static final String embed = "embed";
        public static final String items = "items";
    }
}

