/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.controller;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.core.controller.BaseController;
import com.kdgcsoft.web.core.entity.BaseUser;
import com.kdgcsoft.web.core.pojo.Result;
import com.kdgcsoft.web.core.service.BaseUserService;
import com.mybatisflex.core.paginate.Page;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7528\u6237\u7ba1\u7406")
@RestController
@Validated
@RequestMapping(value={"/base/user"})
public class BaseUserController
extends BaseController {
    @Autowired
    BaseUserService userService;

    @Operation(summary="\u6839\u636e\u89d2\u8272id\u83b7\u53d6\u89d2\u8272\u7528\u6237\u5217\u8868,\u5206\u9875")
    @GetMapping(value={"/pageByRole"})
    public Page<BaseUser> pageByRole(PageRequest<BaseUser> page, String roleId, String searchKey) {
        if (StrUtil.isBlank((CharSequence)roleId)) {
            return null;
        }
        return this.userService.pageByRole(page, roleId, searchKey);
    }

    @Operation(summary="\u6839\u636e\u5c97\u4f4did\u83b7\u53d6\u5c97\u4f4d\u7528\u6237\u5217\u8868,\u5206\u9875")
    @GetMapping(value={"/pageByPosition"})
    public Page<BaseUser> pageByPosition(PageRequest<BaseUser> page, String positionId, String searchKey) {
        if (StrUtil.isBlank((CharSequence)positionId)) {
            return null;
        }
        return this.userService.pageByPosition(page, positionId, searchKey);
    }

    @Operation(summary="\u6839\u636e\u89d2\u8272id\u83b7\u53d6\u975e\u8be5\u89d2\u8272\u7684\u7528\u6237\u5217\u8868,\u5206\u9875")
    @GetMapping(value={"/pageNotExistRole"})
    public Page<BaseUser> pageNotExistRole(PageRequest<BaseUser> page, String orgId, String roleId, String searchKey) {
        return this.userService.pageNotExistRole(page, orgId, roleId, searchKey);
    }

    @Operation(summary="\u6839\u636e\u5c97\u4f4did\u83b7\u53d6\u975e\u8be5\u5c97\u4f4d\u7684\u7528\u6237\u5217\u8868,\u5206\u9875")
    @GetMapping(value={"/pageNotExistPosition"})
    public Page<BaseUser> pageNotExistPosition(PageRequest<BaseUser> page, String orgId, String positionId, String searchKey) {
        return this.userService.pageNotExistPosition(page, orgId, positionId, searchKey);
    }

    @Operation(summary="\u91cd\u7f6e\u5bc6\u7801")
    @GetMapping(value={"/resetPassword"})
    public Result resetPassword(@RequestParam(value="userId", required=true) String userId) {
        return Result.OK(this.userService.resetPassword(userId));
    }

    @Operation(summary="\u4fee\u6539\u5bc6\u7801")
    @GetMapping(value={"/updatePassword"})
    public Result updatePassword(@RequestParam(value="userId", required=true) @NotNull(message="\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a") String userId, @RequestParam(value="oldPwd", required=true) @NotNull(message="\u539f\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u539f\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String oldPwd, @RequestParam(value="newPwd", required=true) @NotNull(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String newPwd) throws Exception {
        return this.userService.updatePassword(userId, oldPwd, newPwd);
    }
}

