/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.controller;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.core.controller.BaseController;
import com.kdgcsoft.web.core.entity.BaseJob;
import com.kdgcsoft.web.core.entity.BaseJobLog;
import com.kdgcsoft.web.core.enums.JobLogStatus;
import com.kdgcsoft.web.core.enums.JobStatus;
import com.kdgcsoft.web.core.pojo.Result;
import com.kdgcsoft.web.core.service.BaseJobLogService;
import com.kdgcsoft.web.core.service.BaseJobService;
import com.mybatisflex.core.paginate.Page;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="\u5b9a\u65f6\u4efb\u52a1\u7ba1\u7406")
@RestController
@RequestMapping(value={"/base/baseJob"})
@Validated
public class BaseJobController
extends BaseController {
    @Autowired
    private BaseJobService jobService;
    @Autowired
    private BaseJobLogService jobLogService;

    @Operation(summary="\u6839\u636eID\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1")
    @RequestMapping(value={"/getJobById"}, method={RequestMethod.GET})
    public Result<?> getJobById(@NotNull(message="jobId\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="jobId\u4e0d\u80fd\u4e3a\u7a7a") String jobId) {
        try {
            BaseJob job = (BaseJob)this.jobService.getById((Serializable)((Object)jobId));
            return Result.OK("\u5b9a\u65f6\u4efb\u52a1\u67e5\u8be2\u6210\u529f", job);
        }
        catch (Exception e) {
            return Result.ERROR("\u5b9a\u65f6\u4efb\u52a1\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"/page"})
    public Result<?> pageQuery(PageRequest<BaseJob> pageRequest, JobStatus jobStatus, String search) {
        try {
            Page<BaseJob> r = this.jobService.pageJob(pageRequest, jobStatus, search);
            return Result.OK("\u5b9a\u65f6\u4efb\u52a1\u5206\u9875\u67e5\u8be2\u6210\u529f", r);
        }
        catch (Exception e) {
            return Result.ERROR("\u5b9a\u65f6\u4efb\u52a1\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage());
        }
    }

    @Operation(summary="\u4fdd\u5b58\u5b9a\u65f6\u4efb\u52a1")
    @RequestMapping(value={"/save"})
    public Result<?> save(@RequestBody BaseJob baseJob) {
        try {
            this.jobService.saveJob(baseJob);
            return Result.OK("\u5b9a\u65f6\u4efb\u52a1\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            return Result.ERROR("\u5b9a\u65f6\u4efb\u52a1\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage());
        }
    }

    @Operation(summary="\u5220\u9664\u5b9a\u65f6\u4efb\u52a1")
    @RequestMapping(value={"/delete"})
    public Result<?> delete(@NotNull(message="jobId\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="jobId\u4e0d\u80fd\u4e3a\u7a7a") String jobId) {
        try {
            this.jobService.delete(jobId);
            return Result.OK("\u5b9a\u65f6\u4efb\u52a1\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return Result.ERROR("\u5b9a\u65f6\u4efb\u52a1\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage());
        }
    }

    @Operation(summary="\u67e5\u8be2\u5185\u7f6e\u5b9a\u65f6\u4efb\u52a1\u7c7b")
    @RequestMapping(value={"/queryJavaClasses"})
    public Result<?> queryJavaClasses() {
        try {
            List<JSONObject> classes = this.jobService.getJavaClasses();
            return Result.OK("\u5185\u7f6e\u5b9a\u65f6\u4efb\u52a1\u7c7b\u67e5\u8be2\u6210\u529f", classes);
        }
        catch (Exception e) {
            return Result.ERROR("\u5185\u7f6e\u5b9a\u65f6\u4efb\u52a1\u7c7b\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage());
        }
    }

    @Operation(summary="\u6539\u53d8\u4efb\u52a1\u72b6\u6001")
    @RequestMapping(value={"/changeJobStatus"})
    public Result<?> changeJobStatus(@NotNull(message="jobId\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="jobId\u4e0d\u80fd\u4e3a\u7a7a") String jobId) {
        try {
            BaseJob job = this.jobService.changeJobStatus(jobId);
            return Result.OK("\u4efb\u52a1" + job.getJobStatus().text() + "\u6210\u529f");
        }
        catch (Exception e) {
            return Result.ERROR("\u6539\u53d8\u4efb\u52a1\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage());
        }
    }

    @Operation(summary="\u6539\u53d8\u542f\u7528\u72b6\u6001")
    @RequestMapping(value={"/changeJobEnabled"})
    public Result<?> changeJobEnabled(@NotNull(message="jobId\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="jobId\u4e0d\u80fd\u4e3a\u7a7a") String jobId) {
        try {
            this.jobService.changeJobEnabled(jobId);
            return Result.OK("\u6539\u53d8\u542f\u7528\u72b6\u6001\u6210\u529f");
        }
        catch (Exception e) {
            return Result.ERROR("\u6539\u53d8\u542f\u7528\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage());
        }
    }

    @Operation(summary="\u7acb\u5373\u6267\u884c")
    @RequestMapping(value={"/executeOnce"})
    public Result<?> executeOnce(@NotNull(message="jobId\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="jobId\u4e0d\u80fd\u4e3a\u7a7a") String jobId) {
        try {
            this.jobService.executeOnce(jobId);
            return Result.OK("\u6539\u53d8\u542f\u7528\u72b6\u6001\u6210\u529f");
        }
        catch (Exception e) {
            return Result.ERROR("\u6539\u53d8\u542f\u7528\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage());
        }
    }

    @Operation(summary="\u5206\u9875\u67e5\u8be2\u4efb\u52a1\u8fd0\u884c\u8bb0\u5f55")
    @RequestMapping(value={"/pageRunLog"})
    public Result<?> pageRunLog(PageRequest<BaseJobLog> pageRequest, String jobId, JobLogStatus jobLogStatus) {
        try {
            Page<BaseJobLog> r = this.jobLogService.pageJobLog(pageRequest, jobId, jobLogStatus);
            return Result.OK("\u5b9a\u65f6\u4efb\u52a1\u8fd0\u884c\u8bb0\u5f55\u5206\u9875\u67e5\u8be2\u6210\u529f", r);
        }
        catch (Exception e) {
            return Result.ERROR("\u5b9a\u65f6\u4efb\u52a1\u8fd0\u884c\u8bb0\u5f55\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"/index"}, method={RequestMethod.GET})
    public ModelAndView index() {
        return this.view("base/baseJob.html");
    }

    @RequestMapping(value={"/form"}, method={RequestMethod.GET})
    public ModelAndView form() {
        return this.view("base/baseJob_form.html");
    }

    @RequestMapping(value={"/hisLog"}, method={RequestMethod.GET})
    public ModelAndView hisLog() {
        return this.view("base/baseJobLog.html");
    }

    @RequestMapping(value={"/jobLogErrorInfo"}, method={RequestMethod.GET})
    public ModelAndView jobLogErrorInfo(Long id) {
        BaseJobLog log = (BaseJobLog)this.jobLogService.getById(id);
        return this.view("base/basejob_errorinfo.html", (Map<String, Object>)MapUtil.of((Object)"joblog", (Object)log));
    }
}

