/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.controller;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.core.controller.BaseController;
import com.kdgcsoft.web.core.service.BaseFileService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import org.dromara.x.file.storage.core.FileInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u6587\u4ef6\u7ba1\u7406")
@Validated
@RestController
@RequestMapping(value={"/file"})
public class BaseFileController
extends BaseController {
    @Autowired
    private BaseFileService fileService;

    @Operation(summary="\u6587\u4ef6\u4e0a\u4f20", description="\u4f20\u5165fileId\u4f1a\u8fdb\u884c\u6587\u4ef6\u66ff\u6362")
    @PostMapping(value={"/upload"})
    public FileInfo upload(MultipartFile file, String fileId, String dirId, String modelCode, String modelPk, String group) {
        HashMap metadata = MapUtil.of((Object)"dirId", (Object)dirId);
        metadata.put("modelCode", modelCode);
        metadata.put("modelPk", modelPk);
        metadata.put("group", group);
        return this.fileService.upload(file, fileId, metadata);
    }

    @Operation(summary="\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/download"})
    public void download(@RequestParam(required=false) String fileId, @RequestParam(required=false) String url, HttpServletResponse resp) {
        if (fileId == null && url == null) {
            throw new IllegalArgumentException("'fileId'\u548c'url' \u81f3\u5c11\u63d0\u4f9b\u5176\u4e2d\u4e00\u4e2a!");
        }
        this.fileService.download(fileId, url, resp);
    }

    @Operation(summary="\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/download/{fileName}"})
    public void downloadByFileName(@PathVariable(name="fileName") @NotBlank(message="\u7f3a\u5c11\u6587\u4ef6\u540d") @NotBlank(message="\u7f3a\u5c11\u6587\u4ef6\u540d") String fileName, HttpServletResponse resp) {
        if (StrUtil.isNotBlank((CharSequence)fileName)) {
            this.fileService.downloadByFileName(fileName, resp);
        }
    }

    @Operation(summary="\u6587\u4ef6\u5220\u9664")
    @GetMapping(value={"/delete/{fileName}"})
    public void deleteByFileName(@PathVariable(name="fileName") String fileName) {
        if (StrUtil.isNotBlank((CharSequence)fileName)) {
            this.fileService.deleteByFileName(fileName);
        }
    }
}

