/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.controller;

import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.core.anno.AuditLog;
import com.kdgcsoft.web.core.controller.BaseController;
import com.kdgcsoft.web.core.entity.BaseDict;
import com.kdgcsoft.web.core.entity.BaseDictItem;
import com.kdgcsoft.web.core.enums.AuditLogType;
import com.kdgcsoft.web.core.enums.YesNo;
import com.kdgcsoft.web.core.service.BaseDictService;
import com.mybatisflex.core.paginate.Page;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5b57\u5178\u7ba1\u7406")
@RestController
@Validated
@RequestMapping(value={"/base/dict"})
public class BaseDictController
extends BaseController {
    @Resource
    BaseDictService dictService;

    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u5b57\u5178\u7684\u5b57\u5178\u9879")
    @GetMapping(value={"/items"})
    public List<BaseDictItem> getDictItems(@NotBlank(message="\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String dictCode) {
        BaseDict baseDict = this.dictService.findByCode(dictCode);
        return baseDict == null ? Collections.emptyList() : baseDict.getItems();
    }

    @Operation(summary="\u83b7\u53d6\u6240\u6709\u5b57\u5178\u5217\u8868")
    @GetMapping(value={"/list"})
    public List<BaseDict> dictList() {
        return this.dictService.listDict();
    }

    @Operation(summary="\u83b7\u53d6\u5b57\u5178\u4fe1\u606f(\u5305\u542b\u5b57\u5178\u9879)")
    @GetMapping(value={"/getByCode"})
    public BaseDict getByCode(@NotBlank(message="\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String dictCode) {
        return this.dictService.findByCode(dictCode);
    }

    @Operation(summary="\u83b7\u53d6\u5b57\u5178\u4fe1\u606f(\u5305\u542b\u5b57\u5178\u9879)")
    @GetMapping(value={"/getById"})
    public BaseDict getById(@NotBlank(message="\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String id) {
        return this.dictService.findById(id);
    }

    @Operation(summary="\u83b7\u53d6\u5b57\u5178\u5217\u8868,\u5206\u9875")
    @GetMapping(value={"/page"})
    public Page<BaseDict> page(PageRequest<BaseDict> page, YesNo embed, String searchKey) {
        return this.dictService.pageDict(page, embed, searchKey);
    }

    @Operation(summary="\u4fdd\u5b58\u5b57\u5178", description="\u4fdd\u5b58\u5b57\u5178\u4fe1\u606f(\u5305\u542b\u5b57\u5178\u9879)")
    @PostMapping(value={"/save"})
    public BaseDict save(@RequestBody @Validated BaseDict entity) {
        return this.dictService.saveDict(entity);
    }

    @AuditLog(type=AuditLogType.DELETE, title="\u6839\u636e\u7f16\u7801\u5220\u9664\u5b57\u5178")
    @Operation(summary="\u5220\u9664\u5b57\u5178(\u5305\u542b\u5b57\u5178\u9879)")
    @GetMapping(value={"/deleteByCode"})
    public void delDictByCode(@Parameter(name="\u5b57\u5178\u7f16\u7801", required=true) @NotBlank(message="\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a") String dictCode) {
        this.dictService.deleteByCode(dictCode);
    }

    @AuditLog(type=AuditLogType.DELETE, title="\u5220\u9664id\u4e3a{id}\u7684\u5b57\u5178")
    @Operation(summary="\u5220\u9664\u5b57\u5178(\u5305\u542b\u5b57\u5178\u9879)")
    @GetMapping(value={"/deleteById"})
    public void deleteById(@Parameter(name="\u5b57\u5178ID", required=true) @NotBlank(message="\u5b57\u5178ID\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u5b57\u5178ID\u4e0d\u80fd\u4e3a\u7a7a") String id) {
        this.dictService.deleteById(id);
    }
}

