/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.controller;

import com.kdgcsoft.web.core.pojo.CacheTreeNode;
import com.kdgcsoft.web.core.pojo.Result;
import com.kdgcsoft.web.core.service.BaseCacheMonitorService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7f13\u5b58\u76d1\u63a7")
@RestController
@Validated
@RequestMapping(value={"/base/baseCacheMonitor"})
public class BaseCacheMonitorController {
    @Resource
    private BaseCacheMonitorService cacheService;

    @Operation(summary="\u83b7\u53d6\u7f13\u5b58\u6811\u5f62\u5217\u8868", description="\u8fd4\u56de\u6811\u5f62\u683c\u5f0f\u7684\u7f13\u5b58\u5217\u8868,\u4e24\u5c42\u7ed3\u6784,\u7b2c\u4e00\u5c42\u4e3a\u7f13\u5b58\u540d\u79f0,\u7b2c\u4e8c\u5c42\u4e3a\u7f13\u5b58key")
    @GetMapping(value={"/treeCache"})
    public List<CacheTreeNode> treeCache() {
        return this.cacheService.treeCache();
    }

    @Operation(summary="\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9", description="\u6839\u636e\u6307\u5b9a\u7f13\u5b58\u540d\u548ckey\u83b7\u53d6\u7f13\u5b58\u5185\u5bb9")
    @GetMapping(value={"/getCacheInfo"})
    public Result getCacheInfo(@NotBlank(message="\u7f13\u5b58\u540d\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7f13\u5b58\u540d\u4e0d\u80fd\u4e3a\u7a7a") String cacheName, String cacheKey) {
        return Result.OK(this.cacheService.getCacheInfo(cacheName, cacheKey));
    }

    @Operation(summary="\u6e05\u9664\u6307\u5b9a\u7f13\u5b58", description="\u6839\u636e\u7f13\u5b58\u540d\u79f0\u548c\u7f13\u5b58key\u6e05\u9664\u7f13\u5b58,\u5982\u679c\u672a\u6307\u5b9a\u7f13\u5b58key,\u5c06\u6e05\u9664\u7f13\u5b58\u540d\u79f0\u4e0b\u7684\u6240\u6709\u7f13\u5b58")
    @GetMapping(value={"/clearCache"})
    public void clearCache(@NotBlank(message="\u7f13\u5b58\u540d\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7f13\u5b58\u540d\u4e0d\u80fd\u4e3a\u7a7a") String cacheName, String cacheKey) {
        this.cacheService.clearCache(cacheName, cacheKey);
    }

    @Operation(summary="\u6e05\u9664\u6240\u6709\u7f13\u5b58")
    @GetMapping(value={"/clearAllCache"})
    public void clearAllCache() {
        this.cacheService.clearAllCache();
    }
}

