/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.aspect;

import com.kdgcsoft.web.core.aspect.AuditLogHandler;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AuditLogAspect {
    private static final Logger log = LoggerFactory.getLogger(AuditLogAspect.class);

    @Pointcut(value="@annotation(com.kdgcsoft.web.core.anno.AuditLog)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint joinPoint) {
        AuditLogHandler logHandler = new AuditLogHandler(joinPoint);
        try {
            logHandler.begin();
            Object result = joinPoint.proceed();
            logHandler.end(result);
            return result;
        }
        catch (Throwable e) {
            logHandler.end(e);
            log.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }
}

