/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.core.advice;

import cn.dev33.satoken.exception.DisableServiceException;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.core.pojo.Result;
import com.kdgcsoft.web.core.util.ServletContextUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.servlet.NoHandlerFoundException;

public class GlobalExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionResolver.class);
    public static List<ExceptionResolver> resolverList = new ArrayList<ExceptionResolver>();

    public static void addResolver(ExceptionResolver exceptionResolver) {
        resolverList.add(0, exceptionResolver);
    }

    public static Result resolveException(Throwable e) {
        ExceptionResolver exceptionResolver = (ExceptionResolver)CollUtil.findOne(resolverList, exceptionResolver1 -> exceptionResolver1.support(e));
        if (exceptionResolver != null) {
            return exceptionResolver.resolveMessage(e);
        }
        log.info("\u672a\u5339\u914d\u5230\u5f02\u5e38\u89e3\u6790\u5668,\u8fd4\u56de\u539f\u751f\u5f02\u5e38\u4fe1\u606f");
        return Result.ERROR(e.getMessage());
    }

    static {
        GlobalExceptionResolver.addResolver(new CommonExceptionResolver());
        GlobalExceptionResolver.addResolver(new AuthExceptionResolver());
        GlobalExceptionResolver.addResolver(new SQLExceptionResolver());
    }

    public static class CommonExceptionResolver
    implements ExceptionResolver {
        @Override
        public boolean support(Throwable e) {
            return true;
        }

        @Override
        public Result resolveMessage(Throwable throwable) {
            Throwable t = ExceptionUtil.getRootCause((Throwable)throwable);
            Result result = Result.ERROR(t.getMessage());
            Object message = t.getMessage();
            if (t instanceof NullPointerException) {
                message = "\u7a7a\u5bf9\u8c61\u8c03\u7528";
            } else if (t instanceof NumberFormatException) {
                message = "\u6570\u5b57\u683c\u5f0f\u5316\u5f02\u5e38:" + t.getMessage();
            } else if (t instanceof ArrayIndexOutOfBoundsException) {
                message = "\u6570\u7ec4\u4e0b\u6807\u8d8a\u754c:" + t.getMessage();
            } else if (t instanceof ArithmeticException) {
                message = "\u7b97\u672f\u903b\u8f91\u51fa\u9519:" + t.getMessage();
            } else if (t instanceof ClassCastException) {
                message = "\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38:" + t.getMessage();
            } else if (t instanceof IllegalArgumentException) {
                message = t.getMessage();
            } else if (t instanceof HttpRequestMethodNotSupportedException) {
                HttpRequestMethodNotSupportedException e = (HttpRequestMethodNotSupportedException)t;
                message = "\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f:" + e.getMethod();
            } else if (t instanceof HttpMediaTypeNotSupportedException) {
                HttpMediaTypeNotSupportedException e = (HttpMediaTypeNotSupportedException)t;
                message = "\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u5185\u5bb9\u7c7b\u578b:" + Convert.toStr((Object)e.getContentType());
            } else if (t instanceof ConstraintViolationException) {
                ConstraintViolationException e = (ConstraintViolationException)t;
                List messageList = e.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
                message = CollUtil.join(messageList, (CharSequence)",");
                result.setCode(400);
            } else if (t instanceof BindException) {
                BindException e = (BindException)t;
                List messageList = e.getBindingResult().getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
                message = "\u6821\u9a8c\u5931\u8d25:" + CollUtil.join(messageList, (CharSequence)",");
                result.setCode(400);
            } else if (t instanceof NoHandlerFoundException) {
                NoHandlerFoundException e = (NoHandlerFoundException)t;
                message = "\u8bf7\u6c42\u8d44\u6e90\u4e0d\u5b58\u5728:" + e.getRequestURL();
                result.setCode(404);
            }
            result.setMsg((String)message);
            return result;
        }
    }

    public static class SQLExceptionResolver
    implements ExceptionResolver {
        private static Class[] supports = new Class[]{SQLException.class, BadSqlGrammarException.class};

        @Override
        public boolean support(Throwable e) {
            return Arrays.stream(supports).anyMatch(clz -> clz.isAssignableFrom(e.getClass()));
        }

        @Override
        public Result resolveMessage(Throwable t) {
            Result result = Result.ERROR(t.getMessage());
            if (t instanceof SQLException) {
                SQLException sqlException = (SQLException)t;
                sqlException.getSQLState();
                result.setMsg("SQL\u5f02\u5e38:" + sqlException.getSQLState());
            } else if (t instanceof BadSqlGrammarException) {
                BadSqlGrammarException badSqlGrammarException = (BadSqlGrammarException)t;
                result.setMsg("SQL\u8bed\u6cd5\u5f02\u5e38:" + badSqlGrammarException.getSQLException().getMessage());
            }
            return result;
        }
    }

    public static class AuthExceptionResolver
    implements ExceptionResolver {
        private static Class[] supports = new Class[]{SaTokenException.class};

        @Override
        public boolean support(Throwable e) {
            return Arrays.stream(supports).anyMatch(clz -> clz.isAssignableFrom(e.getClass()));
        }

        @Override
        public Result resolveMessage(Throwable t) {
            Result result = Result.ERROR(t.getMessage());
            if (t instanceof NotLoginException) {
                result.setMsg("\u4f1a\u8bdd\u8fc7\u671f,\u8bf7\u91cd\u65b0\u767b\u5f55");
                result.setCode(401);
            } else if (t instanceof NotRoleException) {
                NotRoleException notRoleException = (NotRoleException)t;
                result.setMsg(StrUtil.format((CharSequence)"\u6743\u9650\u4e0d\u8db3:\u7f3a\u5c11\u89d2\u8272[{}],\u5730\u5740:{}", (Object[])new Object[]{notRoleException.getRole(), ServletContextUtil.getRequest().getServletPath()}));
                result.setCode(403);
            } else if (t instanceof NotPermissionException) {
                NotPermissionException notPermissionException = (NotPermissionException)t;
                result.setMsg(StrUtil.format((CharSequence)"\u6743\u9650\u4e0d\u8db3\uff1a\u7f3a\u5c11\u6743\u9650[{}],\u5730\u5740:{}", (Object[])new Object[]{notPermissionException.getPermission(), ServletContextUtil.getRequest().getServletPath()}));
                result.setCode(403);
            } else if (t instanceof DisableServiceException) {
                DisableServiceException disableServiceException = (DisableServiceException)t;
                result.setMsg("\u8d26\u53f7\u51bb\u7ed3\uff1a" + disableServiceException.getDisableTime() + "\u79d2\u540e\u89e3\u5c01").setCode(403);
            }
            return result;
        }
    }

    public static interface ExceptionResolver {
        public boolean support(Throwable var1);

        public Result resolveMessage(Throwable var1);
    }
}

