/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.config.security;

import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.convert.Convert;
import com.kdgcsoft.web.config.security.interfaces.AuthUser;
import com.kdgcsoft.web.config.security.interfaces.AuthUserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtil {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtil.class);

    public static SaSession setUser(AuthUserInfo authUserInfo) {
        SaSession session = StpUtil.getTokenSession();
        session.set("LOGIN_USER", (Object)authUserInfo);
        return session;
    }

    public static AuthUserInfo getUser() {
        try {
            Object o = StpUtil.getTokenSession().get("LOGIN_USER");
            return o == null ? null : (AuthUserInfo)Convert.convert(AuthUserInfo.class, (Object)o);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getUserName() {
        AuthUserInfo authUserInfo = SecurityUtil.getUser();
        return authUserInfo != null ? authUserInfo.getAuthUser().getUserName() : null;
    }

    public static boolean isRoot() {
        AuthUserInfo authUserInfo = SecurityUtil.getUser();
        return authUserInfo != null && authUserInfo.getAuthUser().getAccountType().equals((Object)AuthUser.AccountType.ROOT);
    }

    public static <T extends AuthUserInfo> T getUser(Class<T> clazz) {
        AuthUserInfo authUserInfo = SecurityUtil.getUser();
        return (T)(authUserInfo == null ? null : (AuthUserInfo)Convert.convert(clazz, (Object)authUserInfo));
    }

    public static String getUserId() {
        AuthUserInfo authUserInfo = SecurityUtil.getUser();
        return authUserInfo == null ? null : authUserInfo.getAuthUser().getUserId();
    }

    public static String getUserIdWithDefault() {
        AuthUserInfo authUserInfo = SecurityUtil.getUser();
        return authUserInfo == null ? "0" : authUserInfo.getAuthUser().getUserId();
    }

    public static String getUserOrgId() {
        AuthUserInfo authUserInfo = SecurityUtil.getUser();
        return authUserInfo == null ? null : authUserInfo.getAuthUser().getOrgId();
    }

    public static String getUserDeptId() {
        AuthUserInfo authUserInfo = SecurityUtil.getUser();
        return authUserInfo == null ? null : authUserInfo.getAuthUser().getDeptId();
    }
}

