/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.config.mybatisflex.collector;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.core.util.ServletContextUtil;
import com.mybatisflex.core.audit.AuditMessage;
import com.mybatisflex.core.audit.MessageCollector;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerMessageCollector
implements MessageCollector {
    private static final Logger log = LoggerFactory.getLogger(LoggerMessageCollector.class);
    private boolean logSql = false;

    public LoggerMessageCollector() {
    }

    public LoggerMessageCollector(boolean logSql) {
        this.logSql = logSql;
    }

    public void collect(AuditMessage message) {
        String caller = this.getSqlCaller();
        String url = ServletContextUtil.getRequest() == null ? "" : ServletContextUtil.getRequest().getServletPath();
        StringBuffer sb = new StringBuffer();
        sb.append("\r\n");
        sb.append("\u250f\u2501 ").append(StrUtil.fillAfter((String)caller, (char)'\u2501', (int)150)).append("\r\n");
        sb.append("\u2503  ").append(message.getFullSql()).append("\r\n");
        sb.append("\u2503  ").append(StrUtil.format((CharSequence)"params:[{}]", (Object[])new Object[]{CollUtil.join((Iterable)message.getQueryParams(), (CharSequence)",")})).append("\r\n");
        sb.append("\u2517\u2501 ");
        sb.append(StrUtil.fillAfter((String)StrUtil.format((CharSequence)"queryCount:{} ", (Object[])new Object[]{message.getQueryCount()}), (char)'\u2501', (int)80));
        sb.append(StrUtil.fillAfter((String)StrUtil.format((CharSequence)" url:{},time:{}ms. ", (Object[])new Object[]{url, message.getElapsedTime()}), (char)'\u2501', (int)70));
        sb.append("\r\n");
        if (this.logSql) {
            log.info(sb.toString());
        } else {
            System.err.println(sb);
        }
    }

    private String getSqlCaller() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement traceElement = (StackTraceElement)CollUtil.findOne(List.of(stackTraceElements), trace -> trace.getClassName().startsWith("com.kdgcsoft") && !trace.getClassName().equals(LoggerMessageCollector.class.getName()));
        if (traceElement != null) {
            return StrUtil.format((CharSequence)"{}.{}:{} ", (Object[])new Object[]{ClassUtil.getShortClassName((String)traceElement.getClassName()), traceElement.getMethodName(), traceElement.getLineNumber()});
        }
        return "\u672a\u77e5\u8c03\u7528";
    }
}

