/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.config.mybatisflex;

import com.kdgcsoft.web.config.BootProperties;
import com.kdgcsoft.web.config.mvc.resolver.PageMethodArgumentResolver;
import com.kdgcsoft.web.config.mybatisflex.collector.LoggerMessageCollector;
import com.kdgcsoft.web.config.mybatisflex.id.FlexStrIDKeyGenerator;
import com.kdgcsoft.web.config.mybatisflex.listener.MybatisFlexGlobalListener;
import com.kdgcsoft.web.core.entity.base.AuditEntity;
import com.kdgcsoft.web.core.entity.base.AuditRow;
import com.mybatisflex.annotation.InsertListener;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.UpdateListener;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.audit.AuditManager;
import com.mybatisflex.core.audit.MessageCollector;
import com.mybatisflex.core.keygen.IKeyGenerator;
import com.mybatisflex.core.keygen.KeyGeneratorFactory;
import com.mybatisflex.core.query.QueryColumnBehavior;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.spring.boot.ConfigurationCustomizer;
import com.mybatisflex.spring.boot.MyBatisFlexCustomizer;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Resource;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@MapperScan(value={"com.kdgcsoft.**.mapper"})
public class MybatisFlexConfiguration
implements MyBatisFlexCustomizer,
WebMvcConfigurer {
    @Resource
    BootProperties bootProperties;

    @Bean
    public ConfigurationCustomizer configurationCustomizer() {
        return configuration -> configuration.setCallSettersOnNulls(true);
    }

    public void customize(FlexGlobalConfig flexGlobalConfig) {
        flexGlobalConfig.setPrintBanner(false);
        KeyGeneratorFactory.register((String)"flexStrId", (IKeyGenerator)new FlexStrIDKeyGenerator());
        FlexGlobalConfig.KeyConfig keyConfig = new FlexGlobalConfig.KeyConfig();
        keyConfig.setKeyType(KeyType.Generator);
        keyConfig.setValue("flexStrId");
        keyConfig.setBefore(true);
        flexGlobalConfig.setKeyConfig(keyConfig);
        MybatisFlexGlobalListener flexGlobalListener = new MybatisFlexGlobalListener();
        flexGlobalConfig.registerInsertListener((InsertListener)flexGlobalListener, new Class[]{AuditEntity.class, AuditRow.class, Row.class});
        flexGlobalConfig.registerUpdateListener((UpdateListener)flexGlobalListener, new Class[]{AuditEntity.class, AuditRow.class, Row.class});
        QueryColumnBehavior.setIgnoreFunction((Predicate)QueryColumnBehavior.IGNORE_NONE);
        QueryColumnBehavior.setSmartConvertInToEquals((boolean)true);
        QueryColumnBehavior.setIgnoreFunction((Predicate)QueryColumnBehavior.IGNORE_NULL);
        if (this.bootProperties.isSqlLog()) {
            AuditManager.setAuditEnable((boolean)true);
            AuditManager.setMessageCollector((MessageCollector)new LoggerMessageCollector(this.bootProperties.isSqlAudit()));
        }
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new PageMethodArgumentResolver());
    }
}

