/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.entity.AcView;
import com.kdgcsoft.web.ac.entity.table.AcViewTableDef;
import com.kdgcsoft.web.ac.mapper.AcViewMapper;
import com.kdgcsoft.web.ac.utils.ModelUtil;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class AcViewService
extends ServiceImpl<AcViewMapper, AcView> {
    public Page<AcView> pageView(PageRequest<AcView> page, String appCode, String searchKey) {
        QueryWrapper queryWrapper = QueryWrapper.create().select().from(AcView.class).where(AcViewTableDef.AC_VIEW.VIEW_CODE.like((Object)searchKey, If::hasText).or(AcViewTableDef.AC_VIEW.VIEW_NAME.like((Object)searchKey, If::hasText))).and(AcViewTableDef.AC_VIEW.APP_CODE.eq((Object)appCode, If::hasText));
        if (page.hasSorts()) {
            page.appendSortsToWrapper(queryWrapper);
        } else {
            queryWrapper.orderBy(AcViewTableDef.AC_VIEW.VIEW_NAME, (Boolean)true);
        }
        return this.page(page, queryWrapper);
    }

    public AcView findByCode(String formCode) {
        Assert.notBlank((CharSequence)formCode, (String)"\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (AcView)((AcViewMapper)this.getMapper()).selectOneByQuery(QueryWrapper.create().eq(AcView::getViewCode, (Object)formCode));
    }

    public AcView findById(String id) {
        Assert.notBlank((CharSequence)id, (String)"\u8868\u5355ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (AcView)((AcViewMapper)this.getMapper()).selectOneByQuery(QueryWrapper.create().eq(AcView::getViewId, (Object)id));
    }

    public AcView saveView(AcView acApp) {
        if (StrUtil.isBlank((CharSequence)acApp.getViewCode())) {
            acApp.setViewCode(ModelUtil.shortId("view"));
        }
        this.saveOrUpdate(acApp);
        return acApp;
    }

    public List<AcView> exportByAppCode(String appCode) {
        return ((AcViewMapper)this.getMapper()).selectListByQuery(QueryWrapper.create().eq(AcView::getAppCode, (Object)appCode));
    }

    public String importViews(List<AcView> views) {
        int insertCount = 0;
        int updateCount = 0;
        if (CollectionUtil.isNotEmpty(views)) {
            List viewCodeList = views.stream().map(AcView::getViewCode).collect(Collectors.toList());
            List dbViewList = this.list(QueryWrapper.create().in(AcView::getViewCode, viewCodeList));
            Map dbViewMap = dbViewList.stream().collect(Collectors.toMap(AcView::getViewCode, Function.identity()));
            for (AcView view : views) {
                AcView dbView = (AcView)dbViewMap.get(view.getViewCode());
                if (dbView == null) {
                    view.setViewId(null);
                    ++insertCount;
                } else {
                    view.setViewId(dbView.getViewId());
                    ++updateCount;
                }
                this.saveOrUpdate(view);
            }
        }
        if (insertCount + updateCount == 0) {
            return null;
        }
        return String.format("\u5bfc\u5165\u89c6\u56fe %d \u4e2a\uff1a\u65b0\u589e %d \u4e2a\uff0c\u66f4\u65b0 %d \u4e2a", insertCount + updateCount, insertCount, updateCount);
    }
}

