/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.entity.AcApp;
import com.kdgcsoft.web.ac.entity.AcForm;
import com.kdgcsoft.web.ac.entity.table.AcFormTableDef;
import com.kdgcsoft.web.ac.mapper.AcFormMapper;
import com.kdgcsoft.web.ac.pojo.form.FormSchema;
import com.kdgcsoft.web.ac.pojo.query.DataModel;
import com.kdgcsoft.web.ac.service.AcAppService;
import com.kdgcsoft.web.ac.service.AcModelService;
import com.kdgcsoft.web.ac.utils.ModelUtil;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.core.enums.YesNo;
import com.kdgcsoft.web.core.pojo.SelectOption;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AcFormService
extends ServiceImpl<AcFormMapper, AcForm> {
    @Autowired
    private AcModelService modelService;
    @Autowired
    private AcAppService acAppService;

    public Page<AcForm> pageForm(PageRequest<AcForm> page, String appCode, String searchKey) {
        QueryWrapper queryWrapper = QueryWrapper.create().select().from(AcForm.class).where(AcFormTableDef.AC_FORM.FORM_CODE.like((Object)searchKey, If::hasText).or(AcFormTableDef.AC_FORM.FORM_NAME.like((Object)searchKey, If::hasText))).and(AcFormTableDef.AC_FORM.APP_CODE.eq((Object)appCode, If::hasText));
        if (page.hasSorts()) {
            page.appendSortsToWrapper(queryWrapper);
        } else {
            queryWrapper.orderBy(AcFormTableDef.AC_FORM.FORM_NAME, (Boolean)true);
        }
        return this.page(page, queryWrapper);
    }

    public AcForm findByCode(String formCode) {
        Assert.notBlank((CharSequence)formCode, (String)"\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (AcForm)((AcFormMapper)this.getMapper()).selectOneByQuery(QueryWrapper.create().eq(AcForm::getFormCode, (Object)formCode));
    }

    public AcForm findById(String id) {
        Assert.notBlank((CharSequence)id, (String)"\u8868\u5355ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (AcForm)((AcFormMapper)this.getMapper()).selectOneByQuery(QueryWrapper.create().eq(AcForm::getFormId, (Object)id));
    }

    public AcForm saveForm(AcForm acForm) {
        if (StrUtil.isBlank((CharSequence)acForm.getFormCode())) {
            acForm.setFormCode(ModelUtil.shortId("form"));
        }
        this.checkRepeat(acForm);
        this.fillFormConfig(acForm);
        this.saveOrUpdate(acForm);
        return acForm;
    }

    public void checkRepeat(AcForm acForm) {
        Assert.isFalse((boolean)this.exists(AcFormTableDef.AC_FORM.FORM_CODE.eq((Object)acForm.getFormCode()).and(AcFormTableDef.AC_FORM.FORM_ID.ne((Object)acForm.getFormId(), If::hasText))), (String)"\u8868\u5355[{}]\u7f16\u7801[{}]\u91cd\u590d", (Object[])new Object[]{acForm.getFormName(), acForm.getFormCode()});
    }

    public void fillFormConfig(AcForm acForm) {
        DataModel dataModel = this.modelService.getDataModel(acForm.getModelCode());
        Assert.notNull((Object)dataModel, (String)"\u6a21\u578b[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{acForm.getModelCode()});
        if (acForm.getCustom() == YesNo.N) {
            FormSchema formSchema = acForm.getFormConfig();
            if (formSchema == null) {
                formSchema = new FormSchema();
                formSchema.getProps().put((Object)"title", (Object)acForm.getFormName());
            }
            formSchema.getProps().put((Object)"formId", (Object)acForm.getFormId());
            formSchema.getProps().put((Object)"formCode", (Object)acForm.getFormCode());
            formSchema.getProps().put((Object)"appCode", (Object)acForm.getAppCode());
            formSchema.getProps().put((Object)"modelCode", (Object)acForm.getModelCode());
            formSchema.getProps().put((Object)"keyField", (Object)dataModel.getPkField().getFieldCode());
            acForm.setFormConfig(formSchema);
        }
    }

    public List<AcForm> listFormByAppCode(List<String> appCodes) {
        return ((AcFormMapper)this.getMapper()).selectListByQuery(QueryWrapper.create().select().from(AcForm.class).where(AcFormTableDef.AC_FORM.APP_CODE.in(appCodes, CollUtil::isNotEmpty)).orderBy(AcFormTableDef.AC_FORM.FORM_CODE, (Boolean)true));
    }

    public List<SelectOption> formList(String appCode) {
        ArrayList<SelectOption> optionList = new ArrayList<SelectOption>();
        if (StrUtil.isBlank((CharSequence)appCode)) {
            List<AcForm> formList = this.listFormByAppCode(new ArrayList<String>());
            formList.forEach(item -> optionList.add(SelectOption.of(item.getFormCode(), item.getFormName()).setFilter(item.getFormCode() + item.getFormName()).set("custom", (Object)item.getCustom())));
            return optionList;
        }
        List<AcApp> apps = this.acAppService.getUsableApps(appCode);
        List<String> appCodes = apps.stream().map(AcApp::getAppCode).collect(Collectors.toList());
        List<AcForm> models = this.listFormByAppCode(appCodes);
        Map<String, List<AcForm>> mappedModels = models.stream().collect(Collectors.groupingBy(AcForm::getAppCode));
        apps.forEach(app -> {
            SelectOption groupOption = SelectOption.of(app.getAppCode(), app.getAppName());
            if (mappedModels.containsKey(app.getAppCode())) {
                List groupedList = (List)mappedModels.get(app.getAppCode());
                groupOption.setOptions(groupedList.stream().map(item -> SelectOption.of(item.getFormCode(), item.getFormName()).setFilter(item.getFormCode() + item.getFormName()).set("custom", (Object)item.getCustom())).collect(Collectors.toList()));
            } else {
                groupOption.setOptions(new ArrayList<SelectOption>());
            }
            optionList.add(groupOption);
        });
        return optionList;
    }

    public List<AcForm> exportByAppCode(String appCode) {
        return ((AcFormMapper)this.getMapper()).selectListByQuery(QueryWrapper.create().eq(AcForm::getAppCode, (Object)appCode));
    }

    public String importForms(List<AcForm> forms) {
        int insertCount = 0;
        int updateCount = 0;
        if (CollectionUtil.isNotEmpty(forms)) {
            List formCodeList = forms.stream().map(AcForm::getFormCode).collect(Collectors.toList());
            List dbFormList = this.list(QueryWrapper.create().in(AcForm::getFormCode, formCodeList));
            Map dbFormlMap = dbFormList.stream().collect(Collectors.toMap(AcForm::getFormCode, Function.identity()));
            for (AcForm form : forms) {
                AcForm dbForm = (AcForm)dbFormlMap.get(form.getFormCode());
                if (dbForm == null) {
                    form.setFormId(null);
                    ++insertCount;
                } else {
                    form.setFormId(dbForm.getFormId());
                    ++updateCount;
                }
                this.saveOrUpdate(form);
            }
        }
        if (insertCount + updateCount == 0) {
            return null;
        }
        return String.format("\u5bfc\u5165\u8868\u5355 %d \u4e2a\uff1a\u65b0\u589e %d \u4e2a\uff0c\u66f4\u65b0 %d \u4e2a", insertCount + updateCount, insertCount, updateCount);
    }
}

