/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.kdgcsoft.web.ac.enums.TransType;
import com.kdgcsoft.web.ac.interfaces.DataTransService;
import com.kdgcsoft.web.ac.service.AcModelService;
import com.kdgcsoft.web.config.BootProperties;
import com.kdgcsoft.web.core.service.BaseDictService;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class AcDataTransService
implements DataTransService {
    public static final String TRANS_CACHE_NAME = "AcTrans";
    @Autowired
    BaseDictService dictService;
    @Autowired
    AcModelService modelService;
    @Resource
    BootProperties bootProperties;

    @Override
    public Object transValue(TransType transType, String transCode, Object value) {
        AcDataTransService transService = (AcDataTransService)SpringUtil.getBean(AcDataTransService.class);
        if (value instanceof String) {
            ArrayList result = new ArrayList();
            StrUtil.split((CharSequence)Convert.toStr((Object)value), (CharSequence)",").forEach(v -> {
                String transLabel = transService.transSingleValue(transType, transCode, (String)v);
                result.add(transLabel == null ? v : transLabel);
            });
            return CollUtil.join(result, (CharSequence)",");
        }
        return value;
    }

    @Cacheable(value={"AcTrans"}, key="#transType+'.'+#transCode+'.'+#value", unless="#result == null")
    public String transSingleValue(TransType transType, String transCode, String value) {
        if (transType == TransType.DICT) {
            return this.dictService.getDictLabel(transCode, value);
        }
        if (transType == TransType.MODEL) {
            if (StrUtil.equals((CharSequence)transCode, (CharSequence)"BaseUser") && StrUtil.equals((CharSequence)value, (CharSequence)this.bootProperties.getRootAccountId())) {
                return this.bootProperties.getRootName();
            }
            return this.modelService.transModelDataLabel(transCode, value);
        }
        return null;
    }
}

