/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.entity.AcApp;
import com.kdgcsoft.web.ac.entity.AcDataset;
import com.kdgcsoft.web.ac.entity.AcFlow;
import com.kdgcsoft.web.ac.entity.AcForm;
import com.kdgcsoft.web.ac.entity.AcModel;
import com.kdgcsoft.web.ac.entity.AcView;
import com.kdgcsoft.web.ac.entity.table.AcAppTableDef;
import com.kdgcsoft.web.ac.entity.table.AcDatasetTableDef;
import com.kdgcsoft.web.ac.entity.table.AcFormTableDef;
import com.kdgcsoft.web.ac.entity.table.AcModelTableDef;
import com.kdgcsoft.web.ac.entity.table.AcViewTableDef;
import com.kdgcsoft.web.ac.mapper.AcAppMapper;
import com.kdgcsoft.web.ac.mapper.AcDatasetMapper;
import com.kdgcsoft.web.ac.mapper.AcFlowMapper;
import com.kdgcsoft.web.ac.mapper.AcFormMapper;
import com.kdgcsoft.web.ac.mapper.AcModelMapper;
import com.kdgcsoft.web.ac.mapper.AcViewMapper;
import com.kdgcsoft.web.ac.pojo.app.AppCount;
import com.kdgcsoft.web.ac.pojo.app.AppExportModel;
import com.kdgcsoft.web.ac.service.AcDatasetService;
import com.kdgcsoft.web.ac.service.AcFlowService;
import com.kdgcsoft.web.ac.service.AcFormService;
import com.kdgcsoft.web.ac.service.AcModelService;
import com.kdgcsoft.web.ac.service.AcViewService;
import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryMethods;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AcAppService
extends ServiceImpl<AcAppMapper, AcApp> {
    @Autowired
    private AcModelService acModelService;
    @Resource
    private AcModelMapper acModelMapper;
    @Autowired
    private AcFormService acFormService;
    @Resource
    private AcFormMapper acFormMapper;
    @Autowired
    private AcViewService acViewService;
    @Resource
    private AcViewMapper acViewMapper;
    @Autowired
    private AcDatasetService acDatasetService;
    @Resource
    private AcDatasetMapper acDatasetMapper;
    @Autowired
    private AcFlowService acFlowService;
    @Resource
    private AcFlowMapper acFlowMapper;

    public AcApp findByCode(String appCode) {
        Assert.notBlank((CharSequence)appCode, (String)"\u5e94\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (AcApp)((AcAppMapper)this.getMapper()).selectOneByQuery(QueryWrapper.create().eq(AcApp::getAppCode, (Object)appCode));
    }

    public AcApp findById(String id) {
        Assert.notBlank((CharSequence)id, (String)"\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (AcApp)((AcAppMapper)this.getMapper()).selectOneByQuery(QueryWrapper.create().eq(AcApp::getAppId, (Object)id));
    }

    public List<AcApp> listApp() {
        return this.list(QueryWrapper.create().orderBy(AcApp::getOrderNo, (Boolean)true));
    }

    public boolean hasRepeat(AcApp entity) {
        QueryWrapper wrapper = QueryWrapper.create();
        wrapper.from(new QueryTable[]{AcAppTableDef.AC_APP});
        wrapper.and(AcAppTableDef.AC_APP.APP_CODE.eq((Object)entity.getAppCode()).and(AcAppTableDef.AC_APP.APP_ID.ne((Object)entity.getAppId(), If::hasText)));
        return ((AcAppMapper)this.getMapper()).selectCountByQuery(wrapper) > 0L;
    }

    public AcApp saveApp(AcApp acApp) {
        this.saveOrUpdate(acApp);
        return acApp;
    }

    public List<AcApp> getUsableApps(String appCode) {
        AcApp acApp = this.findByCode(appCode);
        if (ObjectUtil.isEmpty((Object)acApp)) {
            return new ArrayList<AcApp>();
        }
        ArrayList appCodes = CollUtil.newArrayList((Object[])new String[]{acApp.getAppCode()});
        appCodes.addAll(List.of(acApp.getRefApps().split(",")));
        return this.list(QueryWrapper.create().in(AcApp::getAppCode, appCodes));
    }

    public HashMap<String, HashMap<String, Integer>> getAppRefCount() {
        HashMap<String, HashMap<String, Integer>> map = new HashMap<String, HashMap<String, Integer>>();
        List acApps = this.list(QueryWrapper.create());
        for (AcApp acApp : acApps) {
            HashMap<String, Integer> innerMap = new HashMap<String, Integer>();
            innerMap.put("model", 0);
            innerMap.put("form", 0);
            innerMap.put("view", 0);
            innerMap.put("dataset", 0);
            map.put(acApp.getAppCode(), innerMap);
        }
        this.updateAppRefCount(map, "model", this.acModelMapper, AcModelTableDef.AC_MODEL.APP_CODE);
        this.updateAppRefCount(map, "form", this.acFormMapper, AcFormTableDef.AC_FORM.APP_CODE);
        this.updateAppRefCount(map, "view", this.acViewMapper, AcViewTableDef.AC_VIEW.APP_CODE);
        this.updateAppRefCount(map, "dataset", this.acDatasetMapper, AcDatasetTableDef.AC_DATASET.APP_CODE);
        return map;
    }

    private void updateAppRefCount(HashMap<String, HashMap<String, Integer>> map, String key, BaseMapper mapper, QueryColumn appCodeColumn) {
        QueryWrapper wrapper = QueryWrapper.create();
        wrapper.select(appCodeColumn, QueryMethods.count().as("count")).groupBy(appCodeColumn);
        List appCounts = mapper.selectListByQueryAs(wrapper, AppCount.class);
        for (AppCount appCount : appCounts) {
            HashMap<String, Integer> integerHashMap = map.get(appCount.getAppCode());
            if (integerHashMap == null) continue;
            integerHashMap.put(key, appCount.getCount());
        }
    }

    public AppExportModel getExportModelByCode(String appCode) {
        AppExportModel exportModel = new AppExportModel();
        List<AcApp> apps = this.exportByAppCode(appCode);
        List<AcModel> models = this.acModelService.exportByAppCode(appCode);
        List<AcForm> forms = this.acFormService.exportByAppCode(appCode);
        List<AcView> views = this.acViewService.exportByAppCode(appCode);
        List<AcDataset> datasets = this.acDatasetService.exportByAppCode(appCode);
        List<AcFlow> flows = this.acFlowService.exportByAppCode(appCode);
        exportModel.setApps(apps);
        exportModel.setModels(models);
        exportModel.setForms(forms);
        exportModel.setViews(views);
        exportModel.setDatasets(datasets);
        exportModel.setFlows(flows);
        return exportModel;
    }

    public List<AcApp> exportByAppCode(String appCode) {
        List<AcApp> apps = this.getUsableApps(appCode);
        apps.forEach(app -> {
            String[] refAppCodes;
            ArrayList<String> refAppCodeList = new ArrayList<String>();
            for (String refAppCode : refAppCodes = app.getRefApps().split(",")) {
                AcApp one = (AcApp)((AcAppMapper)this.getMapper()).selectOneByQuery(QueryWrapper.create().eq(AcApp::getAppCode, (Object)refAppCode));
                if (one == null) continue;
                refAppCodeList.add(refAppCode);
            }
            app.setRefApps(StrUtil.join((CharSequence)",", refAppCodeList));
        });
        return apps;
    }

    public String importAppInfo(AppExportModel exportModel) {
        ArrayList<String> msg = new ArrayList<String>();
        List<AcApp> apps = exportModel.getApps();
        msg.add(this.importApps(apps));
        List<AcModel> models = exportModel.getModels();
        msg.add(this.acModelService.importModels(models));
        List<AcForm> forms = exportModel.getForms();
        msg.add(this.acFormService.importForms(forms));
        List<AcView> views = exportModel.getViews();
        msg.add(this.acViewService.importViews(views));
        List<AcDataset> datasets = exportModel.getDatasets();
        msg.add(this.acDatasetService.importDatasets(datasets));
        List<AcFlow> flows = exportModel.getFlows();
        msg.add(this.acFlowService.importFlows(flows));
        msg.removeIf(Objects::isNull);
        return StrUtil.join((CharSequence)"\n", msg);
    }

    public String importApps(List<AcApp> apps) {
        int insertCount = 0;
        int updateCount = 0;
        if (CollectionUtil.isNotEmpty(apps)) {
            List appCodeList = apps.stream().map(AcApp::getAppCode).collect(Collectors.toList());
            List dbAppList = this.list(QueryWrapper.create().in(AcApp::getAppCode, appCodeList));
            Map dbAppMap = dbAppList.stream().collect(Collectors.toMap(AcApp::getAppCode, Function.identity()));
            for (AcApp app : apps) {
                AcApp dbApp = (AcApp)dbAppMap.get(app.getAppCode());
                if (dbApp == null) {
                    app.setAppId(null);
                    ((AcAppMapper)this.getMapper()).insert(app);
                    ++insertCount;
                    continue;
                }
                app.setAppId(dbApp.getAppId());
                ((AcAppMapper)this.getMapper()).update(app);
                ++updateCount;
            }
        }
        if (insertCount + updateCount == 0) {
            return null;
        }
        return String.format("\u5bfc\u5165\u5e94\u7528 %d \u4e2a\uff1a\u65b0\u589e %d \u4e2a\uff0c\u66f4\u65b0 %d \u4e2a", insertCount + updateCount, insertCount, updateCount);
    }
}

