/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.web.ac.enums.Condition;
import com.kdgcsoft.web.ac.enums.EmbedFields;
import com.kdgcsoft.web.ac.enums.dict.ModelDataType;
import com.kdgcsoft.web.ac.interfaces.ModelHandler;
import com.kdgcsoft.web.ac.pojo.ModelProConfig;
import com.kdgcsoft.web.ac.pojo.ModelRelation;
import com.kdgcsoft.web.ac.pojo.ModelRow;
import com.kdgcsoft.web.ac.pojo.query.ConditionModel;
import com.kdgcsoft.web.ac.pojo.query.DataField;
import com.kdgcsoft.web.ac.pojo.query.DataModel;
import com.kdgcsoft.web.ac.pojo.query.GridModelData;
import com.kdgcsoft.web.ac.pojo.query.RefSubModel;
import com.kdgcsoft.web.ac.service.AcDataTransService;
import com.kdgcsoft.web.ac.service.AcModelService;
import com.kdgcsoft.web.ac.service.AcSerialService;
import com.kdgcsoft.web.ac.utils.ModelUtil;
import com.kdgcsoft.web.common.process.interfaces.ProcessInfoProvider;
import com.kdgcsoft.web.common.process.pojo.ProcessInfo;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.config.security.SecurityUtil;
import com.kdgcsoft.web.core.pojo.Result;
import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Table;
import com.mybatisflex.core.constant.SqlOperator;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.If;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryMethods;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Db;
import com.mybatisflex.core.row.DbChain;
import com.mybatisflex.core.row.Row;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AcApiModelService {
    private static final Logger log = LoggerFactory.getLogger(AcApiModelService.class);
    @Resource
    AcModelService acModelService;
    @Autowired
    AcDataTransService transService;
    @Autowired
    AcSerialService acSerialService;

    public DataModel getDataModel(String modelCode) {
        DataModel dataModel = this.acModelService.getDataModel(modelCode);
        return dataModel;
    }

    public ModelRow getById(String modelCode, String id) {
        Assert.notBlank((CharSequence)id, (String)"\u4e3b\u952e\u503c\u4e3a\u7a7a", (Object[])new Object[0]);
        DataModel dataModel = this.getDataModel(modelCode);
        return this.getByField(modelCode, dataModel.getPkField().getFieldCode(), id);
    }

    public ModelRow getByField(String modelCode, String fieldCode, String fieldValue) {
        TimeInterval timer = DateUtil.timer();
        String logPrefix = StrUtil.format((CharSequence)"\u901a\u7528\u63a5\u53e3\u8c03\u7528:[{}].getBy[{}]({}) ", (Object[])new Object[]{modelCode, fieldCode, fieldValue});
        if (StrUtil.isBlank((CharSequence)fieldCode) || StrUtil.isBlank((CharSequence)fieldValue)) {
            log.info("{} \u67e5\u8be2\u5b57\u6bb5\u6216\u5b57\u6bb5\u503c\u4e3a\u7a7a,\u76f4\u63a5\u8fd4\u56de \u25bc \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix);
            return new ModelRow();
        }
        log.info("{} \u8c03\u7528\u5f00\u59cb \u25bc \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix);
        DataModel dataModel = this.getDataModel(modelCode);
        DataField dataField = dataModel.getNativeFieldByCode(fieldCode);
        Assert.notNull((Object)dataField, (String)"\u6a21\u578b\u5b57\u6bb5{},\u4e0d\u5b58\u5728", (Object[])new Object[]{fieldCode});
        QueryWrapper qw = dataModel.getModelQueryWrapper();
        qw.where(dataField.column().eq(dataField.valueToDb(fieldValue)));
        Row row = Db.selectOneByQuery(qw);
        ModelRow modelRow = dataModel.toModelRow(row);
        modelRow = this.queryRefSubModel(dataModel, modelRow);
        log.info("{} \u5173\u8054\u67e5\u8be2\u5b50\u8868\u6570\u636e,\u8017\u65f6{}ms.\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix, (Object)timer.intervalMs());
        log.info("{} \u8c03\u7528\u5b8c\u6210 \u25b2 \u8017\u65f6{}ms.\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix, (Object)timer.intervalMs());
        return modelRow;
    }

    public ModelRow queryRefSubModel(DataModel dataModel, ModelRow modelRow) {
        TimeInterval timer = DateUtil.timer();
        dataModel.getRefSubModelMap().forEach((alias, refSubModel) -> {
            DataModel subDataModel = refSubModel.getDataModel();
            QueryWrapper subQueryWrapper = subDataModel.getModelQueryWrapper();
            subQueryWrapper.where(refSubModel.getRefSubField().column().eq(modelRow.get(refSubModel.getRefMainField().getAlias())));
            int subCount = 0;
            if (refSubModel.getRefType() == ModelRelation.RelType.MANY) {
                List<ModelRow> subModelRows = subDataModel.toModelRows(Db.selectListByQuery(subQueryWrapper));
                modelRow.put(alias, subModelRows);
                subCount = subModelRows.size();
            } else if (refSubModel.getRefType() == ModelRelation.RelType.ONE) {
                ModelRow subModelRow = subDataModel.toModelRow(Db.selectOneByQuery(subQueryWrapper));
                modelRow.put(alias, (Object)subModelRow);
                subCount = 1;
            }
            log.info("\u5173\u8054\u67e5\u8be2\u5b50\u8868[{}],\u8fd4\u56de{}\u6761,\u8017\u65f6{}ms\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", new Object[]{subDataModel.getModelCode(), subCount, timer.intervalMs()});
        });
        return modelRow;
    }

    public Page<ModelRow> page(String modelCode, PageRequest page, Map<String, String> paramsMap) {
        TimeInterval timer = DateUtil.timer();
        String logPrefix = StrUtil.format((CharSequence)"\u901a\u7528\u63a5\u53e3\u8c03\u7528:[{}].page() ", (Object[])new Object[]{modelCode});
        log.info("{} \u8c03\u7528\u5f00\u59cb \u25bc \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix);
        DataModel dataModel = this.getDataModel(modelCode);
        QueryWrapper qw = dataModel.getModelQueryWrapper();
        qw.where(this.buildQueryCondition(dataModel, paramsMap));
        qw = this.buildQueryOrders(qw, dataModel, paramsMap);
        Page<Row> rowPage = Db.paginate(dataModel.getName(), page, qw);
        Page<ModelRow> result = dataModel.toModelRowPage(rowPage);
        if (MapUtil.getBool(paramsMap, (Object)"_".concat("enable"), (Boolean)false).booleanValue()) {
            this.buildProcessInfo(result.getRecords(), dataModel.getPkField().getFieldCode());
        }
        log.info("{} \u8c03\u7528\u5b8c\u6210 \u25b2 {}ms\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix, (Object)timer.intervalMs());
        return result;
    }

    public List<ModelRow> list(String modelCode, Integer _limit, Map<String, String> paramsMap) {
        TimeInterval timer = DateUtil.timer();
        String logPrefix = StrUtil.format((CharSequence)"\u901a\u7528\u63a5\u53e3\u8c03\u7528:[{}].list() ", (Object[])new Object[]{modelCode});
        log.info("{} \u8c03\u7528\u5f00\u59cb \u25bc \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix);
        DataModel dataModel = this.getDataModel(modelCode);
        QueryWrapper qw = dataModel.getModelQueryWrapper();
        qw.where(this.buildQueryCondition(dataModel, paramsMap));
        qw = this.buildQueryOrders(qw, dataModel, paramsMap);
        if (_limit != null && _limit > 0) {
            qw.limit(_limit);
        }
        List<Row> list = Db.selectListByQuery(qw);
        List<ModelRow> rowlist = dataModel.toModelRows(list);
        if (MapUtil.getBool(paramsMap, (Object)"_".concat("enable"), (Boolean)false).booleanValue()) {
            this.buildProcessInfo(rowlist, dataModel.getPkField().getFieldCode());
        }
        log.info("{} \u8c03\u7528\u5b8c\u6210 \u25b2 {}ms\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix, (Object)timer.intervalMs());
        return rowlist;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteById(String modelCode, String id) {
        return this.deleteByIds(modelCode, StrUtil.split((CharSequence)id, (CharSequence)","));
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteByIds(String modelCode, List<String> ids) {
        TimeInterval timer = DateUtil.timer();
        String logPrefix = StrUtil.format((CharSequence)"\u901a\u7528\u63a5\u53e3\u8c03\u7528:[{}].removeByIds({}) ", (Object[])new Object[]{modelCode, ids});
        int result = 0;
        log.info("{} \u8c03\u7528\u5f00\u59cb \u25bc \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix);
        if (CollUtil.isEmpty(ids)) {
            log.warn("{} \u4e3b\u952e\u6570\u636e\u4e3a\u7a7a,\u76f4\u63a5\u8fd4\u56de,\u8017\u65f6{}ms.", (Object)logPrefix, (Object)timer.intervalMs());
            return result;
        }
        DataModel mainModel = this.getDataModel(modelCode);
        List<Row> toDeleteRows = this.getToDeleteRows(mainModel, ids);
        List toDeleteKeys = toDeleteRows.stream().map(row -> row.get((Object)mainModel.getPkField().getFieldCode())).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(toDeleteKeys)) {
            log.warn("{} \u5206\u6790\u51fa\u5f85\u5220\u9664\u6570\u636e\u4e3a\u7a7a,\u76f4\u63a5\u8fd4\u56de,\u8017\u65f6{}ms.", (Object)logPrefix, (Object)timer.intervalMs());
            return result;
        }
        result = toDeleteKeys.size();
        if (mainModel.hasLogicDelete()) {
            ((DbChain)((DbChain)DbChain.table((QueryTable)mainModel.table()).set(mainModel.getLogicField().getName(), (Object)1)).where(mainModel.getPkField().simpleQueryColumn().in(toDeleteKeys))).update();
            log.info("{} \u6267\u884c\u4e3b\u8868[{}]\u3010\u903b\u8f91\u5220\u9664\u3011,\u5f71\u54cd\u884c\u6570{},\u8017\u65f6{}ms.", new Object[]{logPrefix, mainModel.getModelCode(), result, timer.intervalMs()});
        } else {
            ((DbChain)DbChain.table((QueryTable)mainModel.table()).where(mainModel.getPkField().simpleQueryColumn().in(toDeleteKeys))).remove();
            log.info("{} \u6267\u884c\u4e3b\u8868[{}]\u3010\u7269\u7406\u5220\u9664\u3011,\u5f71\u54cd\u884c\u6570{},\u8017\u65f6{}ms.", new Object[]{logPrefix, mainModel.getModelCode(), result, timer.intervalMs()});
        }
        AtomicInteger subResult = new AtomicInteger();
        mainModel.getRefSubModelMap().forEach((alias, refSubModel) -> {
            if (refSubModel.isRefDelete()) {
                DataModel subDataModel = refSubModel.getDataModel();
                List subJoinKeys = toDeleteRows.stream().map(row -> row.get((Object)refSubModel.getRefMainField().getFieldCode())).distinct().collect(Collectors.toList());
                subResult.addAndGet(subJoinKeys.size());
                if (subDataModel.hasLogicDelete()) {
                    ((DbChain)((DbChain)DbChain.table((QueryTable)subDataModel.table()).set(subDataModel.getLogicField().getName(), (Object)1)).where(refSubModel.getRefSubField().simpleQueryColumn().in(subJoinKeys))).update();
                    log.info("{} \u6267\u884c\u5b50\u8868[{}]\u3010\u903b\u8f91\u5220\u9664\u3011,\u5f71\u54cd\u884c\u6570{},\u8017\u65f6{}ms.", new Object[]{logPrefix, subDataModel.getModelCode(), subJoinKeys.size(), timer.intervalMs()});
                } else {
                    ((DbChain)DbChain.table((QueryTable)subDataModel.table()).where(refSubModel.getRefSubField().simpleQueryColumn().in(subJoinKeys))).remove();
                    log.info("{} \u6267\u884c\u5b50\u8868[{}]\u3010\u7269\u7406\u5220\u9664\u3011,\u5f71\u54cd\u884c\u6570{},\u8017\u65f6{}ms.", new Object[]{logPrefix, subDataModel.getModelCode(), subJoinKeys.size(), timer.intervalMs()});
                }
            }
        });
        log.info("{} \u8c03\u7528\u5b8c\u6210 \u25b2 \u5f71\u54cd\u884c\u6570:\u4e3b\u8868{},\u5b50\u8868{}.{}ms\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", new Object[]{logPrefix, result, subResult, timer.intervalMs()});
        return result;
    }

    public Result deleteByCondition(String modelCode, Map<String, String> paramsMap) {
        TimeInterval timer = DateUtil.timer();
        String logPrefix = StrUtil.format((CharSequence)"\u901a\u7528\u63a5\u53e3\u8c03\u7528:[{}].removeByCondition() ", (Object[])new Object[]{modelCode});
        log.info("{} \u8c03\u7528\u5f00\u59cb \u25bc \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix);
        DataModel dataModel = this.getDataModel(modelCode);
        QueryCondition condition = this.buildQueryCondition(dataModel, paramsMap, true);
        if (dataModel.hasLogicDelete()) {
            Row row = new Row();
            row.set(dataModel.getLogicField().column(), (Object)1);
            int count = Db.updateByCondition(dataModel.getName(), row, condition);
            log.info("{} \u6267\u884c\u6a21\u578b[{}]\u3010\u903b\u8f91\u5220\u9664\u3011,\u5f71\u54cd\u884c\u6570{},\u8017\u65f6{}ms.", new Object[]{logPrefix, dataModel.getModelCode(), count, timer.intervalMs()});
        } else {
            int count = Db.deleteByCondition(dataModel.getName(), condition);
            log.info("{} \u6267\u884c\u6a21\u578b[{}]\u3010\u7269\u7406\u5220\u9664\u3011,\u5f71\u54cd\u884c\u6570{},\u8017\u65f6{}ms.", new Object[]{logPrefix, dataModel.getModelCode(), count, timer.intervalMs()});
        }
        return Result.OK();
    }

    public List<Row> getToDeleteRows(DataModel dataModel, List<String> ids) {
        if (!dataModel.isCascadeDelete()) {
            return Db.selectListByQuery(dataModel.getNativeQueryWrapper().where(dataModel.getPkField().column().in(ids)));
        }
        List<Row> allRows = Db.selectListByQuery(dataModel.getNativeQueryWrapper());
        ArrayList<Row> toDeleteRows = new ArrayList<Row>();
        List todoList = allRows.stream().filter(row -> CollUtil.contains((Collection)ids, (Object)row.get((Object)dataModel.getPkField().getFieldCode()))).collect(Collectors.toList());
        while (!todoList.isEmpty()) {
            Row current = (Row)todoList.get(0);
            todoList.remove(0);
            toDeleteRows.add(current);
            List children = allRows.stream().filter(row -> ObjectUtil.equals((Object)row.get((Object)dataModel.getTreePidField().getFieldCode()), (Object)current.get((Object)dataModel.getTreeIdField().getFieldCode()))).collect(Collectors.toList());
            todoList.addAll(children);
        }
        return CollUtil.distinct(toDeleteRows);
    }

    @Transactional(rollbackFor={Exception.class})
    public Result updateById(String modelCode, ModelRow modelRow) {
        TimeInterval timer = DateUtil.timer();
        String logPrefix = StrUtil.format((CharSequence)"\u901a\u7528\u63a5\u53e3\u8c03\u7528:[{}].updateById() ", (Object[])new Object[]{modelCode});
        log.info("{} \u8c03\u7528\u5f00\u59cb \u25bc \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix);
        DataModel dataModel = this.getDataModel(modelCode);
        String pkValue = modelRow.getString(dataModel.getPkField().getFieldCode());
        Assert.notBlank((CharSequence)pkValue, (String)"\u66f4\u65b0\u6570\u636e\u4e2d\u7f3a\u5c11\u4e3b\u952e", (Object[])new Object[0]);
        Row row = this.buildRow(dataModel, modelRow);
        this.fillEmbedFields(dataModel, row, false);
        int count = Db.updateById(dataModel.getName(), row);
        log.info("{} \u8c03\u7528\u5b8c\u6210 \u25b2 ,\u5f71\u54cd\u884c\u6570:{},\u8017\u65f6:{}ms \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", new Object[]{logPrefix, count, timer.intervalMs()});
        modelRow.putAll(row.toCamelKeysMap());
        Result<ModelRow> result = Result.OK(modelRow);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result save(String modelCode, ModelRow modelRow) {
        TimeInterval timer = DateUtil.timer();
        String logPrefix = StrUtil.format((CharSequence)"\u901a\u7528\u63a5\u53e3\u8c03\u7528:[{}].save() ", (Object[])new Object[]{modelCode});
        log.info("{} \u8c03\u7528\u5f00\u59cb \u25bc \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix);
        DataModel dataModel = this.getDataModel(modelCode);
        boolean isNew = this.isNew(dataModel, modelRow);
        this.validateRow(dataModel, modelRow);
        if (isNew) {
            this.fillSerialField(dataModel, modelRow);
        }
        this.checkUnique(dataModel, modelRow);
        ModelHandler modelHandler = this.getDataHandler(dataModel);
        Object entityObject = this.createEntityObject(modelHandler, modelRow);
        boolean continueSave = this.invokeBeforeSave(modelHandler, entityObject, modelRow, isNew);
        log.info("{} \u6267\u884cBeforeSave \u62e6\u622a\u5668,\u8017\u65f6:{}ms", (Object)logPrefix, (Object)timer.intervalMs());
        if (!continueSave) {
            return Result.OK(modelRow);
        }
        Row row = this.buildRow(dataModel, modelRow);
        this.fillEmbedFields(dataModel, row, isNew);
        int count = isNew ? Db.insert(dataModel.getName(), row) : Db.updateById(dataModel.getName(), row);
        log.info("{} \u6267\u884c\u3010{}\u3011\u64cd\u4f5c,\u5f71\u54cd\u884c\u6570:{},\u8017\u65f6:{}ms \u25bc \u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", new Object[]{logPrefix, isNew ? "\u65b0\u589e" : "\u66f4\u65b0", count, timer.intervalMs()});
        modelRow.putAll(row.toCamelKeysMap());
        this.saveRefSubModels(dataModel, modelRow);
        this.fillProxyEntity(modelRow, entityObject);
        Result<ModelRow> result = this.invokeAfterSave(modelHandler, entityObject, isNew);
        log.info("{} \u6267\u884cAfterSave \u62e6\u622a\u5668,\u8017\u65f6:{}ms", (Object)timer.intervalMs());
        result = result == null ? Result.OK(modelRow) : result;
        log.info("{} \u8c03\u7528\u5b8c\u6210 \u25b2 \u8017\u65f6:{}ms\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (Object)logPrefix, (Object)timer.intervalMs());
        return result;
    }

    public boolean invokeBeforeSave(ModelHandler modelHandler, Object entityObject, ModelRow modelRow, boolean isNew) {
        if (entityObject != null && modelHandler != null) {
            modelRow.startWatch();
            boolean continueSave = modelHandler.beforeSave(entityObject, isNew);
            modelRow.stopWatch();
            return continueSave;
        }
        return true;
    }

    public Result invokeAfterSave(ModelHandler modelHandler, Object entityObject, boolean isNew) {
        if (entityObject != null && modelHandler != null) {
            return modelHandler.afterSave(entityObject, isNew);
        }
        return null;
    }

    public void saveRefSubModels(DataModel dataModel, ModelRow modelRow) {
        dataModel.getRefSubModelMap().forEach((alias, refSubModel) -> {
            int result = 0;
            if (modelRow.containsKey((String)alias)) {
                switch (refSubModel.getRefType()) {
                    case ONE: {
                        result = this.saveRefSubModelOne(dataModel, modelRow, (RefSubModel)refSubModel, modelRow.getJSONObject((String)alias));
                        log.info("\u5173\u8054\u5b50\u8868[{}]\u4e00\u5bf9\u4e00\u4fdd\u5b58\u5b8c\u6210,\u5f71\u54cd\u884c\u6570:{}.", (Object)refSubModel.getDataModel().getModelCode(), (Object)result);
                        break;
                    }
                    case MANY: {
                        result = this.saveRefSubModelMany(dataModel, modelRow, (RefSubModel)refSubModel, modelRow.getJSONArray((String)alias));
                        log.info("\u5173\u8054\u5b50\u8868[{}]\u4e00\u5bf9\u591a\u4fdd\u5b58\u5b8c\u6210,\u5f71\u54cd\u884c\u6570:{}.", (Object)refSubModel.getDataModel().getModelCode(), (Object)result);
                    }
                }
            }
        });
    }

    public int saveRefSubModelOne(DataModel dataModel, ModelRow modelRow, RefSubModel refSubModel, JSONObject jsonData) {
        if (jsonData == null) {
            return 0;
        }
        DataModel subModel = refSubModel.getDataModel();
        String subPk = jsonData.getString(subModel.getPkField().getFieldCode());
        boolean isNew = true;
        if (StrUtil.isNotBlank((CharSequence)subPk)) {
            Row existRow = Db.selectOneById(subModel.getName(), subModel.getPkField().getName(), subPk);
            isNew = existRow == null;
        }
        Row row = this.buildRow(subModel, jsonData);
        this.fillEmbedFields(subModel, row, isNew);
        row.put(refSubModel.getRefSubField().getName(), modelRow.get(refSubModel.getRefMainField().getFieldCode()));
        int count = isNew ? Db.insert(dataModel.getName(), row) : Db.updateById(dataModel.getName(), row);
        return count;
    }

    public int saveRefSubModelMany(DataModel dataModel, ModelRow modelRow, RefSubModel refSubModel, JSONArray jsonArray) {
        DataModel subModel = refSubModel.getDataModel();
        QueryWrapper queryWrapper = subModel.getModelQueryWrapper();
        Object mainKey = modelRow.get(refSubModel.getRefMainField().getFieldCode());
        queryWrapper.eq(refSubModel.getRefSubField().getName(), mainKey);
        List<Row> existRows = Db.selectListByQuery(queryWrapper);
        List existKeys = existRows.stream().map(row -> row.get((Object)subModel.getPkField().getFieldCode())).collect(Collectors.toList());
        ArrayList<Row> deleteRows = new ArrayList<Row>();
        ArrayList<Row> updateRows = new ArrayList<Row>();
        ArrayList<Row> insertRows = new ArrayList<Row>();
        ArrayList keys = new ArrayList();
        if (!CollUtil.isEmpty((Collection)jsonArray)) {
            CollUtil.forEach((Iterable)jsonArray, (CollUtil.Consumer & Serializable)(object, index) -> {
                Object rowPk;
                JSONObject jsonObject = jsonArray.getJSONObject(index);
                Row row = this.buildRow(subModel, jsonObject);
                if (!row.containsKey((Object)refSubModel.getRefSubField().getName())) {
                    row.put(refSubModel.getRefSubField().getName(), mainKey);
                }
                if ((rowPk = row.get((Object)subModel.getPkField().getName())) != null) {
                    keys.add(rowPk);
                }
                boolean isNew = !existKeys.contains(rowPk);
                this.fillEmbedFields(subModel, row, isNew);
                if (isNew) {
                    insertRows.add(row);
                } else {
                    updateRows.add(row);
                }
            });
        }
        CollUtil.forEach(existRows, (CollUtil.Consumer & Serializable)(row, index) -> {
            Object existKey = row.get((Object)subModel.getPkField().getFieldCode());
            if (!keys.contains(existKey)) {
                Row deleteRow = subModel.buildRowById(existKey);
                if (subModel.hasLogicDelete()) {
                    deleteRow.put(subModel.getLogicField().getName(), (Object)1);
                }
                deleteRows.add(deleteRow);
            }
        });
        int deleteCount = 0;
        if (CollUtil.isNotEmpty(deleteRows)) {
            if (subModel.hasLogicDelete()) {
                deleteCount = Db.updateBatchById(subModel.getName(), deleteRows);
            } else {
                List ids = deleteRows.stream().map(row -> row.get((Object)subModel.getPkField().getName())).collect(Collectors.toList());
                deleteCount = Db.deleteBatchByIds(subModel.getName(), subModel.getPkField().getName(), ids);
            }
        }
        int insertCount = 0;
        if (CollUtil.isNotEmpty(insertRows)) {
            int[] count = Db.insertBatch(subModel.getName(), insertRows);
            insertCount = Arrays.stream(count).sum();
        }
        int updateCount = 0;
        if (CollUtil.isNotEmpty(updateRows)) {
            updateCount = Db.updateBatchById(subModel.getName(), updateRows);
        }
        return deleteCount + insertCount + updateCount;
    }

    public Object createEntityObject(ModelHandler modelHandler, ModelRow modelRow) {
        if (modelHandler == null) {
            return null;
        }
        Type entityClass = this.getEntityClass(modelHandler);
        if (entityClass != null) {
            Enhancer enhancer = AcApiModelService.getEnhancer(modelRow, (Class)entityClass);
            Object entityObject = enhancer.create();
            this.fillProxyEntity(modelRow, entityObject);
            return entityObject;
        }
        return null;
    }

    public Object fillProxyEntity(ModelRow modelRow, Object proxyEntity) {
        if (proxyEntity != null) {
            BeanUtil.fillBeanWithMap((Map)((Object)modelRow), (Object)proxyEntity, (boolean)true);
        }
        return proxyEntity;
    }

    private static Enhancer getEnhancer(ModelRow modelRow, Class entityClass) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(entityClass);
        enhancer.setCallback((Callback)((MethodInterceptor)(obj, method, args, methodProxy) -> {
            if (!modelRow.isWatching() || !method.getName().startsWith("set")) {
                return methodProxy.invokeSuper(obj, args);
            }
            String fieldName = StrUtil.lowerFirst((CharSequence)StrUtil.removePrefix((CharSequence)method.getName(), (CharSequence)"set"));
            Field field = ClassUtil.getDeclaredField(method.getDeclaringClass(), (String)fieldName);
            if (field == null) {
                return methodProxy.invokeSuper(obj, args);
            }
            Table tableAnno = method.getDeclaringClass().getAnnotation(Table.class);
            Column columnAnno = field.getAnnotation(Column.class);
            if (tableAnno == null || columnAnno != null && columnAnno.ignore()) {
                return methodProxy.invokeSuper(obj, args);
            }
            modelRow.put(fieldName, args[0]);
            return methodProxy.invokeSuper(obj, args);
        }));
        return enhancer;
    }

    public GridModelData tableDataPreview(String modelCode, Long limit) {
        boolean isTree;
        GridModelData gridModelData = new GridModelData();
        DataModel dataModel = this.getDataModel(modelCode);
        QueryWrapper qw = dataModel.getModelQueryWrapper();
        qw.limit(limit);
        List<Row> list = Db.selectListByQuery(qw);
        List<ModelRow> rowList = dataModel.toModelRows(list);
        gridModelData.setData(rowList);
        boolean bl = isTree = ModelDataType.TREE == dataModel.getDataType() && dataModel.treeFieldValid();
        if (isTree) {
            GridModelData.TreeConfig treeConfig = new GridModelData.TreeConfig();
            treeConfig.setRowField(dataModel.getTreeIdField().getAlias());
            treeConfig.setParentField(dataModel.getTreePidField().getAlias());
            gridModelData.setTreeConfig(treeConfig);
        }
        CollUtil.forEach(dataModel.getQueryFields(), (CollUtil.Consumer & Serializable)(field, index) -> {
            GridModelData.GridColumn group = new GridModelData.GridColumn(null, field.getAlias());
            GridModelData.GridColumn col = new GridModelData.GridColumn(field.getAlias(), field.getFieldName());
            if (isTree && StrUtil.equals((CharSequence)field.getFieldCode(), (CharSequence)dataModel.getTreeLabelField().getFieldCode())) {
                col.setTreeNode(true);
            }
            group.addChild(col);
            gridModelData.addColumn(group);
        });
        return gridModelData;
    }

    private Row buildRow(DataModel model, JSONObject modelRow) {
        DataField pkField = model.getPkField();
        String pkValue = modelRow.getString(pkField.getFieldCode());
        Row row = StrUtil.isBlank((CharSequence)pkValue) ? model.buildRow() : model.buildRowById(pkValue);
        model.getNativeFields().stream().filter(field -> !field.isEmbed()).forEach(field -> {
            if (!field.isPk() && modelRow.containsKey(field.getFieldCode())) {
                switch (field.getFieldType()) {
                    case DATE: {
                        row.set(field.getName(), (Object)modelRow.getDate(field.getFieldCode()));
                        break;
                    }
                    case LONG: {
                        row.set(field.getName(), (Object)modelRow.getLong(field.getFieldCode()));
                        break;
                    }
                    case DOUBLE: {
                        row.set(field.getName(), (Object)modelRow.getDouble(field.getFieldCode()));
                        break;
                    }
                    case TEXT: 
                    case STRING: {
                        row.set(field.getName(), (Object)modelRow.getString(field.getFieldCode()));
                        break;
                    }
                    case BLOB: {
                        row.set(field.getName(), (Object)modelRow.getByte(field.getFieldCode()));
                        break;
                    }
                    case JSON: {
                        row.set(field.getName(), (Object)modelRow.getString(field.getFieldCode()));
                        break;
                    }
                    default: {
                        row.set(field.getName(), modelRow.get(field.getFieldCode()));
                    }
                }
            }
        });
        return row;
    }

    private void validateRow(DataModel model, ModelRow modelRow) {
        List<DataField> uniqueFields = model.getNativeFields().stream().filter(field -> field.isRequired() && !field.isPk() && !field.isEmbed()).collect(Collectors.toList());
        uniqueFields.forEach(field -> Assert.notNull((Object)modelRow.get(field.getFieldCode()), (String)"{}\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{field.getFieldName()}));
    }

    public void fillSerialField(DataModel model, ModelRow modelRow) {
        List<ModelProConfig.SerialField> serialFields = model.getSerialFields();
        CollUtil.forEach(serialFields, (CollUtil.Consumer & Serializable)(serialField, index) -> {
            if (!modelRow.containsKey(serialField.getField()) || StrUtil.isBlank((CharSequence)modelRow.getString(serialField.getField()))) {
                String serialNo = this.acSerialService.genSerialNo((ModelProConfig.SerialField)serialField, model.getModelCode(), modelRow);
                log.info("\u751f\u6210\u6d41\u6c34\u53f7:{}", (Object)serialNo);
                modelRow.put(serialField.getField(), serialNo);
            }
        });
    }

    private void checkUnique(DataModel model, ModelRow modelRow) {
        DataField pkField = model.getPkField();
        String pkValue = modelRow.getString(pkField.getFieldCode());
        model.getNativeFields().stream().filter(DataField::isUnique).forEach(field -> {
            QueryWrapper qw = QueryWrapper.create().from(model.table());
            if (model.hasLogicDelete()) {
                qw.where(model.getLogicField().column().eq((Object)0));
            }
            Object fieldValue = modelRow.get(field.getFieldCode());
            qw.where(field.column().eq(fieldValue, If::notNull));
            qw.where(pkField.column().ne((Object)pkValue, If::hasText));
            long existCount = Db.selectCountByQuery(qw);
            Assert.isFalse((existCount > 0L ? 1 : 0) != 0, (String)"{}:{}\u91cd\u590d", (Object[])new Object[]{field.getFieldName(), fieldValue});
        });
    }

    private void fillEmbedFields(DataModel model, Row row, boolean isNew) {
        model.getNativeFields().stream().filter(DataField::isEmbed).forEach(field -> {
            EmbedFields embedField = EmbedFields.getByCol(field.getName());
            if (embedField != null) {
                if (isNew) {
                    row.set(field.getName(), embedField.getFillValue().get());
                } else {
                    switch (embedField) {
                        case MODIFY_BY: 
                        case MODIFY_TIME: {
                            row.set(field.getName(), embedField.getFillValue().get());
                        }
                    }
                }
            }
        });
    }

    private ModelHandler getDataHandler(DataModel model) {
        if (model == null || StrUtil.isBlank((CharSequence)model.getModelHandler())) {
            return null;
        }
        try {
            ModelHandler modelHandler = (ModelHandler)SpringUtil.getBean(Class.forName(model.getModelHandler()));
            return modelHandler;
        }
        catch (Exception e) {
            log.error("\u6a21\u578b\u5904\u7406\u5668\u8c03\u7528\u5931\u8d25:", (Throwable)e);
            return null;
        }
    }

    private Type getEntityClass(ModelHandler modelHandler) {
        if (modelHandler == null) {
            return null;
        }
        for (ParameterizedType parameterizedType : TypeUtil.getGenerics((Class)AopUtils.getTargetClass((Object)modelHandler))) {
            if (!parameterizedType.getRawType().equals(ModelHandler.class)) continue;
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    public List<ModelRow> tree(String modelCode, Map<String, String> paramsMap, String pk) {
        DataModel dataModel = this.getDataModel(modelCode);
        Assert.isTrue((ModelDataType.TREE == dataModel.getDataType() ? 1 : 0) != 0, (String)"\u6a21\u578b\u6570\u636e\u7c7b\u578b\u4e0d\u662f\u6811\u5f62\u7ed3\u6784,\u4e0d\u652f\u6301\u6811\u5f62\u67e5\u8be2", (Object[])new Object[0]);
        Assert.isTrue((boolean)dataModel.treeFieldValid(), (String)"\u6a21\u578b\u6811\u5f62\u67e5\u8be2\u5b57\u6bb5\u4e0d\u5339\u914d,\u4e0d\u652f\u6301\u6811\u5f62\u67e5\u8be2", (Object[])new Object[0]);
        QueryWrapper qw = dataModel.getModelQueryWrapper();
        qw.where(this.buildQueryCondition(dataModel, paramsMap));
        List<Row> list = Db.selectListByQuery(qw);
        List<ModelRow> rowList = dataModel.toModelRows(list);
        rowList.forEach(row -> {
            row.put("value", row.get(dataModel.getTreeIdField().getFieldCode()));
            row.put("label", row.get(dataModel.getTreeLabelField().getFieldCode()));
        });
        List<ModelRow> tree = ModelUtil.toTree(rowList, dataModel.getTreeIdField().getFieldCode(), dataModel.getTreePidField().getFieldCode());
        if (StrUtil.isNotBlank((CharSequence)pk)) {
            ArrayList<ModelRow> treeList = new ArrayList<ModelRow>();
            ModelRow node = ModelUtil.findNodeById(tree, dataModel.getTreeIdField().getFieldCode(), pk);
            if (node != null) {
                treeList.add(node);
            }
            return treeList;
        }
        return tree;
    }

    public boolean isNew(DataModel dataModel, ModelRow modelRow) {
        String pkValue = modelRow.getString(dataModel.getPkField().getFieldCode());
        if (StrUtil.isBlank((CharSequence)pkValue)) {
            return true;
        }
        Row exist = Db.selectOneById(dataModel.getName(), dataModel.buildRowById(pkValue));
        return exist == null;
    }

    public QueryCondition buildQueryCondition(DataModel dataModel, Map<String, String> paramsMap) {
        return this.buildQueryCondition(dataModel, paramsMap, false);
    }

    public QueryCondition buildQueryCondition(DataModel dataModel, Map<String, String> paramsMap, boolean simple) {
        QueryCondition allQueryCondition = QueryCondition.createEmpty();
        HashMap equalsMap = new HashMap();
        HashMap<Condition, List> conditionMap = new HashMap<Condition, List>();
        paramsMap.forEach((key, value) -> {
            if (ObjectUtil.isNotEmpty((Object)value)) {
                DataField eqField = dataModel.getQueryFieldByCode((String)key);
                if (eqField != null) {
                    if (!conditionMap.containsKey((Object)Condition.EQ)) {
                        conditionMap.put(Condition.EQ, new ArrayList());
                    }
                    List list = (List)conditionMap.get((Object)Condition.EQ);
                    ConditionModel conditionModel = ConditionModel.of(eqField, false, eqField.valueToDb((String)value));
                    list.add(conditionModel);
                }
                Arrays.stream(Condition.values()).forEach(condition -> {
                    String queryAlias;
                    DataField queryField;
                    if (StrUtil.endWith((CharSequence)key, (CharSequence)condition.getSuffix()) && (queryField = dataModel.getQueryFieldByCode(queryAlias = StrUtil.removeSuffix((CharSequence)key, (CharSequence)condition.getSuffix()))) != null) {
                        if (!conditionMap.containsKey(condition)) {
                            conditionMap.put((Condition)((Object)condition), new ArrayList());
                        }
                        List list = (List)conditionMap.get(condition);
                        ConditionModel conditionModel = ConditionModel.of(queryField, condition.isMultiValue(), condition.isMultiValue() ? queryField.valuesToDb((String)value) : queryField.valueToDb((String)value));
                        list.add(conditionModel);
                    }
                });
            }
        });
        conditionMap.forEach((condition, list) -> {
            if (condition == Condition.LIKE) {
                QueryCondition likeCondition = QueryCondition.createEmpty();
                list.forEach(cond -> {
                    if (ObjectUtil.isNotEmpty((Object)cond.getConditionValue())) {
                        QueryColumn likeCol = simple ? cond.getField().simpleQueryColumn() : new QueryColumn(cond.getField().column().getTable(), cond.getField().getName());
                        likeCondition.or(QueryMethods.upper((QueryColumn)likeCol).like((Object)cond.getConditionValue().toString().toUpperCase()));
                    }
                });
                allQueryCondition.and(QueryCondition.createEmpty().and(likeCondition));
            } else if (condition == Condition.IS_NOT_NULL || condition == Condition.IS_NULL) {
                list.forEach(cond -> {
                    boolean affect = Convert.toBool((Object)cond.getConditionValue());
                    if (affect) {
                        QueryCondition queryCondition = QueryCondition.create((QueryColumn)(simple ? cond.getField().simpleQueryColumn() : cond.getField().column()), (SqlOperator)condition.getOperator(), null);
                        allQueryCondition.and(queryCondition);
                    }
                });
            } else if (condition == Condition.IS_EMPTY) {
                list.forEach(cond -> {
                    boolean affect = Convert.toBool((Object)cond.getConditionValue());
                    if (affect) {
                        QueryCondition emptyCondition = QueryCondition.createEmpty();
                        QueryColumn emptyCol = simple ? cond.getField().simpleQueryColumn() : cond.getField().column();
                        emptyCondition.and((QueryCondition)emptyCol.isNull()).or(emptyCol.eq((Object)""));
                        allQueryCondition.and(QueryCondition.createEmpty().and(emptyCondition));
                    }
                });
            } else if (condition == Condition.NOT_EMPTY) {
                list.forEach(cond -> {
                    boolean affect = Convert.toBool((Object)cond.getConditionValue());
                    if (affect) {
                        QueryCondition emptyCondition = QueryCondition.createEmpty();
                        QueryColumn emptyCol = simple ? cond.getField().simpleQueryColumn() : cond.getField().column();
                        emptyCondition.and((QueryCondition)emptyCol.isNotNull()).and(emptyCol.ne((Object)""));
                        allQueryCondition.and(QueryCondition.createEmpty().and(emptyCondition));
                    }
                });
            } else {
                list.forEach(cond -> {
                    QueryCondition queryCondition = cond.isMultiValue() ? QueryCondition.create((QueryColumn)(simple ? cond.getField().simpleQueryColumn() : cond.getField().column()), (SqlOperator)condition.getOperator(), (Collection)((ArrayList)cond.getConditionValue())) : QueryCondition.create((QueryColumn)(simple ? cond.getField().simpleQueryColumn() : cond.getField().column()), (SqlOperator)condition.getOperator(), (Object)cond.getConditionValue());
                    allQueryCondition.and(queryCondition);
                });
            }
        });
        return allQueryCondition;
    }

    public QueryWrapper buildQueryOrders(QueryWrapper queryWrapper, DataModel dataModel, Map<String, String> paramsMap) {
        PageRequest pageRequest = PageRequest.empty();
        pageRequest.buildSorts(paramsMap.get("_sorts"), paramsMap.get("_orders"));
        if (pageRequest.hasSorts()) {
            queryWrapper.clearOrderBy();
            pageRequest.getSorts().forEach(item -> {
                PageRequest.OrderItem orderItem = (PageRequest.OrderItem)item;
                DataField dataField = dataModel.getQueryFieldByAlias(orderItem.getField());
                if (dataField != null) {
                    queryWrapper.orderBy(dataField.column(), (Boolean)orderItem.isAsc());
                }
            });
        }
        return queryWrapper;
    }

    public void buildProcessInfo(List<ModelRow> list, String pkFieldCode) {
        ProcessInfoProvider processInfoService = (ProcessInfoProvider)SpringUtil.getBean(ProcessInfoProvider.class);
        if (processInfoService != null) {
            list.stream().forEach(row -> {
                ProcessInfo process = processInfoService.getProcessInfo(row.get(pkFieldCode).toString(), SecurityUtil.getUserId());
                row.put("_".concat("flow"), process);
            });
        }
    }
}

