/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.pojo.query;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.kdgcsoft.web.ac.entity.AcModel;
import com.kdgcsoft.web.ac.entity.AcModelField;
import com.kdgcsoft.web.ac.enums.TransType;
import com.kdgcsoft.web.ac.enums.dict.ModelDataType;
import com.kdgcsoft.web.ac.enums.dict.ModelType;
import com.kdgcsoft.web.ac.pojo.ModelProConfig;
import com.kdgcsoft.web.ac.pojo.ModelRelation;
import com.kdgcsoft.web.ac.pojo.ModelRow;
import com.kdgcsoft.web.ac.pojo.TreeFields;
import com.kdgcsoft.web.ac.pojo.query.DataField;
import com.kdgcsoft.web.ac.pojo.query.FieldNature;
import com.kdgcsoft.web.ac.pojo.query.JoinQueryModel;
import com.kdgcsoft.web.ac.pojo.query.RefSubModel;
import com.kdgcsoft.web.ac.service.AcDataTransService;
import com.kdgcsoft.web.ac.service.AcModelService;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataModel
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(DataModel.class);
    private String modelId;
    private String modelCode;
    private String appCode;
    private String modelName;
    private QueryTable table;
    private ModelType modelType;
    private ModelDataType dataType;
    private TreeFields treeFields;
    private boolean cascadeDelete = false;
    private String modelHandler;
    private List<DataField> nativeFields = new ArrayList<DataField>();
    private List<DataField> queryFields = new ArrayList<DataField>();
    private List<DataField> orderByFields = new ArrayList<DataField>();
    private List<ModelProConfig.SerialField> serialFields = new ArrayList<ModelProConfig.SerialField>();
    private List<JoinQueryModel> joinQueryModelList = new ArrayList<JoinQueryModel>();
    private DataField pkField;
    private DataField treeIdField;
    private DataField treePidField;
    private DataField treeLabelField;
    private DataField logicField;
    private Map<String, RefSubModel> refSubModelMap = new HashMap<String, RefSubModel>();
    public static final String DEF_TABLE_ALIAS = "t";
    public static final String SUB_MODEL_PREFIX = "ref";

    public static DataModel of(AcModel model) {
        DataModel dataModel = new DataModel();
        BeanUtil.copyProperties((Object)model, (Object)dataModel, (String[])new String[0]);
        QueryTable queryTable = new QueryTable(model.getTableName());
        queryTable.setAlias(DEF_TABLE_ALIAS);
        dataModel.setTable(queryTable);
        boolean configCascadeDel = model.getProConfig() == null ? false : model.getProConfig().isCascadeDelete();
        dataModel.setCascadeDelete(dataModel.getDataType() == ModelDataType.TREE && configCascadeDel);
        dataModel.buildNativeFields(model.getFields());
        dataModel.buildTransFields(model.getProConfig() == null ? null : model.getProConfig().getTransFields());
        dataModel.buildSortFields(model.getProConfig() == null ? null : model.getProConfig().getSortFields());
        dataModel.setSerialFields(model.getProConfig() == null ? null : model.getProConfig().getSerialFields());
        dataModel.buildSubModels(model.getSubModels());
        dataModel.warnValidate();
        return dataModel;
    }

    private void buildNativeFields(List<AcModelField> fields) {
        CollUtil.forEach(fields, (CollUtil.Consumer & Serializable)(field, index) -> {
            DataField dataField = DataField.of(field);
            dataField.setFieldNature(FieldNature.NATIVE);
            dataField.setAlias(field.getFieldCode());
            dataField.setTable(this.getTable());
            this.nativeFields.add(dataField);
            if (!dataField.isEmbed()) {
                this.queryFields.add(dataField);
            }
            this.adapterNativeField(dataField);
        });
    }

    private void adapterNativeField(DataField field) {
        if (field.isPk()) {
            this.pkField = field;
        }
        if (field.isLogicDelete()) {
            this.logicField = field;
        }
        if (this.treeFields != null && this.treeFields.getIdField().equals(field.getFieldCode())) {
            this.treeIdField = field;
        }
        if (this.treeFields != null && this.treeFields.getPidField().equals(field.getFieldCode())) {
            this.treePidField = field;
        }
        if (this.treeFields != null && this.treeFields.getLabelField().equals(field.getFieldCode())) {
            this.treeLabelField = field;
        }
    }

    private void buildTransFields(List<ModelProConfig.TransField> transModelFields) {
        HashMap<String, List> joinMap = new HashMap<String, List>();
        CollUtil.forEach(transModelFields, (CollUtil.Consumer & Serializable)(transModelField, index) -> {
            if (!transModelField.getType().equals((Object)TransType.JOIN)) {
                DataField dataField = this.getNativeFieldByCode(transModelField.getField());
                if (dataField != null) {
                    DataField transField = (DataField)BeanUtil.copyProperties((Object)dataField, DataField.class, (String[])new String[0]);
                    transField.setFieldNature(FieldNature.TRANS);
                    transField.setTransType(transModelField.getType());
                    transField.setTransCode(transModelField.getType() == TransType.DICT ? transModelField.getDictCode() : transModelField.getModelCode());
                    transField.setColumn(new QueryColumn(dataField.column().getTable(), dataField.getName(), transModelField.getAlias()));
                    transField.setFieldName(transField.getFieldName() + "(" + transField.getTransType().getText() + ")");
                    this.queryFields.add(transField);
                }
            } else {
                if (!joinMap.containsKey(transModelField.joinConditionKey())) {
                    joinMap.put(transModelField.joinConditionKey(), new ArrayList());
                }
                ((List)joinMap.get(transModelField.joinConditionKey())).add(transModelField);
            }
        });
        AtomicInteger tableIndex = new AtomicInteger();
        joinMap.forEach((key, joinQueryFields) -> {
            List keys = StrUtil.split((CharSequence)key, (CharSequence)",");
            String joinModelCode = (String)keys.get(0);
            String mainFieldCode = (String)keys.get(1);
            String joinFieldCode = (String)keys.get(2);
            AcModelService acModelService = (AcModelService)((Object)((Object)SpringUtil.getBean(AcModelService.class)));
            DataModel joinDataModel = acModelService.getDataModel(joinModelCode);
            if (joinDataModel != null) {
                JoinQueryModel joinQueryModel = new JoinQueryModel();
                joinDataModel.setAlias(DEF_TABLE_ALIAS + tableIndex);
                tableIndex.getAndIncrement();
                joinQueryModel.setJoinTable(joinDataModel.getTable());
                DataField mField = this.getNativeFieldByCode(mainFieldCode);
                DataField joinField = joinDataModel.getNativeFieldByCode(joinFieldCode);
                QueryCondition joinCondition = mField.column().eq((Object)joinField.column()).and(joinDataModel.getLogicField().column().eq((Object)0, joinDataModel.hasLogicDelete()));
                joinQueryModel.setJoinCondition(joinCondition);
                this.joinQueryModelList.add(joinQueryModel);
                joinQueryFields.forEach(transField -> {
                    DataField qField = joinDataModel.getNativeFieldByCode(transField.getQueryField());
                    if (qField != null) {
                        qField.setFieldNature(FieldNature.JOIN);
                        qField.setAlias(transField.getAlias());
                        this.queryFields.add(qField);
                        this.queryFields.addAll(joinDataModel.getRelationTransFields(qField));
                    }
                });
            }
        });
    }

    private void buildSortFields(List<ModelProConfig.SortField> sortModelFields) {
        CollUtil.forEach(sortModelFields, (CollUtil.Consumer & Serializable)(sortModelField, index) -> {
            DataField sortField = this.getNativeFieldByCode(sortModelField.getField());
            if (sortField != null) {
                sortField.setSort(true).setSortAsc(Convert.toBool((Object)sortModelField.getAsc()));
                this.orderByFields.add(sortField);
            }
        });
    }

    private void buildSubModels(List<ModelRelation> relations) {
        AcModelService acModelService = (AcModelService)((Object)SpringUtil.getBean(AcModelService.class));
        CollUtil.forEach(relations, (CollUtil.Consumer & Serializable)(relation, index) -> {
            if (StrUtil.isAllNotBlank((CharSequence[])new CharSequence[]{relation.getFieldCode(), relation.getRelModelCode(), relation.getRelFieldCode()})) {
                DataField refSubField;
                DataModel subModel = acModelService.getDataModel(relation.getRelModelCode());
                DataField mainField = this.getNativeFieldByCode(relation.getFieldCode());
                DataField dataField = refSubField = subModel == null ? null : subModel.getNativeFieldByCode(relation.getRelFieldCode());
                if (mainField != null && refSubField != null) {
                    RefSubModel refSubModel = new RefSubModel();
                    refSubModel.setRefMainField(mainField);
                    refSubModel.setDataModel(subModel);
                    refSubModel.setRefSubField(refSubField);
                    refSubModel.setRefAlias((String)(StrUtil.isNotBlank((CharSequence)relation.getRelAlias()) ? relation.getRelAlias() : SUB_MODEL_PREFIX + relation.getRelModelCode()));
                    refSubModel.setRefType(relation.getRelType());
                    refSubModel.setRefDelete(relation.isRelDelete());
                    this.refSubModelMap.put(refSubModel.getRefAlias(), refSubModel);
                }
            }
        });
    }

    public boolean hasLogicDelete() {
        return this.logicField != null;
    }

    public boolean treeFieldValid() {
        return this.treeIdField != null && this.treePidField != null && this.treeLabelField != null;
    }

    public List<QueryColumn> getQueryColumns() {
        return this.queryFields.stream().map(DataField::column).collect(Collectors.toList());
    }

    public List<QueryColumn> getAssignedQueryColumns(List<String> fieldCodes) {
        List fields = this.queryFields.stream().filter(field -> fieldCodes.contains(field.getFieldCode()) && field.getFieldNature() != FieldNature.JOIN).collect(Collectors.toList());
        return fields.stream().map(DataField::column).collect(Collectors.toList());
    }

    public DataField getNativeFieldByCode(String fieldCode) {
        return (DataField)CollUtil.findOne(this.nativeFields, field -> StrUtil.equals((CharSequence)fieldCode, (CharSequence)field.getFieldCode()));
    }

    public DataField getQueryFieldByCode(String fieldCode) {
        return (DataField)CollUtil.findOne(this.queryFields, field -> StrUtil.equals((CharSequence)fieldCode, (CharSequence)field.getFieldCode()));
    }

    public DataField getQueryFieldByAlias(String columnAlias) {
        return (DataField)CollUtil.findOne(this.queryFields, field -> StrUtil.equals((CharSequence)columnAlias, (CharSequence)field.getAlias()));
    }

    public List<DataField> getRelationTransFields(DataField field) {
        return this.queryFields.stream().filter(f -> StrUtil.equals((CharSequence)field.getFieldCode(), (CharSequence)f.getFieldCode()) && f.getFieldNature() == FieldNature.TRANS).collect(Collectors.toList());
    }

    public QueryTable table() {
        return this.table;
    }

    public void setAlias(String alias) {
        this.table.setAlias(alias);
    }

    public RowKey getRowKey() {
        return RowKey.of((String)this.getPkField().getName(), (KeyType)KeyType.Generator, (String)"flexStrId");
    }

    public Row buildRow() {
        return Row.ofKey((RowKey[])new RowKey[]{this.getRowKey()});
    }

    public Row buildRowById(Object id) {
        return Row.ofKey((RowKey)this.getRowKey(), (Object)id);
    }

    public ModelRow toModelRow(Row row) {
        ModelRow modelRow = new ModelRow();
        if (row == null) {
            log.error("\u884c\u6570\u636e\u4e3a\u7a7a");
            return modelRow;
        }
        modelRow.putAll((Map)row);
        CollUtil.forEach(this.queryFields, (CollUtil.Consumer & Serializable)(field, index) -> {
            if (field.getFieldNature() == FieldNature.TRANS) {
                modelRow.put(field.getAlias(), this.transValue(field.getTransType(), field.getTransCode(), row.get((Object)field.getAlias())));
            }
        });
        return modelRow;
    }

    public Object transValue(TransType transType, String transCode, Object value) {
        if (transType != null && value instanceof String && StrUtil.isNotBlank((CharSequence)transCode)) {
            AcDataTransService transService = (AcDataTransService)SpringUtil.getBean(AcDataTransService.class);
            return transService.transValue(transType, transCode, value);
        }
        return value;
    }

    public List<ModelRow> toModelRows(List<Row> rows) {
        ArrayList<ModelRow> modelRowList = new ArrayList<ModelRow>();
        if (CollUtil.isNotEmpty(rows)) {
            rows.forEach(row -> modelRowList.add(this.toModelRow((Row)row)));
        }
        return modelRowList;
    }

    public Page<ModelRow> toModelRowPage(Page<Row> page) {
        Page modelDataPage = new Page();
        modelDataPage.setPageNumber(page.getPageNumber());
        modelDataPage.setPageSize(page.getPageSize());
        modelDataPage.setTotalPage(page.getTotalPage());
        modelDataPage.setTotalRow(page.getTotalRow());
        modelDataPage.setOptimizeCountQuery(page.needOptimizeCountQuery());
        modelDataPage.setRecords(this.toModelRows(page.getRecords()));
        return modelDataPage;
    }

    public void warnValidate() {
        ArrayList warnMessages = new ArrayList();
        ArrayList queryAliases = new ArrayList();
        this.queryFields.forEach(field -> {
            if (queryAliases.contains(field.getAlias())) {
                warnMessages.add(StrUtil.format((CharSequence)"\u6a21\u578b\u67e5\u8be2\u51fa\u73b0\u91cd\u590d\u5b57\u6bb5[{}],\u6765\u6e90:{},\u539f\u59cb\u5b57\u6bb5:{}", (Object[])new Object[]{field.getAlias(), field.getFieldNature().getText(), field.getFieldCode()}));
            } else {
                queryAliases.add(field.getAlias());
            }
        });
        if (!warnMessages.isEmpty()) {
            log.warn("\u6a21\u578b{}\u51fa\u73b0\u6821\u9a8c\u8b66\u544a:", (Object)this.modelCode);
            warnMessages.forEach(arg_0 -> ((Logger)log).warn(arg_0));
            log.warn("\u53ef\u80fd\u9020\u6210\u6a21\u578b\u76f8\u5173\u64cd\u4f5c\u4e0e\u7ed3\u679c\u4e0d\u5339\u914d");
        }
    }

    public QueryWrapper getModelQueryWrapper() {
        QueryWrapper qw = QueryWrapper.create().from(this.table);
        qw.select(this.getQueryColumns());
        if (this.hasLogicDelete()) {
            qw.and(this.getLogicField().column().eq((Object)0, this.hasLogicDelete()));
        }
        this.joinQueryModelList.forEach(joinQueryModel -> qw.leftJoin(joinQueryModel.getJoinTable()).on(joinQueryModel.getJoinCondition()));
        this.orderByFields.forEach(sortField -> qw.orderBy(sortField.column(), (Boolean)sortField.isSortAsc()));
        return qw;
    }

    public QueryWrapper getNativeQueryWrapper() {
        QueryWrapper qw = QueryWrapper.create().from(this.table);
        List<QueryColumn> nativeColumns = this.nativeFields.stream().map(DataField::column).collect(Collectors.toList());
        qw.select(nativeColumns);
        if (this.hasLogicDelete()) {
            qw.and(this.getLogicField().column().eq((Object)0, this.hasLogicDelete()));
        }
        return qw;
    }

    public String getName() {
        return this.table.getName();
    }

    public DataModel setModelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    public DataModel setModelCode(String modelCode) {
        this.modelCode = modelCode;
        return this;
    }

    public DataModel setAppCode(String appCode) {
        this.appCode = appCode;
        return this;
    }

    public DataModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    public DataModel setTable(QueryTable table) {
        this.table = table;
        return this;
    }

    public DataModel setModelType(ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    public DataModel setDataType(ModelDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public DataModel setTreeFields(TreeFields treeFields) {
        this.treeFields = treeFields;
        return this;
    }

    public DataModel setCascadeDelete(boolean cascadeDelete) {
        this.cascadeDelete = cascadeDelete;
        return this;
    }

    public DataModel setModelHandler(String modelHandler) {
        this.modelHandler = modelHandler;
        return this;
    }

    public DataModel setNativeFields(List<DataField> nativeFields) {
        this.nativeFields = nativeFields;
        return this;
    }

    public DataModel setQueryFields(List<DataField> queryFields) {
        this.queryFields = queryFields;
        return this;
    }

    public DataModel setOrderByFields(List<DataField> orderByFields) {
        this.orderByFields = orderByFields;
        return this;
    }

    public DataModel setSerialFields(List<ModelProConfig.SerialField> serialFields) {
        this.serialFields = serialFields;
        return this;
    }

    public DataModel setJoinQueryModelList(List<JoinQueryModel> joinQueryModelList) {
        this.joinQueryModelList = joinQueryModelList;
        return this;
    }

    public DataModel setPkField(DataField pkField) {
        this.pkField = pkField;
        return this;
    }

    public DataModel setTreeIdField(DataField treeIdField) {
        this.treeIdField = treeIdField;
        return this;
    }

    public DataModel setTreePidField(DataField treePidField) {
        this.treePidField = treePidField;
        return this;
    }

    public DataModel setTreeLabelField(DataField treeLabelField) {
        this.treeLabelField = treeLabelField;
        return this;
    }

    public DataModel setLogicField(DataField logicField) {
        this.logicField = logicField;
        return this;
    }

    public DataModel setRefSubModelMap(Map<String, RefSubModel> refSubModelMap) {
        this.refSubModelMap = refSubModelMap;
        return this;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getModelCode() {
        return this.modelCode;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getModelName() {
        return this.modelName;
    }

    public QueryTable getTable() {
        return this.table;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public ModelDataType getDataType() {
        return this.dataType;
    }

    public TreeFields getTreeFields() {
        return this.treeFields;
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    public String getModelHandler() {
        return this.modelHandler;
    }

    public List<DataField> getNativeFields() {
        return this.nativeFields;
    }

    public List<DataField> getQueryFields() {
        return this.queryFields;
    }

    public List<DataField> getOrderByFields() {
        return this.orderByFields;
    }

    public List<ModelProConfig.SerialField> getSerialFields() {
        return this.serialFields;
    }

    public List<JoinQueryModel> getJoinQueryModelList() {
        return this.joinQueryModelList;
    }

    public DataField getPkField() {
        return this.pkField;
    }

    public DataField getTreeIdField() {
        return this.treeIdField;
    }

    public DataField getTreePidField() {
        return this.treePidField;
    }

    public DataField getTreeLabelField() {
        return this.treeLabelField;
    }

    public DataField getLogicField() {
        return this.logicField;
    }

    public Map<String, RefSubModel> getRefSubModelMap() {
        return this.refSubModelMap;
    }

    public static final class Fields {
        public static final String modelId = "modelId";
        public static final String modelCode = "modelCode";
        public static final String appCode = "appCode";
        public static final String modelName = "modelName";
        public static final String table = "table";
        public static final String modelType = "modelType";
        public static final String dataType = "dataType";
        public static final String treeFields = "treeFields";
        public static final String cascadeDelete = "cascadeDelete";
        public static final String modelHandler = "modelHandler";
        public static final String nativeFields = "nativeFields";
        public static final String queryFields = "queryFields";
        public static final String orderByFields = "orderByFields";
        public static final String serialFields = "serialFields";
        public static final String joinQueryModelList = "joinQueryModelList";
        public static final String pkField = "pkField";
        public static final String treeIdField = "treeIdField";
        public static final String treePidField = "treePidField";
        public static final String treeLabelField = "treeLabelField";
        public static final String logicField = "logicField";
        public static final String refSubModelMap = "refSubModelMap";
    }
}

