/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.enums.dict;

import cn.hutool.core.convert.Convert;
import cn.hutool.json.JSONUtil;
import com.kdgcsoft.web.core.anno.EnumDict;
import java.util.Date;
import java.util.function.Function;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.metadata.type.init.StandardTypeMetadata;

@EnumDict(value="\u5b57\u6bb5\u7c7b\u578b")
public enum FieldType {
    STRING("\u5b57\u7b26", String.class, 32, null, StandardTypeMetadata.VARCHAR, s -> s),
    LONG("\u6574\u6570", Long.class, 10, null, StandardTypeMetadata.INT4, Convert::toLong),
    DOUBLE("\u5c0f\u6570", Double.class, 10, 2, StandardTypeMetadata.DOUBLE, Convert::toDouble),
    TEXT("\u5927\u6587\u672c", String.class, null, null, StandardTypeMetadata.TEXT, s -> s),
    DATE("\u65e5\u671f", Date.class, null, null, StandardTypeMetadata.DATE, Convert::toDate),
    BLOB("\u5b57\u8282", Byte.class, null, null, StandardTypeMetadata.BLOB, s -> s),
    JSON("JSON\u5bf9\u8c61", String.class, null, null, StandardTypeMetadata.TEXT, JSONUtil::parseObj),
    LOGIC_DELETE("\u903b\u8f91\u5220\u9664", Integer.class, 1, null, StandardTypeMetadata.SMALLINT, Convert::toInt);

    private final String text;
    private final Class javaType;
    private final Integer size;
    private final Integer scale;
    private final StandardTypeMetadata standardType;
    private Function<String, Object> toDbValue;

    private FieldType(String text, Class javaType, Integer size, Integer scale, StandardTypeMetadata standardType, Function<String, Object> toDbValue) {
        this.text = text;
        this.javaType = javaType;
        this.size = size;
        this.scale = scale;
        this.standardType = standardType;
        this.toDbValue = toDbValue;
    }

    public static FieldType getByDbType(StandardTypeMetadata standardType) {
        switch (standardType) {
            case VARCHAR: 
            case CHAR: {
                return STRING;
            }
            case INT4: 
            case INT8: 
            case BIGINT: {
                return LONG;
            }
            case DATE: {
                return DATE;
            }
            case TEXT: {
                return TEXT;
            }
            case BLOB: 
            case BYTE: {
                return BLOB;
            }
            case FLOAT: {
                return DOUBLE;
            }
        }
        return STRING;
    }

    public static FieldType getByCategory(TypeMetadata.CATEGORY category) {
        switch (category) {
            case CHAR: {
                return STRING;
            }
            case DATE: 
            case DATETIME: 
            case TIMESTAMP: {
                return DATE;
            }
            case TEXT: {
                return TEXT;
            }
            case BLOB: 
            case BYTES: {
                return BLOB;
            }
            case INT: {
                return LONG;
            }
            case FLOAT: {
                return DOUBLE;
            }
        }
        return STRING;
    }

    public Object toDbValue(String value) {
        return this.toDbValue.apply(value);
    }

    public String getText() {
        return this.text;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getScale() {
        return this.scale;
    }

    public StandardTypeMetadata getStandardType() {
        return this.standardType;
    }

    public Function<String, Object> getToDbValue() {
        return this.toDbValue;
    }
}

