/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.enums;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.EnumUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.entity.AcModelField;
import com.kdgcsoft.web.ac.enums.dict.FieldType;
import com.kdgcsoft.web.config.security.SecurityUtil;
import com.kdgcsoft.web.core.enums.YesNo;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;

public enum EmbedFields {
    TENANT_ID("tenant_id", "\u79df\u6237ID", FieldType.STRING, () -> ""),
    LOGIC_DELETE("deleted", "\u903b\u8f91\u5220\u9664", FieldType.LOGIC_DELETE, () -> 0),
    CREATE_BY("create_by", "\u521b\u5efa\u4eba", FieldType.STRING, SecurityUtil::getUserId),
    CREATE_TIME("create_time", "\u521b\u5efa\u65f6\u95f4", FieldType.DATE, DateTime::now),
    MODIFY_BY("modify_by", "\u4fee\u6539\u4eba", FieldType.STRING, SecurityUtil::getUserId),
    MODIFY_TIME("modify_time", "\u4fee\u6539\u65f6\u95f4", FieldType.DATE, DateTime::now);

    private final String colName;
    private final FieldType fieldType;
    private final String fieldName;
    private final Supplier fillValue;

    private EmbedFields(String colName, String fieldName, FieldType fieldType, Supplier fillValue) {
        this.colName = colName;
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.fillValue = fillValue;
    }

    public static EmbedFields getByCol(String colName) {
        return (EmbedFields)EnumUtil.getBy(EmbedFields.class, embedFields -> StrUtil.equalsIgnoreCase((CharSequence)embedFields.getColName(), (CharSequence)colName));
    }

    public static boolean isEmbedField(String colName) {
        return Arrays.stream(EmbedFields.values()).anyMatch(embedFields -> StrUtil.equalsIgnoreCase((CharSequence)embedFields.getColName(), (CharSequence)colName));
    }

    public static AcModelField buildEmbedField(String colName) {
        Optional<EmbedFields> optional = Arrays.stream(EmbedFields.values()).filter(embedFields -> StrUtil.equalsIgnoreCase((CharSequence)embedFields.getColName(), (CharSequence)colName)).findFirst();
        if (optional.isPresent()) {
            EmbedFields embedField = optional.get();
            AcModelField field = new AcModelField();
            field.setEmbed(YesNo.Y).setColName(embedField.getColName()).setFieldCode(NamingCase.toCamelCase((CharSequence)colName)).setFieldName(embedField.getFieldName());
            field.setFieldType(embedField.getFieldType()).setFieldSize(embedField.getFieldType().getSize());
            field.setIsPk(YesNo.N).setNotNull(YesNo.Y);
            field.setOrderNo(10000 + embedField.ordinal());
            return field;
        }
        return null;
    }

    public String getColName() {
        return this.colName;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Supplier getFillValue() {
        return this.fillValue;
    }
}

