/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.entity;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.entity.AcModelField;
import com.kdgcsoft.web.ac.enums.dict.ModelDataType;
import com.kdgcsoft.web.ac.enums.dict.ModelSyncStatus;
import com.kdgcsoft.web.ac.enums.dict.ModelType;
import com.kdgcsoft.web.ac.pojo.ModelProConfig;
import com.kdgcsoft.web.ac.pojo.ModelRelation;
import com.kdgcsoft.web.ac.pojo.TreeFields;
import com.kdgcsoft.web.core.entity.base.AuditEntity;
import com.kdgcsoft.web.core.enums.YesNo;
import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.RelationOneToMany;
import com.mybatisflex.annotation.Table;
import com.mybatisflex.core.handler.Fastjson2TypeHandler;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

@Table(value="ac_model")
public class AcModel
extends AuditEntity {
    @Schema(name="\u6a21\u578bID", title="")
    @Id
    private String modelId;
    @Schema(name="\u6240\u5c5e\u5e94\u7528", title="")
    private String appCode;
    @Schema(name="\u6a21\u578b\u7f16\u7801", title="")
    private String modelCode;
    @Schema(name="\u6a21\u578b\u540d\u79f0", title="")
    @NotBlank(message="\u6a21\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u6a21\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String modelName;
    @Schema(name="\u6a21\u578b\u7c7b\u578b", title="")
    @NotNull(message="\u6a21\u578b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u6a21\u578b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") ModelType modelType;
    @Schema(name="\u6570\u636e\u5e93\u8868\u540d", title="")
    @NotBlank(message="\u6570\u636e\u5e93\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u6570\u636e\u5e93\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a") String tableName;
    @Schema(name="\u6700\u540e\u4e00\u6b21\u540c\u6b65\u540e\u7684\u6570\u636e\u5e93\u8868\u540d", title="")
    private String lastDbName;
    @Schema(name="\u5185\u7f6e\u6a21\u578b", title="")
    private YesNo embed;
    @Schema(name="\u6570\u636e\u5e93\u540c\u6b65\u72b6\u6001", title="")
    private ModelSyncStatus syncStatus;
    @Schema(name="\u6a21\u578b\u7684\u9ad8\u7ea7\u8bbe\u7f6e", title="")
    @Column(typeHandler=Fastjson2TypeHandler.class)
    private ModelProConfig proConfig;
    @Schema(name="\u6570\u636e\u7c7b\u578b", title="")
    private ModelDataType dataType;
    @Schema(name="\u6a21\u578b\u7684\u5173\u952e\u7ed3\u6784\u5b57\u6bb5", title="")
    @Column(typeHandler=Fastjson2TypeHandler.class)
    private TreeFields treeFields;
    @Schema(name="\u6a21\u578b\u6570\u636e\u5904\u7406\u7684\u5904\u7406\u5668", title="")
    private String modelHandler;
    @Schema(name="\u63cf\u8ff0", title="")
    private String description;
    @RelationOneToMany(selfField="modelCode", targetField="modelCode", orderBy="order_no")
    private List<AcModelField> fields;
    @Schema(name="\u5173\u8054\u5b50\u6a21\u578b", title="")
    @Column(typeHandler=Fastjson2TypeHandler.class)
    private List<ModelRelation> subModels;
    @Column(ignore=true)
    private boolean imported = false;

    public void buildAndValidate() {
        this.tableName = StringUtils.lowerCase((String)this.tableName);
        this.embed = (YesNo)((Object)ObjectUtil.defaultIfNull((Object)((Object)this.embed), (Object)((Object)YesNo.N)));
        if (this.modelId == null) {
            this.modelCode = NamingCase.toPascalCase((CharSequence)this.tableName);
        }
        Assert.notBlank((CharSequence)this.modelCode, (String)"\u6a21\u578b[{}]\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{this.modelName});
        if (CollUtil.isEmpty(this.fields)) {
            return;
        }
        ArrayList<AcModelField> pkFields = new ArrayList<AcModelField>();
        ArrayList<String> fieldCodes = new ArrayList<String>();
        ListIterator<AcModelField> iterator = this.fields.listIterator();
        while (iterator.hasNext()) {
            AcModelField field2 = iterator.next();
            if (StrUtil.isBlank((CharSequence)field2.getFieldName()) || StrUtil.isBlank((CharSequence)field2.getColName())) {
                iterator.remove();
            }
            field2.setModelCode(this.modelCode);
            field2.settleField();
            if (YesNo.Y == field2.getIsPk()) {
                pkFields.add(field2);
            }
            Assert.notBlank((CharSequence)field2.getFieldCode(), (String)"\u5b57\u6bb5[{}]\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[]{field2.getFieldName()});
            Assert.isFalse((boolean)fieldCodes.contains(field2.getFieldCode()), (String)"\u5b57\u6bb5[{}]\u7f16\u7801[{}]\u91cd\u590d", (Object[])new Object[]{field2.getFieldName(), field2.getFieldCode()});
            fieldCodes.add(field2.getFieldCode());
        }
        CollUtil.forEach(this.fields, (CollUtil.Consumer & Serializable)(field, index) -> {
            if (field.getEmbed() == YesNo.N) {
                field.setOrderNo(index);
            }
        });
        if (this.modelType == ModelType.T) {
            Assert.notEmpty(pkFields, (String)"\u6a21\u578b\u9700\u8981\u4e00\u4e2a\u4e3b\u952e\u5217", (Object[])new Object[0]);
            Assert.state((pkFields.size() == 1 ? 1 : 0) != 0, (String)"\u6a21\u578b\u6682\u4e0d\u652f\u6301\u591a\u4e3b\u952e\u5217", (Object[])new Object[0]);
        }
        if (this.dataType == ModelDataType.TREE) {
            Assert.notNull((Object)this.treeFields, (String)"\u6811\u5f62\u6a21\u578b\u9700\u8981\u914d\u7f6e\u6811\u5f62\u5b57\u6bb5", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)this.treeFields.getIdField(), (String)"\u6811\u5f62\u6a21\u578b\u9700\u8981\u914d\u7f6e\u8282\u70b9\u5b57\u6bb5", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)this.treeFields.getPidField(), (String)"\u6811\u5f62\u6a21\u578b\u9700\u8981\u914d\u7f6e\u7236\u8282\u70b9\u5b57\u6bb5", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)this.treeFields.getLabelField(), (String)"\u6811\u5f62\u6a21\u578b\u9700\u8981\u914d\u7f6e\u8282\u70b9\u6587\u5b57\u5b57\u6bb5", (Object[])new Object[0]);
        }
        if (this.proConfig != null && this.proConfig.getTransFields() != null) {
            this.proConfig.getTransFields().removeIf(transField -> !transField.isValid());
            this.proConfig.getTransFields().forEach(transField -> {
                String alias = transField.getAlias();
                Assert.isFalse((boolean)fieldCodes.contains(alias), (String)"\u7ffb\u8bd1\u5b57\u6bb5\u522b\u540d\u4e0e\u6a21\u578b\u5b57\u6bb5\u91cd\u590d,{}", (Object[])new Object[]{alias});
            });
        }
    }

    public List<AcModelField> getNormalFields() {
        return this.fields.stream().filter(field -> field.getEmbed() != YesNo.Y).collect(Collectors.toList());
    }

    public AcModelField getFieldByColName(String colName) {
        return (AcModelField)CollUtil.findOne(this.fields, field -> StrUtil.equalsIgnoreCase((CharSequence)colName, (CharSequence)field.getColName()));
    }

    public AcModelField getFieldByCode(String fieldCode) {
        return (AcModelField)CollUtil.findOne(this.fields, field -> StrUtil.equalsIgnoreCase((CharSequence)fieldCode, (CharSequence)field.getFieldCode()));
    }

    public ModelSyncStatus genSyncStatus(AcModel model) {
        List columnStr2;
        if (model.getSyncStatus() == ModelSyncStatus.UN_SYNCED || !StrUtil.equalsIgnoreCase((CharSequence)this.tableName, (CharSequence)model.getTableName()) || CollUtil.size(this.fields) != CollUtil.size(model.getFields())) {
            return ModelSyncStatus.UN_SYNCED;
        }
        List columnStr1 = this.fields.stream().map(AcModelField::columnStr).collect(Collectors.toList());
        if (!CollUtil.disjunction(columnStr1, columnStr2 = model.getFields().stream().map(AcModelField::columnStr).collect(Collectors.toList())).isEmpty()) {
            return ModelSyncStatus.UN_SYNCED;
        }
        return ModelSyncStatus.SYNCED;
    }

    public void updateLastDbName() {
        this.lastDbName = this.tableName;
        CollUtil.forEach(this.fields, (CollUtil.Consumer & Serializable)(field, index) -> field.setLastDbName(field.getColName()));
    }

    public boolean isCacheEnable() {
        return this.proConfig != null && this.proConfig.getCacheConfig() != null && this.proConfig.getCacheConfig().isEnable();
    }

    public AcModelField cacheKeyField() {
        if (this.isCacheEnable()) {
            return this.getFieldByCode(this.proConfig.getCacheConfig().getKeyField());
        }
        return null;
    }

    public AcModelField cacheLabelField() {
        if (this.isCacheEnable()) {
            return this.getFieldByCode(this.proConfig.getCacheConfig().getLabelField());
        }
        return null;
    }

    public AcModel setModelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    public AcModel setAppCode(String appCode) {
        this.appCode = appCode;
        return this;
    }

    public AcModel setModelCode(String modelCode) {
        this.modelCode = modelCode;
        return this;
    }

    public AcModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    public AcModel setModelType(ModelType modelType) {
        this.modelType = modelType;
        return this;
    }

    public AcModel setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public AcModel setLastDbName(String lastDbName) {
        this.lastDbName = lastDbName;
        return this;
    }

    public AcModel setEmbed(YesNo embed) {
        this.embed = embed;
        return this;
    }

    public AcModel setSyncStatus(ModelSyncStatus syncStatus) {
        this.syncStatus = syncStatus;
        return this;
    }

    public AcModel setProConfig(ModelProConfig proConfig) {
        this.proConfig = proConfig;
        return this;
    }

    public AcModel setDataType(ModelDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public AcModel setTreeFields(TreeFields treeFields) {
        this.treeFields = treeFields;
        return this;
    }

    public AcModel setModelHandler(String modelHandler) {
        this.modelHandler = modelHandler;
        return this;
    }

    public AcModel setDescription(String description) {
        this.description = description;
        return this;
    }

    public AcModel setFields(List<AcModelField> fields) {
        this.fields = fields;
        return this;
    }

    public AcModel setSubModels(List<ModelRelation> subModels) {
        this.subModels = subModels;
        return this;
    }

    public AcModel setImported(boolean imported) {
        this.imported = imported;
        return this;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getModelCode() {
        return this.modelCode;
    }

    public String getModelName() {
        return this.modelName;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getLastDbName() {
        return this.lastDbName;
    }

    public YesNo getEmbed() {
        return this.embed;
    }

    public ModelSyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public ModelProConfig getProConfig() {
        return this.proConfig;
    }

    public ModelDataType getDataType() {
        return this.dataType;
    }

    public TreeFields getTreeFields() {
        return this.treeFields;
    }

    public String getModelHandler() {
        return this.modelHandler;
    }

    public String getDescription() {
        return this.description;
    }

    public List<AcModelField> getFields() {
        return this.fields;
    }

    public List<ModelRelation> getSubModels() {
        return this.subModels;
    }

    public boolean isImported() {
        return this.imported;
    }

    public static final class Fields {
        public static final String modelId = "modelId";
        public static final String appCode = "appCode";
        public static final String modelCode = "modelCode";
        public static final String modelName = "modelName";
        public static final String modelType = "modelType";
        public static final String tableName = "tableName";
        public static final String lastDbName = "lastDbName";
        public static final String embed = "embed";
        public static final String syncStatus = "syncStatus";
        public static final String proConfig = "proConfig";
        public static final String dataType = "dataType";
        public static final String treeFields = "treeFields";
        public static final String modelHandler = "modelHandler";
        public static final String description = "description";
        public static final String fields = "fields";
        public static final String subModels = "subModels";
        public static final String imported = "imported";
    }
}

