/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.controller;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.controller.params.SyncModelParam;
import com.kdgcsoft.web.ac.entity.AcModel;
import com.kdgcsoft.web.ac.entity.AcModelField;
import com.kdgcsoft.web.ac.mapper.AcModelMapper;
import com.kdgcsoft.web.ac.pojo.query.DataModel;
import com.kdgcsoft.web.ac.service.AcModelService;
import com.kdgcsoft.web.ac.service.AcModelSyncHisService;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.core.controller.BaseController;
import com.kdgcsoft.web.core.pojo.SelectOption;
import com.mybatisflex.core.paginate.Page;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u6570\u636e\u6a21\u578b\u7ba1\u7406")
@RestController
@Validated
@RequestMapping(value={"/ac/model"})
public class AcModelController
extends BaseController {
    @Resource
    AcModelService modelService;
    @Resource
    AcModelSyncHisService modelSyncHisService;

    @Operation(summary="\u5206\u9875\u83b7\u53d6\u6570\u636e\u6a21\u578b")
    @GetMapping(value={"/page"})
    public Page<AcModel> page(PageRequest<AcModel> page, @Parameter(description="\u5e94\u7528\u7f16\u7801") String appCode, @Parameter(description="\u6a21\u7cca\u641c\u7d22") String searchKey) {
        return this.modelService.pageModel(page, appCode, searchKey);
    }

    @Operation(summary="\u6240\u6709\u7684\u6a21\u578b\u5217\u8868")
    @GetMapping(value={"/list"})
    public List<AcModel> list() {
        return this.modelService.listModel(null);
    }

    @Operation(summary="\u83b7\u53d6\u5e94\u7528\u53ef\u8bbf\u95ee\u7684\u6a21\u578b\u5217\u8868,\u6ca1\u6709\u5e94\u7528\u7f16\u7801\u5219\u8fd4\u56de\u5168\u90e8\u7684\u6a21\u578b")
    @GetMapping(value={"/groupModelByApp"})
    public List<SelectOption> groupModelByApp(@Parameter(description="\u5e94\u7528\u7f16\u7801") String appCode) {
        return this.modelService.groupModelByApp(appCode);
    }

    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u6a21\u578b\u7684\u5b57\u6bb5\u5217\u8868")
    @GetMapping(value={"/fieldList"})
    public List<SelectOption> fieldList(String modelCode, @RequestParam(value="trans", defaultValue="false") Boolean trans, @RequestParam(value="embed", defaultValue="false") Boolean embed) {
        if (StrUtil.isBlank((CharSequence)modelCode)) {
            return new ArrayList<SelectOption>();
        }
        return this.modelService.listFieldsByCode(modelCode, trans, embed);
    }

    @Operation(summary="\u83b7\u53d6\u6a21\u578b\u7684\u8868\u5355\u57df,\u5305\u542b\u5b50\u8868\u5355\u5bf9\u5e94\u7684\u57df")
    @GetMapping(value={"/modelFormFieldList"})
    public List<SelectOption> modelFormFieldList(String modelCode) {
        if (StrUtil.isBlank((CharSequence)modelCode)) {
            return new ArrayList<SelectOption>();
        }
        return this.modelService.modelFormFieldList(modelCode);
    }

    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u6a21\u578b\u67e5\u8be2\u8fd4\u56de\u7684\u5b57\u6bb5\u5217\u8868")
    @GetMapping(value={"/queryFieldList"})
    public List<SelectOption> queryFieldList(String modelCode) {
        if (StrUtil.isBlank((CharSequence)modelCode)) {
            return new ArrayList<SelectOption>();
        }
        return this.modelService.queryFieldList(modelCode);
    }

    @Operation(summary="\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u6a21\u578b\u6570\u636e")
    @GetMapping(value={"/getById"})
    public AcModel getById(@Parameter(description="\u4e3b\u952e") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String id) {
        return (AcModel)((AcModelMapper)this.modelService.getMapper()).selectOneWithRelationsById((Serializable)((Object)id));
    }

    @Operation(summary="\u83b7\u5f97\u5185\u7f6e\u5b57\u6bb5\u5217\u8868")
    @GetMapping(value={"/getEmbedFields"})
    public List<AcModelField> getEmbedFields() {
        return this.modelService.getEmbedFields();
    }

    @Operation(summary="\u7531\u6570\u636e\u5e93\u5bfc\u51fa")
    @PostMapping(value={"/importFromDb"})
    public AcModel importFromDb(@RequestBody @Validated AcModel acModel) {
        return this.modelService.importFromDb(acModel);
    }

    @Operation(summary="\u4fdd\u5b58\u6570\u636e\u6a21\u578b")
    @PostMapping(value={"/save"})
    public AcModel save(@RequestBody @Validated AcModel acModel) {
        return this.modelService.saveModel(acModel);
    }

    @Operation(summary="\u6279\u91cf\u83b7\u53d6\u6570\u636e\u6a21\u578b\u57fa\u672c\u4fe1\u606f")
    @GetMapping(value={"/getModelByIds"})
    public List<AcModel> getModelByIds(@RequestParam List<String> modelIds) {
        return this.modelService.findByIds(modelIds);
    }

    @Operation(summary="\u540c\u6b65\u6570\u636e\u6a21\u578b")
    @PostMapping(value={"syncModels"})
    public SyncModelParam syncModels(@RequestBody @Validated SyncModelParam syncModelParam) {
        return this.modelSyncHisService.syncModels(syncModelParam);
    }

    @Operation(summary="\u83b7\u53d6\u540c\u6b65\u7684\u8fdb\u5ea6")
    @GetMapping(value={"/getSyncStatus"})
    public SyncModelParam getSyncStatus(String syncId) {
        return this.modelSyncHisService.getSyncStatus(syncId);
    }

    @Operation(summary="\u5220\u9664\u6570\u636e\u6a21\u578b")
    @GetMapping(value={"/deleteById"})
    public void deleteById(@Parameter(description="\u4e3b\u952e") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String modelId) {
        this.modelService.deleteModel(modelId);
    }

    @Operation(summary="\u83b7\u53d6\u6570\u636e\u5e93\u6240\u6709\u8868")
    @GetMapping(value={"/getTableAndViews"})
    public List<SelectOption> getTableAndViews() {
        return this.modelService.getTableAndViews();
    }

    @Operation(summary="\u83b7\u53d6\u6570\u636e\u5e93\u6240\u6709\u8868\u53ca\u5b57\u6bb5")
    @GetMapping(value={"/getTableAndViewsColumns"})
    public List<SelectOption> getTableAndViewsColumns() {
        return this.modelService.getTableAndViewsColumns();
    }

    @Operation(summary="\u83b7\u53d6\u9879\u76ee\u4e2d\u6240\u6709\u7684\u6a21\u578b\u62e6\u622a\u5668\u670d\u52a1")
    @GetMapping(value={"/getModelServiceList"})
    public List<SelectOption> getModelServiceList() {
        return this.modelService.getModelServiceList();
    }

    @Operation(summary="\u83b7\u5f97\u6a21\u578b\u7684\u7ea7\u8054\u6a21\u578b")
    @GetMapping(value={"/getRefModelList"})
    public List<SelectOption> getRefModelList(String modelCode) {
        ArrayList<SelectOption> list = new ArrayList<SelectOption>();
        DataModel model = this.modelService.getDataModel(modelCode);
        if (model != null) {
            model.getRefSubModelMap().forEach((key, refModel) -> {
                SelectOption option = SelectOption.of(refModel.getDataModel().getModelCode(), refModel.getDataModel().getModelName());
                option.put("refAlias", refModel.getRefAlias());
                option.put("pkField", refModel.getDataModel().getPkField().getFieldCode());
                list.add(option);
            });
        }
        return list;
    }

    @Operation(summary="\u7ea7\u8054\u67e5\u8be2\u6a21\u578b\u548c\u5b57\u6bb5\u7684\u5206\u7ec4")
    @GetMapping(value={"/cascadeFields"})
    public List<SelectOption> cascadeFields(String appCode) {
        if (StrUtil.isBlank((CharSequence)appCode)) {
            return new ArrayList<SelectOption>();
        }
        return this.modelService.cascadeFields(appCode);
    }
}

