/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.web.ac.controller;

import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.web.ac.entity.AcDataset;
import com.kdgcsoft.web.ac.pojo.dataset.DatasetParams;
import com.kdgcsoft.web.ac.pojo.query.GridModelData;
import com.kdgcsoft.web.ac.service.AcDatasetService;
import com.kdgcsoft.web.config.mvc.resolver.PageRequest;
import com.kdgcsoft.web.core.controller.BaseController;
import com.kdgcsoft.web.core.pojo.Result;
import com.kdgcsoft.web.core.pojo.SelectOption;
import com.mybatisflex.core.paginate.Page;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u6570\u636e\u96c6")
@RestController
@Validated
@RequestMapping(value={"/ac/dataset"})
public class AcDatasetController
extends BaseController {
    @Resource
    private AcDatasetService acDatasetService;

    @Operation(summary="\u4fdd\u5b58\u6570\u636e\u96c6", description="\u4fdd\u5b58\u6570\u636e\u96c6")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody @Validated AcDataset entity) {
        if (this.acDatasetService.hasRepeat(entity)) {
            return Result.ERROR("\u6570\u636e\u96c6\u7f16\u7801\u91cd\u590d");
        }
        this.acDatasetService.saveDataset(entity);
        return Result.OK();
    }

    @Operation(summary="\u9884\u89c8\u6570\u636e\u96c6\u6570\u636e", description="\u9884\u89c8\u6570\u636e\u96c6\u6570\u636e")
    @PostMapping(value={"previewData"})
    public GridModelData previewData(@RequestBody @Validated DatasetParams preivewParams, HttpServletRequest request) {
        return this.acDatasetService.getDatasetData(preivewParams, true);
    }

    @Operation(summary="\u5206\u9875\u83b7\u53d6\u6570\u636e\u96c6")
    @GetMapping(value={"/page"})
    public Page<AcDataset> page(PageRequest<AcDataset> page, @Parameter(description="\u5e94\u7528\u7f16\u7801") String appCode, @Parameter(description="\u6a21\u7cca\u641c\u7d22") String searchKey) {
        return this.acDatasetService.pageDataset(page, appCode, searchKey);
    }

    @Operation(summary="\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u6570\u636e\u96c6")
    @GetMapping(value={"/getById"})
    public AcDataset getById(@Parameter(description="\u4e3b\u952e") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String datasetId) {
        return (AcDataset)this.acDatasetService.getById((Serializable)((Object)datasetId));
    }

    @Operation(summary="\u6839\u636e\u4e3b\u952e\u5220\u9664\u6570\u636e\u96c6")
    @GetMapping(value={"/deleteById"})
    public void deleteById(@Parameter(description="\u4e3b\u952e") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String datasetId) {
        this.acDatasetService.removeById((Serializable)((Object)datasetId));
    }

    @Operation(summary="\u83b7\u53d6\u5e94\u7528\u4e0b\u7684\u6240\u6709\u5173\u8054\u7684\u6570\u636e\u96c6\u5217\u8868")
    @GetMapping(value={"/groupDatasetByApp"})
    public List<SelectOption> groupDatasetByApp(@Parameter(description="\u5e94\u7528\u7f16\u7801") String appCode) {
        return this.acDatasetService.groupDatasetByApp(appCode);
    }

    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u6570\u636e\u96c6\u8fd4\u56de\u7684\u5b57\u6bb5\u5217\u8868")
    @GetMapping(value={"/getFieldList"})
    public List<SelectOption> getFieldList(@Parameter(description="\u6570\u636e\u96c6\u7f16\u7801") String datasetCode) {
        if (StrUtil.isBlank((CharSequence)datasetCode)) {
            return new ArrayList<SelectOption>();
        }
        return this.acDatasetService.getFieldList(datasetCode);
    }
}

