/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.tdengine.reader;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.StrUtil;
import com.kdgcsoft.plugin.api.DataNumEstimateType;
import com.kdgcsoft.plugin.api.PluginContext;
import com.kdgcsoft.plugin.api.PluginContextParam;
import com.kdgcsoft.plugin.api.PluginType;
import com.kdgcsoft.plugin.api.data.IDataReadPlugin;
import com.kdgcsoft.plugin.api.message.MessageBoxWrapper;
import com.kdgcsoft.plugin.api.param.DataType;
import com.kdgcsoft.plugin.api.param.PluginParam;
import com.kdgcsoft.plugin.api.record.Item;
import com.kdgcsoft.plugin.api.record.ItemType;
import com.kdgcsoft.plugin.api.record.Record;
import com.kdgcsoft.plugin.api.resource.DBIResourcePlugin;
import com.kdgcsoft.plugin.collect.tdengine.reader.TDEngineReaderPluginParam;
import com.kdgcsoft.plugin.common.model.OutputField;
import com.kdgcsoft.plugin.common.model.ReadType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;

public class TDEngineReaderPlugin
extends Plugin {
    public TDEngineReaderPlugin(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Extension
    public static class TDEngineIDataReadPlugin
    extends MessageBoxWrapper
    implements IDataReadPlugin,
    ExtensionPoint {
        private Connection connection;
        private ResultSet resultSet;
        private int columnCount;
        private int[] columnTypes;
        private String[] columnTypeNames;
        private String[] columnNames;
        private ResultSetMetaData metaData;
        private NumberFormat[] numberFormats;
        private TDEngineReaderPluginParam pluginParam;
        private List<PluginContextParam> variables;
        private String sql;
        private PluginContext context;

        public void init(PluginContext context, PluginParam param) throws Exception {
            this.pluginParam = (TDEngineReaderPluginParam)param;
            this.context = context;
            DBIResourcePlugin dbResource = (DBIResourcePlugin)context.resourcePlugin(this.pluginParam.getResourceCode());
            long connectBegin = System.currentTimeMillis();
            this.connection = dbResource.openConnection();
            long connectEnd = System.currentTimeMillis();
            this.mb.sendResourceConnectInfo(context.flowCode(), context.taskCode(), context.jobCode(), this.pluginParam.getResourceCode());
            this.mb.writeLog("\u8fde\u63a5TDEngine\u8017\u65f6{}ms", new Object[]{connectEnd - connectBegin});
            this.variables = context.variables();
            this.mb.writeLog("\u8bfb\u53d6\u6765\u6e90:{}", new Object[]{this.pluginParam.getReadType().name()});
            this.mb.writeLog("\u6570\u636e\u5f62\u5f0f:{}, {}", new Object[]{this.pluginParam.getDataType().name(), this.pluginParam.getBatchNum()});
        }

        private String getQuerySQL() {
            String columns;
            if (ReadType.FROM_SQL == this.pluginParam.getReadType()) {
                String sql = this.pluginParam.getSql();
                for (PluginContextParam param : this.variables) {
                    if (!sql.contains(param.getCode())) continue;
                    String replace = param.getValue() instanceof Supplier ? (String)((Supplier)param.getValue()).get() : param.getValue().toString();
                    this.mb.writeLog("\u66ff\u6362\u53d8\u91cf\uff1a{}\uff0c \u503c\uff1a{}", new Object[]{param.getCode(), replace});
                    sql = sql.replaceAll(param.getRegExp(), replace);
                }
                return sql;
            }
            if (CollUtil.isNotEmpty((Collection)this.pluginParam.getColumns())) {
                List selectColumns = this.pluginParam.getColumns().stream().filter(field -> !field.isAddColumn()).map(OutputField::getSrcColumnName).collect(Collectors.toList());
                columns = String.join((CharSequence)", ", selectColumns);
            } else {
                columns = "*";
            }
            return "SELECT " + columns + " FROM `" + this.pluginParam.getTable() + "`";
        }

        /*
         * Exception decompiling
         */
        public long estimateDataNum() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public DataNumEstimateType estimateType() {
            return DataNumEstimateType.STATIC_NUM;
        }

        public void begin() throws Exception {
            PreparedStatement statement;
            this.sql = this.getQuerySQL();
            this.mb.writeLog("sql:{}", new Object[]{this.sql});
            if (DataType.STREAM == this.pluginParam.getDataType()) {
                statement = this.connection.prepareStatement(this.sql, 1003, 1007);
                statement.setFetchSize(500);
            } else {
                statement = this.connection.prepareStatement(this.sql);
                statement.setFetchSize(this.pluginParam.getBatchNum());
            }
            this.resultSet = statement.executeQuery();
            this.metaData = this.resultSet.getMetaData();
            this.columnCount = this.metaData.getColumnCount();
            this.columnTypes = new int[this.columnCount];
            this.columnTypeNames = new String[this.columnCount];
            this.columnNames = new String[this.columnCount];
            this.numberFormats = new NumberFormat[this.columnCount];
            for (int i = 1; i <= this.columnCount; ++i) {
                this.columnTypes[i - 1] = this.metaData.getColumnType(i);
                this.columnTypeNames[i - 1] = this.metaData.getColumnTypeName(i);
                this.columnNames[i - 1] = this.metaData.getColumnLabel(i);
            }
        }

        public void end() throws Exception {
            if (null != this.resultSet) {
                this.resultSet.close();
                this.resultSet = null;
            }
            if (null != this.connection) {
                this.connection.close();
                this.connection = null;
                this.mb.sendResourceDisconnectInfo(this.context.flowCode(), this.context.taskCode(), this.context.jobCode(), this.pluginParam.getResourceCode());
            }
            this.columnTypes = null;
            this.columnTypeNames = null;
            this.columnNames = null;
            this.numberFormats = null;
        }

        public boolean hasNext() throws Exception {
            return this.resultSet.next();
        }

        public Record next() throws Exception {
            Record record = new Record();
            for (int i = 1; i <= this.columnCount; ++i) {
                record.add(this.getItem(i));
            }
            return record;
        }

        /*
         * Unable to fully structure code
         */
        public Item getItem(int index) throws Exception {
            switch (this.columnTypes[index - 1]) {
                case 93: {
                    ts = this.resultSet.getTimestamp(index);
                    if (null == ts) {
                        return new Item(this.columnNames[index - 1], ItemType.NULL, null);
                    }
                    if (this.isDateOrDateTime(this.columnTypeNames[index - 1])) {
                        return new Item(this.columnNames[index - 1], ItemType.DATE, (Serializable)DateTime.of((long)ts.getTime()));
                    }
                    return new Item(this.columnNames[index - 1], ItemType.TIMESTAMP, (Serializable)ts);
                }
                case 91: {
                    ts = this.resultSet.getTimestamp(index);
                    if (null == ts) {
                        return new Item(this.columnNames[index - 1], ItemType.NULL, null);
                    }
                    return new Item(this.columnNames[index - 1], ItemType.DATE, (Serializable)DateTime.of((long)ts.getTime()));
                }
                case 92: {
                    return new Item(this.columnNames[index - 1], ItemType.DATE, (Serializable)this.resultSet.getDate(index));
                }
                case 2005: {
                    return new Item(this.columnNames[index - 1], ItemType.STRING, (Serializable)this.clobToString(this.resultSet.getClob(index)));
                }
                case 2004: {
                    blob = this.resultSet.getBlob(index);
                    length = blob.length();
                    bytes = blob.getBytes(1L, (int)length);
                    return new Item(this.columnNames[index - 1], ItemType.BYTE_ARRAY, (Serializable)bytes);
                }
                case -4: {
                    is = this.resultSet.getBinaryStream(index);
                    try {
                        bos = new ByteArrayOutputStream();
                        if (null != is) ** GOTO lbl32
                        var4_14 = new Item(this.columnNames[index - 1], ItemType.BYTE_ARRAY, null);
                        bos.close();
                        return var4_14;
lbl32:
                        // 1 sources

                        try {
                            buf_size = 1024;
                            buffer = new byte[buf_size];
                            while ((len = is.read(buffer, 0, buf_size)) != -1) {
                                bos.write(buffer, 0, len);
                            }
                            var7_19 = new Item(this.columnNames[index - 1], ItemType.BYTE_ARRAY, (Serializable)bos.toByteArray());
                        }
                        catch (Throwable var4_16) {
                            try {
                                bos.close();
                            }
                            catch (Throwable var5_13) {
                                var4_16.addSuppressed(var5_13);
                            }
                            throw var4_16;
                        }
                        bos.close();
                        return var7_19;
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    if (this.metaData.getScale(index) > 0) {
                        col = this.resultSet.getBigDecimal(index);
                        if (col != null) {
                            if (this.numberFormats[index - 1] == null) {
                                nf = NumberFormat.getInstance();
                                nf.setGroupingUsed(false);
                                nf.setMaximumFractionDigits(this.metaData.getScale(index));
                                this.numberFormats[index - 1] = nf;
                            }
                            return new Item(this.columnNames[index - 1], ItemType.STRING, (Serializable)this.numberFormats[index - 1].format(col));
                        }
                        return new Item(this.columnNames[index - 1], ItemType.NULL, null);
                    }
                    return this.ofNull(this.columnNames[index - 1], this.getString(index));
                }
            }
            return this.ofNull(this.columnNames[index - 1], this.getString(index));
        }

        public boolean isDateOrDateTime(String columnTypeName) {
            String upperName = columnTypeName.toUpperCase();
            return upperName.contains("DATE") || upperName.contains("DATETIME");
        }

        public String clobToString(Clob clob) throws IOException, SQLException {
            if (clob == null) {
                return null;
            }
            try (Reader reader = clob.getCharacterStream();){
                String string = IOUtils.toString((Reader)reader);
                return string;
            }
        }

        private Item ofNull(String columnName, String value) {
            if (null == value) {
                return new Item(columnName, ItemType.NULL, null);
            }
            return new Item(columnName, ItemType.STRING, (Serializable)((Object)value));
        }

        private String getString(int i) {
            boolean getStringError = false;
            String obj = null;
            try {
                obj = this.resultSet.getString(i);
            }
            catch (SQLException e1) {
                getStringError = true;
            }
            if (!getStringError && (null == obj || StrUtil.isEmpty((CharSequence)obj))) {
                try {
                    byte[] bytes = this.resultSet.getBytes(i);
                    if (null != bytes) {
                        return new String(bytes, StandardCharsets.UTF_8);
                    }
                }
                catch (Exception e) {
                    this.mb.writeExceptionLog(e);
                }
            }
            return obj;
        }

        public PluginType type() {
            return PluginType.READER;
        }

        public Class<? extends PluginParam> pluginParamClass() {
            return TDEngineReaderPluginParam.class;
        }

        public String configComponent() {
            return "TDEngineReaderConfigForm";
        }
    }
}

