/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.service;

import cn.hutool.core.map.MapBuilder;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.kdgcsoft.scrdc.workflow.common.utils.CommTreeUtils;
import com.kdgcsoft.scrdc.workflow.dao.StfBusinessTypeMapper;
import com.kdgcsoft.scrdc.workflow.entity.StfBusinessType;
import com.kdgcsoft.scrdc.workflow.helper.ComBoxTreeNode;
import com.kdgcsoft.scrdc.workflow.helper.StfBusinessTypeHelper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Exception.class})
public class StfBusinessTypeService {
    @Autowired
    private StfBusinessTypeMapper stfbusinesstypeDao;
    @Autowired
    private StfBusinessTypeHelper stfBusinessTypeHelper;

    public List<StfBusinessType> findAll() {
        return this.stfbusinesstypeDao.selectList(null);
    }

    public List<StfBusinessType> findByParentId(Long parentId) {
        return this.stfbusinesstypeDao.selectList((Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)parentId));
    }

    public StfBusinessType findById(Long Id) {
        return (StfBusinessType)((Object)this.stfbusinesstypeDao.selectById(Id));
    }

    public void saveStfBusinessType(StfBusinessType entity) {
        if (entity.getResId() != null) {
            this.stfbusinesstypeDao.updateById((Object)entity);
        } else {
            this.stfbusinesstypeDao.insert((Object)entity);
        }
    }

    public void delStfBusinessType(Long id) {
        this.stfbusinesstypeDao.deleteById(id);
    }

    public void delStfBusinessTypeAndChild(Long id) {
        List<StfBusinessType> sons = this.stfBusinessTypeHelper.getAllSons(id);
        this.stfbusinesstypeDao.deleteById(id);
        if (CollectionUtils.isNotEmpty(sons)) {
            this.stfbusinesstypeDao.deleteBatchIds(sons.stream().map(StfBusinessType::getResId).collect(Collectors.toList()));
        }
    }

    public StfBusinessType getByCode(String code) {
        return (StfBusinessType)((Object)this.stfbusinesstypeDao.selectOne((Wrapper)Wrappers.query().eq((Object)"CODE", (Object)code)));
    }

    public List<ComBoxTreeNode> treeStfBusinessType(Long pid) {
        List<StfBusinessType> sons = this.stfBusinessTypeHelper.getAllSons(pid);
        List list = sons.stream().sorted(Comparator.comparing(StfBusinessType::getOrderIndex)).map(s -> MapBuilder.create(new HashMap()).put((Object)"id", (Object)s.getResId()).put((Object)"pid", (Object)s.getParentId()).put((Object)"text", (Object)s.getName()).build()).collect(Collectors.toList());
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> treeStfBusinessTypeWithCode(Long pid) {
        List<StfBusinessType> sons = this.stfBusinessTypeHelper.getAllSons(pid);
        List list = sons.stream().sorted(Comparator.comparing(StfBusinessType::getOrderIndex)).map(s -> {
            MapBuilder builder = MapBuilder.create(new HashMap());
            return builder.put((Object)"id", (Object)s.getResId()).put((Object)"pid", (Object)s.getParentId()).put((Object)"text", (Object)s.getName()).put((Object)"code", (Object)s.getCode()).build();
        }).collect(Collectors.toList());
        return CommTreeUtils.buildTreeNode(list);
    }
}

