﻿/*-------------------------------------
	名称：USI-Framework 2.0 核心脚本
	功能：组件交互控制
	版本:1.0
	作者:Simon
-------------------------------------*/
jQuery.cookie = function(name, value, options) {
    if (typeof value != 'undefined') { // name and value given, set cookie
        options = options || {};
        if (value === null) {
            value = '';
            options.expires = -1;
        }
        var expires = '';
        if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
            var date;
            if (typeof options.expires == 'number') {
                date = new Date();
                date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
            } else {
                date = options.expires;
            }
            expires = '; expires=' + date.toUTCString(); // use expires attribute, max-age is not supported by IE
        }
        // CAUTION: Needed to parenthesize options.path and options.domain
        // in the following expressions, otherwise they evaluate to undefined
        // in the packed version for some reason...
        var path = options.path ? '; path=' + (options.path) : '';
        var domain = options.domain ? '; domain=' + (options.domain) : '';
        var secure = options.secure ? '; secure' : '';
        document.cookie = [name, '=', encodeURIComponent(value), expires, path, domain, secure].join('');
    } else { // only name given, get cookie
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = jQuery.trim(cookies[i]);
                // Does this cookie string begin with the name we want?
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
};

/*
* 作者：Simon
* 日期：2014年3月12日
* 说明：弹窗插件,支持显示div内容和iframe内容
* 要求：$("body").UfWin({label:"",elem:"",src:"",width:600});
*/
 (function ($) {
    $.fn.UfWin = function(options){
        var defaults = {
            label:"",
            elem:"",
            src:"",
            width:600,
            height:400,
            left:0,
            outerX:40,
            outerY:40,
            position:"",
            callback:"",
            end:"",
            mask:true,
            isMove:true
        }
        var options = $.extend(defaults, options);
        var _this = this;
        var c = '<div class="uf_maskBack"></div>';
        var d = '<div class="uf_win"></div>';
        var e = '<div class="uf_winHead"><p class="f_l">'+options.label+'</p><p class="f_r"><i class="uf_winClose fa fa-times1"></i></p></div>';
        var f = '<div class="uf_winCont"></div>';
        
        if(options.mask){
        	_this.append(c)
        }
        _this.append(d);
        $(".uf_maskBack").css({ opacity:0.3 });

        $(".uf_win").append(e).append(f);


        if(options.elem!=""){
            var h = $(options.elem).clone(true).removeClass("disNone");
            h.appendTo(".uf_winCont");
        }else{
            if(options.src!=""){
                var g = '<iframe frameborder="0" width="100%" height="100%" scrolling="auto" marginheight="0" marginwidth="0" src="'+ options.src +'" ></iframe>';
                $(".uf_winCont").append(g);
            }
        }

        if(options.position==""){
	        if(options.width!="auto"){
	            $(".uf_win").css({"width":options.width,"height":options.height,"left":options.left==0?[$(window).width()-options.width]/2:options.left,"top":[$(window).height()-options.height]/2}).show();
	        }else{
	            $(".uf_win").css({"top":options.outerY,"right":options.outerX,"bottom":options.outerY,"left":options.outerX}).show();
	        }
    	}else if(options.position=="right"){
    		$(".uf_win").css({"top":0,"right":-options.width,"bottom":0,"left":"auto","width":options.width}).show().animate({ "right":0 },350);
    		_this.animate({ paddingRight: options.width},350);
    	}else if(options.position=="left"){
    		$(".uf_win").css({"top":0,"right":"auto","bottom":0,"left":-options.width,"width":options.width}).show().animate({ "left":0 },350);
    		_this.animate({ paddingLeft: options.width},350);
    	}

    	function autoHeight(){
    		var nh = $(".uf_win").innerHeight()-$(".uf_winHead").innerHeight()-14;
    		$(".uf_winCont").height(nh);
        	$(".uf_winCont").children().height(nh);
        }

        autoHeight();


        $(".uf_winClose").on("click",function(){
            $(".uf_win,.uf_maskBack").hide().remove();

            if(options.position=="right"){
            	_this.animate({ paddingRight: 0},350);
            }else if(options.position=="left"){
            	_this.animate({ paddingLeft: 0},350);
            }

            if(typeof options.end == 'function'){
                options.end.call(this);
            }
        });

        $(window).resize(function(){
            //console.log($(this).width());
            if(options.position=="" && options.width!="auto"){
                $(".uf_win").css({"left":[$(window).width()-options.width]/2,"top":[$(window).height()-options.height]/2});
            }
            if(options.position!=""){
        		autoHeight();
            }
        });

        //判断窗口是否可拖动
        if(options.isMove==true){
        	moveWin();
        }
        
        // 窗口拖动
        function moveWin(){
        	var isMove = false;
        	var ox,oy;
        	$(".uf_winHead").on("mousedown",function(e){
        		ox = e.pageX-$(".uf_win").offset().left;
        		oy = e.pageY-$(".uf_win").offset().top+$(window).scrollTop();
        		isMove = true;
        		$(this).css({ cursor:"move" });
        	});
        	$(".uf_winHead").on("mouseup",function(){
        		isMove = false;
        		$(this).css({ cursor:"default" });
        	});
        	$("body").on("mousemove",function(e){
        		if(isMove){
        			$(".uf_win").css({ left:e.pageX-ox, top:e.pageY-oy })
        		}else{}
        	});
        }


        // 引用回调函数
        if (typeof options.callback == 'function') { // 确保类型为函数类型
            options.callback.call(this); // 执行回调函数
        }
        
        
    };
})(jQuery);

 /*
* 作者：Simon
* 日期：2014年3月12日
* 说明：提示信息
* 要求：$("body").ufDialog({icon:"fa-check",text:"提示文本"});
*/
 (function ($) {
    $.fn.ufDialog = function(options){
        var defaults = {
            icon:"fa-check",
            type:"",
            text:"",
            button:false,
            left:0,
            width:"300",
            height:"108",
            interval:"2000",
            eventOK:"",
            eventCancel:"",
            condition:true,
            myId:""
        }
        var options = $.extend(defaults, options);

        if(this.find(".uf_dialog").length!=0){
            $(".uf_dialog").remove();
        }

        var c = '<div class="uf_dialog uf_'+options.type+'"></div>';
        var d = '<div class="uf_dialog_cont">'+ '<i class="fa '+ options.icon +'"></i>' + options.text +'</div>';
        var e = '<div class="uf_dialog_btns"><button class="uf_btn_normal uf_btn_defult uf_btn_ok">确定</button> <button class="uf_btn_normal uf_btn_cancel">取消</button></div>';

        this.append(c);

        var b = $(".uf_dialog");
        
        
        if(options.condition){
        var x = [$(window).width() - options.width]/2;
        var y = [$(window).height() - options.height]/2;
    }else{
    	 
    	  var x = [$(options.myId).width() - options.width]/2;
          var y = [$(options.myId).height() - options.height]/2;
    }
        
		b.append(d);
        var hh = $(".uf_dialog_cont").height();

		if(options.button){
			b.append(e);

			$(".uf_dialog_btns").find(".uf_btn_cancel").on("click",function(){

				hideDialog();

				if (typeof options.eventCancel == 'function') {
					options.eventCancel.call(this);
				}
			});

			$(".uf_dialog_btns").find(".uf_btn_ok").on("click",function(){

				hideDialog();

				if (typeof options.eventOK == 'function') {
					options.eventOK.call(this);
				}
			});
		}
																		//$(window).width() - options.width]/2
        b.css({"width":options.width, "height":options.height, "left":options.left==0?x:options.left, "top":y-20, opacity:0}).show();

        b.animate({"top":y, opacity: 1},350,function(){
        	
        	if(!options.button){
	            setTimeout( hideDialog, options.interval );
       		}
        });

        function hideDialog(){
			b.animate({"top":y-50, opacity: 0}, 500, function(){
				b.remove();
			});
        }

    };
})(jQuery);


$(function($){

	/*-------------风格选择--------------*/

	$(".uf_li_skin>a").on("click",function(){
		var src = "css/skin/"+$(this).attr("dataskin")+"/skin.css";
		setSkin(src);
	});

	var days = 30;
	function setSkin(name){
		$("#css_skin").attr("href",name);
		$("#uf_main_iframe").contents().find("#css_skin").attr("href",name);
		$.cookie("skinName", name, {expires:days});
		//alert( $.cookie("skinName") );
	}

	//$(window).load(function(){
		if( $.cookie("skinName") ){
			setSkin($.cookie("skinName"));
		}
	//});

	/*-------------左侧菜单--------------*/
	$(".uf_menu").each(function(i){
		if($(this).next().is(".uf_menu_child")){
			$(this).append('<span><i class="fa fa-angle-down"></i></span>').on("click",function(){
				if($(this).next().is(":hidden")){
					$(this).next(".uf_menu_child").slideDown();
					$(this).addClass("on");
					$(this).find(".fa-angle-down").removeClass("fa-angle-down").addClass("fa-angle-up");
				}else{
					$(this).next(".uf_menu_child").slideUp();
					$(this).removeClass("on");
					$(this).find(".fa-angle-up").removeClass("fa-angle-up").addClass("fa-angle-down");
				}
			});
		}
	});

	$(".uf_menu_child").find("li").on("click",function(){
		$(".uf_menu_child").find("li.on").removeClass("on");
		$(this).addClass("on");
	});

	$(".uf_menu").on("click",function(){
		$(".uf_menu_child").find("li.on").removeClass("on");
	});


	/*左侧菜单 收起*/
	$(".uf_pack_left").on("mouseenter",function(){

		var _t = $(this);
		var a =_t.offset().left;

		if(a<0){
			var y = _t.offset().top + (_t.innerHeight()-70)/2;
			$("<a/>").addClass("uf_btn_pack_left").css({ position: "fixed", top:y, left:0 }).html('<i class="fa fa-angle-right fa-2x"></i>').appendTo(_t)
			.on("click",function(){
				_t.animate({ left:0 },350);
				_t.next(".uf_layout_right").animate({ left:227 },350,function(){
					$(".uf_btn_pack_left").remove();
				});
			});
		}else{
			var y = (_t.innerHeight()-70)/2;
			$("<a/>").addClass("uf_btn_pack_left").css({ position: "absolute", top:y, right:0 }).html('<i class="fa fa-angle-left fa-2x"></i>').appendTo(_t)
			.on("click",function(){
				_t.animate({ left:-222 },350);
				_t.next(".uf_layout_right").animate({ left:5 },350);
			});
		}

	});
	$(".uf_pack_left").on("mouseleave",function(){
		$(this).find(".uf_btn_pack_left").remove();
	});
	
	$("body").on("mouseenter",".uf_btn_pack_left",function(){
		$(this).css("background","#A6A6A6");
		
	});

	/*上下滚动通知*/
	function scroll(){
		$(".uf_notice_ul").animate({ marginTop:-30 },"slow",function(){
			$(".uf_notice_ul>li").first().appendTo($(".uf_notice_ul"));
			$(".uf_notice_ul").css({ marginTop:0 });
		});
	}

	setInterval( scroll, 4000 );

	/*tips*/
	$(".uf_tip").each(function(i){

		var a = $(this).parent();
		
		$(this).on("mouseenter",function(){

			var l1 = $(this).innerWidth();
			var l2 = $(this).next(".uf_tip_wrap").innerWidth();
			var h1 = $(this).innerHeight();

			if($(this).next().hasClass("uf_tip_bl")){
				var x = $(this).offset().left;
				if(x<0){x=0}
				var y = $(this).offset().top+h1-95;
				var z = 0;
			}

			if($(this).next().hasClass("uf_tip_br")){
				var x = $(this).offset().left-(l2-l1);
				if(x<0){x=0}
				var y = $(this).offset().top+h1-95;
				var z = l2-l1;
			}

			if($(this).next().hasClass("uf_tip_bc")){
				var x = $(this).offset().left-(l2-l1)/2;
				if(x<0){x=0}
				var y = $(this).offset().top+h1-95;
				var z = (l2-l1)/2;
			}


			var b = $(this).next().appendTo("body");

			b.css({ position: "absolute", top:y, left:x, zIndex:99 });
			b.find(".arrow_t").css({ left: z, width:l1});
			b.show().find(".uf_tag").on("click",function(){
				$(this).addClass("on").siblings().removeClass("on");

				var v = $(this).attr("value");
				var p = a.parents(".uf_dargItem");
				switch(v){
					case 'size_1x':
						p.removeClass().addClass("uf_dargItem");
						b.hide().appendTo(a);
						break;
					case 'size_2x':
						p.removeClass().addClass("uf_dargItem").addClass("uf_2x");
						b.hide().appendTo(a);
						break;
					case 'size_3x':
						p.removeClass().addClass("uf_dargItem").addClass("uf_3x");
						b.hide().appendTo(a);
						break;
				}
				//console.log(b);
			});

		});

		$(".uf_tip_wrap").on("mouseleave",function(){
			$(".uf_tip_wrap:last").find(".uf_tag").off("click");
			$(".uf_tip_wrap:last").hide().appendTo(a);
		});


		/*--------------面板尺寸控制--------------*/
		function tagClick(){

			$(this).addClass("on").siblings().removeClass("on");

			var t = $(this).parents(".uf_tip_wrap");
			var v = $(this).attr("value");

			switch(v){
				case 'size_1x':
					a.parents(".uf_dargItem").removeClass().addClass("uf_dargItem");
					t.hide().appendTo(a);
					break;
				case 'size_2x':
					a.parents(".uf_dargItem").removeClass().addClass("uf_dargItem").addClass("uf_2x");
					t.hide().appendTo(a);
					break;
				case 'size_3x':
					a.parents(".uf_dargItem").removeClass().addClass("uf_dargItem").addClass("uf_3x");
					t.hide().appendTo(a);
					break;
			}
		}

	});

	/*tabs*/
	$(".uf_tabHead").find("li").on("click",function(){
		$(this).addClass("on").siblings().removeClass("on");
		$(this).parents(".uf_tabs").find(".uf_tabCont").eq($(this).index()).show().siblings().hide();
		var a = $(this).parents(".panel").find(".uf_tabPanel");
		if(a.is(":hidden")){
			a.slideDown();
		}
	});

	$(".uf_tabHead").each(function(i){
		$(this).find("li").first().click();
	});

	/*展开收起*/
	$(".uf_btn_hide").on("click",function(){
		var a = $(this).parents(".panel").find(".uf_tabPanel,.uf_panel_cont");
		var b = $(this).parents(".panel").find(".uf_panel_cont");
		var c = $(this).parents(".panel").find(".uf_tabPanel");
		if(a.is(":hidden")){
			if(a.attr('class')=="uf_tabPanel"){
				a.slideDown();
				$(this).find(".fa-angle-down").removeClass("fa-angle-down").addClass("fa-angle-up");
			}else{
				if(!b.is(":hidden")){
					b.slideUp();
					$(this).find(".fa-angle-up").removeClass("fa-angle-up").addClass("fa-angle-down");
				}else if(document.getElementById("p").style.width=="99%"){
					b.slideDown();
					$(this).find(".fa-angle-down").removeClass("fa-angle-down").addClass("fa-angle-up");
				}else {
					a.slideDown();
					$(this).find(".fa-angle-down").removeClass("fa-angle-down").addClass("fa-angle-up");
				}
			}
		}else{
				a.slideUp();				
			$(this).find(".fa-angle-up").removeClass("fa-angle-up").addClass("fa-angle-down");
		}
	});

	/*table*/
	$(".uf_table_y").find("tr:gt(0)").on("click",function(){
		if($(this).hasClass("on")){
			$(this).removeClass("on");
			//$(this).find(":checkbox").attr("checked",false);
		}else{
			$(this).addClass("on");
			//$(this).find(":checkbox").attr("checked",true);
		}
	});

	/*--------------textInput 验证--------------*/

	//验证
	function isDefined(type,str){
		var a;
		switch(type){
			case "empty": //非空
			a = /^\S+$/;
			break;
			case "number": //数字
			a = /^([+-]?)\d*\.?\d+$/;
			break;
			case "email": //邮箱
			a = /\w+((-w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+/;
			break;
			case "telephone": //电话号码
			a = /[0-9-()（）]{7,18}/;
			break;
			case "mobile": //手机号码
			a = /0?(13|14|15|18)[0-9]{9}/;
			break;
			case "IDCard": //身份证号码
			a = /\d{17}[\d|x]|\d{15}/;
			break;
			case "cn": //仅中文
			a = /^[\u4e00-\u9fa5]+$/;
			break;
		}
		
		return a.test(str);
	}

	function inputDefined(type,str,elem){
		var s =  str.toLowerCase();
		if(!isDefined(type,s)){
			errorDefined(elem);
		}else{
		}
	}

	function errorDefined(elem){
		elem.addClass("uf_txt_wrong");
	}

	$(".uf_inp_txt[datatype]").on("blur",function(){
		inputDefined($(this).attr("datatype"),$(this).val(),$(this));
	});


	$(".uf_inp_txt[datatype]").on("focus", function(){
		$(this).removeClass("uf_txt_wrong");
	});

	/*------按下回车键查询---------*/
	$(document).keydown(function(e){
	    // 这个判断是为了兼容所有浏览器，使 e 能被所有浏览器所解析
	    if(!e) var e = window.event;  
	    // 这里就是要执行的方法体，其中 e 就是键盘对象
	    // 其中 e.keyCode（Code中C一定要大写） 就是按下的键的键值 
	   //alert("键盘按键的 keycode 是 " + e.keyCode);
	    if(e.keyCode==13){
	    	if($.isFunction(window.uquery))
	    	{
	    		uquery();
	    	}
	    	if($.isFunction(window.search)){
	    		search();
	    	}
	    }
	});
	/*--------button按钮点击后取消焦点------------*/
	$("button").each(function() {
		$(this).focus(function(){
		this.blur();
		})
		});

});