$(function() {
	var riskStatisticsChart;
	var riskPatrolProblemChart;
	var yearRiskStatisticsChart;
	$("#thisYear").attr("checked", true);
	$("#startDate").datebox({
		disabled : true
	});
	$("#endDate").datebox({
		disabled : true
	});
	getNewRisksCountThisMonth();
	setInterval("getNewRisksCountThisMonth()", "180000");
	getRiskStatisticsData();
	getRiskPatrolProblemChart("thisMonth", "", "", 1);
	getYearRiskStatisticsChart(1);
	$("input[name=period]").click(function() {
		switch ($("input[name=period]:checked").attr("id")) {
		case "thisYear":
		case "thisSeason":
		case "thisMonth":
			$("#startDate").datebox({
				disabled : true
			});
			$("#endDate").datebox({
				disabled : true
			});
			getRiskStatisticsData();
			break;
		default:
			$("#startDate").datebox({
				disabled : false
			});
			$("#endDate").datebox({
				disabled : false
			});
			break;
		}
	});
});

// 获取本月新增风险数量
function getNewRisksCountThisMonth() {
	$.ajax({
		type : "POST",
		cache : false,
		dataType : "json",
		url : ctx + "/BRiskPatrolProblemList/getRisksCount.action",
		data : {
			periodType : "thisMonth"
		},
		success : function(result) {
			var resultObj = JSON.parse(result);
			$("#riskACount").html(resultObj.RISKACOUNT + "条");
			$("#riskBCount").html(resultObj.RISKBCOUNT + "条");
			$("#riskCCount").html(resultObj.RISKCCOUNT + "条");
			$("#riskDCount").html(resultObj.RISKDCOUNT + "条");
			getRiskStatisticsChart(resultObj);
		}
	});
}

// 获取风险统计数据
function getRiskStatisticsData() {
	var periodType = $("input[name=period]:checked").attr("id");
	var startDate = "";
	var endDate = "";
	var startDateP = "";
	var endDateP = "";
	var date = new Date();
	var year = date.getFullYear();
	var month = date.getMonth() + 1;
	var day = date.getDate();
	if (periodType == "thisYear") {
		startDate = year + "年1月1日";
		endDate = year + "年" + month + "月" + day + "日";
	} else if (periodType == "thisSeason") {
		var startMonth;
		if (month <= 3) {
			startMonth = 1;
		} else if (month <= 6) {
			startMonth = 4;
		} else if (month <= 9) {
			startMonth = 7;
		} else if (month <= 12) {
			startMonth = 10;
		}
		startDate = year + "年" + startMonth + "月1日";
		endDate = year + "年" + month + "月" + day + "日";
	} else if (periodType == "thisMonth") {
		startDate = year + "年" + month + "月1日";
		endDate = year + "年" + month + "月" + day + "日";
	} else if (periodType == "period") {
		startDateP = $("#startDate").datebox("getValue");
		endDateP = $("#endDate").datebox("getValue");
		if (!startDateP) {
			alertInfo("请选择开始日期！");
			return;
		} else if (!endDateP) {
			alertInfo("请选择结束日期！");
			return;
		} else if (startDateP > endDateP) {
			alertInfo("开始日期不能大于结束日期！");
			return;
		}
		startDate = formatDate(startDateP);
		endDate = formatDate(endDateP);
	}
	// 重大风险监测数据
	$
			.ajax({
				type : "POST",
				cache : false,
				dataType : "json",
				url : ctx
						+ "/BRiskPatrolProblemList/getSignificantRiskData.action",
				data : {
					periodType : periodType,
					startDate : startDateP,
					endDate : endDateP
				},
				success : function(result) {
					var resultObj = JSON.parse(result);
					$("#riskACompletionRatePic")
							.html(
									"<div id=\"riskACompletionRate\" data-dimension=\"42\" "
											+ "data-text=\""
											+ resultObj.riskACompletionRate
											+ "\" data-width=\"3\" data-fontsize=\"14\" "
											+ "data-percent=\""
											+ resultObj.riskACompletionRate
											+ "\" data-fgcolor=\"#59B94D\" data-bgcolor=\"#eee\"></div>");
					$('#riskACompletionRate').circliful();
					$("#confirmRiskACount").html(resultObj.confirmRiskACount);
					$("#reformRiskACount").html(resultObj.reformRiskACount);
					$("#restRiskACount").html(resultObj.restRiskACount);
					$("#riskBInTimeRate").html(resultObj.riskBInTimeRate);
					$("#riskBInTimeRatePic")
							.html(
									"<div id=\"riskBInTimeRate\" data-dimension=\"42\" "
											+ "data-text=\""
											+ resultObj.riskBInTimeRate
											+ "\" data-width=\"3\" data-fontsize=\"14\" "
											+ "data-percent=\""
											+ resultObj.riskBInTimeRate
											+ "\" data-fgcolor=\"#59B94D\" data-bgcolor=\"#eee\"></div>");
					$('#riskBInTimeRate').circliful();
					$("#confirmRiskBCount").html(resultObj.confirmRiskBCount);
					$("#reformRiskBCount").html(resultObj.reformRiskBCount);
					$("#outTimeRiskBCount").html(resultObj.outTimeRiskBCount);
				}
			});
	// 风险统计数据
	$.ajax({
		type : "POST",
		cache : false,
		dataType : "json",
		url : ctx + "/BRiskPatrolProblemList/getRisksCount.action",
		data : {
			periodType : periodType,
			startDate : startDateP,
			endDate : endDateP
		},
		success : function(result) {
			var resultObj = JSON.parse(result);
			getRiskStatisticsChart(resultObj);
		}
	});
	$("#riskPatrolProblemTitle").html("A类风险统计");
	getRiskPatrolProblemChart($("input[name=period]:checked").attr("id"), $(
			"#startDate").datebox("getValue"), $("#endDate")
			.datebox("getValue"), 1);
	$("#yearRiskStatisticsTitle").html("A类风险");
	getYearRiskStatisticsChart(1);
	$("#appropriationStatisticsStartDate").html(startDate);
	$("#appropriationStatisticsEndDate").html(endDate);
	// 特殊拨付统计数据
	$.ajax({
		type : "POST",
		cache : false,
		dataType : "json",
		url : ctx + "/BFmPay/getAppropriationStatistics.action",
		data : {
			periodType : periodType,
			startDate : startDateP,
			endDate : endDateP
		},
		success : function(result) {
			$("#applyMoney1").html("0");
			$("#approveMoney1").html("0");
			$("#payMoney1").html("0");
			$("#payRate1").html("-");
			$("#applyMoney2").html("0");
			$("#approveMoney2").html("0");
			$("#payMoney2").html("0");
			$("#payRate2").html("-");
			$("#applyMoney3").html("0");
			$("#approveMoney3").html("0");
			$("#payMoney3").html("0");
			$("#payRate3").html("-");
			for ( var i = 0; i < result.length; i++) {
				if (result[i].PAY_TYPE == (i + 2)) {
					$("#applyMoney" + (i + 1)).html(result[i].APPLY_MONEY);
					$("#approveMoney" + (i + 1)).html(result[i].APPROVE_MONEY);
					$("#payMoney" + (i + 1)).html(result[i].PAY_MONEY);
					$("#payRate" + (i + 1)).html(result[i].PAY_RATE);
				}
			}
		}
	});
}

// 获取风险统计图表
function getRiskStatisticsChart(data) {
	// 初始化echarts实例
	riskStatisticsChart = echarts.init($("#riskStatisticsChart")[0]);
	// 指定图表的配置项和数据
	var option = {
		tooltip : {
			trigger : 'item',
			formatter : "{a} <br/>{b} : {c} ({d}%)"
		},
		legend : {
			orient : 'horizontal',
			bottom : 'bottom',
			data : [ 'A类风险', 'B类风险', 'C类风险', 'D类风险' ]
		},
		series : [ {
			name : '风险统计',
			type : 'pie',
			radius : '50%',
			center : [ '50%', '50%' ],
			data : [ {
				value : data.RISKBCOUNT,
				name : 'B类风险'
			}, {
				value : data.RISKCCOUNT,
				name : 'C类风险'
			}, {
				value : data.RISKDCOUNT,
				name : 'D类风险'
			}, {
				value : data.RISKACOUNT,
				name : 'A类风险'
			} ],
			itemStyle : {
				emphasis : {
					shadowBlur : 10,
					shadowOffsetX : 0,
					shadowColor : 'rgba(0, 0, 0, 0.5)'
				}
			},
			color : [ '#1FDBDD', '#C5AEF6', '#FFCA84', '#F07D84' ]
		} ]
	};
	// 使用指定的配置项和数据显示图表
	riskStatisticsChart.setOption(option);
	riskStatisticsChart.on('click', function(params) {
		var riskType = params.name;
		var riskLevel;
		if (params.name == "A类风险") {
			riskLevel = 1;
		} else if (params.name == "B类风险") {
			riskLevel = 2;
		} else if (params.name == "C类风险") {
			riskLevel = 3;
		} else if (params.name == "D类风险") {
			riskLevel = 4;
		}
		$("#riskPatrolProblemTitle").html(params.name + "统计");
		getRiskPatrolProblemChart($("input[name=period]:checked").attr("id"),
				$("#startDate").datebox("getValue"), $("#endDate").datebox(
						"getValue"), riskLevel);
		$("#yearRiskStatisticsTitle").html(params.name);
		getYearRiskStatisticsChart(riskLevel);
	});
}

// 获取风险巡查报告图表
function getRiskPatrolProblemChart(periodType, startDate, endDate, riskLevel) {
	$.ajax({
		type : "POST",
		cache : false,
		dataType : "json",
		url : ctx + "/BRiskPatrolProblemList/getRiskPatrolProblemData.action",
		data : {
			periodType : periodType,
			startDate : startDate,
			endDate : endDate,
			riskLevel : riskLevel
		},
		success : function(result) {
			var resultObj = JSON.parse(result);
			// 初始化echarts实例
			riskPatrolProblemChart = echarts
					.init($("#riskPatrolProblemChart")[0]);
			// 指定图表的配置项和数据
			var option = {
				tooltip : {
					trigger : 'axis'
				},
				legend : {
					orient : 'horizontal',
					bottom : 'bottom',
					data : [ '报告', '整改' ]
				},
				calculable : true,
				xAxis : [ {
					type : 'category',
					data : [ '巡查风险', '跟踪审计', '其他风险' ]
				} ],
				yAxis : [ {
					type : 'value'
				} ],
				series : [ {
					name : '报告',
					type : 'bar',
					data : resultObj.reportRiskCount
				}, {
					name : '整改',
					type : 'bar',
					data : resultObj.reformRiskCount
				} ],
				color : [ '#FF8305', '#87CEFA' ]
			};
			// 使用指定的配置项和数据显示图表
			riskPatrolProblemChart.setOption(option);
		}
	});
}

// 获取年度风险统计图表
function getYearRiskStatisticsChart(riskLevel) {
	$
			.ajax({
				type : "POST",
				cache : false,
				dataType : "json",
				url : ctx
						+ "/BRiskPatrolProblemList/getYearRiskStatisticsData.action",
				data : {
					riskLevel : riskLevel
				},
				success : function(result) {
					var resultObj = JSON.parse(result);
					// 初始化echarts实例
					yearRiskStatisticsChart = echarts
							.init($("#yearRiskStatisticsChart")[0]);
					// 指定图表的配置项和数据
					var option = {
						tooltip : {
							trigger : 'axis'
						},
						legend : {
							orient : 'horizontal',
							bottom : 'bottom',
							data : [ resultObj.lastYear + '年',
									resultObj.thisYear + '年' ]
						},
						grid : {
							left : '5%',
							right : '5%',
							bottom : '12%',
							containLabel : true
						},
						xAxis : {
							type : 'category',
							boundaryGap : false,
							data : [ '1月', '2月', '3月', '4月', '5月', '6月', '7月',
									'8月', '9月', '10月', '11月', '12月' ]
						},
						yAxis : {
							type : 'value'
						},
						series : [ {
							name : resultObj.lastYear + '年',
							type : 'line',
							stack : '总量',
							data : resultObj.lastYearData
						}, {
							name : resultObj.thisYear + '年',
							type : 'line',
							stack : '总量',
							data : resultObj.thisYearData
						} ],
						color : [ '#8BCFFB', '#C74745' ]
					};
					// 使用指定的配置项和数据显示图表
					yearRiskStatisticsChart.setOption(option);
				}
			});
}

// 格式化日期
function formatDate(dateValue) {
	var dateArr = dateValue.split("-");
	return dateArr[0] + "年" + dateArr[1].replace(/\b(0+)/gi, "") + "月"
			+ dateArr[2].replace(/\b(0+)/gi, "") + "日";
}

window.onresize = function() {
	riskStatisticsChart.resize();
	riskPatrolProblemChart.resize();
	yearRiskStatisticsChart.resize();
}
function RiskCount(riskType,risklevel){
	var title;
	var periodType = $("input[name=period]:checked").attr("id");
	var startDate = "";
	var endDate = "";
	var startDateP = "";
	var endDateP = "";
	var date = new Date();
	var year = date.getFullYear();
	var month = date.getMonth() + 1;
	var day = date.getDate();
	if (periodType == "thisYear") {
		startDate = year + "-01-01";
		endDate = year + "-" + month + "-" + day;
	} else if (periodType == "thisSeason") {
		var startMonth;
		if (month <= 3) {
			startMonth = 1;
		} else if (month <= 6) {
			startMonth = 4;
		} else if (month <= 9) {
			startMonth = 7;
		} else if (month <= 12) {
			startMonth = 10;
		}
		startDate = year + "-" + startMonth + "-01";
		endDate = year + "-" + month + "-" + day;
	} else if (periodType == "thisMonth") {
		startDate = year + "-" + month + "-01";
		endDate = year + "-" + month + "-" + day;
	} else if (periodType == "period") {
		startDateP = $("#startDate").datebox("getValue");
		endDateP = $("#endDate").datebox("getValue");
		if (!startDateP) {
			alertInfo("请选择开始日期！");
			return;
		} else if (!endDateP) {
			alertInfo("请选择结束日期！");
			return;
		} else if (startDateP > endDateP) {
			alertInfo("开始日期不能大于结束日期！");
			return;
		}
		startDate = formatDate(startDateP);
		endDate = formatDate(endDateP);
	}
	if(riskType=='confirm'){
		title='确认风险';
	}else if(riskType=='reform'){
		title='整改风险';
	}else if(riskType=='rest'){
		title='剩余风险';
	}else{
		title='逾期风险';
	}
	var risk='B';
	if(risklevel=='1'){
		risk='A';
	}
	parent.openInMainTab(risk+'类风险'+title+'信息','/view/riskStatisticsPage/RiskCount?riskType='+riskType+'&risklevel='+risklevel+'&startDate='+startDate+'&endDate='+endDate);
}