

//普通导出表格数据gridName 表格名称，title要导出的名称
function exportExcel(gridName,title){
	var gridOptions= $('#'+gridName).datagrid('options');
	var params=setParams(gridOptions);
	var heads = params.heads;//导出时的列标题
	var fields = params.fields;//导出时的列fields
	var queryParams = setQueryparams(gridOptions);//连接url条件
	var data = $('#'+gridName).datagrid('getData');
	//是否查询全部数据flag=all是全部查询
	queryParams=setParamsForPage(data,"all",queryParams);
	queryParams=setParamsForSort(gridOptions,queryParams);
	var urlAddress=gridOptions.url;
	var url=ctx+'/export/exportExcel?title='+title;
	urlPost(url,urlAddress,heads,fields,queryParams);
}
//导出多表头表格数据gridName 表格名称，title要导出的名称
function exportSpanExcel(gridName,title){
	var gridOptions= $('#'+gridName).datagrid('options');
	var params=setMoreParams(gridOptions);
	var heads = params.heads;//导出时的列标题
	var fields = params.fields;//导出时的列fields
	var queryParams = setQueryparams(gridOptions);//连接url条件
	var data = $('#'+gridName).datagrid('getData');
	queryParams=setParamsForPage(data,"all",queryParams);
	var urlAddress=gridOptions.url;
	var url=ctx+'/export/exportSpanExcel.action?title='+title;
	urlPost(url,urlAddress,heads,fields,queryParams);
}
//导出带分页多表头表格数据gridName 表格名称，title要导出的名称
function exportSpanPageExcel(gridName,title,flag){
	var gridOptions= $('#'+gridName).datagrid('options');
	var params=setMoreParams(gridOptions);
	var heads = params.heads;//导出时的列标题
	var fields = params.fields;//导出时的列fields
	var queryParams = setQueryparams(gridOptions);//连接url条件
	//分页页面取当前查询页面的currpage和total
	var data = $('#'+gridName).datagrid('getData');
	//是否查询全部数据flag=all是全部查询
	queryParams=setParamsForPage(data,flag,queryParams);
	var urlAddress=gridOptions.url;
	var url=ctx+'/export/exportSpanExcel.action?title='+title;
	urlPost(url,urlAddress,heads,fields,queryParams);
}
//多个grid导出
function exportExcelMulti(gridids,titles,bigTitle,pageFlags){
	var gridarrays = [];//连接url条件
	var urlAddressArray = [];//连接url条件
	var headsArray = [];//连接url条件
	var fieldsArray = [];//连接url条件
	var queryParamsArray = [];//连接url条件
	var baseurl=ctx+'/export/exportExcelMulti?bigTitle='+bigTitle+'&titles='+titles;
	for(var i=0;i<gridids.length;i++){
		var gridOptions= $('#'+gridids[i]).datagrid('options');
		var params=setMoreParams(gridOptions);
		var heads = params.heads;//导出时的列标题
		var fields = params.fields;//导出时的列fields
		var queryParams = setQueryparams(gridOptions);//连接url条件
		//分页页面取当前查询页面的currpage和total
		var data = $('#'+gridids[i]).datagrid('getData');
		//是否查询全部数据flag=all是全部查询
		queryParams=setParamsForPage(data,pageFlags[i],queryParams);//获取分页参数
		var urlAddress=gridOptions.url;
		urlAddressArray.push(urlAddress);
		headsArray.push(heads.join(','));
		fieldsArray.push(fields.join(',') );
		queryParamsArray.push(queryParams.join(','));
	}
	var gridurl=GetGridUrl(baseurl,urlAddressArray,headsArray,fieldsArray,queryParamsArray);
	window.open(gridurl);
}

//设置单表头导出excel的heads fields
function setParams(gridOptions){
	var params=new Object();
	var heads = [];//导出时的列标题
	var fields = [];//导出时的列fields
	//取grid的column循环取标题及fields
	 if( gridOptions.frozenColumns[0]){
		for(var i=0;i<gridOptions.frozenColumns[0].length;i++){
				if(undefined==gridOptions.frozenColumns[0][i].title||gridOptions.frozenColumns[0][i].hidden||gridOptions.frozenColumns[0][i].title=="明细"){
					continue ;
				}
				var head=gridOptions.frozenColumns[0][i].title.replace('<br/>','');//去掉标题换行符
				heads.push(head);
				var field=gridOptions.frozenColumns[0][i].field;
				fields.push(field);
			}
		}
	 if(gridOptions.columns[0]){
		for(var i=0;i<gridOptions.columns[0].length;i++){
			if(undefined==gridOptions.columns[0][i].title||gridOptions.columns[0][i].hidden||gridOptions.columns[0][i].title=="明细"){
				continue ;
			}
			var head=gridOptions.columns[0][i].title.replace('<br/>','');//去掉标题换行符
			heads.push(head);
			var field=gridOptions.columns[0][i].field;
			fields.push(field);
		}
	 }
	params.heads=heads;
	params.fields=fields;
	return params;
}

//设置多表头导出excel的heads fields
function setMoreParams(gridOptions){
	var params=new Object();
	var heads = [];//导出时的列标题
	var fields = [];//导出时的列fields
	if(gridOptions.frozenColumns.length==2){//多表头
		var index=0;
		for(var i=0;i<gridOptions.frozenColumns.length;i++){
			var colums=gridOptions.frozenColumns[i];
			for(var k=0;k<colums.length;k++){
				var col=colums[k];
				if(col.field){
					fields.push(col.field);
				}
				if(i==0){
					if(col.colspan){
						var childtitle=[];
						for(var j=0;j<col.colspan;j++){
							childtitle.push(gridOptions.frozenColumns[1][index].title);
							index++;
						}
						heads.push(col.title+":"+childtitle.join(";"));

					}else{
						heads.push(col.title);
					}
				}
			}
		}
	}else if(gridOptions.frozenColumns.length==1){//单表头
		for(var i=0;i<gridOptions.frozenColumns[0].length;i++){
			if(undefined==gridOptions.frozenColumns[0][i].title||gridOptions.frozenColumns[0][i].hidden||gridOptions.frozenColumns[0][i].title=="明细"){
				continue ;
			}
			var head=gridOptions.frozenColumns[0][i].title;
			heads.push(head);
			var field=gridOptions.frozenColumns[0][i].field;
			fields.push(field);
		}
	}
	//取grid的column循环取标题及fields
	if(gridOptions.columns.length==2){//多表头
		var index=0;
		for(var i=0;i<gridOptions.columns.length;i++){
			var colums=gridOptions.columns[i];
			for(var k=0;k<colums.length;k++){
				var col=colums[k];
				if(col.field&&i!=0){
					fields.push(col.field);
				}
				if(i==0){
					if(col.colspan){
						var childtitle=[];
						for(var j=0;j<col.colspan;j++){
							childtitle.push(gridOptions.columns[1][index].title);
							index++;
						}
						heads.push(col.title+":"+childtitle.join(";"));

					}else{
						heads.push(col.title);
					}
				}
			}
		}
	}else if(gridOptions.columns.length==1){//单表头
		for(var i=0;i<gridOptions.columns[0].length;i++){
			if(undefined==gridOptions.columns[0][i].title||gridOptions.columns[0][i].hidden||gridOptions.columns[0][i].title=="明细"){
				continue ;
			}
			var head=gridOptions.columns[0][i].title;
			heads.push(head);
			var field=gridOptions.columns[0][i].field;
			fields.push(field);
		}
	}
	params.heads=heads;
	params.fields=fields;
	return params;
}


//设置导出excel的queryparam
function setQueryparams(gridOptions){
	var queryParams = [];//连接url条件
	//取grid的queryParams循环得到参数
	for(var param in gridOptions.queryParams){
		var queryParam=[];
		queryParam.push(param);
		queryParam.push(gridOptions.queryParams[param]);
		queryParams.push(queryParam.join(':'));
	}
	return queryParams;
}
//设置导出excel的分页条件信息
function setParamsForPage(data,flag,queryParams){
	//是否查询全部数据flag=all是全部查询
	if(flag=="all"){//所有数据
		var page="page:"+1;
		queryParams.push(page);
		if(data.total==0){
			data.total=1;
		}
		var rows="rows:"+data.total;

		queryParams.push(rows);
	}else if(flag=="curent"){//当前页数据
		var page="page:"+data.currpage;
		queryParams.push(page);
		var rows="rows:"+gridOptions.pageSize;
		queryParams.push(rows);
	}else{//没有分页
		;
	}
	return queryParams;
}
//设置导出excel的分页条件信息
function setParamsForSort(dataoptions,queryParams){
	if(dataoptions.sortName){
		var rows="sort:"+dataoptions.sortName;
		queryParams.push(rows);
		if(dataoptions.sortOrder){
			var rows="order:"+dataoptions.sortOrder;
			queryParams.push(rows);
		}else{
			var rows="order:asc";
		}
	}
	return queryParams;
}


//设置导出excel的url
function setUrl(url,urlAddress,heads,fields,queryParams){
	url+='&urlAddress='+urlAddress;
	url+='&heads='+heads.join(',').replace(/%/g,"%25");
	url+='&fields='+fields.join(',');
	url+='&queryParams='+queryParams.join(',');
	return url ;
}


//设置导出excel的url,多个grid
function GetGridUrl(baseurl,urlAddressArray,headsArray,fieldsArray,queryParamsArray){
	baseurl+='&urlAddressArray='+urlAddressArray.join(',');
	baseurl+='&headsArray='+headsArray.join(']');
	baseurl+='&fieldsArray='+fieldsArray.join(']');
	baseurl+='&queryParamsArray='+queryParamsArray.join(']');
	return baseurl ;
}
//通过POST方式导出带分页的表格数据  放置heads fields过多导致url过长以及get方式报错
//导出带分页的表格数据 gridName 表格名称，title要导出的名称flag是all表示导出所有数据否则导出当前页数据
/**
 * 
 * @param {} gridName 导出的grid的ID
 * @param {} title 导出文件的标题
 * @param {} flag flag=all是全部查询
 * @param {} dicparas 导出表格中涉及字典的字段 var dicparas={"COOPERATION_MODE":"PRE_COOPERATION_MODE"};
 */
function exportPageExcel(gridName,title,flag,dicparas){
	var gridOptions= $('#'+gridName).datagrid('options');
	var gridOptions= $('#'+gridName).datagrid('options');
	var params=setParams(gridOptions);
	var heads = params.heads;//导出时的列标题
	var fields = params.fields;//导出时的列fields
	var queryParams = setQueryparams(gridOptions);//连接url条件
	//分页页面取当前查询页面的currpage和total
	var data = $('#'+gridName).datagrid('getData');
	//是否查询全部数据flag=all是全部查询
	queryParams=setParamsForPage(data,flag,queryParams);
	var urlAddress=gridOptions.url;
	var url=ctx+'/export/exportExcel?title='+title;
	urlPost(url,urlAddress,heads,fields,queryParams,dicparas);
//	url=setUrl(url,urlAddress,heads,fields,queryParams);
//	window.open(url);
}
function urlPost(url,urlAddress,heads,fields,queryParams,dicparas){
	var isExit=document.getElementById('frmDummy');
	if(!isExit){
		var f="<form id='frmDummy' name='frmDummy' method='post' action='"+url+"'  style='display:none' >"
		+" <textarea  name='urlAddress' id='urlAddress' ></textarea> "
		+" <input type='hidden' name='heads' id='heads' >  "
		+" <input type='hidden' name='fields' id='fields' >  "
		+" <input type='hidden' name='queryParams' id='queryParams' >  "
		+" <input type='hidden' name='dicparas' id='dicparas' >  "
		+"</form>";
		$('body').append(f);
	}
	
	$("#frmDummy").attr('action',url);
	$("#urlAddress").val(urlAddress);
	$("#heads").val(heads.join(','));
	$("#fields").val(fields.join(','));
	$("#queryParams").val(queryParams.join(','));
	if(dicparas){
		$("#dicparas").val(JSON.stringify(dicparas));
	}
	$('#frmDummy').submit();
}

/**
 * 
 * 境外机构总览界面
 * @param gridName
 * @param title
 * @param flag
 * @param dicparas
 */
function exportPageExcelJQGrid1(gridName,title,flag,dicparas){
	var gridOptions= $('#'+gridName).jqGrid('getGridParam');
	var params=setParamsJQGrid(gridName);
	var heads = params.heads;//导出时的列标题
	var fields = params.fields;//导出时的列fields
	var queryParams = setQueryparamsJQGrid(gridName);//连接url条件
	//分页页面取当前查询页面的currpage和total
	//是否查询全部数据flag=all是全部查询
	queryParams=setParamsForPageJQ(gridName,flag,queryParams);
	var urlAddress=gridOptions.url;
	var url=ctx+'/export/exportExcel.action?title='+title;
	var urlAddress = ctx+ '/BasOutsideOrgController/getBasOutsideOrgListzonglanExport.action';
	urlPost(url,urlAddress,heads,fields,queryParams,dicparas);
}


/**
 * 
 * @param {} gridName 导出数据的jqgrid的ID
 * @param {} title  导出文件的标题
 * @param {} flag   "total"导出所有数据  "current" 导出当前页
 * @param {} dicparas dicparas 导出表格中涉及字典的字段 var dicparas={"COOPERATION_MODE":"PRE_COOPERATION_MODE"};
 */
function exportPageExcelJQGrid(gridName,title,flag,dicparas){
	var gridOptions= $('#'+gridName).jqGrid('getGridParam');
	var params=setParamsJQGrid(gridName);
	var heads = params.heads;//导出时的列标题
	var fields = params.fields;//导出时的列fields
	var queryParams = setQueryparamsJQGrid(gridName);//连接url条件
	//分页页面取当前查询页面的currpage和total
	//是否查询全部数据flag=all是全部查询
	queryParams=setParamsForPageJQ(gridName,flag,queryParams);
	var url=ctx+'/export/exportExcel?title='+title;
	var urlAddress=gridOptions.url;
	urlPost(url,urlAddress,heads,fields,queryParams,dicparas);
}
//设置单表头导出excel的heads fields
function setParamsJQGrid(gridName){
	
	var params=new Object();
	var heads = [];//导出时的列标题
	var fields = [];//导出时的列fields
	var colNames=$("#"+gridName).jqGrid('getGridParam','colNames');
	var colModel=$("#"+gridName).jqGrid('getGridParam','colModel');
	var groupheader=$("#"+gridName).jqGrid('getGridParam','groupHeader');
	//多表头
	if(groupheader&&groupheader.groupHeaders.length>0){
		if(colModel[0]){
			for(var i=0;i<colModel.length;i++){
				if(colModel[i].name&&!colModel[i].hidden&&colNames[i]!='明细'){
				
					var childtitle=[];
					var parenttitle="";
					for(var j=0;j<groupheader.groupHeaders.length;j++){
						if(groupheader.groupHeaders[j].startColumnName==colModel[i].name){//如果
							for(var k=0;k<groupheader.groupHeaders[j].numberOfColumns;k++){
								childtitle.push(colNames[i]);
								fields.push(colModel[i].name);
								i++;
							}
							parenttitle=groupheader.groupHeaders[j].titleText;
							i=i-1;
							break;
						}
					}
					if(childtitle.length>0){
						heads.push(parenttitle+":"+childtitle.join(";"));
					}else{
						fields.push(colModel[i].name);
						heads.push(colNames[i]);
					}
					
				}
			}
		}
		
	}else{
		if(colModel[0]){
			for(var i=0;i<colModel.length;i++){
				if(colModel[i].name&&!colModel[i].hidden&&colNames[i]!='明细'){
					heads.push(colNames[i]);
					fields.push(colModel[i].name);
				}
			}
		}
		
	}
	params.heads=heads;
	params.fields=fields;
	
	return params;
}

//设置导出excel的分页条件信息
function setParamsForPageJQ(gridName,flag,queryParams){
	//是否查询全部数据flag=all是全部查询
	 var records = $("#"+gridName).getGridParam("records")
	if(flag=="all"){//所有数据
		var page="page:"+1;
		queryParams.push(page);
		var rows="rows:";
		if(records!=0){
			rows+=records;
		}
		queryParams.push(rows);
	}else if(flag=="curent"){//当前页数据
		var page="page:"+$("#"+gridName).getGridParam('page');
		queryParams.push(page);
		var rows="rows:"+$("#"+gridName).getGridParam('rowNum');
		queryParams.push(rows);
	}else{//没有分页
		var page="page:"+1;
		queryParams.push(page);
		var rows="rows:";
		if(records!=0){
			rows+=records;
		}
		queryParams.push(rows);
	}
	return queryParams;
}

//设置导出excel的queryparam
function setQueryparamsJQGrid(gridName){
	var queryParams = [];//连接url条件
	//取grid的queryParams循环得到参数
	for(var param in $("#"+gridName).getGridParam('postData')){
		if(param!="rows"&&param!="page"){//page和rows之前已经拼接进参数了
			var queryParam=[];
			queryParam.push(param);
			queryParam.push($("#"+gridName).getGridParam('postData')[param]);
			queryParams.push(queryParam.join(':'));
		}
		
	}
	return queryParams;
}

//多个grid导出
function exportExcelMultiJQGrid(gridids,titles,bigTitle,pageFlags){
	var gridarrays = [];//连接url条件
	var urlAddressArray = [];//连接url条件
	var headsArray = [];//连接url条件
	var fieldsArray = [];//连接url条件
	var queryParamsArray = [];//连接url条件
	var baseurl=ctx+'/export/exportExcelMulti?bigTitle='+bigTitle+'&titles='+titles;
	for(var i=0;i<gridids.length;i++){
		var gridOptions= $('#'+gridids[i]).jqGrid('getGridParam');
		var params=setParamsJQGrid(gridids[i]);
		var heads = params.heads;//导出时的列标题
		var fields = params.fields;//导出时的列fields
		var queryParams = setQueryparamsJQGrid(gridids[i]);//连接url条件
		//分页页面取当前查询页面的currpage和total
		//是否查询全部数据flag=all是全部查询
		queryParams=setParamsForPageJQ(gridids[i],pageFlags[i],queryParams);//获取分页参数
		var urlAddress=gridOptions.url;
		urlAddressArray.push(urlAddress);
		headsArray.push(heads.join(','));
		fieldsArray.push(fields.join(',') );
		queryParamsArray.push(queryParams.join(','));
	}
	var gridurl=GetGridUrl(baseurl,urlAddressArray,headsArray,fieldsArray,queryParamsArray);
	window.open(gridurl);
}

