/*jslint browser: true */ /*global jQuery: true */
String.prototype.getWidth = function(fontSize)  
{  
    var span = document.getElementById("__getwidth");  
    if (span == null) {  
        span = document.createElement("span");  
        span.id = "__getwidth";  
        document.body.appendChild(span);  
        span.style.visibility = "hidden";  
        span.style.whiteSpace = "nowrap";  
    }  
    span.innerText = this;  
    span.style.fontSize = fontSize + "px";  
  
    return span.offsetWidth;  
}
/**
 * 格式化数字
 * @param {} value 数字
 * @param {} fix  保留的小数点后位数
 * @return {} 返回结果如 12123456.78
 */
$.FormatNumber= function(value,fix) {  
        var reg = /[\$,%]/g;  
        var key = parseFloat( String(value).replace(reg, '')).toFixed(fix); // toFixed小数点后两位  
        return isNaN(key) ? '' : key;  
};  
/**
 * 数字格式化成金额格式
 * 用法:$.FormatMoney(123456,2);
 * 
 * @param {} value 数字
 * @param {} fix 保留的小数点位数
 * @return {} 返回结果如 12,123,456.78
 */
$.FormatMoney=function(num,fix){
	if (typeof num !== "number")
		return num;// 判断是否是数字
	//格式化金额
	num= parseFloat(num);
	//取绝对值操作
	var absNum = Math.abs(num);
	if(fix){
		num= num.toFixed(fix);
		absNum=absNum.toFixed(fix);
	}
	absNum = absNum.toString();// 字符化
	var s = absNum.match(/e\+(\d+)$/), ext = 0;
	absNum = absNum.replace(/e.+$/, '');
	if (s)
		ext = Number(s[1]);

	// 分割小数点两边
	var tA = absNum.split('.');
	if (tA.length >= 2 && ext) {// 有小数点则分割开来处理(小数点后面可能还跟有科学记数法表示)
		if (tA.length > ext) {
			tA[0] += tA[1].slice(0, ext - 1);
			tA[1] = tA[1].slice(ext - 1, tA[1].length - 1);
		} else {
			tA[0] += (tA[1] + "0".repeat(ext - tA.length));
			tA[1] = '';
		}
	}
	tA[0] = tA[0].split('');// 拆字符
	for (var i = tA[0].length; (i -= 3) > 0;) {//插逗号
		tA[0].splice(i, 0, ',');
	}
	var formatNum = tA[0].join('') + (tA[1] ? '.' + tA[1] : '');//连起来
	//负数则补上负号
	return absNum==num?formatNum:'-'+formatNum;
}    

/**
 * @requires jQuery,EasyUI panel关闭时回收内存，主要用于layout使用iframe嵌入网页时的内存泄漏问题
 */
$.fn.panel.defaults.onBeforeDestroy = function() {
	var frame = $('iframe', this);
	try {
		if (frame.length > 0) {
			for ( var i = 0; i < frame.length; i++) {
				frame[i].contentWindow.document.write('');
				frame[i].contentWindow.close();
			}
			frame.remove();
			if ($.browser.msie) {
				CollectGarbage();
			}
		}
	} catch (e) {
	}
};

/**
 * @requires jQuery,EasyUI
 * 扩展tree，使其支持平滑数据格式
 */
$.fn.tree.defaults.loadFilter = function(data, parent) {
	var opt = $(this).data().tree.options;
	var idFiled, textFiled, parentField;
	if (opt.parentField) {
		idFiled = opt.idFiled || 'id';
		textFiled = opt.textFiled || 'text';
		parentField = opt.parentField;
		var i, l, treeData = [], tmpMap = [];
		for (i = 0, l = data.length; i < l; i++) {
			tmpMap[data[i][idFiled]] = data[i];
		}
		for (i = 0, l = data.length; i < l; i++) {
			if (tmpMap[data[i][parentField]] && data[i][idFiled] != data[i][parentField]) {
				if (!tmpMap[data[i][parentField]]['children'])
					tmpMap[data[i][parentField]]['children'] = [];
				data[i]['text'] = data[i][textFiled];
				tmpMap[data[i][parentField]]['children'].push(data[i]);
			} else {
				data[i]['text'] = data[i][textFiled];
				treeData.push(data[i]);
			}
		}
		return treeData;
	}
	return data;
};

$.fn.form.defaults.fieldTypes =['combobox','combotree','combogrid','combotreegrid','datetimebox','datebox','combo',
		        'datetimespinner','timespinner','numberspinner','spinner',
		        'slider','searchbox','numberbox','passwordbox','filebox','textbox','switchbutton','monthbox','yearbox'];
//数值输入框设置最大值,防止出现科学计数法造成保存出错
//$.fn.numberbox.defaults.max=999999999999;
//数值输入框设置最小值(如果有特俗需要的数字框，在需要处修改)
//下拉框默认不可编辑
$.fn.combo.defaults.width=200;
$.fn.combobox.defaults.editable=false;
$.fn.textbox.defaults.width=200;
$.fn.numberbox.defaults.width=200;
$.fn.numberspinner.defaults.width=200;

//下拉框默认宽度180
$.fn.combobox.defaults.width=200;
$.fn.combobox.defaults.panelMaxHeight=150;
//下拉树默认宽度180
$.fn.combotree.defaults.width=200;
//日期框默认不可编辑
$.fn.datebox.defaults.editable=false;
//日期框默认宽度180
$.fn.datebox.defaults.width=200;
//日期框默认不可编辑
$.fn.datetimebox.defaults.editable=false;
//日期框默认宽度180
$.fn.datetimebox.defaults.width=200;
//日期框默认宽度180
$.fn.passwordbox.defaults.width=200;
//设置日期框的默认时间
//$.fn.datebox.defaults.value=new Date().format("yyyy-MM-dd");
////设置日期框的默认格式
//$.fn.datebox.defaults.formatter = function(date){
//	var s= date.format("yyyy-MM-dd");
//	var ss = s.split('-');
//	if(ss[0].length!=4){
//		return this.originalValue;
//	}
//	return s;
//};
//分页不显示showPageList
$.fn.pagination.defaults.showPageList=false;

//grid分页大小为20行
$.fn.datagrid.defaults.pageSize=30;

$.fn.datagrid.defaults.striped=true;
//下拉框设置默认group
$.fn.combobox.defaults.groupField="group";

$.fn.tree.defaults.lines=true;
$.fn.tree.defaults.onDblClick= function(node) {  
    $(this).tree(node.state === 'closed' ? 'expand' : 'collapse', node.target);
}  
/*默认加载成功后，如有数据自动选择第一项。*/
/*$.fn.combobox.defaults.onLoadSuccess = SelectComboboxFirstItem;

function SelectComboboxFirstItem() {
    $(this).combobox('selectIndex', 0);
}*/

/*
*根据索引选中Combobox中的项
*示例 $('#cmb').combobox('selectIndex',0);
*/
$.extend($.fn.combobox.methods, {
    selectIndex: function (cmb, index) {
        var datas = cmb.combobox('getData');
        if (datas == null || datas.length == 0 || index > datas.length) {
            return;
        }
        var valueField = cmb.combobox('options').valueField;
        var textField = cmb.combobox('options').textField;
        if (valueField != null&&textField!=null) {
        	cmb.combobox('select',datas[index][valueField]);
        	setTimeout(function(){//解决IE10下 不显示默认值的bug
        		$.data(cmb[0],"combo").combo.find("input.combo-text").val(datas[index][textField])
//        		cmb.combobox('setText',datas[index][textField]);
        	},300)
//            cmb.combobox('select', eval('datas[index].' + valueField));
        }
    },
    getSelectData: function(cmb){
    	var datas = cmb.combobox('getData');
    	var value=cmb.combobox('getValue');
    	if(value){
    		if (datas == null || datas.length == 0 ) {
    			return null;
    		}
    		var valueField = cmb.combobox('options').valueField;
    		if (valueField != null) {
    			for(var i=0;i<datas.length;i++){
    				if(eval('datas['+i+'].' + valueField)==value){
    					return datas[i];
    				}
    			}
    		}
    	}
    	return null;
    }
});
/***
 * 扩展easyui树的获取层级的方法
 */
$.extend($.fn.tree.methods, {
	    getLevel:function(jq,target){
	        var l = $(target).parentsUntil("ul.tree","ul");
	        return l.length+1;
	    }
});


$.extend($.fn.panel.methods, {
    isLoaded: function (jq) {
      return  $.data(jq[0],"panel").isLoaded;
    }
});

$.extend($.fn.form.methods, {
LoadDetail : function (jq, param) {
	return jq.each(function () {
		load(this, param);
	});

	function load(target, param) {
		if (!$.data(target, "form")) {
			$.data(target, "form", {
				options : $.extend({}, $.fn.form.defaults)
			});
		}
		var options = $.data(target, "form").options;
		if (typeof param == "string") {
			var params = {};
			if (options.onBeforeLoad.call(target, params) == false) {
				return;
			}
			$.ajax({
				url : param,
				data : params,
				dataType : "json",
				success : function (rsp) {
					loadData(rsp);
				},
				error : function () {
					options.onLoadError.apply(target, arguments);
				}
			});
		} else {
			loadData(param);
		}
		function loadData(dd) {
			
			var form = $(target);
			var formFields = form.find("span");
			formFields.each(function(){
				var name = $(this).attr("name");
				var value = jQuery.proxy(function(){try{return eval('this.'+name);}catch(e){return "";}},dd)();
				//从数据中找到控件对应的值之后 才进行赋值
				if(typeof(value) != "undefined"){
					$("span[name=\"" + name + "\"]", form).html(value);
				}else{
					$("span[name=\"" + name + "\"]", form).html('');
				}
			});
			options.onLoadSuccess.call(target, dd);
			$(target).form("validate");
		};
	};
}
});



$.extend($.fn.datagrid.methods, {
    statistics: function (jq) {
        var opt=$(jq).datagrid('options').columns;
        var rows = $(jq).datagrid("getRows");
         
        var footer = new Array();
        footer['sum'] = "";
        footer['avg'] = "";
        footer['max'] = "";
        footer['min'] = "";
         
        for(var i=0; i<opt[0].length; i++){
            if(opt[0][i].sum){
                footer['sum'] = footer['sum'] + sum(opt[0][i].field)+ ',';
            }
            if(opt[0][i].avg){
                footer['avg'] = footer['avg'] + avg(opt[0][i].field)+ ',';
            }
            if(opt[0][i].max){
                footer['max'] = footer['max'] + max(opt[0][i].field)+ ',';
            }
            if(opt[0][i].min){
                footer['min'] = footer['min'] + min(opt[0][i].field)+ ',';
            }
        }
 
        var footerObj = new Array();
         
        if(footer['sum'] != ""){
            var tmp = '{' + footer['sum'].substring(0,footer['sum'].length - 1) + "}";
            var obj = eval('(' + tmp + ')');
            if(obj[opt[0][0].field] == undefined){
                footer['sum'] += '"' + opt[0][0].field + '":"<b>合计:</b>"';
                obj = eval('({' + footer['sum'] + '})');
            }else{
                obj[opt[0][0].field] = "<b>合计:</b>" + obj[opt[0][0].field];
            }
            footerObj.push(obj);
        }
         
        if(footer['avg'] != ""){
            var tmp = '{' + footer['avg'].substring(0,footer['avg'].length - 1) + "}";
            var obj = eval('(' + tmp + ')');
            if(obj[opt[0][0].field] == undefined){
                footer['avg'] += '"' + opt[0][0].field + '":"<b>均值:</b>"';
                obj = eval('({' + footer['avg'] + '})');
            }else{
                obj[opt[0][0].field] = "<b>均值:</b>" + obj[opt[0][0].field];
            }
            footerObj.push(obj);
        }
         
        if(footer['max'] != ""){
            var tmp = '{' + footer['max'].substring(0,footer['max'].length - 1) + "}";
            var obj = eval('(' + tmp + ')');
             
            if(obj[opt[0][0].field] == undefined){
                footer['max'] += '"' + opt[0][0].field + '":"<b>最大:</b>"';
                obj = eval('({' + footer['max'] + '})');
            }else{
                obj[opt[0][0].field] = "<b>最大:</b>" + obj[opt[0][0].field];
            }
            footerObj.push(obj);
        }
         
        if(footer['min'] != ""){
            var tmp = '{' + footer['min'].substring(0,footer['min'].length - 1) + "}";
            var obj = eval('(' + tmp + ')');
             
            if(obj[opt[0][0].field] == undefined){
                footer['min'] += '"' + opt[0][0].field + '":"<b>最小:</b>"';
                obj = eval('({' + footer['min'] + '})');
            }else{
                obj[opt[0][0].field] = "<b>最小:</b>" + obj[opt[0][0].field];
            }
            footerObj.push(obj);
        }
         
         
         
        if(footerObj.length > 0){
            $(jq).datagrid('reloadFooter',footerObj); 
        }
         
         
        function sum(filed){
            var sumNum = 0;
            for(var i=0;i<rows.length;i++){
                sumNum += Number(rows[i][filed]);
            }
            return '"' + filed + '":"' + sumNum.toFixed(2) +'"';
        };
         
        function avg(filed){
            var sumNum = 0;
            for(var i=0;i<rows.length;i++){
                sumNum += Number(rows[i][filed]);
            }
            return '"' + filed + '":"'+ (sumNum/rows.length).toFixed(2) +'"';
        }
 
        function max(filed){
            var max = 0;
            for(var i=0;i<rows.length;i++){
                if(i==0){
                    max = Number(rows[i][filed]);
                }else{
                    max = Math.max(max,Number(rows[i][filed]));
                }
            }
            return '"' + filed + '":"'+ max +'"';
        }
         
        function min(filed){
            var min = 0;
            for(var i=0;i<rows.length;i++){
                if(i==0){
                    min = Number(rows[i][filed]);
                }else{
                    min = Math.min(min,Number(rows[i][filed]));
                }
            }
            return '"' + filed + '":"'+ min +'"';
        }
    }
});
/****************扩展easyui验证规则 开始*******************/
function getByteLen(val) { 
	var newvar=val.replace(/[^\x00-\xff]/g, "**");
	return newvar.length;
	
} 

//正整数的验证规模
function getpositiveIntegerLen(val) { 
	var newvar=val.replace(/^(0|([1-9]\d*))$/);
	return newvar.length;
} 


$.extend($.fn.validatebox.defaults.rules, {
	minLength: {
         validator: function (value, param) { return getByteLen(value)>= param[0]; },
         message: "最少 {0} 个字符."
     },
	maxLength: {
		validator: function(value, param){ return getByteLen(value)<= param[0];},
        message: "最多{0}个字符."
    },
    integerLength:{
    	validator: function(value,param){ 
    		return value >param;
    		},
        message: "只能是正整数."
    },
    validDouble:{
    	 validator: function (value, param) {
 	    	if(value){
 		    	var myregex = new RegExp("^[+-]?\\d{1,"+param[0]+"}(\\.\\d{0,"+param[1]+"})?$");
 		        return myregex.test(value);   
 	    	}
 	    },   
 	    message: '最大{0}位数字,{1}位小数.'
    },
    planCode:{
    	validator: function (value) {  
            return /^\d{4}-\d{3}-[A-Z]{3}-[a-zA-Z]{2,3}-[A-Z]$/.test(value);  
        },  
        message: '编号规则：立项年度-流水号-二级单位编码-产业类型编码-建设类型编码，示例：2013-002-ZDG-HD-F'  
    },
    date:{
    	validator: function (value) {  
            return /^[0-9]{4}-[0-1]?[0-9]{1}-[0-3]?[0-9]{1}$/.test(value);  
        },  
        message: '日期规则:"yyyy-MM-dd"'  
    },
    bankAccount: {
         validator: function (value) { 
         	return /^\d{16}$/.test(value)||/^\d{19}$/.test(value);
         },
         message: "16位或19位银行账号."
    },
    contactOrgcode: {
         validator: function (value) {
         	return /^[0-9A-Z]{9}$/.test(value)||/^[0-9A-Z]{18}$/.test(value);
         },
         message: "9或18位数字或字母."
    },
    idcard: {// 验证身份证
                validator: function (value) {
                    return /^\d{15}(\d{2}[A-Za-z0-9])?$/i.test(value);
                },
                message: '身份证号码格式不正确'
   },
   passportNo: {// 护照
       validator: function (value) {
    	   return /(^[EeKkGgDdSsPpHh]\d{8}$)|(^(([Ee][a-fA-F])|([DdSsPp][Ee])|([Kk][Jj])|([Mm][Aa])|(1[45]))\d{7}$)/i.test(value);
       },
       message: '护照格式不正确'
   },
   mobile: {// 验证手机号码
       validator: function (value) {
           return /^1[3-9]\d{9}$/i.test(value);
       },
       message: '手机号码格式不正确'
   },
   mobiles: {// 验证多个手机号码
       validator: function (value) {
           return /^(1[3-9]\d{9})(,(1[3-9]\d{9}))*$/i.test(value);
       },
       message: '手机号码格式不正确'
   },// filebox验证文件大小的规则函数  
        // 如：validType : ['fileSize[1,"MB"]']  
        fileSize : {  
            validator : function(value, array) {  
                var size = array[0];  
                var unit = array[1];  
                if (!size || isNaN(size) || size == 0) {  
                    $.error('验证文件大小的值不能为 "' + size + '"');  
                } else if (!unit) {  
                    $.error('请指定验证文件大小的单位');  
                }  
                var index = -1;  
                var unitArr = new Array("bytes", "kb", "mb", "gb", "tb", "pb", "eb", "zb", "yb");  
                for (var i = 0; i < unitArr.length; i++) {  
                    if (unitArr[i] == unit.toLowerCase()) {  
                        index = i;  
                        break;  
                    }  
                }  
                if (index == -1) {  
                    $.error('请指定正确的验证文件大小的单位：["bytes", "kb", "mb", "gb", "tb", "pb", "eb", "zb", "yb"]');  
                }  
                // 转换为bytes公式  
                var formula = 1;  
                while (index > 0) {  
                    formula = formula * 1024;  
                    index--;  
                }  
                // this为页面上能看到文件名称的文本框，而非真实的file  
                // $(this).next()是file元素  
                return $(this).next().get(0).files[0].size < parseFloat(size) * formula;  
            },  
            message : '文件大小不能超过 {0}{1}'  
        }
});  


/****************扩展easyui验证规则 结束*******************/

/*****************easyu窗口扩展开始*******************/
/**
         * add by cgh
         * 针对panel window dialog三个组件拖动时会超出父级元素的修正
         * 如果父级元素的overflow属性为hidden，则修复上下左右个方向
         * 如果父级元素的overflow属性为非hidden，则只修复上左两个方向
         * @param left
         * @param top
         * @returns
         */
        var easyuiPanelOnMove = function(left, top){
            if ($(this).panel('options').closed) 
                return;
            var parentObj = $(this).panel('panel').parent();
            var width = $(this).panel('options').width;
            var height = $(this).panel('options').height;
            var right = left + width;
            var buttom = top + height;
            var parentWidth = parentObj.width();
            var parentHeight = parentObj.height();
            
            if (left < 1) {
                $(this).panel('move', {
                    left: 1
                });
            }
            if (top < 1) {
                $(this).panel('move', {
                    top: 1
                });
            }
            if (parentWidth < right) {
                $(this).panel('move', {
                    left: parentWidth-width
                });
            }
            
            if (parentHeight < buttom) {
                $(this).panel('move', {
                    top: parentHeight-height
                });
            }
        };
$.fn.window.defaults.onMove = easyuiPanelOnMove;
//$.fn.panel.defaults.onMove = easyuiPanelOnMove;
$.fn.dialog.defaults.onMove = easyuiPanelOnMove; 


////////////datagrid 鼠标经过提示单元格内容 ///////////////
/**
 * Created with JetBrains WebStorm.
 * User: cao.guanghui
 * Date: 13-6-26
 * Time: 下午11:27
 * To change this template use File | Settings | File Templates.
 */
$.extend($.fn.datagrid.methods, {
    /**
     * 开打提示功能（基于1.3.3+版本）
     * @param {} jq
     * @param {} params 提示消息框的样式
     * @return {}
     */
    doCellTip:function (jq, _params) {
    	var params={
        onlyShowInterrupt : 'true',//是否只有在文字被截断时才显示tip，默认值为false，即所有单元格都显示tip
        position : 'bottom',
        maxWidth : '200px',
        specialShowFields : [],
        tipStyler : {
            backgroundColor : '#fff',
            borderColor : '#ccc'
        }
    }
    	$.extend(params,_params);
    	
    	
        function showTip(showParams, td, e, dg) {
            //无文本，不提示。
            if ($(td).text() == "") return;
            params = params || {};
            var options = dg.data('datagrid');
            var styler = 'style="';
            if(showParams.width){
                styler = styler + "width:" + showParams.width + ";";
            }
            if(showParams.maxWidth){
                styler = styler + "max-width:" + showParams.maxWidth + ";";
            }
            if(showParams.minWidth){
                styler = styler + "min-width:" + showParams.minWidth + ";";
            }
            styler = styler + '"';
            showParams.content = '<div class="tipcontent" ' + styler + '>' + showParams.content + '</div>';
            $(td).tooltip({
                content:showParams.content,
                trackMouse:true,
                position:params.position,
                onHide:function () {
                    $(this).tooltip('destroy');
                },
                onShow:function () {
                    var tip = $(this).tooltip('tip');
                    if(showParams.tipStyler){
                        tip.css(showParams.tipStyler);
                    }
                    if(showParams.contentStyler){
                        tip.find('div.tipcontent').css(showParams.contentStyler);
                    }
                }
            }).tooltip('show');
        };
        return jq.each(function () {
            var grid = $(this);
            var options = $(this).data('datagrid');
            if (!options.tooltip) {
                var panel = grid.datagrid('getPanel').panel('panel');
                panel.find('.datagrid-body').each(function () {
                    var delegateEle = $(this).find('> div.datagrid-body-inner').length ? $(this).find('> div.datagrid-body-inner')[0] : this;
                    $(delegateEle).undelegate('td', 'mouseover').undelegate('td', 'mouseout').undelegate('td', 'mousemove').delegate('td[field]', {
                        'mouseover':function (e) {
                            //if($(this).attr('field')===undefined) return;
                            var that = this;
                            var setField = null;
                            if(params.specialShowFields && params.specialShowFields.sort){
                                for(var i=0; i<params.specialShowFields.length; i++){
                                    if(params.specialShowFields[i].field == $(this).attr('field')){
                                        setField = params.specialShowFields[i];
                                    }
                                }
                            }
                            if(setField==null){
                                options.factContent = $(this).find('>div').clone().css({'margin-left':'-5000px', 'width':'auto', 'display':'inline', 'position':'absolute'}).appendTo('body');
                                var factContentWidth = options.factContent.width();
                                params.content = $(this).text();
                                if (params.onlyShowInterrupt) {
                                    if (factContentWidth > $(this).width()) {
                                        showTip(params, this, e, grid);
                                    }
                                } else {
                                    showTip(params, this, e, grid);
                                }
                            }else{
                                panel.find('.datagrid-body').each(function(){
                                    var trs = $(this).find('tr[datagrid-row-index="' + $(that).parent().attr('datagrid-row-index') + '"]');
                                    trs.each(function(){
                                        var td = $(this).find('> td[field="' + setField.showField + '"]');
                                        if(td.length){
                                            params.content = td.text();
                                        }
                                    });
                                });
                                showTip(params, this, e, grid);
                            }
                        },
                        'mouseout':function (e) {
                            if (options.factContent) {
                                options.factContent.remove();
                                options.factContent = null;
                            }
                        }
                    });
                });
            }
        });
    },
    /**
     * 关闭消息提示功能（基于1.3.3版本）
     * @param {} jq
     * @return {}
     */
    cancelCellTip:function (jq) {
        return jq.each(function () {
            var data = $(this).data('datagrid');
            if (data.factContent) {
                data.factContent.remove();
                data.factContent = null;
            }
            var panel = $(this).datagrid('getPanel').panel('panel');
            panel.find('.datagrid-body').undelegate('td', 'mouseover').undelegate('td', 'mouseout').undelegate('td', 'mousemove')
        });
    }
});

/**
 * 合并单元格
 * 
 * @param fields 列名
 */
$.extend($.fn.datagrid.methods, {
	autoMergeCells : function (jq, fields) {
		return jq.each(function () {
			var target = $(this);
			if (!fields) {
				fields = target.datagrid("getColumnFields");
			}
			var rows = target.datagrid("getRows");
			var i = 0,
			j = 0,
			temp = {};
			for (i; i < rows.length; i++) {
				var row = rows[i];
				j = 0;
				for (j; j < fields.length; j++) {
					var field = fields[j];
					var fieldCode = field;
					var fieldvalue=[];
					for(var k=0; k < field.length; k++){
						fieldvalue.push(row[field[k]]);
					}
					if(field instanceof Array){
						fieldCode=field.reverse()[0];
						field.reverse();
					}
					var tf = temp[fieldCode];
					if (!tf) {
						tf = temp[fieldCode] = {};
						tf[fieldvalue.join(",")] = [i];
					} else {
						var tfv = tf[fieldvalue.join(",")];
						if (tfv) {
							tfv.push(i);
						} else {
							tfv = tf[fieldvalue.join(",")] = [i];
						}
					}
				}
			}
			$.each(temp, function (field, colunm) {
				$.each(colunm, function () {
					var group = this;
					
					if (group.length > 1) {
						var before,
						after,
						megerIndex = group[0];
						for (var i = 0; i < group.length; i++) {
							before = group[i];
							after = group[i + 1];
							if (after && (after - before) == 1) {
								continue;
							}
							var rowspan = before - megerIndex + 1;
							if (rowspan > 1) {
								target.datagrid('mergeCells', {
									index : megerIndex,
									field : field,
									rowspan : rowspan
								});
							}
							if (after && (after - before) != 1) {
								megerIndex = after;
							}
						}
					}
				});
			});
		});
	},
	columnMoving: function(jq){
        return jq.each(function(){
            var target = this;
            var cells = $(this).datagrid('getPanel').find('div.datagrid-header td[field]');
            cells.unbind().draggable({
                revert:true,
                cursor:'pointer',
                delay:180,
                edge:5,
                proxy:function(source){
                    var p = $('<div class="tree-node-proxy tree-dnd-no" style="position:absolute;border:1px solid #ff0000"/>').appendTo('body');
                    p.html($(source).text());
                    p.hide();
                    return p;
                },
                onBeforeDrag:function(e){
                    e.data.startLeft = $(this).offset().left;
                    e.data.startTop = $(this).offset().top;
                },
                onStartDrag: function(){
                    $(this).draggable('proxy').css({
                        left:-10000,
                        top:-10000
                    });
                },
                onDrag:function(e){
                    $(this).draggable('proxy').show().css({
                        left:e.pageX+15,
                        top:e.pageY+15
                    });
                    return false;
                }
            }).droppable({
                accept:'td[field]',
                onDragOver:function(e,source){
                	if($(source).parent().is($(this).parent())){//兄弟节点 在同一个row才能拖动
                		$(this).droppable('enable');
	                    $(source).draggable('proxy').removeClass('tree-dnd-no').addClass('tree-dnd-yes');
	                    $(this).css('border-left','1px solid #ff0000');
                	}else{
                		$(this).droppable('disable');
                		$(source).draggable('proxy').removeClass('tree-dnd-yes').addClass('tree-dnd-no');
                   		$(this).css('border-left',0);
                	}
                },
                onDragLeave:function(e,source){
                    $(source).draggable('proxy').removeClass('tree-dnd-yes').addClass('tree-dnd-no');
                    $(this).css('border-left',0);
                },
                onDrop:function(e,source){
                    $(this).css('border-left',0);
                    var fromField = $(source).attr('field');
                    var toField = $(this).attr('field');
                    setTimeout(function(){
                        swapField(fromField,toField);
                        $(target).datagrid();
                        $(target).datagrid('columnMoving');
                    },0);
                }
            });

            // swap Field to another location
            function swapField(from,to){
                var columnss = $(target).datagrid('options').columns;
                var frozenColumnss = $(target).datagrid('options').frozenColumns;
                var sourceColumn;
                //获取拖动表头所在的column组
                sourceColumn=getSourceColumn(from,columnss);
                if(sourceColumn.length==0){
               		sourceColumn=getSourceColumn(from,frozenColumnss);
                }
                _swap(from,to);
                function _swap(fromfiled,tofiled){
                    var fromtemp;
                    var totemp;
                    var fromindex = 0;
                    var toindex = 0;
                    for(var i=0; i<sourceColumn.length; i++){
                        if (sourceColumn[i].field == fromfiled){
                            fromindex = i;
                            fromtemp = sourceColumn[i];
                        }
                        if(sourceColumn[i].field == tofiled){
                            toindex = i;
                            totemp = sourceColumn[i];
                        }
                    }
//                    sourceColumn.splice(fromindex,1,totemp);
//                    sourceColumn.splice(toindex,1,fromtemp);
                      sourceColumn.splice(fromindex,1);
                      sourceColumn.splice(toindex,0,fromtemp);
                }
                function  getSourceColumn(sourcefiled,columns){
	                for(var i=0;i<columns.length;i++){
	                	for(var j in columns[i]){
	                		if(columns[i][j].field==sourcefiled){
	                			return columns[i];
	                		}
	                	}
	                }
	                return [];
                }
            }
        });
    },
    columnSelect : function (jq, fields) {//控制菜单显示隐藏
		return jq.each(function () {
			var target = $(this);
			if (!fields) {
				fields = target.datagrid("getColumnFields",true);
				fields=fields.concat(target.datagrid("getColumnFields"));
			}
			var cells = target.datagrid('getPanel').find('div.datagrid-header td[field]');
    		var uuid = generateUUID();
			var menu='<div id="menu'+uuid+'"  style="width:160px;"> ';
			$.each(fields, function (index, colunm) {
				var coloption=target.datagrid("getColumnOption",colunm);
				menu+='<div id="menu_'+colunm+'" data-options="iconCls:\'icon-ok\',field:\''+colunm+'\'">'+coloption.title+'</div>';
			});
			menu+="</div>";
			var p = $(menu).appendTo('body');
			$('#menu'+uuid).menu({
//				hideOnUnhover:false,
//				noline:false,
				onClick:function(item){
					if(item.iconCls=='icon-ok'){
						target.datagrid("hideColumn",item.field);
						$('#menu'+uuid).menu('setIcon',{
							target: item.target,
							iconCls: ''
						});
					}else{
						target.datagrid("showColumn",item.field);
						$('#menu'+uuid).menu('setIcon',{
							target: item.target,
							iconCls: 'icon-ok'
						});
					}
					$('#menu'+uuid).menu('hide');
					target.datagrid("resize");
				}
			}); 
			cells.tooltip({
				position: 'top',
				content: '<span style="color:#fff">表头右键展示或者隐藏列,拖动改变列位置</span>',
				onShow: function(){
					$(this).tooltip('tip').css({ 
						backgroundColor: '#666',
						borderColor: '#666' 
					});    
				}
			});
			target.datagrid('getPanel').find('div.datagrid-header').on('contextmenu',function (e) {   //设置鼠标左键方法
		        e.preventDefault();  //阻止默认行为，阻止掉浏览器系统菜单
		        $('#menu'+uuid).menu('show',{   //执行自定义鼠标左键菜单
		            left:e.pageX-3,  //菜单位置
		            top:e.pageY-3    //菜单位置
		        })
		    })
		});
    }
});


$.extend($.fn.datagrid.defaults.editors, {    
    monthbox: {    
        init: function(container, options){    
        	
        	var input = $('<input  class="easyui-monthbox"  >');
            if(options.required){
            	$(input).attr("data-options","required:true");
            }
//            console.log($(input));
            $(input).appendTo(container);  
            $.parser.parse(container);  
           // $.fn.monthbox.call(input, options);
            return input;    
        },    
        getValue: function(target){    
            return $(target).datebox('getValue');    
        },    
        setValue: function(target, value){    
            $(target).datebox('setValue',value);    
        },    
        resize: function(target, width){    
            var input = $(target);    
            if ($.boxModel == true){    
                input.datebox({width:width - (input.outerWidth() - input.width())});    
            } else {    
            	input.datebox({width:width});    
            }    
        }    
    }    
});  

$.extend($.fn.tabs.defaults,{tabHeight:28}); 
$.extend($.fn.textbox.defaults,{height:30});
$.extend($.fn.passwordbox.defaults,{height:30});
$.extend($.fn.combo.defaults,{height:30});
$.extend($.fn.combobox.defaults,{height:30});
$.extend($.fn.combogrid.defaults,{height:30});
$.extend($.fn.combotree.defaults,{height:30});
$.extend($.fn.combotreegrid.defaults,{height:30});
$.extend($.messager.defaults,{width:320}); 
$.extend($.fn.datebox.defaults,{
	height:30,
	panelWidth:220
});
$.extend($.fn.datetimebox.defaults,{
	height:30,
	panelWidth:220
});
$.extend($.fn.datetimespinner.defaults,{height:30});
$.extend($.fn.numberbox.defaults,{height:30});
$.extend($.fn.spinner.defaults,{height:30});
$.extend($.fn.searchbox.defaults,{height:30});
$.extend($.fn.filebox.defaults,{height:30});
$.extend($.fn.validatebox.defaults,{height:30});
$.extend($.fn.validatebox.defaults.tipOptions, {
	onShow: function() {
		$(this).tooltip("tip").css({
			color: "#fff",
			border: "none",
			backgroundColor: "#ff7e00"
		});
	}
}); 
