/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.service;

import com.google.common.base.Joiner;
import com.kdgcsoft.scrdc.workflow.dao.ActivityInstMapper;
import com.kdgcsoft.scrdc.workflow.dao.WfProcessinstMapper;
import com.kdgcsoft.scrdc.workflow.dao.WfWorkItemMapper;
import com.kdgcsoft.scrdc.workflow.entity.WfProcessinst;
import com.kdgcsoft.scrdc.workflow.service.bo.UserBO;
import com.kdgcsoft.scrdc.workflow.service.inf.IUserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class FlowUtilService {
    Logger logger = LoggerFactory.getLogger(FlowUtilService.class);
    @Autowired
    private ActivityInstMapper activityInstMapper;
    @Autowired(required=false)
    private IUserService userService;
    @Autowired
    private WfWorkItemMapper wfWorkItemMapper;
    @Autowired
    private WfProcessinstMapper wfProcessinstMapper;

    public Long getProcessdefidByProcessinstid(Long processinstid) {
        return ((WfProcessinst)this.wfProcessinstMapper.selectById(processinstid)).getProcessdefid();
    }

    public List<Map<String, Object>> getAppList(Long processinstid) {
        List<Map<String, Object>> appList = this.activityInstMapper.getAppList(processinstid);
        List<String> participants = appList.stream().filter(m -> Objects.nonNull(m.get("participant"))).map(m -> m.get("participant").toString()).collect(Collectors.toList());
        List<Object> userBOS = new ArrayList();
        if (this.userService != null) {
            userBOS = this.userService.listByIds(participants);
        }
        Map userMap = userBOS.stream().collect(Collectors.toMap(UserBO::getUserId, Function.identity(), (u1, u2) -> u2));
        appList.forEach(m -> {
            Object participant = m.get("participant");
            if (Objects.nonNull(participant) && userMap.containsKey(participant)) {
                UserBO user = (UserBO)userMap.get(participant);
                m.put("accountname", user.getUserName());
            }
        });
        Map<String, Object> appMap = appList.get(appList.size() - 1);
        if (Objects.isNull(appMap.get("participant"))) {
            List<String> participantIds;
            Long workitemid = null;
            if (appMap.get("workitemid") != null) {
                workitemid = Long.parseLong(appMap.get("workitemid").toString());
            }
            if (CollectionUtils.isNotEmpty(participantIds = this.activityInstMapper.getParticipantsByWorkitemId(workitemid))) {
                List<UserBO> userBOList = this.userService.listByIds(participantIds);
                List userNames = userBOList.stream().map(UserBO::getUserName).collect(Collectors.toList());
                appMap.put("accountname", Joiner.on((String)",").skipNulls().join(userNames));
            }
        }
        return appList;
    }
}

