/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.controller;

import cn.hutool.core.map.MapBuilder;
import com.kdgcsoft.scrdc.workflow.common.utils.CommTreeUtils;
import com.kdgcsoft.scrdc.workflow.helper.ComBoxTreeNode;
import com.kdgcsoft.scrdc.workflow.helper.PageObject;
import com.kdgcsoft.scrdc.workflow.service.bo.OrgBO;
import com.kdgcsoft.scrdc.workflow.service.inf.IOrgService;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="usiflowOrgController")
@RequestMapping(value={"/base-org"})
public class BaseOrgController {
    @Autowired(required=false)
    private IOrgService iOrgService;

    @RequestMapping(value={"/tree"})
    @ResponseBody
    public List<ComBoxTreeNode> getOrgTree() {
        List<OrgBO> orgList = this.iOrgService.getOrgList();
        List treeList = orgList.stream().map(so -> MapBuilder.create(new HashMap()).put((Object)"id", (Object)so.getOrgCode()).put((Object)"pid", (Object)so.getPorgCode()).put((Object)"text", (Object)so.getOrgName()).put((Object)"org_code", (Object)so.getOrgCode()).build()).collect(Collectors.toList());
        return CommTreeUtils.buildTreeNode(treeList);
    }

    @RequestMapping(value={"/all"})
    @ResponseBody
    public PageObject getAllOrg() {
        List<OrgBO> orgList = this.iOrgService.getOrgList();
        List treeList = orgList.stream().map(so -> MapBuilder.create(new HashMap()).put((Object)"id", (Object)so.getOrgCode()).put((Object)"pid", (Object)so.getPorgCode()).put((Object)"text", (Object)so.getOrgName()).put((Object)"_parentId", (Object)("0".equals(so.getPorgCode()) ? null : so.getPorgCode())).build()).collect(Collectors.toList());
        return new PageObject(treeList, Long.valueOf(treeList.size()));
    }
}

