/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.common.spring;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.support.PropertiesLoaderSupport;
import org.springframework.stereotype.Component;

@Component(value="SpringContextHolder")
public class SpringContextHolder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static Properties properties;

    public void setApplicationContext(ApplicationContext applicationContext) {
        SpringContextHolder.applicationContext = applicationContext;
        this.initProperties(applicationContext);
    }

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.checkApplicationContext();
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        SpringContextHolder.checkApplicationContext();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        SpringContextHolder.checkApplicationContext();
        return (T)applicationContext.getBeansOfType(clazz).get(clazz.getSimpleName());
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        return SpringContextHolder.getApplicationContext().getBeansOfType(clazz);
    }

    public static void cleanApplicationContext() {
        applicationContext = null;
    }

    private static void checkApplicationContext() {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u672a\u6ce8\u5165,\u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder");
        }
    }

    private void initProperties(ApplicationContext applicationContext) {
        try {
            Map configurerMap = applicationContext.getBeansOfType(PropertyResourceConfigurer.class);
            for (Map.Entry entry : configurerMap.entrySet()) {
                PropertyResourceConfigurer propertyResourceConfigurer = (PropertyResourceConfigurer)entry.getValue();
                Method mergeProperties = PropertiesLoaderSupport.class.getDeclaredMethod("mergeProperties", new Class[0]);
                mergeProperties.setAccessible(true);
                Properties props = (Properties)mergeProperties.invoke((Object)propertyResourceConfigurer, new Object[0]);
                Method convertProperties = PropertyResourceConfigurer.class.getDeclaredMethod("convertProperties", Properties.class);
                convertProperties.setAccessible(true);
                convertProperties.invoke((Object)propertyResourceConfigurer, props);
                properties.putAll((Map<?, ?>)props);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static List<Map<String, String>> getPropertyList(String key, String keyName) {
        ArrayList<Map<String, String>> propertyList = new ArrayList<Map<String, String>>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String checkKey;
            if (entry.getKey() == null || (checkKey = (String)entry.getKey()).indexOf(key) < 0) continue;
            HashMap<String, String> property = new HashMap<String, String>();
            property.put(keyName, entry.getValue().toString());
            property.put("key", checkKey);
            propertyList.add(property);
        }
        return propertyList;
    }

    public static Map<String, String> getPropertyMap(String key) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String checkKey;
            if (entry.getKey() == null || (checkKey = (String)entry.getKey()).indexOf(key) < 0) continue;
            propertyMap.put(checkKey, entry.getValue().toString());
        }
        return propertyMap;
    }

    public static String getPropertyKeyByValue(String value) {
        String key = "";
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String checkValue;
            if (entry.getKey() == null || entry.getValue() == null || (checkValue = (String)entry.getValue()).indexOf(value) < 0) continue;
            key = entry.getKey().toString();
            break;
        }
        return key;
    }

    static {
        properties = new Properties();
    }
}

