
-- ----------------------------
-- Table structure for STF_BUSINESS_PROCESS
-- ----------------------------
--DROP TABLE "STF_BUSINESS_PROCESS";
CREATE TABLE "STF_BUSINESS_PROCESS" (
  "RES_ID" NUMBER(19) NOT NULL ,
  "BUSINESS_TYPE_ID" NUMBER(19) ,
  "DESIGN_NAME" VARCHAR2(100 BYTE) ,
  "MEMO" VARCHAR2(100 BYTE) ,
  "RES_CREATE_DATE" DATE ,
  "RES_CREATOR" VARCHAR2(100 BYTE) ,
  "RES_EDIT_DATE" DATE ,
  "RES_EDITOR" VARCHAR2(100 BYTE) ,
  "FLOW_NAME" VARCHAR2(100 BYTE) ,
  "FLOW_CODE" VARCHAR2(100 BYTE) ,
  "TYPE" VARCHAR2(100 BYTE)
);

-- ----------------------------
-- Table structure for STF_BUSINESS_TYPE
-- ----------------------------
--DROP TABLE "STF_BUSINESS_TYPE";
CREATE TABLE "STF_BUSINESS_TYPE" (
  "RES_ID" NUMBER(19) NOT NULL ,
  "CODE" VARCHAR2(100 BYTE) ,
  "LEAF_NAME" VARCHAR2(100 BYTE) ,
  "LEVELS" VARCHAR2(100 BYTE) ,
  "NAME" VARCHAR2(255 BYTE) ,
  "ORDER_INDEX" NUMBER(10) ,
  "PARENT_ID" NUMBER(10) ,
  "REMARK" VARCHAR2(255 BYTE) ,
  "RES_CREATE_DATE" DATE ,
  "RES_CREATOR" VARCHAR2(100 BYTE) ,
  "RES_EDIT_DATE" DATE ,
  "RES_EDITOR" VARCHAR2(100 BYTE)
);

-- ----------------------------
-- Table structure for WF_ACTIVITYINST
-- ----------------------------
--DROP TABLE "WF_ACTIVITYINST";
CREATE TABLE "WF_ACTIVITYINST" (
  "ACTIVITYINSTID" NUMBER(10) NOT NULL ,
  "ACTIVITYDEFID" VARCHAR2(255 BYTE) ,
  "ACTIVITYINSTNAME" VARCHAR2(255 BYTE) ,
  "ACTIVITYTYPE" VARCHAR2(255 BYTE) ,
  "CREATETIME" DATE ,
  "CURRENTSTATE" NUMBER(10) ,
  "DESCRIPTION" VARCHAR2(255 BYTE) ,
  "ACTCLASS" VARCHAR2(255 BYTE) ,
  "ENDTIME" DATE ,
  "FINALTIME" DATE ,
  "LIMITTIME" NUMBER(10) ,
  "PROCESSINSTID" NUMBER(10) ,
  "STARTTIME" DATE
);

-- ----------------------------
-- Table structure for WF_PARTICIPANT
-- ----------------------------
--DROP TABLE "WF_PARTICIPANT";
CREATE TABLE "WF_PARTICIPANT" (
  "PARTICID" NUMBER ,
  "WORKITEMID" NUMBER ,
  "PARTICTYPE" VARCHAR2(4000 BYTE) ,
  "PARTICIPANT" VARCHAR2(4000 BYTE) ,
  "PARTICIPANT2" VARCHAR2(4000 BYTE) ,
  "PROCESSINSTID" NUMBER
);

-- ----------------------------
-- Table structure for WF_PROCESSDEFINE
-- ----------------------------
--DROP TABLE "WF_PROCESSDEFINE";
CREATE TABLE "WF_PROCESSDEFINE" (
  "PROCESSDEFID" NUMBER(19) NOT NULL ,
  "CREATETIME" DATE ,
  "CREATOR" VARCHAR2(255 BYTE) ,
  "CURRENTSTATE" NUMBER(10) ,
  "DESCRIPTION" VARCHAR2(255 BYTE) ,
  "LIMITTIME" NUMBER(10) ,
  "PROCESSCHNAME" VARCHAR2(255 BYTE) ,
  "PROCESSDEFCONTENT" CLOB ,
  "PROCESSDEFNAME" VARCHAR2(255 BYTE) ,
  "PROCESSDEFCODE" VARCHAR2(255 BYTE) ,
  "UPDATETIME" DATE ,
  "UPDATOR" VARCHAR2(255 BYTE) ,
  "VERSIONSIGN" VARCHAR2(255 BYTE)
);

-- ----------------------------
-- Table structure for WF_PROCESSDEFINE_PROCESSINST
-- ----------------------------
--DROP TABLE "WF_PROCESSDEFINE_PROCESSINST";
CREATE TABLE "WF_PROCESSDEFINE_PROCESSINST" (
  "PROCESSINSTID" NUMBER(10) NOT NULL ,
  "PROCESSDEFID" NUMBER(19) ,
  "PROCESSDEFNAME" VARCHAR2(255 BYTE) ,
  "PROCESSCHNAME" VARCHAR2(255 BYTE) ,
  "DESCRIPTION" VARCHAR2(255 BYTE) ,
  "CURRENTSTATE" NUMBER(10) ,
  "VERSIONSIGN" VARCHAR2(255 BYTE) ,
  "LIMITTIME" NUMBER(10) ,
  "PROCESSDEFCONTENT" CLOB ,
  "CREATETIME" DATE ,
  "CREATOR" VARCHAR2(255 BYTE) ,
  "UPDATETIME" DATE ,
  "UPDATOR" VARCHAR2(255 BYTE)
);

-- ----------------------------
-- Table structure for WF_PROCESSINST
-- ----------------------------
--DROP TABLE "WF_PROCESSINST";
CREATE TABLE "WF_PROCESSINST" (
  "PROCESSINSTID" NUMBER(10) NOT NULL ,
  "ACTIVITYINSTID" NUMBER(10) ,
  "CREATETIME" DATE ,
  "CREATOR" VARCHAR2(255 BYTE) ,
  "CURRENTSTATE" NUMBER(10) ,
  "ENDTIME" DATE ,
  "FINALTIME" DATE ,
  "LIMITNUM" NUMBER(10) ,
  "MAINPROCINSTID" NUMBER(10) ,
  "PARENTPROCINSTID" NUMBER(10) ,
  "PROCESSDEFID" NUMBER(19) ,
  "PROCESSINSTNAME" VARCHAR2(255 BYTE) ,
  "STARTTIME" DATE ,
  "SUBFLOW" VARCHAR2(255 BYTE)
);

-- ----------------------------
-- Table structure for WF_RELEVANT_DATA
-- ----------------------------
--DROP TABLE "WF_RELEVANT_DATA";
CREATE TABLE "WF_RELEVANT_DATA" (
  "PROCESSINSTID" NUMBER ,
  "ACTIVITYDEFID" VARCHAR2(4000 BYTE) ,
  "NAME" VARCHAR2(4000 BYTE) ,
  "VALUE" BLOB ,
  "CREATETIME" DATE ,
  "UPDATETIME" DATE
);

-- ----------------------------
-- Table structure for WF_TRANSCTRL
-- ----------------------------
--DROP TABLE "WF_TRANSCTRL";
CREATE TABLE "WF_TRANSCTRL" (
  "TRANSCTRLID" NUMBER ,
  "SRCACTDEFID" VARCHAR2(4000 BYTE) ,
  "SRCACTDEFNAME" VARCHAR2(4000 BYTE) ,
  "DESTACTTYPE" VARCHAR2(4000 BYTE) ,
  "DESTACTDEFID" VARCHAR2(4000 BYTE) ,
  "DESTACTDEFNAME" VARCHAR2(4000 BYTE) ,
  "SRCACTTYPE" VARCHAR2(4000 BYTE) ,
  "TRANSTIME" DATE ,
  "PROCESSINSTID" NUMBER ,
  "ISUSE" VARCHAR2(4000 BYTE) ,
  "ISSTARTDESTACT" VARCHAR2(4000 BYTE)
);

-- ----------------------------
-- Table structure for WF_WORKITEM
-- ----------------------------
--DROP TABLE "WF_WORKITEM";
CREATE TABLE "WF_WORKITEM" (
  "WORKITEMID" NUMBER(10) NOT NULL ,
  "ACTIVITYDEFID" VARCHAR2(255 BYTE) ,
  "BIZSTATE" VARCHAR2(255 BYTE) ,
  "CURRENTSTATE" NUMBER(10) ,
  "ENDTIME" DATE ,
  "FINALTIME" DATE ,
  "LIMITTIME" NUMBER(10) ,
  "PARTICIPANT" VARCHAR2(255 BYTE) ,
  "PROCESSINSTID" NUMBER(10) ,
  "STARTTIME" DATE ,
  "WORKITEMNAME" VARCHAR2(255 BYTE) ,
  "WORKITEMTYPE" VARCHAR2(255 BYTE) ,
  "WORKMEMORY" VARCHAR2(255 BYTE) ,
  "ACTIVITYINSTID" NUMBER(10) ,
  "PROCESSDEFNAME" VARCHAR2(255 BYTE) ,
  "WORKMEMORY_PIC" CLOB
);

-- ----------------------------
-- Primary Key structure for table STF_BUSINESS_PROCESS
-- ----------------------------
ALTER TABLE "STF_BUSINESS_PROCESS" ADD CONSTRAINT "SYS_C0033238" PRIMARY KEY ("RES_ID");

-- ----------------------------
-- Checks structure for table STF_BUSINESS_PROCESS
-- ----------------------------
ALTER TABLE "STF_BUSINESS_PROCESS" ADD CONSTRAINT "SYS_C0033237" CHECK ("RES_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table STF_BUSINESS_TYPE
-- ----------------------------
ALTER TABLE "STF_BUSINESS_TYPE" ADD CONSTRAINT "SYS_C0033240" PRIMARY KEY ("RES_ID");

-- ----------------------------
-- Checks structure for table STF_BUSINESS_TYPE
-- ----------------------------
ALTER TABLE "STF_BUSINESS_TYPE" ADD CONSTRAINT "SYS_C0033239" CHECK ("RES_ID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table WF_ACTIVITYINST
-- ----------------------------
ALTER TABLE "WF_ACTIVITYINST" ADD CONSTRAINT "SYS_C0033243" PRIMARY KEY ("ACTIVITYINSTID");

-- ----------------------------
-- Checks structure for table WF_ACTIVITYINST
-- ----------------------------
ALTER TABLE "WF_ACTIVITYINST" ADD CONSTRAINT "SYS_C0033242" CHECK ("ACTIVITYINSTID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table WF_PROCESSDEFINE
-- ----------------------------
ALTER TABLE "WF_PROCESSDEFINE" ADD CONSTRAINT "SYS_C0033247" PRIMARY KEY ("PROCESSDEFID");

-- ----------------------------
-- Checks structure for table WF_PROCESSDEFINE
-- ----------------------------
ALTER TABLE "WF_PROCESSDEFINE" ADD CONSTRAINT "SYS_C0033246" CHECK ("PROCESSDEFID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table WF_PROCESSDEFINE_PROCESSINST
-- ----------------------------
ALTER TABLE "WF_PROCESSDEFINE_PROCESSINST" ADD CONSTRAINT "PROCESSINST_PRIMARY" PRIMARY KEY ("PROCESSINSTID");

-- ----------------------------
-- Primary Key structure for table WF_PROCESSINST
-- ----------------------------
ALTER TABLE "WF_PROCESSINST" ADD CONSTRAINT "SYS_C0033250" PRIMARY KEY ("PROCESSINSTID");

-- ----------------------------
-- Checks structure for table WF_PROCESSINST
-- ----------------------------
ALTER TABLE "WF_PROCESSINST" ADD CONSTRAINT "SYS_C0033249" CHECK ("PROCESSINSTID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Primary Key structure for table WF_WORKITEM
-- ----------------------------
ALTER TABLE "WF_WORKITEM" ADD CONSTRAINT "SYS_C0033252" PRIMARY KEY ("WORKITEMID");

-- ----------------------------
-- Checks structure for table WF_WORKITEM
-- ----------------------------
ALTER TABLE "WF_WORKITEM" ADD CONSTRAINT "SYS_C0033251" CHECK ("WORKITEMID" IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

CREATE SEQUENCE  "SEQ_ACTIVITYINSTID"  MINVALUE 0 MAXVALUE 9999999999 INCREMENT BY 1 START WITH 1005200 CACHE 20 NOORDER  NOCYCLE;

CREATE SEQUENCE  "SEQ_BUSINESSUSIFLOW"  MINVALUE 1 MAXVALUE 9999999999 INCREMENT BY 1 START WITH 1000540 CACHE 20 NOORDER  NOCYCLE;

CREATE SEQUENCE  "SEQ_PARTICIPANTID"  MINVALUE 1 MAXVALUE 9999999999 INCREMENT BY 1 START WITH 1003520 CACHE 20 NOORDER  NOCYCLE;

CREATE SEQUENCE  "SEQ_PROCESSINSTID"  MINVALUE 0 MAXVALUE 9999999999 INCREMENT BY 1 START WITH 1001780 CACHE 20 NOORDER  NOCYCLE;

CREATE SEQUENCE  "SEQ_TRANSCTRLID"  MINVALUE 1 MAXVALUE 9999999999 INCREMENT BY 1 START WITH 1003740 CACHE 20 NOORDER  NOCYCLE;

CREATE SEQUENCE  "SEQ_WORKITEMID"  MINVALUE 1 MAXVALUE 9999999999 INCREMENT BY 1 START WITH 1003340 CACHE 20 NOORDER  NOCYCLE;
