SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for stf_business_process
-- ----------------------------
DROP TABLE IF EXISTS `stf_business_process`;
CREATE TABLE `stf_business_process`  (
  `RES_ID` bigint(20) NOT NULL,
  `BUSINESS_TYPE_ID` bigint(20) NULL DEFAULT NULL,
  `DESIGN_NAME` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `MEMO` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `RES_CREATE_DATE` datetime(0) NULL DEFAULT NULL,
  `RES_CREATOR` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `RES_EDIT_DATE` datetime(0) NULL DEFAULT NULL,
  `RES_EDITOR` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `FLOW_NAME` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `FLOW_CODE` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `TYPE` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`RES_ID`) USING BTREE
) ;

-- ----------------------------
-- Table structure for stf_business_type
-- ----------------------------
DROP TABLE IF EXISTS `stf_business_type`;
CREATE TABLE `stf_business_type`  (
  `RES_ID` bigint(20) NOT NULL,
  `CODE` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `LEAF_NAME` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `LEVELS` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `NAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `ORDER_INDEX` bigint(20) NULL DEFAULT NULL,
  `PARENT_ID` bigint(20) NULL DEFAULT NULL,
  `REMARK` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `RES_CREATE_DATE` datetime(0) NULL DEFAULT NULL,
  `RES_CREATOR` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `RES_EDIT_DATE` datetime(0) NULL DEFAULT NULL,
  `RES_EDITOR` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`RES_ID`) USING BTREE
) ;

-- ----------------------------
-- Table structure for wf_activityinst
-- ----------------------------
DROP TABLE IF EXISTS `wf_activityinst`;
CREATE TABLE `wf_activityinst`  (
  `ACTIVITYINSTID` bigint(20) NOT NULL,
  `ACTIVITYDEFID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `ACTIVITYINSTNAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `ACTIVITYTYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `CREATETIME` datetime(0) NULL DEFAULT NULL,
  `CURRENTSTATE` bigint(20) NULL DEFAULT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `ENDTIME` datetime(0) NULL DEFAULT NULL,
  `FINALTIME` datetime(0) NULL DEFAULT NULL,
  `LIMITTIME` bigint(20) NULL DEFAULT NULL,
  `PROCESSINSTID` bigint(20) NULL DEFAULT NULL,
  `STARTTIME` datetime(0) NULL DEFAULT NULL,
  `ACTCLASS` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ACTIVITYINSTID`) USING BTREE
) ;

-- ----------------------------
-- Table structure for wf_participant
-- ----------------------------
DROP TABLE IF EXISTS `wf_participant`;
CREATE TABLE `wf_participant`  (
  `PARTICID` bigint(65) NOT NULL,
  `WORKITEMID` bigint(65) NULL DEFAULT NULL,
  `PARTICTYPE` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `PARTICIPANT` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `PARTICIPANT2` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `PROCESSINSTID` bigint(65) NULL DEFAULT NULL,
  PRIMARY KEY (`PARTICID`) USING BTREE
) ;

-- ----------------------------
-- Table structure for wf_primarykey
-- ----------------------------
DROP TABLE IF EXISTS `wf_primarykey`;
CREATE TABLE `wf_primarykey`  (
  `CODE` bigint(20) NOT NULL,
  `NAME` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`CODE`, `NAME`) USING BTREE
) ;

-- ----------------------------
-- Table structure for wf_processdefine
-- ----------------------------
DROP TABLE IF EXISTS `wf_processdefine`;
CREATE TABLE `wf_processdefine`  (
  `PROCESSDEFID` bigint(20) NOT NULL,
  `CREATETIME` datetime(0) NULL DEFAULT NULL,
  `CREATOR` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `CURRENTSTATE` bigint(20) NULL DEFAULT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `LIMITTIME` bigint(20) NULL DEFAULT NULL,
  `PROCESSCHNAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `PROCESSDEFCONTENT` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `PROCESSDEFNAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `PROCESSDEFCODE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `UPDATETIME` datetime(0) NULL DEFAULT NULL,
  `UPDATOR` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `VERSIONSIGN` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`PROCESSDEFID`) USING BTREE
) ;

-- ----------------------------
-- Table structure for wf_processdefine_processinst
-- ----------------------------
DROP TABLE IF EXISTS `wf_processdefine_processinst`;
CREATE TABLE `wf_processdefine_processinst`  (
  `PROCESSINSTID` bigint(20) NOT NULL,
  `PROCESSDEFID` bigint(20) NULL DEFAULT NULL,
  `PROCESSDEFNAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `PROCESSCHNAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `DESCRIPTION` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `CURRENTSTATE` bigint(20) NULL DEFAULT NULL,
  `VERSIONSIGN` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `LIMITTIME` bigint(20) NULL DEFAULT NULL,
  `PROCESSDEFCONTENT` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `CREATETIME` datetime(0) NULL DEFAULT NULL,
  `CREATOR` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `UPDATETIME` datetime(0) NULL DEFAULT NULL,
  `UPDATOR` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`PROCESSINSTID`) USING BTREE
) ;

-- ----------------------------
-- Table structure for wf_processinst
-- ----------------------------
DROP TABLE IF EXISTS `wf_processinst`;
CREATE TABLE `wf_processinst`  (
  `PROCESSINSTID` bigint(20) NOT NULL,
  `ACTIVITYINSTID` bigint(20) NULL DEFAULT NULL,
  `CREATETIME` datetime(0) NULL DEFAULT NULL,
  `CREATOR` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `CURRENTSTATE` bigint(20) NULL DEFAULT NULL,
  `ENDTIME` datetime(0) NULL DEFAULT NULL,
  `FINALTIME` datetime(0) NULL DEFAULT NULL,
  `LIMITNUM` bigint(20) NULL DEFAULT NULL,
  `MAINPROCINSTID` bigint(20) NULL DEFAULT NULL,
  `PARENTPROCINSTID` bigint(20) NULL DEFAULT NULL,
  `PROCESSDEFID` bigint(20) NULL DEFAULT NULL,
  `PROCESSINSTNAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `STARTTIME` datetime(0) NULL DEFAULT NULL,
  `SUBFLOW` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`PROCESSINSTID`) USING BTREE
) ;

-- ----------------------------
-- Table structure for wf_relevant_data
-- ----------------------------
DROP TABLE IF EXISTS `wf_relevant_data`;
CREATE TABLE `wf_relevant_data`  (
  `PROCESSINSTID` bigint(20) NOT NULL,
  `ACTIVITYDEFID` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `NAME` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `VALUE` longblob NULL,
  `CREATETIME` datetime(0) NULL DEFAULT NULL,
  `UPDATETIME` datetime(0) NULL DEFAULT NULL,
  PRIMARY KEY (`PROCESSINSTID`, `ACTIVITYDEFID`, `NAME`) USING BTREE
) ;

-- ----------------------------
-- Table structure for wf_transctrl
-- ----------------------------
DROP TABLE IF EXISTS `wf_transctrl`;
CREATE TABLE `wf_transctrl`  (
  `TRANSCTRLID` bigint(20) NOT NULL,
  `SRCACTDEFID` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `SRCACTDEFNAME` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `DESTACTTYPE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `DESTACTDEFID` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `DESTACTDEFNAME` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `SRCACTTYPE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `TRANSTIME` datetime(0) NULL DEFAULT NULL,
  `PROCESSINSTID` bigint(20) NULL DEFAULT NULL,
  `ISUSE` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `ISSTARTDESTACT` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  PRIMARY KEY (`TRANSCTRLID`) USING BTREE
) ;

-- ----------------------------
-- Table structure for wf_workitem
-- ----------------------------
DROP TABLE IF EXISTS `wf_workitem`;
CREATE TABLE `wf_workitem`  (
  `WORKITEMID` bigint(20) NOT NULL,
  `ACTIVITYDEFID` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `BIZSTATE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `CURRENTSTATE` bigint(20) NULL DEFAULT NULL,
  `ENDTIME` datetime(0) NULL DEFAULT NULL,
  `FINALTIME` datetime(0) NULL DEFAULT NULL,
  `LIMITTIME` bigint(20) NULL DEFAULT NULL,
  `PARTICIPANT` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `PROCESSINSTID` bigint(20) NULL DEFAULT NULL,
  `STARTTIME` datetime(0) NULL DEFAULT NULL,
  `WORKITEMNAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `WORKITEMTYPE` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `WORKMEMORY` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `ACTIVITYINSTID` bigint(20) NULL DEFAULT NULL,
  `PROCESSDEFNAME` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `WORKMEMORY_PIC` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  PRIMARY KEY (`WORKITEMID`) USING BTREE
) ;

SET FOREIGN_KEY_CHECKS = 1;
