/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.service;

import cn.hutool.core.collection.CollUtil;
import com.google.common.base.Joiner;
import com.kdgcsoft.scrdc.workflow.dao.ActivityInstMapper;
import com.kdgcsoft.scrdc.workflow.dao.WfProcessinstMapper;
import com.kdgcsoft.scrdc.workflow.dao.WfWorkItemMapper;
import com.kdgcsoft.scrdc.workflow.entity.WfProcessinst;
import com.kdgcsoft.scrdc.workflow.entity.WfTransctrl;
import com.kdgcsoft.scrdc.workflow.service.WfActivityinstService;
import com.kdgcsoft.scrdc.workflow.service.WfTransctrlService;
import com.kdgcsoft.scrdc.workflow.service.bo.UserBO;
import com.kdgcsoft.scrdc.workflow.service.inf.IUserService;
import com.ustcsoft.usiflow.engine.model.ActivityInst;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class FlowUtilService {
    Logger logger = LoggerFactory.getLogger(FlowUtilService.class);
    @Autowired
    private ActivityInstMapper activityInstMapper;
    @Autowired(required=false)
    private IUserService<Serializable> userService;
    @Autowired
    private WfWorkItemMapper wfWorkItemMapper;
    @Autowired
    private WfProcessinstMapper wfProcessinstMapper;
    @Autowired
    private WfTransctrlService transctrlService;
    @Autowired
    private WfActivityinstService activityinstService;

    public Long getProcessdefidByProcessinstid(Long processinstid) {
        return ((WfProcessinst)this.wfProcessinstMapper.selectById(processinstid)).getProcessdefid();
    }

    public List<Map<String, Object>> getAppList(Long processinstid) {
        List<Map<String, Object>> appList = this.activityInstMapper.getAppList(processinstid);
        List participants = appList.stream().filter(m -> Objects.nonNull(m.get("participant"))).map(m -> (Serializable)m.get("participant")).collect(Collectors.toList());
        List<Object> userBOS = new ArrayList();
        if (this.userService != null) {
            userBOS = this.userService.listByIds(participants);
        }
        Map userMap = userBOS.stream().collect(Collectors.toMap(UserBO::getUserId, Function.identity(), (u1, u2) -> u2));
        appList.forEach(m -> {
            Serializable participant = (Serializable)m.get("participant");
            if (Objects.nonNull(participant) && userMap.containsKey(participant)) {
                UserBO user = (UserBO)userMap.get(participant);
                m.put("accountname", user.getUserName());
            }
        });
        Map<String, Object> appMap = appList.get(appList.size() - 1);
        if (Objects.isNull(appMap.get("participant"))) {
            List<Serializable> participantIds;
            Long workitemid = null;
            if (appMap.get("workitemid") != null) {
                workitemid = Long.parseLong(appMap.get("workitemid").toString());
            }
            if (CollectionUtils.isNotEmpty(participantIds = this.activityInstMapper.getParticipantsByWorkitemId(workitemid))) {
                List<UserBO> userBOList = this.userService.listByIds(participantIds);
                List userNames = userBOList.stream().map(UserBO::getUserName).collect(Collectors.toList());
                appMap.put("accountname", Joiner.on((String)",").skipNulls().join(userNames));
            }
        }
        return appList;
    }

    public List<String> getRollbackActivitsDefId(Long id) {
        List<WfTransctrl> transCtrls = this.transctrlService.findTransCtrls(id);
        List<ActivityInst> terminateAct = this.activityinstService.findActivityInstByCurrentState(7, id);
        List<ActivityInst> runningAct = this.activityinstService.findActivityInstByCurrentState(10, id);
        if (CollUtil.isEmpty(transCtrls) || CollUtil.isEmpty(terminateAct) || CollUtil.isEmpty(runningAct)) {
            return null;
        }
        List desActDefId = transCtrls.stream().map(x -> x.getDestactdefId()).collect(Collectors.toList());
        int runningActIndex = desActDefId.lastIndexOf(runningAct.get(0).getActivityDefId());
        ArrayList<Integer> terminateActIndexs = new ArrayList<Integer>();
        for (ActivityInst inst : terminateAct) {
            terminateActIndexs.add(desActDefId.lastIndexOf(inst.getActivityDefId()));
        }
        Optional<Integer> optionalInteger = terminateActIndexs.stream().max(Comparator.comparingInt(x -> x));
        Integer max = optionalInteger.get();
        this.logger.info("\u6d41\u7a0b\uff1a{},\u56de\u6eda\u8fc7\u7a0b\u4e2d\u7ecf\u5386\u7684\u73af\u8282{}", (Object)id, desActDefId.subList(runningActIndex, max + 1));
        return desActDefId.subList(runningActIndex, max + 1);
    }
}

