/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.helper;

import cn.hutool.core.collection.CollUtil;
import com.kdgcsoft.scrdc.workflow.dao.StfBusinessTypeMapper;
import com.kdgcsoft.scrdc.workflow.entity.StfBusinessType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class StfBusinessTypeHelper {
    @Autowired
    private StfBusinessTypeMapper stfBusinessTypeDao;

    private List<StfBusinessType> getAllSons(List<StfBusinessType> all, List<StfBusinessType> fathers, Map<Long, List<StfBusinessType>> stfBusinessTypeMap) {
        if (CollUtil.isNotEmpty(fathers)) {
            List<StfBusinessType> sons = fathers.stream().map(t -> stfBusinessTypeMap.getOrDefault(t.getResId(), Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.toList());
            all.addAll(sons);
            return this.getAllSons(all, sons, stfBusinessTypeMap);
        }
        return all;
    }

    public List<StfBusinessType> getAllSons(Long pid) {
        List all = this.stfBusinessTypeDao.selectList(null);
        Map<Long, List<StfBusinessType>> stfBusinessTypeMap = all.stream().collect(Collectors.groupingBy(StfBusinessType::getParentId));
        List<StfBusinessType> firstLevelChildren = Optional.ofNullable(stfBusinessTypeMap.get(pid)).orElse(Collections.emptyList());
        ArrayList<StfBusinessType> sons = new ArrayList<StfBusinessType>(firstLevelChildren);
        return this.getAllSons(sons, firstLevelChildren, stfBusinessTypeMap);
    }
}

