/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.controller;

import cn.hutool.core.collection.CollUtil;
import com.kdgcsoft.scrdc.workflow.entity.WfTransctrl;
import com.kdgcsoft.scrdc.workflow.helper.PageObject;
import com.kdgcsoft.scrdc.workflow.service.FlowUtilService;
import com.kdgcsoft.scrdc.workflow.service.StfBusinessProcessService;
import com.kdgcsoft.scrdc.workflow.service.WfActivityinstService;
import com.kdgcsoft.scrdc.workflow.service.WfTransctrlService;
import com.ustcsoft.usiflow.engine.model.ActivityInst;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/viewwf"})
public class ViewFlowController {
    @Autowired
    private StfBusinessProcessService sbpservice;
    @Autowired
    private FlowUtilService flowUtilservice;
    @Autowired
    private WfTransctrlService transctrlService;
    @Autowired
    private WfActivityinstService activityinstService;

    @RequestMapping(value={"/queryTransctrls"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryTransctrls(HttpServletRequest requestServlet, Long id) throws IOException {
        if (id != null) {
            StringBuilder sb = new StringBuilder();
            List<WfTransctrl> transCtrls = this.transctrlService.findTransCtrls(id);
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<activities>\n<transctrls>\n");
            for (WfTransctrl tc : transCtrls) {
                sb.append("<transctrl srcId=\"" + tc.getSrcactdefId() + "\" destId=\"" + tc.getDestactdefId() + "\" />\n");
            }
            sb.append("</transctrls>\n<noFinishActs>\n");
            List<ActivityInst> activityInsts = this.activityinstService.findWaitingAndTerminateAndRunningActivityInst(id);
            for (ActivityInst activityInst : activityInsts) {
                sb.append("<activity id=\"" + activityInst.getActivityDefId() + "\" status=\"" + activityInst.getCurrentState() + "\" />\n");
            }
            sb.append("</noFinishActs></activities>");
            return sb.toString();
        }
        return "";
    }

    @RequestMapping(value={"/queryFlowContent"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryFlowContent(HttpServletRequest requestServlet, Long id, Long processInstId, HttpServletResponse reponse) throws IOException, SQLException {
        reponse.setContentType("text/xml;charset=UTF-8");
        return this.sbpservice.queryFlowContent(id, processInstId);
    }

    @RequestMapping(value={"/viewFlow"}, method={RequestMethod.GET})
    public Object viewFlow(HttpServletRequest requestServlet, Long processInstId) {
        requestServlet.setAttribute("processInstId", (Object)processInstId);
        requestServlet.setAttribute("processDefId", (Object)this.flowUtilservice.getProcessdefidByProcessinstid(processInstId));
        List<ActivityInst> currentInsts = this.activityinstService.findActivityInstByCurrentState(10, processInstId);
        requestServlet.setAttribute("currentActiveActDefId", (Object)(CollUtil.isNotEmpty(currentInsts) ? currentInsts.get(0).getActivityDefId() : ""));
        return "/workflow/jsflowview";
    }

    @RequestMapping(value={"/getAppList"})
    @ResponseBody
    public Object getAppList(Long processinstid, Integer start, Integer limit) {
        List<Map<String, Object>> appList = this.flowUtilservice.getAppList(processinstid);
        List<String> rollbackActDefIf = this.flowUtilservice.getRollbackActivitsDefId(processinstid);
        List<ActivityInst> currentInsts = this.activityinstService.findActivityInstByCurrentState(10, processinstid);
        if (CollUtil.isNotEmpty(rollbackActDefIf)) {
            Iterator<Map<String, Object>> iterator = appList.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> next = iterator.next();
                if (!rollbackActDefIf.contains(next.get("activitydefid")) || next.get("activitydefid").equals(currentInsts.get(0).getActivityDefId())) continue;
                iterator.remove();
            }
        }
        if (start == null || limit == null) {
            return appList;
        }
        int to = start + limit;
        if (to > appList.size()) {
            to = appList.size();
        }
        return new PageObject<Map<String, Object>>(appList.subList(start, to), Long.valueOf(appList.size()));
    }

    @RequestMapping(value={"/workItemInfo"})
    public ModelAndView openWorkItemInfo(Long processInstId) {
        ModelAndView mv = new ModelAndView();
        mv.addObject("processInstId", (Object)processInstId);
        mv.setViewName("workflow/flowWorkItemInfo");
        return mv;
    }

    @RequestMapping(value={"/getRollbackActivits"})
    @ResponseBody
    public List<String> getRollbackActivits(Long id) {
        return this.flowUtilservice.getRollbackActivitsDefId(id);
    }
}

