/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.controller;

import cn.hutool.core.bean.BeanUtil;
import com.kdgcsoft.scrdc.workflow.entity.StfBusinessProcess;
import com.kdgcsoft.scrdc.workflow.helper.ComBoxTreeNode;
import com.kdgcsoft.scrdc.workflow.helper.JsonMsg;
import com.kdgcsoft.scrdc.workflow.service.FlowUtilService;
import com.kdgcsoft.scrdc.workflow.service.StfBusinessProcessService;
import com.kdgcsoft.scrdc.workflow.service.StfBusinessTypeService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/StfBusinessProcess"})
public class StfBusinessProcessController {
    @Autowired
    private StfBusinessProcessService stfBusinessProcessService;
    @Autowired
    private StfBusinessTypeService stfbusinesstypeService;
    @Autowired
    private FlowUtilService flowUtilService;

    @RequestMapping(value={"/index"})
    public ModelAndView index(ModelAndView model) {
        model.setViewName("workflow/StfBusinessProcess");
        return model;
    }

    @RequestMapping(value={"/get-form"})
    public ModelAndView getForm(ModelAndView model) {
        model.setViewName("workflow/StfBusinessProcessform");
        return model;
    }

    @RequestMapping(value={"/detail"})
    public ModelAndView openDetailPage(@RequestParam(value="resId") Long resId) {
        ModelAndView mv = new ModelAndView();
        StfBusinessProcess sbp = this.stfBusinessProcessService.findWithType(resId);
        mv.addObject("sbp", (Object)sbp);
        mv.setViewName("workflow/StfBusinessProcessDefine");
        return mv;
    }

    @RequestMapping(value={"/findStfBusinessProcess"})
    @ResponseBody
    public Map<String, Object> findStfBusinessProcess(Long id) {
        StfBusinessProcess sbp = this.stfBusinessProcessService.findWithType(id);
        return BeanUtil.beanToMap((Object)((Object)sbp));
    }

    @RequestMapping(value={"/queryFlowContent"})
    @ResponseBody
    public Object queryFlowContent(HttpServletRequest requestServlet, Long id, Long processinstid, String actid, HttpServletResponse reponse) throws IOException, SQLException {
        reponse.setContentType("text/xml;charset=UTF-8");
        return this.stfBusinessProcessService.queryFlowContent(id, processinstid);
    }

    @RequestMapping(value={"/saveStfBusinessProcess"})
    @ResponseBody
    public Object saveStfBusinessProcess(StfBusinessProcess entity, @RequestParam(value="businessTypeId", defaultValue="") Long businessTypeId, Long id) {
        JsonMsg msg = new JsonMsg();
        String type = entity.getType();
        if (null != type && !"".equals(type)) {
            switch (type) {
                case "4": {
                    type = "flow";
                    break;
                }
                case "1": {
                    type = "subflow";
                    break;
                }
                case "2": {
                    type = "feiflow";
                }
            }
            entity.setType(type);
        }
        if (entity.getId() == null && id == null) {
            StfBusinessProcess newentity = new StfBusinessProcess();
            entity.setFlowCode(entity.getFlowCode().toUpperCase());
            StfBusinessProcess process = this.stfBusinessProcessService.getByFlowCode(entity.getFlowCode());
            if (process != null) {
                msg.setMsg("\u7f16\u7801\u91cd\u590d\uff01");
                msg.setSuccess(false);
                return msg;
            }
            this.stfBusinessProcessService.save(entity);
            newentity = this.stfBusinessProcessService.find(entity.getId());
            newentity.setDesignName(newentity.getType() + "." + String.valueOf(newentity.getId()));
            this.stfBusinessProcessService.update(newentity);
        } else {
            entity.setId(id);
            this.stfBusinessProcessService.update(entity);
        }
        msg.setO((Object)entity);
        return msg;
    }

    @RequestMapping(value={"/delStfBusinessProcess"})
    @ResponseBody
    public Object delStfBusinessProcess(Long id) {
        this.stfBusinessProcessService.delStfBusinessProcess(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treeStfBusinessTypeWithRoot"})
    @ResponseBody
    public Object treeStfBusinessTypeWithRoot(@RequestParam(value="pid", defaultValue="0") Long pid) {
        List<ComBoxTreeNode> treelist = this.stfbusinesstypeService.treeStfBusinessTypeWithCode(pid);
        return treelist;
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageStfBusinessProcess(@RequestParam(value="businessTypeId", defaultValue="") String businessTypeId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="type", defaultValue="") String type, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.stfBusinessProcessService.PageAll(businessTypeId, search, type, page, rows);
    }

    @RequestMapping(value={"/getflowByFlowCatId"})
    @ResponseBody
    public Object getflowByFlowCatId(Long flowCatId) {
        return this.stfBusinessProcessService.getflowByFlowCatId(flowCatId);
    }
}

