/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.controller;

import com.kdgcsoft.scrdc.workflow.entity.StfBusinessProcess;
import com.kdgcsoft.scrdc.workflow.entity.WfProcessDefine;
import com.kdgcsoft.scrdc.workflow.helper.JsonMsg;
import com.kdgcsoft.scrdc.workflow.service.FlowUtilService;
import com.kdgcsoft.scrdc.workflow.service.StfBusinessProcessService;
import com.kdgcsoft.scrdc.workflow.service.WfProcessDefineService;
import com.kdgcsoft.scrdc.workflow.service.inf.IProcessDefineSaveService;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pd"})
public class ProcessDefineController {
    @Autowired
    private StfBusinessProcessService sbpservice;
    @Autowired
    private FlowUtilService flowUtilservice;
    @Autowired(required=false)
    private IProcessDefineSaveService processDefineSaveService;
    @Autowired
    private WfProcessDefineService processDefineService;

    @RequestMapping(value={"/saveFlow"}, method={RequestMethod.POST})
    @ResponseBody
    public Object saveFlow(String processDefId, String processDefContent, String processDefName, String processCHName, String versionSign, String description, String limitTime, String createTime) throws IOException {
        List<StfBusinessProcess> list;
        Long _processDefId = 0L;
        WfProcessDefine processDefine = new WfProcessDefine();
        if (!StringUtils.isEmpty((CharSequence)processDefId)) {
            _processDefId = Long.valueOf(processDefId);
            processDefine.setProcessDefId(_processDefId);
        }
        String _processDefContent = null;
        if (processDefContent != null) {
            _processDefContent = processDefContent;
            processDefine.setProcessDefContent(_processDefContent);
        }
        String _processDefName = null;
        if (processDefName != null) {
            _processDefName = processDefName;
            processDefine.setProcessDefName(_processDefName);
        }
        String _processCHName = null;
        if (processCHName != null) {
            _processCHName = processCHName;
            processDefine.setProcessCHName(_processCHName);
        }
        String _versionSign = null;
        if (versionSign != null) {
            _versionSign = versionSign;
            processDefine.setVersionSign(_versionSign);
        }
        String _description = "\u8bf4\u660e";
        if (!StringUtils.isEmpty((CharSequence)description)) {
            _description = description;
        }
        if (!StringUtils.isEmpty((CharSequence)description)) {
            _description = description;
        }
        if (!(list = this.sbpservice.findByDesignName(_processDefName)).isEmpty()) {
            processDefine.setProcessCHName(list.get(0).getMemo());
            processDefine.setProcessDefCode(list.get(0).getFlowCode());
        }
        processDefine.setDescription(_description);
        Long _limitTime = null;
        if (!StringUtils.isEmpty((CharSequence)limitTime)) {
            _limitTime = Long.valueOf(limitTime);
            processDefine.setLimitTime(_limitTime);
        }
        processDefine.setUpdateTime(new Date());
        boolean isExists = this.processDefineService.isUniqueProcessDefine(processDefine.getProcessDefName(), processDefine.getVersionSign());
        if (isExists) {
            WfProcessDefine pd = this.processDefineService.findProcessDefine(processDefine.getProcessDefId());
            pd.setDescription(processDefine.getDescription());
            pd.setLimitTime(processDefine.getLimitTime());
            pd.setProcessDefContent(processDefine.getProcessDefContent());
            pd.setUpdateTime(new Date());
            pd.setUpdator("admin");
            this.processDefineService.updateProcessDefine(pd);
        } else {
            processDefine.setProcessDefId(null);
            processDefine.setCreateTime(new Date());
            processDefine.setCreator("admin");
            processDefine.setCurrentState(1);
            this.processDefineService.insertProcessDefine(processDefine);
        }
        if (this.processDefineSaveService != null) {
            this.processDefineSaveService.afterSaveProcessDefine(processDefine.getProcessDefId());
        }
        return processDefine.getProcessDefId();
    }

    @RequestMapping(value={"/ztreeNodes"})
    @ResponseBody
    public Object ztreeNodes(String nodeType, Long id) {
        return this.sbpservice.queryWorkFlowVersion(nodeType, id);
    }

    @RequestMapping(value={"/delProcessDefine"}, method={RequestMethod.GET})
    @ResponseBody
    public Object delProcessDefine(Long id) {
        JsonMsg jm = new JsonMsg();
        if (null == id) {
            jm.setMsg("\u53d1\u751f\u9519\u8bef");
            jm.setSuccess(false);
        }
        this.sbpservice.delProcessDefine(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/pubProcessDefine"}, method={RequestMethod.GET})
    @ResponseBody
    public Object pubProcessDefine(Long id) {
        JsonMsg jm = new JsonMsg();
        if (null == id) {
            jm.setMsg("\u53d1\u751f\u9519\u8bef");
            jm.setSuccess(false);
        }
        this.sbpservice.pubProcessDefine(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/cancelProcessDefine"}, method={RequestMethod.GET})
    @ResponseBody
    public Object cancelProcessDefine(Long id) {
        JsonMsg jm = new JsonMsg();
        if (null == id) {
            jm.setMsg("\u53d1\u751f\u9519\u8bef");
            jm.setSuccess(false);
        }
        this.sbpservice.cancelProcessDefine(id);
        return new JsonMsg();
    }
}

