var basetree=$('#StfBusinessProcess_tree');
var basegrid=$('#StfBusinessProcess_datagrid');
var selectflow=$('#flow_combo');
$(function(){
	initTree();
	initGrid();

});
function initTree(){
	basetree.tree({
		url : ctx + '/StfBusinessProcess/treeStfBusinessTypeWithRoot',
		onSelect : function(node) {
			reloadGrid();
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}

function flowsel(){
	reloadGrid();
}

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:false,
		toolbar:"#StfBusinessProcess_datagrid_tb",
	    url:ctx+'/StfBusinessProcess/findAll',
	    columns:[[{
	      			field:'resId',title:'明细',width:40,align:'center',
	      			formatter:function(value,row,index){
	      				//value表示字段的值,rowData行记录数据,index行索引
	      				return '<div onclick="openFormDetail(\''+value+'\')" class="icon-detail">&nbsp;</div>';
	      		}},
	      	    {field:'flowName',title:'显示名称',width:100,align:'center'},
	      	    {field:'businessTypeName',title:'业务目录',width:100,align:'center'},
	      	    {field:'designName',title:'定义名称',width:80,align:'center'},
	      	    {field:'typeName',title:'流程类型',width:50,align:'center'},
	      	    {field:'memo',title:'说明',width:200}
	      	    ]]
	});
}

function reloadGrid(){
	var flowtype=selectflow.combobox('getValue');
		switch(flowtype){
		case "4":
			flowtype="flow";
			break;
		case "1":
			flowtype="subflow";
			break;
		case "2":
			flowtype="feiflow";
			break;
		case "":
			flowtype="";
			break;
		}
	var node=basetree.tree('getSelected');
	basegrid.datagrid('reload',{
		type:flowtype,
		businessTypeId:node.id,
		search:$("#searchStfBusinessProcess").val()
	});
}

function searchStfBusinessProcess(){
	reloadGrid();
}

//增加数据字典
function addStfBusinessProcess() {
	var node=basetree.tree('getSelected');
	if(node && node.children.length==0){
		openSaveDialog({
			title:"流程属性",
			contenturl : "/StfBusinessProcess/get-form",
			submiturl:"/StfBusinessProcess/saveStfBusinessProcess?businessTypeId="+node.id,
			callback:reloadGrid
		});
	}else{
		alertInfo('请选择一个业务流程');
	}


}

//修改数据字典
function editStfBusinessProcess() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.resId;
		openSaveDialog({
			title : "修改记录",
			contenturl : "/StfBusinessProcess/get-form",
			submiturl : "/StfBusinessProcess/saveStfBusinessProcess?id="+id,
			onload : "/StfBusinessProcess/findStfBusinessProcess?id=" + id,
			callback : reloadGrid
		});
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//查看表单明细
function openFormDetail(resId){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/StfBusinessProcess/detail?resId="+resId
	});
}

//删除数据字典
function delStfBusinessProcess() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.resId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/StfBusinessProcess/delStfBusinessProcess",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据字典信息');
	}
}
