/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.service;

import com.google.common.base.Joiner;
import com.kdgcsoft.scrdc.workflow.common.spring.SpringContextHolder;
import com.kdgcsoft.scrdc.workflow.dao.ActivityInstMapper;
import com.kdgcsoft.scrdc.workflow.dao.WfWorkItemMapper;
import com.kdgcsoft.scrdc.workflow.service.bo.UserBO;
import com.kdgcsoft.scrdc.workflow.service.inf.IUserService;
import com.ustcsoft.usiflow.engine.ProcessEngine;
import com.ustcsoft.usiflow.engine.ProcessEngineBuilder;
import com.ustcsoft.usiflow.engine.model.ProcessInstance;
import com.ustcsoft.usiflow.engine.repository.IProcessInstanceRepository;
import com.ustcsoft.usiflow.engine.service.IActivityInstService;
import com.ustcsoft.usiflow.engine.service.IProcessDefineService;
import com.ustcsoft.usiflow.engine.service.IProcessInstanceService;
import com.ustcsoft.usiflow.engine.service.IWorkItemService;
import com.ustcsoft.usiflow.service.filter.DataSourceRelaDataFilter;
import com.ustcsoft.usiflow.service.filter.LoggerProcessFilter;
import com.ustcsoft.usiflow.service.filter.ProcessFilter;
import com.ustcsoft.usiflow.service.filter.TransCtrlFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
@DependsOn(value={"SpringContextHolder"})
public class FlowUtilService {
    Logger logger = LoggerFactory.getLogger(FlowUtilService.class);
    private ProcessEngine processEngine;
    private IProcessInstanceService procInstService;
    private IWorkItemService workItemService;
    private IProcessDefineService proservice;
    private IProcessInstanceRepository procInstRep;
    private IActivityInstService activityInstService;
    @Autowired
    private ActivityInstMapper activityInstMapper;
    @Autowired(required=false)
    private IUserService<Long> userService;
    @Autowired
    private WfWorkItemMapper wfWorkItemMapper;

    @PostConstruct
    public void init() {
        this.logger.info("\u521d\u59cb\u5316\u6d41\u7a0b\u5f15\u64ce...");
        this.processEngine = new ProcessEngineBuilder(SpringContextHolder.getApplicationContext()).buildProcessEngine();
        this.processEngine.addFilter((ProcessFilter)new LoggerProcessFilter());
        this.processEngine.addFilter((ProcessFilter)new TransCtrlFilter());
        this.processEngine.addFilter((ProcessFilter)new DataSourceRelaDataFilter());
        this.procInstService = this.processEngine.getProcessInstanceService();
        this.workItemService = this.processEngine.getWorkItemService();
        this.proservice = this.processEngine.getProcessDefineService();
        this.activityInstService = this.processEngine.getActivityInstService();
        this.procInstRep = (IProcessInstanceRepository)SpringContextHolder.getApplicationContext().getBean(IProcessInstanceRepository.class);
        this.logger.info("\u521d\u59cb\u5316\u6d41\u7a0b\u5f15\u64ce...\u5b8c\u6210!");
    }

    public String getProcessdefidByProcessinstid(Long processinstid) {
        ProcessInstance processInstance = this.procInstService.findProcessById(processinstid.longValue());
        return processInstance != null ? String.valueOf(processInstance.getProcessDefId()) : "";
    }

    public String getCurrentActId(Long processinstid) {
        return this.wfWorkItemMapper.getCurrentActId(processinstid);
    }

    public List<Map<String, Object>> getAppList(Long processinstid) {
        Long workitemid;
        List<Long> participantIds;
        List<Map<String, Object>> appList = this.activityInstMapper.getAppList(processinstid);
        List participants = appList.stream().filter(m -> Objects.nonNull(m.get("participant"))).map(m -> Long.parseLong((String)m.get("participant"))).collect(Collectors.toList());
        List<Object> userBOS = new ArrayList();
        if (this.userService != null) {
            userBOS = this.userService.listByIds(participants);
        }
        Map userMap = userBOS.stream().collect(Collectors.toMap(UserBO::getUserId, Function.identity(), (u1, u2) -> u2));
        appList.forEach(m -> {
            Long p;
            Object participant = m.get("participant");
            if (Objects.nonNull(participant) && userMap.containsKey(p = Long.valueOf(Long.parseLong((String)participant)))) {
                UserBO user = (UserBO)userMap.get(p);
                m.put("accountname", user.getUserName());
            }
        });
        Map<String, Object> appMap = appList.get(appList.size() - 1);
        if (Objects.isNull(appMap.get("participant")) && CollectionUtils.isNotEmpty(participantIds = this.activityInstMapper.getParticipantsByWorkitemId(workitemid = (Long)appMap.get("workitemid")))) {
            List<UserBO> userBOList = this.userService.listByIds(participantIds);
            List userNames = userBOList.stream().map(UserBO::getUserName).collect(Collectors.toList());
            appMap.put("accountname", Joiner.on((String)",").skipNulls().join(userNames));
        }
        return appList;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public IProcessInstanceService getProcInstService() {
        return this.procInstService;
    }

    public void setProcInstService(IProcessInstanceService procInstService) {
        this.procInstService = procInstService;
    }

    public IWorkItemService getWorkItemService() {
        return this.workItemService;
    }

    public void setWorkItemService(IWorkItemService workItemService) {
        this.workItemService = workItemService;
    }

    public IProcessDefineService getProservice() {
        return this.proservice;
    }

    public void setProservice(IProcessDefineService proservice) {
        this.proservice = proservice;
    }

    public IProcessInstanceRepository getProcInstRep() {
        return this.procInstRep;
    }

    public void setProcInstRep(IProcessInstanceRepository procInstRep) {
        this.procInstRep = procInstRep;
    }
}

