/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.controller;

import com.kdgcsoft.scrdc.workflow.controller.FlowSpringBeanUtil;
import com.kdgcsoft.scrdc.workflow.controller.StrUtil;
import com.kdgcsoft.scrdc.workflow.entity.StfBusinessProcess;
import com.kdgcsoft.scrdc.workflow.entity.StfBusinessType;
import com.kdgcsoft.scrdc.workflow.entity.WfProcessDefine;
import com.kdgcsoft.scrdc.workflow.helper.PageObject;
import com.kdgcsoft.scrdc.workflow.service.FlowUtilService;
import com.kdgcsoft.scrdc.workflow.service.StfBusinessProcessService;
import com.kdgcsoft.scrdc.workflow.service.StfBusinessTypeService;
import com.kdgcsoft.scrdc.workflow.service.bo.PageTemplateBO;
import com.kdgcsoft.scrdc.workflow.service.inf.IOperationService;
import com.kdgcsoft.scrdc.workflow.service.inf.IPageTemplateService;
import com.ustcsoft.usiflow.engine.model.elements.OperationElement;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/wf"})
public class WorkFlowController {
    @Autowired
    private StfBusinessProcessService sbpservice;
    @Autowired
    private StfBusinessTypeService sbtservice;
    @Autowired
    private FlowUtilService flowUtilservice;
    @Autowired(required=false)
    private IPageTemplateService pageTemplateService;
    @Autowired(required=false)
    private IOperationService operationService;

    public void stfBusinessProcessSave(StfBusinessProcess entity) {
        this.sbpservice.save(entity);
    }

    public void stfBusinessProcessUpdate(StfBusinessProcess entity) {
        this.sbpservice.update(entity);
    }

    public void stfBusinessProcessDelete(StfBusinessProcess entity) {
        this.sbpservice.delete(entity);
    }

    public void findStfBusinessProcess(Long id) {
        this.sbpservice.find(id);
    }

    public void findStfBusinessProcessByType(Object businessTypeId) {
        this.sbpservice.findByBusinessTypeId(businessTypeId);
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.POST})
    @ResponseBody
    public Object findAll(HttpServletRequest requestServlet, Integer start, Integer limit, String flowName, String designName, String type, String level) throws IOException {
        List<StfBusinessProcess> list = this.sbpservice.findAll(flowName, designName, type, level);
        PageObject<StfBusinessProcess> result = new PageObject<StfBusinessProcess>();
        result.setRows(list.subList(start, start + limit > list.size() ? list.size() : start + limit));
        result.setTotal(list.size());
        return result;
    }

    @RequestMapping(value={"/queryWorkFlowVersion"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryWorkFlowVersion(HttpServletRequest requestServlet) throws Exception {
        String processDefName = requestServlet.getParameter("processDefName");
        List<WfProcessDefine> tmp = this.sbpservice.queryWorkFlowVersion(processDefName);
        PageObject<WfProcessDefine> result = new PageObject<WfProcessDefine>();
        result.setRows(tmp);
        result.setTotal(tmp.size());
        return result;
    }

    @RequestMapping(value={"/queryFlowContent"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryFlowContent(HttpServletRequest requestServlet, Long id, Long processinstid, String actid, HttpServletResponse reponse) throws IOException, SQLException {
        return this.sbpservice.queryFlowContent(id, processinstid);
    }

    @RequestMapping(value={"/queryWorkItem"})
    @ResponseBody
    public Object queryWorkItem(HttpServletRequest requestServlet) throws IOException {
        List<StfBusinessType> list = this.sbtservice.findAll();
        ArrayList<StfBusinessType> temp = new ArrayList<StfBusinessType>();
        for (StfBusinessType businessType : list) {
            if (businessType.getParentId() != 0L) continue;
            temp.add(businessType);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        for (int i = 0; i < temp.size(); ++i) {
            sb.append("<node id=\"" + ((StfBusinessType)((Object)temp.get(i))).getResId() + "\" label=\"" + StrUtil.encodeString(((StfBusinessType)((Object)temp.get(i))).getName()) + "\" level=\"" + ((StfBusinessType)((Object)temp.get(i))).getLevels() + "\" type=\"organization\" >\n");
            if ("N".equals(((StfBusinessType)((Object)temp.get(i))).getLeafName())) {
                this.getAllParentLabel((StfBusinessType)((Object)temp.get(i)), list, sb);
            }
            sb.append("</node>\n");
        }
        return sb.toString();
    }

    @RequestMapping(value={"/querySpringBean"}, method={RequestMethod.POST})
    @ResponseBody
    public Object querySpringBean(HttpServletRequest requestServlet) throws IOException {
        String type = "";
        if (!StringUtils.isEmpty((CharSequence)requestServlet.getParameter("type"))) {
            type = requestServlet.getParameter("type").toString();
        }
        StringBuilder sb = new StringBuilder();
        List<String> list = FlowSpringBeanUtil.querySpringBean(type);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        if (list != null && !list.isEmpty()) {
            for (String name : list) {
                sb.append("<node value=\"" + name + "\" name=\"" + name + "\" />\n");
            }
        }
        sb.append("</node>");
        return sb.toString();
    }

    @RequestMapping(value={"/queryOrgModel"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryOrgModel(HttpServletRequest requestServlet) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("</menuitem>");
        return sb.toString();
    }

    @RequestMapping(value={"/querySubFlow"}, method={RequestMethod.POST})
    @ResponseBody
    public Object querySubFlow(HttpServletRequest requestServlet) throws IOException {
        long bussinessTypeId = 0L;
        if (!StringUtils.isEmpty((CharSequence)requestServlet.getParameter("busiId"))) {
            bussinessTypeId = Long.parseLong(requestServlet.getParameter("busiId"));
        }
        List<StfBusinessProcess> list = this.sbpservice.findFlowByType(bussinessTypeId, "subflow");
        return list;
    }

    private void getAllParentLabel(StfBusinessType bt, List<StfBusinessType> list, StringBuilder sb) {
        ArrayList<StfBusinessType> temp2 = new ArrayList<StfBusinessType>();
        for (StfBusinessType businessType : list) {
            if (!businessType.getParentId().equals(bt.getResId())) continue;
            temp2.add(businessType);
            sb.append("<node id=\"" + businessType.getResId() + "\" label=\"" + StrUtil.encodeString(businessType.getName()) + "\" level=\"" + businessType.getLevels() + "\" type=\"organization\" >\n");
            if ("N".equals(businessType.getLeafName())) {
                this.getAllParentLabel(businessType, list, sb);
            }
            sb.append("</node>\n");
        }
    }

    @RequestMapping(value={"/jsflow"})
    public ModelAndView openJsflowPage(HttpServletRequest request) throws UnsupportedEncodingException {
        ModelAndView mv = new ModelAndView();
        mv.addObject("appCode", (Object)request.getParameter("appCode"));
        mv.addObject("status", (Object)request.getParameter("status"));
        mv.addObject("processDefId", (Object)request.getParameter("processDefId"));
        mv.addObject("processCHName", (Object)URLDecoder.decode(request.getParameter("processCHName"), "utf-8"));
        mv.addObject("processDefName", (Object)request.getParameter("processDefName"));
        mv.addObject("version", (Object)request.getParameter("version"));
        mv.addObject("busiId", (Object)request.getParameter("busiId"));
        mv.addObject("param", new HashMap());
        mv.setViewName("workflow/jsflow");
        return mv;
    }

    @RequestMapping(value={"/participants"})
    public ModelAndView openParticipantsPage() {
        ModelAndView mv = new ModelAndView();
        mv.setViewName("workflow/participants");
        return mv;
    }

    @RequestMapping(value={"/queryPageTemplates"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryPageTemplates4Flex(HttpServletRequest requestServlet) throws IOException {
        Long busiId = 0L;
        if (requestServlet.getParameter("busiId") != null && !"".equals(requestServlet.getParameter("busiId"))) {
            busiId = Long.valueOf(requestServlet.getParameter("busiId"));
        }
        List<PageTemplateBO> all = this.pageTemplateService.getAll(busiId);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (PageTemplateBO bo : all) {
            sb.append("<node id=\"" + bo.getCode() + "\" name=\"" + bo.getName() + "\" />\n");
        }
        sb.append("</node>");
        return sb.toString();
    }

    @RequestMapping(value={"/queryOperations"})
    @ResponseBody
    public Object queryOperations(HttpServletRequest requestServlet) {
        Long busiId = 0L;
        if (requestServlet.getParameter("busiId") != null && !"".equals(requestServlet.getParameter("busiId"))) {
            busiId = Long.valueOf(requestServlet.getParameter("busiId"));
        }
        List<OperationElement> all = this.operationService.getAll(busiId);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (OperationElement bo : all) {
            sb.append("<node id=\"" + bo.getId() + "\" code=\"" + bo.getCode() + "\" name=\"" + bo.getName() + "\" action=\"" + bo.getAction() + "\" displayName=\"" + bo.getDisplayName() + "\"  />\n");
        }
        sb.append("</node>");
        return sb.toString();
    }
}

