/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.controller;

import com.google.common.base.Joiner;
import com.kdgcsoft.scrdc.workflow.helper.PageObject;
import com.kdgcsoft.scrdc.workflow.service.FlowUtilService;
import com.kdgcsoft.scrdc.workflow.service.StfBusinessProcessService;
import com.ustcsoft.usiflow.engine.model.ActivityInst;
import com.ustcsoft.usiflow.engine.model.TransCtrl;
import com.ustcsoft.usiflow.engine.model.elements.FreeActElement;
import com.ustcsoft.usiflow.engine.service.IActivityInstService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/viewwf"})
public class ViewFlowController {
    @Autowired
    private StfBusinessProcessService sbpservice;
    @Autowired
    private FlowUtilService flowUtilservice;
    private static final String PROCESSINSTIDS = "processinstid";
    private static final String ACTID = "actid";
    private static final String VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    @RequestMapping(value={"/queryTransctrls"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryTransctrls(HttpServletRequest requestServlet, Long id) throws IOException {
        if (id != null) {
            IActivityInstService activityInstService = this.flowUtilservice.getProcessEngine().getActivityInstService();
            StringBuilder sb = new StringBuilder();
            List transCtrls = activityInstService.findTransCtrls(id.longValue());
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<activities>\n<transctrls>\n");
            for (TransCtrl tc : transCtrls) {
                sb.append("<transctrl srcId=\"" + tc.getSrcActDefId() + "\" destId=\"" + tc.getDestActDefId() + "\" />\n");
            }
            sb.append("</transctrls>\n<noFinishActs>\n");
            List activityInsts = activityInstService.findWaitingAndTerminateAndRunningActivityInst(id.longValue());
            for (ActivityInst activityInst : activityInsts) {
                sb.append("<activity id=\"" + activityInst.getActivityDefId() + "\" status=\"" + activityInst.getCurrentState() + "\" />\n");
            }
            sb.append("</noFinishActs></activities>");
            return sb.toString();
        }
        return "";
    }

    @RequestMapping(value={"/queryFlowContent"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryFlowContent(HttpServletRequest requestServlet, Long id, Long processInstId, HttpServletResponse reponse) throws IOException, SQLException {
        reponse.setContentType("text/xml;charset=UTF-8");
        return this.sbpservice.queryFlowContent(id, processInstId);
    }

    @RequestMapping(value={"/viewFlow"}, method={RequestMethod.GET})
    public Object viewFlow(HttpServletRequest requestServlet, Long processInstId) {
        requestServlet.setAttribute("processInstId", (Object)processInstId);
        requestServlet.setAttribute("processDefId", (Object)this.flowUtilservice.getProcessdefidByProcessinstid(processInstId));
        return "/workflow/jsflowview";
    }

    @RequestMapping(value={"/selecFlow"}, method={RequestMethod.GET})
    public Object selecFlow(HttpServletRequest requestServlet, Long processInstId) {
        String processDefId = this.flowUtilservice.getProcessdefidByProcessinstid(processInstId);
        requestServlet.setAttribute("processInstId", (Object)processInstId);
        List actlist = this.flowUtilservice.getProcessEngine().getFreeFlowService().queryCustomPossibleNextActsOfFreeActivity(processInstId.longValue(), Long.parseLong(processDefId), this.flowUtilservice.getCurrentActId(processInstId));
        if (!actlist.isEmpty()) {
            IActivityInstService activityInstService = this.flowUtilservice.getProcessEngine().getActivityInstService();
            List transCtrls = activityInstService.findTransCtrls(processInstId.longValue());
            HashMap tsacts = new HashMap();
            for (TransCtrl ts : transCtrls) {
                tsacts.put(ts.getSrcActDefId(), null);
            }
            ArrayList<String> freeacts = new ArrayList<String>(actlist.size());
            ArrayList<String> freeactnames = new ArrayList<String>(actlist.size());
            for (FreeActElement freeact : actlist) {
                if (!tsacts.containsKey(freeact.getId()) || "start".equals(freeact.getType()) || "finish".equals(freeact.getType())) continue;
                freeacts.add(freeact.getId());
                freeactnames.add(freeact.getName());
            }
            requestServlet.setAttribute("freeacts", (Object)Joiner.on((String)",").skipNulls().join(freeacts));
            requestServlet.setAttribute("freeactnames", (Object)Joiner.on((String)",").skipNulls().join(freeactnames));
        }
        requestServlet.setAttribute("processDefId", (Object)processDefId);
        return "workflow/jsflowselect";
    }

    @RequestMapping(value={"/getAppList"})
    @ResponseBody
    public Object getAppList(Long processinstid, Integer start, Integer limit) {
        List<Map<String, Object>> appList = this.flowUtilservice.getAppList(processinstid);
        if (start == null || limit == null) {
            return appList;
        }
        int to = start + limit;
        if (to > appList.size()) {
            to = appList.size();
        }
        return new PageObject<Map<String, Object>>(appList.subList(start, to), Long.valueOf(appList.size()));
    }

    @RequestMapping(value={"/workItemInfo"})
    public ModelAndView openWorkItemInfo(Long processInstId) {
        ModelAndView mv = new ModelAndView();
        mv.addObject("processInstId", (Object)processInstId);
        mv.setViewName("workflow/flowWorkItemInfo");
        return mv;
    }
}

