/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.controller;

import java.io.UnsupportedEncodingException;

public class StrUtil {
    private static String SPACE = "000000";

    public static String rPad(String source, int length, String charset) {
        int padLength = 0;
        if (source == null) {
            source = "";
        }
        try {
            padLength = length - source.getBytes(charset).length;
        }
        catch (UnsupportedEncodingException ex) {
            padLength = length - source.getBytes().length;
        }
        if (padLength <= 0) {
            return source;
        }
        while (SPACE.length() < padLength) {
            SPACE = SPACE.concat(SPACE);
        }
        return source.concat(SPACE.substring(0, padLength));
    }

    public static String lPad(String source, int length) {
        int padLength = 0;
        if (source == null) {
            source = "";
        }
        if ((padLength = length - source.length()) <= 0) {
            return source;
        }
        return "0".concat(source);
    }

    public static boolean isNullString(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean isNullInteger(Integer iIn) {
        return iIn == null;
    }

    public static String replaceString(String strData, String regex, String replacement) {
        if (strData == null) {
            return null;
        }
        int index = strData.indexOf(regex);
        String strNew = "";
        if (index >= 0) {
            StringBuilder buf = new StringBuilder();
            while (index >= 0) {
                buf.append(strData.substring(0, index) + replacement);
                strData = strData.substring(index + regex.length());
                index = strData.indexOf(regex);
            }
            strNew = strNew + buf.toString() + strData;
            return strNew;
        }
        return strData;
    }

    public static String encodeString(String strData) {
        if (strData == null) {
            return "";
        }
        strData = StrUtil.replaceString(strData, "&", "&amp;");
        strData = StrUtil.replaceString(strData, "<", "&lt;");
        strData = StrUtil.replaceString(strData, ">", "&gt;");
        strData = StrUtil.replaceString(strData, "&apos;", "&apos;");
        strData = StrUtil.replaceString(strData, "\"", "&quot;");
        return strData;
    }

    public static String decodeString(String strData) {
        strData = StrUtil.replaceString(strData, "&lt;", "<");
        strData = StrUtil.replaceString(strData, "&gt;", ">");
        strData = StrUtil.replaceString(strData, "&apos;", "&apos;");
        strData = StrUtil.replaceString(strData, "&quot;", "\"");
        strData = StrUtil.replaceString(strData, "&amp;", "&");
        return strData;
    }

    private StrUtil() {
    }
}

