/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.controller;

import com.kdgcsoft.scrdc.workflow.entity.StfBusinessProcess;
import com.kdgcsoft.scrdc.workflow.helper.JsonMsg;
import com.kdgcsoft.scrdc.workflow.service.FlowUtilService;
import com.kdgcsoft.scrdc.workflow.service.StfBusinessProcessService;
import com.kdgcsoft.scrdc.workflow.service.inf.IProcessDefineSaveService;
import com.ustcsoft.usiflow.core.util.PrimaryKeyUtil;
import com.ustcsoft.usiflow.engine.model.ProcessDefine;
import com.ustcsoft.usiflow.engine.service.IProcessDefineService;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pd"})
public class ProcessDefineController {
    @Autowired
    private StfBusinessProcessService sbpservice;
    @Autowired
    private FlowUtilService flowUtilservice;
    @Autowired(required=false)
    private IProcessDefineSaveService processDefineSaveService;

    @RequestMapping(value={"/createFlow"}, method={RequestMethod.GET})
    @ResponseBody
    public Object createFlow(String userId) {
        return this.flowUtilservice.getProcInstService().createAndStartProcess("flow.1", userId);
    }

    @RequestMapping(value={"/finshFlow"}, method={RequestMethod.GET})
    @ResponseBody
    public Object finshFlow() throws DocumentException {
        this.flowUtilservice.getWorkItemService().queryPersonFinishedWorkItems("4");
        return new JsonMsg();
    }

    @RequestMapping(value={"/saveFlow"}, method={RequestMethod.POST})
    @ResponseBody
    public Object saveFlow(String processDefId, String processDefContent, String processDefName, String processCHName, String versionSign, String description, String limitTime, String createTime) throws IOException {
        List<StfBusinessProcess> list;
        Long _processDefId = 0L;
        ProcessDefine processDefine = new ProcessDefine();
        if (!StringUtils.isEmpty((CharSequence)processDefId)) {
            _processDefId = Long.valueOf(processDefId.toString());
            processDefine.setProcessDefId(_processDefId.longValue());
        }
        String _processDefContent = null;
        if (processDefContent != null) {
            _processDefContent = processDefContent.toString();
            processDefine.setProcessDefContent(_processDefContent);
        }
        String _processDefName = null;
        if (processDefName != null) {
            _processDefName = processDefName.toString();
            processDefine.setProcessDefName(_processDefName);
        }
        String _processCHName = null;
        if (processCHName != null) {
            _processCHName = processCHName.toString();
            processDefine.setProcessCHName(_processCHName);
        }
        String _versionSign = null;
        if (versionSign != null) {
            _versionSign = versionSign.toString();
            processDefine.setVersionSign(_versionSign);
        }
        String _description = "\u8bf4\u660e";
        if (!StringUtils.isEmpty((CharSequence)description)) {
            _description = description.toString();
        }
        if (!StringUtils.isEmpty((CharSequence)description)) {
            _description = description.toString();
        }
        if (!(list = this.sbpservice.findByDesignName(_processDefName)).isEmpty()) {
            processDefine.setProcessCHName(list.get(0).getMemo());
        }
        processDefine.setDescription(_description);
        Long _limitTime = null;
        if (!StringUtils.isEmpty((CharSequence)limitTime)) {
            _limitTime = Long.valueOf(limitTime.toString());
            processDefine.setLimitTime(_limitTime.longValue());
        }
        processDefine.setUpdateTime(new Date());
        IProcessDefineService iProcessDefineService = this.flowUtilservice.getProcessEngine().getProcessDefineService();
        boolean isUnique = iProcessDefineService.isUniqueProcessDefine(processDefine.getProcessDefName(), processDefine.getVersionSign());
        if (!isUnique) {
            ProcessDefine pd = iProcessDefineService.findProcessDefine(processDefine.getProcessDefId());
            pd.setDescription(processDefine.getDescription());
            pd.setLimitTime(processDefine.getLimitTime());
            pd.setProcessDefContent(processDefine.getProcessDefContent());
            pd.setUpdateTime(new Date());
            pd.setUpdator("admin");
            iProcessDefineService.updateProcessDefine(processDefine);
        } else {
            processDefine.setProcessDefId(PrimaryKeyUtil.getPrimaryKey((String)"BusinessUsiFlow").longValue());
            processDefine.setCreateTime(new Date());
            processDefine.setCreator("admin");
            processDefine.setCurrentState(1);
            iProcessDefineService.insertProcessDefine(processDefine);
        }
        if (this.processDefineSaveService != null) {
            this.processDefineSaveService.afterSaveProcessDefine(processDefine.getProcessDefId());
        }
        return processDefine.getProcessDefId();
    }

    @RequestMapping(value={"/delWorkFlow"})
    @ResponseBody
    public Object delWorkFlow(long processDefId) {
        IProcessDefineService iProcessDefineService = this.flowUtilservice.getProcessEngine().getProcessDefineService();
        iProcessDefineService.deleteProcessDefine(processDefId);
        return "{success:true}";
    }

    @RequestMapping(value={"/publishWorkFlow"}, method={RequestMethod.POST})
    @ResponseBody
    public Object publishWorkFlow(HttpServletRequest requestServlet, String flowName, String processDefId) throws IOException {
        long workItem = 0L;
        String processDefName = "";
        if (flowName != null) {
            processDefName = flowName.toString();
        }
        Long _processDefId = 0L;
        if (!StringUtils.isEmpty((CharSequence)processDefId)) {
            _processDefId = Long.valueOf(processDefId.toString());
        }
        IProcessDefineService iProcessDefineService = this.flowUtilservice.getProcessEngine().getProcessDefineService();
        iProcessDefineService.publishProcessDefine(processDefName, _processDefId.longValue());
        return workItem;
    }

    @RequestMapping(value={"/saveWorkItem"}, method={RequestMethod.POST})
    @ResponseBody
    public Object saveWorkItem(HttpServletRequest requestServlet, Long id, String flowName, String type, String designName, Long businessTypeId, String memo) throws IOException {
        StfBusinessProcess businessProcess = new StfBusinessProcess();
        if (id != null) {
            businessProcess.setId(id);
        }
        businessProcess.setFlowName(flowName);
        businessProcess.setType(type);
        businessProcess.setDesignName(designName);
        if (businessTypeId != null) {
            businessProcess.setBusinessTypeId(businessTypeId);
        }
        businessProcess.setMemo(memo);
        long workItem = 0L;
        if (businessProcess.getId() == null) {
            this.sbpservice.save(businessProcess);
            businessProcess = this.sbpservice.getCurrentInfo();
            businessProcess.setDesignName(businessProcess.getType() + "." + String.valueOf(businessProcess.getId()));
            this.sbpservice.update(businessProcess);
        } else {
            this.sbpservice.update(businessProcess);
        }
        return String.valueOf(workItem);
    }

    @RequestMapping(value={"/ztreeNodes"})
    @ResponseBody
    public Object ztreeNodes(String nodeType, Long id) {
        return this.sbpservice.queryWorkFlowVersion(nodeType, id);
    }

    @RequestMapping(value={"/delProcessDefine"}, method={RequestMethod.GET})
    @ResponseBody
    public Object delProcessDefine(Long id) throws DocumentException {
        JsonMsg jm = new JsonMsg();
        if (null == id) {
            jm.setMsg("\u53d1\u751f\u9519\u8bef");
            jm.setSuccess(false);
        }
        this.sbpservice.delProcessDefine(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/pubProcessDefine"}, method={RequestMethod.GET})
    @ResponseBody
    public Object pubProcessDefine(Long id) throws DocumentException {
        JsonMsg jm = new JsonMsg();
        if (null == id) {
            jm.setMsg("\u53d1\u751f\u9519\u8bef");
            jm.setSuccess(false);
        }
        this.sbpservice.pubProcessDefine(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/cancelProcessDefine"}, method={RequestMethod.GET})
    @ResponseBody
    public Object cancelProcessDefine(Long id) throws DocumentException {
        JsonMsg jm = new JsonMsg();
        if (null == id) {
            jm.setMsg("\u53d1\u751f\u9519\u8bef");
            jm.setSuccess(false);
        }
        this.sbpservice.cancelProcessDefine(id);
        return new JsonMsg();
    }
}

