/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.scrdc.workflow.config.id;

public class SnowFlakeWorker {
    private static final long START_STMP = 1480166465631L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long DATACENTER_BIT = 5L;
    private static final long MAX_DATACENTER_NUM = 31L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long DATACENTER_LEFT = 12L;
    private static final long TIMESTMP_LEFT = 17L;
    private long datacenterId;
    private long sequence = 0L;
    private long lastStmp = -1L;

    public SnowFlakeWorker(long datacenterId) {
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException("datacenterId can't be greater than MAX_DATACENTER_NUM or less than 0");
        }
        this.datacenterId = datacenterId;
    }

    public synchronized long nextId() {
        long currStmp = this.getNewstmp();
        if (currStmp < this.lastStmp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStmp == this.lastStmp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStmp = currStmp;
        return currStmp - 1480166465631L << 17 | this.datacenterId << 12 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewstmp();
        while (mill <= this.lastStmp) {
            mill = this.getNewstmp();
        }
        return mill;
    }

    private long getNewstmp() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
        SnowFlakeWorker snowFlake = new SnowFlakeWorker(2L);
        Long id = snowFlake.nextId();
        System.out.println(id);
        System.out.println(id.toString().length());
        System.out.println(Long.toBinaryString(id));
        int maxTimes = 10000000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < maxTimes; ++i) {
            snowFlake.nextId();
        }
        long end = System.currentTimeMillis();
        System.out.println("\u9884\u70ed" + maxTimes + " \u5e73\u5747:" + (long)maxTimes / (end - start) + "/\u6beb\u79d2");
        long start1 = System.currentTimeMillis();
        for (int i = 0; i < maxTimes; ++i) {
            snowFlake.nextId();
        }
        long end1 = System.currentTimeMillis();
        System.out.println("\u6b63\u5f0f" + maxTimes + " \u5e73\u5747:" + (long)maxTimes / (end1 - start1) + "/\u6beb\u79d2");
    }
}

