var baseform = $('#StfBusinessType_form');
var parentName = $("#parentName");
var resId;
var pid;
var eleTreeEl;
var eleTreeConfig;
var parentTreeEl;
var parentTreeConfig;
var nodeData;
$(function () {
    initTree();
    initParentTree();
    initForm();
});

//初始化左侧树
function initTree() {
    layui.config({
        base: ctx + "/static/plugins/layui/lay/thirdparty/"
    }).use(['eleTree'], function () {
        var eleTree = layui.eleTree;
        eleTreeConfig = {
            elem: '.treeMore',
            expandOnClickNode: false,
            url: ctx + '/StfBusinessType/treeStfBusinessTypeWithRoot',
            highlightCurrent: true,
            defaultExpandAll: true,
            renderAfterExpand: true,
            request: {
                name: "text",
                key: "id",
                children: "children",
                checked: "checked",
                disabled: "disabled",
                isLeaf: "leaf"
            },
            response: {
                statusName: "status",
                statusCode: 200,
                dataName: "data"
            },
            done: function (res) {
                if (resId) {
                    eleTreeEl.setHighlightNode(resId);
                }
            }
        };
        eleTreeEl = eleTree.render(eleTreeConfig);
        eleTree.on("nodeClick(eleTree)", function (d) {
            nodeData = d.data;
            openNode(d.data);
        })
    });

    /*    basetree.tree({
            url: ctx + '/StfBusinessType/treeStfBusinessTypeWithRoot',
            onSelect: function (node) {
                openNode(node);
            },
            onLoadSuccess: function (node, data) {
                // 默认显示根节点信息
                var root = $(this).tree('getRoot');
                var selectNode = $(this).tree('find', resId);
                if (selectNode) {
                    $(this).tree('select', selectNode.target);
                } else {
                    $(this).tree('collapseAll');
                    $(this).tree('expand', root.target);
                    $(this).tree('select', root.target);
                }
            }
        });*/
}

function initParentTree() {
    layui.config({
        base: ctx + "/static/plugins/layui/lay/thirdparty/"
    }).use(['eleTree'], function () {
        var eleTree = layui.eleTree;
        parentTreeConfig = {
            elem: '#parentTree',
            url: ctx + '/StfBusinessType/treeStfBusinessTypeWithRoot',
            defaultExpandAll: true,
            expandOnClickNode: false,
            highlightCurrent: true,
            request: {
                name: "text",
                key: "id",
                children: "children",
                checked: "checked",
                disabled: "disabled",
                isLeaf: "leaf"
            },
            response: {
                statusName: "status",
                statusCode: 200,
                dataName: "data"
            },
            done: function (res) {
                if (pid) {
                    parentTreeEl.setHighlightNode(pid);
                }
            }
        };
        parentTreeEl = eleTree.render(parentTreeConfig);
        $("#parentTree").hide();
        $("#parentName").on("click", function (e) {
            e.stopPropagation();
            $("#parentTree").toggle();
        });
        eleTree.on("nodeClick(parentTree)", function (d) {
            $("#parentName").val(d.data.currentData.text);
            $("#parentId").val(d.data.currentData.id);
            $("#parentTree").hide();
        })
    });
    $(document).on("click", function () {
        $("#parentTree").hide();
    })
};

function initForm() {
    layui.use('form', function () {
        var form = layui.form;
        form.on('submit(saveType)', function (data) {
            saveStfBusinessType();
            return false; //阻止表单跳转。如果需要表单跳转，去掉这段即可。
        });
    });
}

//控制按钮的可用状态 如果选中的是虚拟的根节点择会禁用对应按钮
function controlBtn(isable) {
    if (isable) {
        $('#delStfBusinessType').removeClass("layui-btn-disabled"); //删除
        $('#delStfBusinessType').removeAttr("disabled"); //删除
        $('#saveStfBusinessType').removeClass("layui-btn-disabled"); //保存
        $('#saveStfBusinessType').removeAttr("disabled"); //保存
    } else {
        $('#delStfBusinessType').addClass("layui-btn-disabled");
        $('#delStfBusinessType').attr("disabled", "disabled");
        $('#saveStfBusinessType').addClass("layui-btn-disabled");
        $('#saveStfBusinessType').attr("disabled", "disabled");
    }
}

//加载节点信息,对根节点进行了特殊处理===表示值和类型都匹配
function openNode(node) {
    var currentData = node.currentData;
    if (!currentData || currentData.id === "0") {
        baseform.form('clear');
        parentTreeEl.setHighlightNode(0);
        controlBtn(false);
    } else {
        baseform.form('load', ctx + "/StfBusinessType/findStfBusinessType?id=" + currentData.id);
        var parentData = node.parentData.data;
        parentName.val(parentData.text);
        parentTreeEl.setHighlightNode(parentData.id);
        controlBtn(true);
    }
}

//增加
function addStfBusinessType() {
    // 清除当前界面信息
    var name = $("#name").val();
    baseform.form('clear');
    var highlightNode = eleTreeEl.getHighlightNode();
    if (highlightNode.hasOwnProperty('id')) {
        parentName.val(name);
        if (highlightNode.id === 0) {
            parentName.val("根节点");
        }
        parentTreeEl.setHighlightNode(highlightNode.id);
        $("#parentId").val(highlightNode.id);
    } else {
        parentName.val("根节点");
        $("#parentId").val(0);
    }
    $('#saveStfBusinessType').removeClass("layui-btn-disabled"); //保存
    $('#saveStfBusinessType').removeAttr("disabled"); //保存
    /*var node = basetree.tree('getSelected');
    // 清除当前界面信息
    baseform.form('clear');
    parentName.combotree('setValue', node.id);
    $('#saveStfBusinessType').linkbutton('enable');*/
}

//删除
function delStfBusinessType() {
    var highlightNode = eleTreeEl.getHighlightNode();
    if (highlightNode.hasOwnProperty('id')) {
        if (highlightNode.id === "0") {
            alertInfo('根节点不可删除!');
            return;
        }
        alertConfirm('将删除该节点及下级所有节点,确定?', function (r) {
            if (r) {
                $.ajax({
                    type: 'post',
                    dataType: 'json',
                    url: ctx + "/StfBusinessType/delStfBusinessTypeAndChild?id=" + highlightNode.id,
                    success: function (result) {
                        if (result.success) {
                            eleTreeEl.remove(highlightNode.id)
                            parentTreeEl.remove(highlightNode.id);
                            baseform.form('clear');
                            alertInfo(result.msg);
                        } else {
                            alertError(result.msg);
                        }
                    }, error: function () {
                        alertError("删除失败!");
                    }
                });
            }
        });
    } else {
        alertInfo('请选择一个节点');
    }
}

function saveStfBusinessType() {
    var parentId = $("#parentId").val();
    if (parentId || parentId === 0) {
        baseform.form('submit', {
            url: ctx + "/StfBusinessType/saveStfBusinessType",
            onSubmit: function () {
                $('#saveStfBusinessType').addClass("layui-btn-disabled");
                $('#saveStfBusinessType').attr("disabled", "disabled");
                return true;
            },
            success: function (result) {
                result = jQuery.parseJSON(result);
                if (result.success) {
                    resId = result.o.resId;
                    pid = result.o.parentId;
                    eleTreeEl = eleTreeEl.reload(eleTreeConfig);
                    parentTreeEl = parentTreeEl.reload(parentTreeConfig);
                    $('#saveStfBusinessType').removeClass("layui-btn-disabled"); //保存
                    $('#saveStfBusinessType').removeAttr("disabled"); //保存
                    alertInfo("保存成功");
                } else {
                    alertError(result.msg);
                    $('#saveStfBusinessType').removeClass("layui-btn-disabled"); //保存
                    $('#saveStfBusinessType').removeAttr("disabled"); //保存
                }
            }
        });
    } else {
        alertInfo('请选择一个节点');
    }
}

function triggerSubmit() {
    $("#submitBtn").click();
}

//转化正整数
function zhzs(value) {
    value = value.replace(/[^\d]/g, '');
    if ('' !== value) {
        value = parseInt(value);
    }
    return value;
}