var el;
var data = {
    currentData: {id: ''}
};
var baseform = $('#StfBusinessProcess_form');
//var basegrid = $('#StfBusinessProcess_datagrid');
var selectflow = $('#flow_combo');
$(function () {
    layui.use('form', function () {
        var form = layui.form;
        form.on('select(flow_combo)', function (data) {
            reloadGrid();
        });
    });
    initTree();
    initGrid();
});

function initTree() {
    layui.config({
        base: ctx + "/static/plugins/layui/lay/thirdparty/"
    }).use(['eleTree'], function () {
        var eleTree = layui.eleTree;
        el = eleTree.render({
            elem: '.treeMore',
            expandOnClickNode: false,
            url: ctx + '/StfBusinessProcess/treeStfBusinessTypeWithRoot',
            highlightCurrent: true,
            renderAfterExpand: true,
            request: {
                name: "text",
                key: "id",
                children: "children",
                checked: "checked",
                disabled: "disabled",
                isLeaf: "leaf"
            },
            response: {
                statusName: "status",
                statusCode: 200,
                dataName: "data"
            },
            done: function (res) {
                if (res.data && res.data.length > 0) {
                    el.expandNode(res.data[0].id);
                }
            }
        });
        eleTree.on("nodeClick()", function (d) {
            data = d.data;
            reloadGrid();
        })
    });
}

function initGrid() {
    var flowtype = selectflow.val();
    layui.use('table', function () {
        var table = layui.table;
        table.on('row(StfBusinessProcess_datagrid)', function (obj) {
            //选中行样式
            obj.tr.addClass('layui-table-click').siblings().removeClass('layui-table-click');
            //选中radio样式
            obj.tr.find('i[class="layui-anim layui-icon"]').trigger("click");
        });
        //监听行双击事件
        table.on('rowDouble(StfBusinessProcess_datagrid)', function (obj) {
            //obj 同上
            editStfBusinessProcess();
        });
        table.render({
            elem: '#StfBusinessProcess_datagrid',
            url: ctx + '/StfBusinessProcess/findAll',
            page: true,
            method: "post",
            height: 'full-100',
            where: {
                type: flowtype,
                businessTypeId: data.currentData.id,
                search: $("#searchStfBusinessProcess").val()
            },
            limit: 20,
            loading: true,
            limits: [10, 20, 30, 40, 50, 60, 70, 80, 90],
            cols: [[ //表头
                {field: 'resId', type: 'radio', width: 50},
                {
                    field: 'resId', title: '明细', width: 80, align: 'center',
                    templet: function (d) {
                        //value表示字段的值,rowData行记录数据,index行索引
                        return '<a href="javascript:openFormDetail(\'' + d.resId + '\')"><i class="layui-icon">&#xe63c;</i></a>';
                    }
                },
                {field: 'flowName', title: '显示名称', minWidth: 150},
                {field: 'businessTypeName', title: '业务目录', minWidth: 130},
                {field: 'designName', title: '定义名称', minWidth: 220},
                {field: 'typeName', title: '流程类型', minWidth: 80},
                {field: 'memo', title: '说明', minWidth: 250}
            ]],
            request: {
                pageName: 'page', //页码的参数名称，默认：page
                limitName: 'rows' //每页数据量的参数名，默认：limit
            },
            response: {
                statusCode: 200
            }
        });

    });
}

function reloadGrid() {
    var flowtype = selectflow.val();
    layui.use('table', function () {
        var table = layui.table;
        table.reload('StfBusinessProcess_datagrid', {
            where: {
                type: flowtype,
                businessTypeId: data.currentData.id,
                search: $("#searchStfBusinessProcess").val()
            },
            page: {
                curr: 1
            }
        });
    });
}

function searchStfBusinessProcess() {
    reloadGrid();
}

//增加数据字典
function addStfBusinessProcess() {
    if (data.currentData.id !== '') {
        layui.use('layer', function () {
            var layer = layui.layer;
            layer.open({
                type: 2,
                title: '新增记录',
                area: ['500px', '350px'],
                maxmin: true,
                content: [ctx + '/StfBusinessProcess/get-form?businessTypeId=' + data.currentData.id, 'no']
            });

            /*openSaveDialog({
                title: "流程属性",
                contenturl: "/StfBusinessProcess/get-form",
                submiturl: "/StfBusinessProcess/saveStfBusinessProcess?businessTypeId=" + data.currentData.id,
                callback: reloadGrid
            });*/
        });
    } else {
        alertInfo('请选择一个业务流程');
    }


}

//修改数据字典
function editStfBusinessProcess() {
    layui.use(['table', 'layer'], function () {
        var table = layui.table;
        var layer = layui.layer;
        var checkStatus = table.checkStatus('StfBusinessProcess_datagrid');
        if (checkStatus.data.length > 0) {
            var id = checkStatus.data[0].resId;
            layer.open({
                type: 2,
                title: '修改记录',
                area: ['500px', '350px'],
                maxmin: true,
                content: [ctx + '/StfBusinessProcess/get-form?id=' + id, 'no']
            });


            /*openSaveDialog({
                title: "修改记录",
                contenturl: "/StfBusinessProcess/get-form",
                submiturl: "/StfBusinessProcess/saveStfBusinessProcess?id=" + id,
                onload: "/StfBusinessProcess/findStfBusinessProcess?id=" + id,
                callback: reloadGrid
            });*/
        } else {
            alertInfo('请选择一条记录进行修改');
        }
    });
}

//查看表单明细
function openFormDetail(resId) {
    layui.use('layer', function () {
        var layer = layui.layer;
        var index = layer.open({
            type: 2,
            title: "查看记录",
            area: ['70%', '70%'],
            maxmin: true,
            content: [ctx + '/StfBusinessProcess/detail?resId=' + resId, 'no']
        });
    });
}

//删除数据字典
function delStfBusinessProcess() {
    layui.use('table', function () {
        var table = layui.table;
        var checkStatus = table.checkStatus('StfBusinessProcess_datagrid');
        if (checkStatus.data.length > 0) {
            var id = checkStatus.data[0].resId;
            alertConfirmYes('您是否要删除当前选中的数据？', function (r) {
                if (r) {
                    $.ajax({
                        url: ctx + "/StfBusinessProcess/delStfBusinessProcess",
                        data: {
                            id: id
                        },
                        dataType: 'json',
                        success: function (result) {
                            if (result.success) {
                                reloadGrid();
                                alertInfo("删除成功");
                            } else {
                                alertError(result.msg);
                            }
                        }
                    });
                }
            });
        } else {
            alertInfo('请先选择要删除的数据字典信息');
        }
    });
}
