window.console = window.console || (function () {
    var c = {};
    c.log = c.warn = c.debug = c.info = c.error = c.time = c.dir = c.profile
        = c.clear = c.exception = c.trace = c.assert = function () {
    };
    return c;
})();

// 对Date的扩展，将 Date 转化为指定格式的String
// 月(M)、日(d)、小时(h)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，
// 年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
// 例子：
// (new Date()).Format("yyyy-MM-dd hh:mm:ss.S") ==> 2006-07-02 08:09:04.423
// (new Date()).Format("yyyy-M-d h:m:s.S") ==> 2006-7-2 8:9:4.18
Date.prototype.Format = function (fmt) { // author: meizz
    var o = {
        "M+": this.getMonth() + 1, // 月份
        "d+": this.getDate(), // 日
        "h+": this.getHours(), // 小时
        "m+": this.getMinutes(), // 分
        "s+": this.getSeconds(), // 秒
        "q+": Math.floor((this.getMonth() + 3) / 3), // 季度
        "S": this.getMilliseconds() // 毫秒
    };
    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
    return fmt;
};

/**
 * 字符串日期转Date
 *
 * @param DateStr
 * @returns {Date}
 * @constructor
 */
function StringToDate(DateStr) {
    var converted = Date.parse(DateStr);
    var myDate = new Date(converted);
    if (isNaN(myDate)) {
        // var delimCahar = DateStr.indexOf('/')!=-1?'/':'-';
        var arys = DateStr.split('-');
        myDate = new Date(arys[0], --arys[1], arys[2]);
    }
    return myDate;
}

/** 数字金额大写转换(可以处理整数,小数,负数) */
var digitUppercase = function (n) {
    var fraction = ['角', '分'];
    var digit = [
        '零', '壹', '贰', '叁', '肆',
        '伍', '陆', '柒', '捌', '玖'
    ];
    var unit = [
        ['元', '万', '亿'],
        ['', '拾', '佰', '仟']
    ];
    var head = n < 0 ? '欠' : '';
    n = Math.abs(n);
    var s = '';
    for (var i = 0; i < fraction.length; i++) {
        s += (digit[Math.floor(n * 10 * Math.pow(10, i)) % 10] + fraction[i]).replace(/零./, '');
    }
    s = s || '整';
    n = Math.floor(n);
    for (var i = 0; i < unit[0].length && n > 0; i++) {
        var p = '';
        for (var j = 0; j < unit[1].length && n > 0; j++) {
            p = digit[n % 10] + unit[1][j] + p;
            n = Math.floor(n / 10);
        }
        s = p.replace(/(零.)*零$/, '').replace(/^$/, '零') + unit[0][i] + s;
    }
    return head + s.replace(/(零.)*零元/, '元')
        .replace(/(零.)+/g, '零')
        .replace(/^整$/, '零元整');
};

/**
* 获取当前月的第一天
* @returns {Date}
*/
function getCurrentMonthFirst(d){
	   var date = new Date(d);
	   date.setDate(1);
	   var month = parseInt(date.getMonth()+1);
	   var day = date.getDate();
	   if (month < 10) {
	       month = '0' + month
	   }
	   if (day < 10) {
	       day = '0' + day
	   }
	   return date.getFullYear() + '-' + month + '-' + day;
	}

	/**
	* 获取当前月的最后一天
	* @returns {Date}
	*/
	function getCurrentMonthLast(d){
	   var date=new Date(d);
	   var currentMonth=date.getMonth();
	   var nextMonth=++currentMonth;
	   var nextMonthFirstDay=new Date(date.getFullYear(),nextMonth,1);
	   var oneDay=1000*60*60*24;
	   var lastTime = new Date(nextMonthFirstDay-oneDay);
	   var month = parseInt(lastTime.getMonth()+1);
	   var day = lastTime.getDate();
	   if (month < 10) {
	       month = '0' + month
	   }
	   if (day < 10) {
	       day = '0' + day
	   }
	   return date.getFullYear() + '-' + month + '-' + day;
	}

/**
 * 金额数字转大写，上面那个方法精度有问题 例如：33.3300 上面方法返回大写：叁拾叁圆叁角贰分
 *
 * @param money
 * @returns {*}
 */
function convertCurrency(money) {
    // 汉字的数字
    var cnNums = new Array('零', '壹', '贰', '叁', '肆', '伍', '陆', '柒', '捌', '玖');
    // 基本单位
    var cnIntRadice = new Array('', '拾', '佰', '仟');
    // 对应整数部分扩展单位
    var cnIntUnits = new Array('', '万', '亿', '兆');
    // 对应小数部分单位
    var cnDecUnits = new Array('角', '分', '毫', '厘');
    // 整数金额时后面跟的字符
    var cnInteger = '整';
    // 整型完以后的单位
    var cnIntLast = '元';
    // 最大处理的数字
    var maxNum = 999999999999999.9999;
    // 金额整数部分
    var integerNum;
    // 金额小数部分
    var decimalNum;
    // 输出的中文金额字符串
    var chineseStr = '';
    // 分离金额后用的数组，预定义
    var parts;
    if (money == '') {
        return '';
    }
    money = parseFloat(money);
    if (money >= maxNum) {
        // 超出最大处理数字
        return '';
    }
    if (money == 0) {
        chineseStr = cnNums[0] + cnIntLast + cnInteger;
        return chineseStr;
    }
    // 转换为字符串
    money = money.toString();
    if (money.indexOf('.') == -1) {
        integerNum = money;
        decimalNum = '';
    } else {
        parts = money.split('.');
        integerNum = parts[0];
        decimalNum = parts[1].substr(0, 4);
    }
    // 获取整型部分转换
    if (parseInt(integerNum, 10) > 0) {
        var zeroCount = 0;
        var IntLen = integerNum.length;
        for (var i = 0; i < IntLen; i++) {
            var n = integerNum.substr(i, 1);
            var p = IntLen - i - 1;
            var q = p / 4;
            var m = p % 4;
            if (n == '0') {
                zeroCount++;
            } else {
                if (zeroCount > 0) {
                    chineseStr += cnNums[0];
                }
                // 归零
                zeroCount = 0;
                chineseStr += cnNums[parseInt(n)] + cnIntRadice[m];
            }
            if (m == 0 && zeroCount < 4) {
                chineseStr += cnIntUnits[q];
            }
        }
        chineseStr += cnIntLast;
    }
    // 小数部分
    if (decimalNum != '') {
        var decLen = decimalNum.length;
        for (var i = 0; i < decLen; i++) {
            var n = decimalNum.substr(i, 1);
            if (n != '0') {
                chineseStr += cnNums[Number(n)] + cnDecUnits[i];
            }
        }
    }
    if (chineseStr == '') {
        chineseStr += cnNums[0] + cnIntLast + cnInteger;
    } else if (decimalNum == '') {
        chineseStr += cnInteger;
    }
    return chineseStr;
}

// grid金钱格式化函数
function formatterMoney(value) {
    if (value === null || value === "") {
        return value;
    }
    return $.FormatMoney(value, 2);
}

// 金额千分位格式化
function formatCurrency(num) {
	if (!num) {
        return num;
    }
    num = num.toString().replace(/\$|\,/g, '');
    if (isNaN(num))
        num = "0";
    sign = (num == (num = Math.abs(num)));
    num = Math.floor(num * 100 + 0.50000000001);
    cents = num % 100;
    num = Math.floor(num / 100).toString();
    if (cents < 10)
        cents = "0" + cents;
    for (var i = 0; i < Math.floor((num.length - (1 + i)) / 3); i++)
        num = num.substring(0, num.length - (4 * i + 3)) + ',' +
            num.substring(num.length - (4 * i + 3));
    return (((sign) ? '' : '-') + num + '.' + cents);
}


/**
 * 取得地址栏参数
 *
 * @param {}
 *            name
 * @return {}
 */
function getUrlParam(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)"); // 构造一个含有目标参数的正则表达式对象
    var r = window.location.search.substr(1).match(reg);  // 匹配目标参数
    // 返回参数值
    if (r != null) {
        return unescape(r[2]);
    }
    return null;
}


/**
 * 使用企查查查询单位名称
 *
 * @param {}
 *            name
 * @return {}
 */
function openOrgNameQueryUrl() {
    if ($("#contactOrgName").val()) {
// window.open(encodeURI("http://www.tianyancha.com/search?key="+$("#contactOrgName").val()+"&checkFrom=searchBox"));//调用天眼查
        window.open(encodeURI("https://www.qichacha.com/search?key=" + $("#contactOrgName").val()));// 调用企查查
    } else {
        alertInfo('请输入单位名称');
    }
}

/**
 * 解析Url 取得传入地址栏参数 - 根据键名获取url参数 yzhao - 2014.10.16
 *
 * @param name
 *            要查询的参数名称
 * @param url
 *            传入的url(地址栏)
 * @returns 参数的传入值
 */
function getUrlParamValue(name, url) {
    // 1.i:执行对大小写不敏感的匹配 2.g:执行全局匹配（查找所有匹配而非在找到第一个匹配后停止）
    var rs = new RegExp("(^|)" + name + "=([^\&]*)(\&|$)", "g").exec(url);
    if (rs) {
        return rs[2];
    } else {
        // parameter cannot be found
        return "";
    }
}

/**
 * 封装message alert方法
 *
 */
var alertInfo = function (msg) {
    if (typeof(msg) == "object") {
        var content = '<div id="layermsgtitle" >' + msg.title + '! </div>' +
            '<div id="layermsgdetail" style="display:none;width:300px;overflow:auto">' +
            '<font style="color:red;">明细:' + msg.detail + '</font></div>';
        layer.open({
            title: '提示信息',
            icon: 6,
            content: content,
            success: function (layerE) {
                if ($("#layermsgtitle")) {
                    $("#layermsgtitle").dblclick(function () {
                        $("#layermsgdetail").toggle();
                        var index = layer.getIndex(this);
                        layer.autoArea(index);
                    });
                }
            }
        });
    } else {
        layer.msg(msg, {icon: 6});
    }

// $.messager.alert('提示',msg+'。','info');
};
var alertWarn = function (msg) {
    var content = msg + "!";
    if (typeof(msg) == "object") {
        content = '<div id="layermsgtitle" >' + msg.title + '! </div>' +
            '<div id="layermsgdetail" style="display:none;width:300px;overflow:auto">' +
            '<font style="color:red;">明细:' + msg.detail + '</font></div>';
    }
    layer.open({
        title: '提示信息',
        icon: 0,
        content: content,
        success: function (layerE) {
            if ($("#layermsgtitle")) {
                $("#layermsgtitle").dblclick(function () {
                    $("#layermsgdetail").toggle();
                });
            }
        }
    });

};
var alertError = function (msg) {
    var content = msg + "!";
    if (typeof(msg) == "object") {
        content = '<div id="layermsgtitle" >' + msg.title + '! </div>' +
            '<div id="layermsgdetail" style="display:none;width:300px;overflow:auto">' +
            '<font style="color:red;">明细:' + msg.detail + '</font></div>';
    }
    layer.open({
        title: '提示信息',
        icon: 5,
        content: content,
        success: function (layerE) {
            if ($("#layermsgtitle")) {
                $("#layermsgtitle").dblclick(function () {
                    $("#layermsgdetail").toggle();
// var index=layer.getIndex(this);
// layer.autoArea(index);
                });
            }
        }
    });
};
var alertConfirm = function (msg, func) {
    layer.confirm(msg, {
        icon: 3,
        yes: function () {
            if (typeof(func) == "function") func(true);
        }, no: function () {
            if (typeof(func) == "function") func(false);
        }
    });
}
var alertConfirmYes = function (msg, func, title) {
    layer.confirm(msg, {icon: 3, btn: ['是', '否'], title: title}, function (index) {
        // do something
        if (typeof(func) == "function") func(true);
        layer.close(index);
    }, function (index) {
        if (typeof(func) == "function") func(false);
    });
}

var alertConfirmYes1 = function (msg, func, title) {
    layer.confirm(msg, {
        icon: 3,
        btn: ['是', '否', '取消'],
        yes: function (index) {
            if (typeof(func) == "function") func(true);
            layer.close(index);
        }, btn2: function (index) {
            if (typeof(func) == "function") func(false);
        }, btn3: function (index) {
            layer.close(index);
        }
    });
}

/**
 * 判断指定ID的控件是否是easyui 组件
 *
 * @param {}
 *            element
 * @return {Boolean}
 */
function haseasyui(element) {
    if ($(element).length > 0 && ($(element).attr("data-options") || $(element).hasClass("panel-body"))) {
        return true;
    } else {
        return false;
    }
}

/**
 * 封装打开窗口的方法 options.title 标题 options.contenturl 内容的地址 options.submiturl 表单提交的地址
 * options.width 宽度 options.height 高度 options.callback 提交成功后的回调 options.onload
 * 内容加载成功后需要做的操作 nstring类型为地址 会根据地址请求的数据加载表单 function 为加载成功后需要执行的函数
 * options.onsubmit 提交前要进行的操作
 */
function openSaveDialog(_options) {
    var options = {
        title: '窗口',
        contenturl: '',
        submiturl: '',
        width: 500,
        height: 350,
        maximized: false,
        autoClose:true
    }
    $.extend(options, _options);
    var fncOnSubmit = options.onsubmit;
    var callback = options.callback;
    var fncOnLoad = options.onload;
    var fncOnClose = options.onclose;
    var error = options.error
    if (options.maximized) {
        options.sureText = options.sureText ? options.sureText : '保存';
        options.closeText = options.closeText ? options.closeText : '返回';
        options.draggable = false;
    } else {
        options.sureText = options.sureText ? options.sureText : '确定';
        options.closeText = options.closeText ? options.closeText : '取消';
        options.draggable = true;
    }
    var uuid = generateUUID();
    // 循环添加自定义按钮
    var resToolBar = [];
    // 如果有请求路径,则提供保存按钮
    if (options.submiturl) {
        resToolBar.push({
            text: options.sureText,
            id : 'save',
            iconCls: 'icon-disk',
            handler: function () {
                var okbutton = $(this);
                var d = $(this).closest('.window').find('.window-body');
                var submitform = $("form", "#open_dialog" + uuid);
                if (options.submitbtn) {
                    submitform = $("#" + options.submitbtn);
                }
                submitform.form('enableValidation');
                submitform.form('submit', {
                    dataType: 'json',
                    method: "POST",
                    url: ctx + options.submiturl,
                    onSubmit: function (param) {
                        if ($(this).form('validate')) {
                            if (fncOnSubmit && typeof(fncOnSubmit) === "function") {
                                if (fncOnSubmit(param)) {
                                    if ($(this).form('validate')) {
                                        layer.msg('提交中', {icon: 16, shade: 0.3, time: 0});
                                    } else {
                                        return false;
                                    }
                                    okbutton.linkbutton('disable');// 防止重复提交
                                    return true;
                                } else {
                                    return false;
                                }
                            } else {
                                layer.msg('提交中', {icon: 16, shade: 0.3, time: 0});
                                okbutton.linkbutton('disable');// 防止重复提交
                                return true;
                            }
                        } else {
                            return false;
                        }
                    },
                    success: function (result) {
                        var reg = new RegExp("\\&quot;", "g");// g,表示全部替换。
                        result = jQuery.parseJSON(result.replace(reg, ""));
                        if (result.success) {
                            layer.closeAll();
                            options.autoClose&&d.dialog('destroy');
                            (callback && typeof(callback) === "function") && callback(result);
                            alertInfo(result.msg);
                            if(!options.autoClose){
                            	okbutton.linkbutton('enable');// 防止重复提交
                            }
                        } else {
                            layer.closeAll();
                            alertError(result.msg);
                            (error && typeof(error) === "function") && error(result);
                            okbutton.linkbutton('enable');// 信息错误 则启用按钮
                        }
                    }
                });
            }
        });
        if (options.maximized) {
            resToolBar.push('-');
        }
    }
    // 拼装自定义按钮
    if (options.bottons) {
        for (var i = 0; i < options.bottons.length; i++) {
            resToolBar.push(options.bottons[i]);
            if (options.maximized) {
                resToolBar.push('-');
            }
        }
    }
    // 拼装返回按钮
    resToolBar.push({
        text: options.closeText,
        iconCls: 'icon-dialog-cancel',
        handler: function () {
            if (fncOnClose && typeof(fncOnClose) === "function") {
                fncOnClose()
            }

            var d = $(this).closest('.window').find('.window-body');
            d.dialog('destroy');
        }
    });

    $('<div/>').dialog({
        id: "open_dialog" + uuid,
        href: ctx + options.contenturl,
        style: {overflowX: 'hidden'},
        width: options.width,
        height: options.height,
        modal: true,
        title: options.title,
        maximized: options.maximized,
        draggable: options.draggable,
        toolbar: options.maximized ? resToolBar : '',
        buttons: options.maximized ? '' : resToolBar,
        inline: false,
        onClose: function () {
            if (fncOnClose && typeof(fncOnClose) === "function") {
                fncOnClose()
            }
            $(this).dialog('destroy');
        },
        onLoad: function () {
// $.parser.parse();
            if (fncOnLoad && typeof(fncOnLoad) === "string") {
                $.ajax({
                    type: 'post',
                    dataType: 'json',
                    url: ctx + fncOnLoad,
                    success: function (data) {
                        var submitform = $("form", "#open_dialog" + uuid);
                        if (options.submitbtn) {
                            submitform = $("#" + options.submitbtn);
                        }
                        submitform.form('load', data);
                    }
                });
            } else if (fncOnLoad && typeof(fncOnLoad) === "function") {
                fncOnLoad()
            }
        }
    });
}
function openDetailDialog(_options) {
// var options={
// title:options.title?options.title:'窗口',
// maximized:options.maximized?options.maximized:false,
// contenturl:options.contenturl?options.contenturl:'',
// width:options.width?options.width:500,
// height:options.height?options.height:300,
// onload:options.onload
// }
    var options = {
        title: '窗口',
        contenturl: '',
        submiturl: '',
        width: 500,
        height: 300,
        maximized: false
    }

    $.extend(options, _options);
    var fncOnLoad = options.onload;
    var fncOnClose = options.onclose;
// if($("#open_dialog").length>0){
// return;
// }

    // 循环添加自定义按钮
    var resToolBar = [];
    // 拼装自定义按钮
    if (options.bottons) {
        for (var i = 0; i < options.bottons.length; i++) {
            resToolBar.push(options.bottons[i]);
            if (options.maximized) {
                resToolBar.push('-');
            }
        }
    }

    // 拼装返回按钮
    resToolBar.push({
        text: '关闭',
        iconCls: 'icon-dialog-cancel',
        handler: function () {
        	if (fncOnClose && typeof(fncOnClose) === "function") {
                fncOnClose()
            }

            var d = $(this).closest('.window').find('.window-body');
            d.dialog('destroy');
        }
    });
    var dialogoptions = {
            id: "open_dialog",
            style: {overflowX: 'hidden'},
            width: options.width,
            height: options.height,
            modal: true,
            title: options.title,
            maximized: options.maximized,
            inline: false,
            toolbar: '',
            buttons: options.maximized ? '' : resToolBar,
            onClose: function () {
            	if (fncOnClose && typeof(fncOnClose) === "function") {
                    fncOnClose()
                }
                $(this).dialog('destroy');
            },
            onLoad: function () {
                if (fncOnLoad && typeof(fncOnLoad) === "string") {
                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        url: ctx + fncOnLoad,
                        success: function (data) {
                            var submitform = $("form",
                                "#open_dialog");
                            if (options.submitbtn) {
                                submitform = $("#" + options.submitbtn);
                            }
                            submitform.form('load', data);
                        }
                    });
                } else if (fncOnLoad && typeof(fncOnLoad) === "function") {
                    fncOnLoad()
                }
            }
        };

    if(options.isframe){
    	dialogoptions.content="<iframe frameborder='0'  style='display:block;border:0;width:100%;height:100%;' src='"+ctx + options.contenturl+"'></iframe>";
    }else{
    	dialogoptions.href=ctx + options.contenturl;
    }
    $('<div/>').dialog(dialogoptions);
}

function openChooseDialog(_options) {
// var options={
// title:options.title?options.title:'窗口',
// contenturl:options.contenturl?options.contenturl:'',
// width:options.width?options.width:500,
// height:options.height?options.height:300,
// okhandler:options.okhandler,
// onload:options.onload,
// bottons:options.bottons
// }
    var options = {
// id:'',
        title: '窗口',
        contenturl: '',
        submiturl: '',
        width: 500,
        height: 300,
        maximized: false
    }
    $.extend(options, _options);

    var okhandler = options.okhandler;
    var onload = options.onload;
    var callback = options.callback;
    var onclose = options.onclose;

    // 循环添加自定义按钮
    var resToolBar = [];

    // 拼装自定义按钮
    if (options.bottons) {
        for (var i = 0; i < options.bottons.length; i++) {
            resToolBar.push(options.bottons[i]);
            if (options.maximized) {
                resToolBar.push('-');
            }
        }
    }

    resToolBar.push({
        text: options.sureText ? options.sureText : '确定',
        iconCls: 'icon-disk',
        handler: function () {
            var okbutton = $(this);
            var d = $(this).closest('.window').find('.window-body');
            if (okhandler && typeof(okhandler) === "function") {
                if (okhandler()) {
                    d.dialog('destroy');
                    (callback && typeof(callback) === "function") && callback();
                }
            } else {
                d.dialog('destroy');
            }
        }
    });

    resToolBar.push({
        text: '取消',
        iconCls: 'icon-dialog-cancel',
        handler: function () {
            if (onclose && typeof(onclose) === "function") {
                onclose()
            }

            var d = $(this).closest('.window').find('.window-body');
            d.dialog('destroy');
        }
    });

    $('<div/>').dialog({
        id: options.id,
        href: ctx + options.contenturl,
        style: {overflowX: 'hidden'},
        width: options.width,
        height: options.height,
        modal: true,
        title: options.title,
// maximized:true,
        inline: false,
        buttons: resToolBar,
        onClose: function () {
            if (onclose && typeof(onclose) === "function") {
                onclose()
            }

            $(this).dialog('destroy');
        },
        onLoad: function () {
            (onload && typeof(onload) === "function") && onload();
        }
    });
}


function downloadFile(options) {
    var options = {
        versionid: options.versionid ? options.versionid : '',
        usebase: (options.usebase == false) ? false : true// usebase使用基础版本
        // 传入false择使用version对应的版本,否则
        // 使用version对应的基础版本
    }
    window.open(ctx + "/file/download?versionid=" + options.versionid + "&usebase=" + options.usebase);
}

function downloadhelpFile(filename) {
    window.open(ctx + "/file/downloadhelpfile?filename=" + filename);
}


function previewFile(options) {
    var options = {
        versionid: options.versionid ? options.versionid : '',
        usebase: (options.usebase == false) ? false : true// usebase使用基础版本
        // 传入false择使用version对应的版本,否则
        // 使用version对应的基础版本
    }
    window.open(ctx + "/file/preview?versionid=" + options.versionid + "&&usebase=" + options.usebase, null, "");
}

function choosedownloadfiles(options) {
	$.post(ctx+"/file/getdownloadcount",{
		formcode: options.formcode,
		Panelid:options.panelid ,
		PK:options.pk,
		fileTypeId:(options.fileTypeId?options.fileTypeId:'')
	},function(result){
		if(result.o.length==1){
			 window.open(ctx + "/file/downloadfiles?versionids=" + result.o[0].fileVersionId);
		}else{
			openChooseDialog({
		        title: "选择要打包下载的文件",
		        contenturl: '/file/choosedownloadfiles?formcode=' + options.formcode + "&Panelid=" + options.panelid + "&PK=" + options.pk+ "&fileTypeId=" + (options.fileTypeId?options.fileTypeId:''),
		        width: 600,
		        height: 400,
		        okhandler: function () {
		            var rows = $('#choosedownloadfilesgrid').datagrid('getSelections');
		            if (rows.length > 0) {
		                var versionids = [];
		                for (var i = 0; i < rows.length; i++) {
		                    versionids.push(rows[i].versionid);
		                }
		                window.open(ctx + "/file/downloadfiles?versionids=" + versionids.join(','));
		                return true;
		            } else {
		                alertInfo("请选择要打包下载的文件");
		                return false;
		            }
		        }
		    })
		}
	},'json');
}


function printQrcode(options) {
    var options = {
        versionid: options.versionid ? options.versionid : '',
        usebase: (options.usebase == false) ? false : true// usebase使用基础版本
        // 传入false择使用version对应的版本,否则
        // 使用version对应的基础版本
    }
    openDetailDialog({
        title: "二维码查看",
        width: 300,
        height: 400,
        contenturl: "/qrcode/genqrcode?versionid=" + options.versionid + "&&usebase=" + options.usebase
    });
}

// 删除签章
function DeleteSignature() {
    var mLength = document.getElementsByName("iHtmlSignature").length;
    var mSigOrder = "";
    for (var i = mLength - 1; i >= 0; i--) {
        var vItem = document.getElementsByName("iHtmlSignature")[i];
        // mSigOrder :=
        if (vItem.SignatureOrder == "1") {
            vItem.DeleteSignature();
        }
    }
}

// 生成uuid
function generateUUID() {
    var d = new Date().getTime();
    var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = (d + Math.random() * 16) % 16 | 0;
        d = Math.floor(d / 16);
        return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
    });
    return uuid;
}

// 查看流程
function viewFlowDialog(processInstId) {
    if (processInstId) {
// window.open(ctx+'/viewwf/viewFlow?processInstId='+processInstId,'');
        var btn =
            "<a  class=\"easyui-linkbutton\" style=\"width:90px;margin-bottom:5px;\" href=\"javascript:void(0)\" data-options=\"iconCls:'icon-new',plain:false\" onclick=\"viewFlowChart()\">\n" +
            "<span style=\"height:26px;line-height:26px;\" >\n" +
            "<span class=\"l-btn-icon icon-viewflow\" style=\"\"></span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;查看流程</span></a>";
        openDetailDialog({
            title: "查看流程" + btn,
            width: 750,
            height: 500,
            bottons: [{
                text: '查看流程',
                iconCls: 'icon-viewflow',
                handler: viewFlowChart
            }],
            contenturl: '/view/sys/workFlowView?processInstId=' + processInstId
        });
    } else {
        alertInfo('该数据信息没有流程实例');
    }

}

function viewFlowChart() {
    window.open(ctx + '/viewwf/viewFlow?processInstId=' + processinstid, '');
}
/**
 * 验证流程权限和业务信息校验后在弹出流程提交弹窗
 *
 * @param {}
 *            _options
 */
function openFlowDialog(_options){
    var options = {
        title: "流程操作",
        processInstId: null,
        businessMainId: null,
        formCode: null,
        callback: null,
        msgtitle: null,
        params: {},
        dialogoptions: {},
        msgid: '',
        showtodo: false,
        msglevel: 0,
        onsubmit: null,
        advice: null
    }
    $.extend(options, _options);
    if (!options.processInstId) {
        alertInfo("该数据信息没有流程实例");
        return;
    }
    if (!options.businessMainId || !options.formCode) {
        alertInfo("业务主键和表单编码不能为空");
        return;
    }
    if ($("#flow_dialog").length > 0) {
        return;
    }
    if (!options.params) {
        options.params = {};
    }
    var conditon = "";
    options.params.processInstId = options.processInstId;
    options.params.businessMainId = options.businessMainId;
    options.params.formCode = options.formCode;
    options.params.showtodo = options.showtodo;
    checkFlow(options.params,function(wfActivityParams){
    	options.wfActivityParams=wfActivityParams;
    	openFlowDialog_action(options);
    });
}
/**
 * 检查流程提交合法性 有无非法提示信息和确认信息
 */
function checkFlow(params,callback){
	$.ajax({
        url: ctx + "/wf/getWfActivityParams",
        data: {
            processInstId : params.processInstId,
            conditon : JSON.stringify(params)
        },
        dataType: 'json',
        success: function (result) {
            if (result.success) {
            	//wfActivityParams.lines下一步可分支的线
            	if(result.o.validate){
            		if(result.o.needConfirm){// 有确认消息
            			alertConfirmYes(result.o.cofirmMsg, function (yes) {
                   						 if (yes) {
                   						 	callback(result.o);
                   						 }
               						 });
            		}else{// 无非法和确认消息
            			callback(result.o);
            		}
            	}else{// 有非法消息不能提交
            		alertWarn(result.o.unvalidateMsg);
            	}

            } else {
                alertError(result.msg);
            }
        }
    });
}
/**
 *
 * @param {}
 *            _options processInstId 流程实例ID /n businessMainId 业务表主键ID: formCode
 *            表单编码 callback 回调函数 msgtitle 消息参数 params 执行流程时传入的参数 options 其他选项
 *            msgid 待办ID showtodo 流程操作页面是否显示待办的超链接
 */
function openFlowDialog_action(options) {
	var lines = options.wfActivityParams.lines;
	//没有操作权限直接返回
	if(!options.wfActivityParams.lines||options.wfActivityParams.lines.length==0){
		alertWarn("您当前没有流程操作权限！");
		return;
	}
	//只有一条线 且下一步节点不能指定参与人员  表单里面有流程意见框（options.advice不为空） 则直接发送流程 不弹出流程弹窗
	if(options.backActId||((lines.length==1||!options.wfActivityParams.allWorkDone)&&(lines[0][5]+"")!="true"&&options.advice)){
		if(options.backActId){
			options.params.backActId = options.backActId;
			options.params.toActId = options.backActId;
			options.params.TH = "TH";
		}else{
			options.params.condition = lines[0][1];
			options.params.toActId = lines[0][2];
			options.params.TH = lines[0][3];
		}
        options.params.title = options.msgtitle;
        options.params.advice = options.advice;
		if(options.wfActivityParams.needConfirm){
			flowSubmit(options.callback, options.params, this, options.onsubmit);
		}else{
			var opname = "提交流程";
	       	 if(options.backActId){
	       		 opname="退回流程到【"+options.backActName+"】节点";

	       	 }
			top.alertConfirmYes("确认"+opname+"？", function (yes) {
					 if (yes) {
						 flowSubmit(options.callback, options.params, this, options.onsubmit);
					 }
				 });
		}
		return;
	}
    var conditon = "";
    conditon = "&conditon=" + encodeURI(JSON.stringify(options.params));
    // 默认配置
    var opendialogoptions = {
        title: '流程操作',
        url: ctx + '/wf/getLineCondition.action?processInstId=' + options.processInstId + "&msglevel=" + options.msglevel + "&showtodo=" + options.showtodo + "&msgid=" + options.msgid + conditon,
        width: 760,
        height: 460
    }
    if (options.dialogoptions) {
        $.extend(opendialogoptions, options.dialogoptions);
    }
    if(options.advice){
    	opendialogoptions.height = 280;
    }
    $('<div/>').dialog({
        id: "flow_dialog",
        href: opendialogoptions.url,
        width: opendialogoptions.width,
        height: opendialogoptions.height,
        modal: true,
        title: opendialogoptions.title,
        buttons: [{
            text: '确定',
            iconCls: 'icon-disk',
            handler: function () {
                if ($("#hasper").val() == "0") {
                    var d = $(this).closest('.window').find('.window-body');
                    d.dialog('destroy');
                    return;
                }
                if ($('#flowForm').form('validate')) {
                    options.params.processInstId = $("#flow_processInstId").val();
                    options.params.businessMainId = $("#flow_businessMainId").val();
                    options.params.formCode = $("#flow_formCode").val();
                    options.params.fromActId = $("#flow_actId").val();
                    options.params.workItemId = $("#flow_workItemId").val();
                    // 对应上面的不再把title传到后台去往复一遍,这里执行流程的时候直接传给后台
                    options.params.title = options.msgtitle;
                    options.params.msglevel = $("#msglevel").combobox('getValue');
                    // params.title=$("#flow_title").val();
                    if ($("#hasper").val() == 0) {// 没有操作权限
				        var d = $(this).closest('.window').find('.window-body');
				        d.dialog('destroy');
				        return;
				    }
				    var toActId=[];// 下一步的节点ID
				    var condition=[];// 线的复杂表达式
				    var nextPerson=[];//接收人
				    var TH;// 改线是否是退回操作
				    var isChecked = false;
				    $('input[name^=line]:checked').each(function () {
				        isChecked = true;
				        TH = $(this).attr("TH");
				        toActId.push($(this).attr("toActId"));
				        condition.push($(this).attr("condition"));
				        var np=$("#nextPerson_"+$(this).attr("toActId")).val();
				        nextPerson.push(np?np:" ");
				    });
				    if (!isChecked) {
				        alertInfo("请选择处理意见");
				        return;
				    }
				    var splitstr = "@#@";
                    options.params.nextPerson = nextPerson.join(splitstr);
				    options.params.condition = condition.join(splitstr);
				    options.params.toActId = toActId.join(splitstr);
			    	options.params.advice = $("#advice").val();
				    options.params.TH = TH;
                    flowSubmit(options.callback, options.params, this, options.onsubmit);
                }else{
                	alertInfo("请完善发送信息")
                }
            }
        }, {
            text: '取消',
            iconCls: 'icon-dialog-cancel',
            handler: function () {
                var d = $(this).closest('.window').find('.window-body');
                d.dialog('destroy');
            }
        }],
        onClose: function () {
            $(this).dialog('destroy');
        },
        onLoad: function () {
        	if(options.advice){
            	$("#advice").closest("tr").hide();
            	$("#advice").textbox("setValue",options.advice);
            }
        }
    });
}

/**
 * 根据流程参数执行流程
 *
 * @param {}
 *            callback 成功回掉函数
 * @param {}
 *            params 执行参数 包含 必需 processInstId condition fromActId toActId TH
 *            businessMainId formCode msgid 非必需 msglevel title advice
 * @param {}
 *            win
 * @param {}
 *            submit
 */
function flowSubmit(callback, params, win, submit) {
    $.messager.progress({
        title: "请稍等",
        msg: "数据提交中...",
        text: "",
        interval: 500
    });
    var isChecked=true;
    // 同意前校验方法
    if (params.TH != 'TH' && submit && typeof(submit) === "function") {
        isChecked = submit();
    }
    if (isChecked) {
        $.ajax({
            type: "POST",
            url: ctx + '/wf/excuteFlow.action',
            data: params,
            dataType: "json",
            success: function (result) {
                $.messager.progress('close');
                if(win){
	                var d = $(win).closest('.window').find('.window-body');
	                d.dialog('destroy');
                }
                if (result.success) {
                    top.alertInfo("流程流转发送成功");
              		 (callback && typeof(callback) === "function") && callback(params);
                } else {
                    top.alertWarn(result.msg);
                }
            },
            error: function (request, textStatus, error) {
                $.messager.progress('close');
            }
        });
    } else {
        $.messager.progress('close');
    }

}


function doFlowWithBatch(_options) {
    var options = {
        title: '批量审批',
        contenturl: ctx + '/view/workflow/flowSubmitBatch',
        submiturl: '',
        width: 500,
        height: 300,
        maximized: false
    }
    $.extend(options, _options);

    $('<div/>').dialog({
        id: "flow_dialog",
        href: options.contenturl,
        width: options.width,
        height: options.height,
        modal: true,
        title: options.title,
        buttons: [{
            text: '确定',
            iconCls: 'icon-disk',
            handler: function () {
                var d = $(this).closest('.window').find('.window-body');
                var flowlinetext = $("input[name='flowline']:checked").next("label").text();
                alertConfirmYes("批量审批将按照您选择的'" + flowlinetext + "',对流程进行统一操作,确定?", function (yes) {
                    if (yes) {
                        $.messager.progress({
                            title: "请稍等",
                            msg: "数据提交中...",
                            text: "",
                            interval: 500
                        });
                        $.ajax({
                            type: "POST",
                            url: ctx + '/wf/excuteFlowWithMsgIds',
                            data: {
                                msgIds: _options.msgIds,
                                flowline: $("input[name='flowline']:checked").val(),
                                advice: $("#advice").val()
                            },
                            dataType: "json",
                            success: function (result) {
                                $.messager.progress('close');
                                if (result.success) {
                                    alertInfo("流程流转发送成功");
                                } else {
                                    alertWarn(result.msg);
                                }

                                d.dialog('destroy');
                                (options.callback && typeof(options.callback) === "function")
                                && options.callback();
                            },
                            error: function (request, textStatus, error) {
                                $.messager.progress('close');
                            }
                        });
                    }
                })
            }
        }, {
            text: '取消',
            iconCls: 'icon-dialog-cancel',
            handler: function () {
                var d = $(this).closest('.window').find('.window-body');
                d.dialog('destroy');
            }
        }],
        onClose: function () {
            $(this).dialog('destroy');
        },
        onLoad: function () {
        }
    });

}

/** *************************************************弹出窗口操作********************************************* */
/**
 * 格式化弹出框操作对象
 *
 * @param o
 *            操作的input对象
 * @return inputobj
 */
function formatterInputobj(o) {
    // 弹出框操作对象
    var inputobj = {
        inputId: '',
        inputText: ''
    }

    // indexOf() 方法可返回某个指定的字符串值在字符串中首次出现的位置
    if (o && o.id && o.id.toString().indexOf("_TEXT_") > -1) {
        inputobj.inputId = o.id.split("_TEXT_")[0];
        inputobj.inputText = o.id;
    } else {
        inputobj.inputId = o.id;
    }
    return inputobj;
}


// 鼠标移动提示框
function formatterTip(value) {
    if (value === null || value === "") {
        return value;
    }
    return '<li title="' + value + '" class="tip">' + value + '</li>';
}

// 格式化日期 返回年月 可编辑表格
function dateformatter(value, row) {
    if (value != undefined && value != null && value != '') {
        value = value.replace(/-/g, "/");
        var date = new Date(value);
        return date.Format("yyyy-MM");
    }
    return value;
}

// grid金钱元->万元
function formatterMoney2(value) {
    return $.FormatMoney(parseFloat(value / 10000), 6);
}

// 智能判断赋值
function autoSetValue(id, value) {
    var obj = $("#" + id);
    if(obj.length>0){
    	var objCls = obj.attr("class");
        if (id && objCls && objCls.indexOf("easyui") != -1) {
            if (objCls.indexOf("numberbox") != -1) {
                obj.numberbox('setValue', value);
            } else if (objCls.indexOf("datebox") != -1) {
                obj.datebox('setValue', value);
            } else if (objCls.indexOf("combobox") != -1) {
                obj.combobox('setValue', value);
            }else if (objCls.indexOf("combotree") != -1) {
                obj.combotree('setValue', value);
            } else {
                obj.textbox('setValue', value);
            }
        } else if (id) {
            obj.val(value);
        }
    }
}

function monthDayFormatter(date) {
    var y = date.getFullYear();
    var m = date.getMonth() + 1;
    var d = date.getDate();
    if (m < 10) {
        m = "0" + m;
    }
    if (d < 10) {
        d = "0" + d;
    }
    return m + '-' + d;
}

function monthDayParser(s) {
    s = s.split(" ")[0];
    if (s.length < 7) {
        s = new Date().getFullYear() + "-" + s;
    }
    var t = Date.parse(s);
    if (!isNaN(t)) {
        return new Date(t);
    } else {
        return new Date();
    }
}

// 多选下拉框清空","
function formatterMultCombobox(newValue, oldValue) {
    if (newValue.length == 1 && !newValue[0]) {
        $('#' + this.id).combobox('clear');
    }
}


function updataMsgisRead(msgid) {
    if (msgid) {
        $.ajax({
            type: "POST",
            url: ctx + "/BasMessage/setMsgIsRead",
            data: "msgIds=" + msgid,
            dataType: "json",
            success: function (result) {
            }
        });
    }

}

// 计算日期相差天数
function dateDiff(start,sDate2) {
    oDate1 = new Date(start);  // 转换为yyyy-MM-dd格式
    oDate2 = new Date(sDate2);
    iDays = parseInt((oDate2 - oDate1) / 1000 / 60 / 60 / 24); // 把相差的毫秒数转换为天数
    return iDays;  // 返回相差天数
}

// 格式化日期
function myformatter(date) {
    var y = date.getFullYear();
    var m = date.getMonth() + 1;
    var d = date.getDate();
    return y + '-' + (m < 10 ? ('0' + m) : m) + '-' + (d < 10 ? ('0' + d) : d);
}

// 格式化日期 返回年月
function formatterMonth(date) {
// var y = date.getFullYear();
// var m = date.getMonth()+1;
// return y+'-'+(m<10?('0'+m):m);
    return (new Date()).Format("yyyy-MM")
}

// 初始化扫描二维码
var qrstr = "";

function initScanQRCode() {
    qrstr = "";
    // $(".QRCode").unbind("keypress").unbind("keydown");
    $(document).unbind("keypress").unbind("keydown");
    $(document).select();
    $(document).keypress(function (event) {
        if (event.keyCode != 13) {
            qrstr += event.key;
        }

    }).keydown(function () {
        if (event.keyCode == 13) {
            var layerindex = parent.layer.msg('扫描信息识别中...', {
                icon: 16,
                shade: 0.3, time: 0
            });
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: ctx + '/qrcode/scanQRCode',
                data: {
                    params: qrstr
                },
                success: function (result) {
                    parent.layer.close(layerindex);
                    if (result.success) {
                        if (result.o.qrcodetype == "0") {// 附件预览
                            parent.openInMainTab("扫描信息", result.o.url);
                        } else if (result.o.qrcodetype == "3") {//
                            parent.openInMainTab("扫描信息", result.o.url);
                        } else if (result.o.qrcodetype == "4") {//
                            var msg = result.o.message;
                            parent.openInMainTab(msg.msgTitle, result.o.url);
// openFlowDialog({
// processInstId:msg.processinstid,
// businessMainId:msg.busiMainId,
// formCode:msg.formCode,
// msgtitle:msg.msgTitle,
// msgid:msg.msgId,
// showtodo:true
// });
                        }
                    } else {
                        layer.msg('扫描结果:' + result.msg);
                    }
                }
            });
            // console.log(qrstr);
            qrstr = "";

        }
    });
}

function queryByOrg(newValue, oldValue) {
    $('#dept_select').combobox({
        url: ctx + "/basdept/queryDeptCombo?orgId=" + newValue

    });
}

// 改变form表样式 changeCSS($('#id'),"add","combobox");
function changeCSS($id, type, datatype) {//
    if ("add" == type) {
        if (datatype == "textbox") {
            $id.textbox('readonly');
        } else if (datatype == "numberbox") {
            $id.numberbox('readonly');
        } else if (datatype == "datebox") {
            $id.datebox('readonly');
        } else if(datatype == "combotree"){
        	$id.combotree('readonly');
        }else{
            $id.combobox('readonly');
        }
        $id.closest('td').addClass('disableinput');
    } else if (type == "remove") {
        if (datatype == "combobox") {
            $id.combobox('readonly', false);
        } else if (datatype == "datebox") {
            $id.textbox('readonly', false);
        } else if (datatype == "numberbox") {
            $id.numberbox('readonly', false);
        } else if(datatype == "combotree"){
        	$id.combotree('readonly', false);
        } else {
            $id.textbox('readonly', false);
        }
        $id.closest('td').removeClass('disableinput');
    }
}

// 动态设置控件属性 setCss($("#id"),"textbox",true,false,true,false,true);
function setCss($id, datatype, editable, readonly, required, disableinput, clear) {
    if (datatype == "textbox") {
        $id.textbox({
            editable: editable,
            readonly: readonly,
            required: required
        });
        if (clear != null) {
            if (clear) {
                $id.textbox('clear');
            }
        }
    } else if (datatype == "numberbox") {
        $id.numberbox({
            editable: editable,
            readonly: readonly,
            required: required
        });
        if (clear != null) {
            if (clear) {
                $id.numberbox('clear');
            }
        }
    } else if (datatype == "datebox") {
        $id.datebox({
            editable: editable,
            readonly: readonly,
            required: required
        });
        if (clear != null) {
            if (clear) {
                $id.datebox('clear');
            }
        }
    } else if (datatype == "combobox") {
        $id.combobox({
            editable: editable,
            readonly: readonly,
            required: required
        });
        if (clear != null) {
            if (clear) {
                $id.combobox('clear');
            }
        }
    }
    if (disableinput != null) {
        if (disableinput) {
            $id.parent().addClass('disableinput');
        } else {
            $id.parent().removeClass('disableinput');
        }
    }


}

// 计算可编辑表格某列金额之和
function getTotalMoney(index, $id) {
    var totalMoney = 0;
    for (var i = 0; i < index; i++) {
        if ($("#isUse" + i).val() == 'Y') {
            if ($("#" + $id + i).val() != null && $("#" + $id + i).val() != '') {
                totalMoney = parseFloat(totalMoney) + parseFloat($("#" + $id + i).val());
            }

        }
    }
    return totalMoney;
}

/**
 * 通过id获取结尾数字 var index = getEndNumberForStr(this.id);
 *
 * @param str
 * @returns
 */
function getEndNumberForStr(str) {
    var regend = new RegExp("\\d+$");
    str = str.match(regend);
    return str;
}

function hideShowHeader(grid, method, headers) {
    for (var i=0;i<headers.length;i++) {
        grid.datagrid(method, headers[i]);
    }
}

/**
 * @param checkMonth
 *            数据月份 格式: yyyy-MM
 *
 * @returns {Boolean} true 允许上报 false 不允许上报
 */
function checkNowMonth(checkMonth) {
    console.info(checkMonth);
    console.info((new Date()).Format("yyyy-MM"));
    if (checkMonth == (new Date()).Format("yyyy-MM")) {
        return true;
    } else {
        return false;
    }
}
/**
 * html行合并 tableId table id cols []数组 要合并的列
 */
function mergeTableRow(tableId, cols) {
    var tab = document.getElementById(tableId);
    var val, count, start;
    for (var k=0;k<cols.length;k++) {
        var col = cols[k];
        count = 1;
        val = "";
        for (var i = 0; i < tab.rows.length; i++) {
            if (val == tab.rows[i].cells[col].innerHTML) {
                count++;
            } else {
                if (count > 1) { // 合并
                    start = i - count;
                    // console.log("i:" + i + " count:" + count + "start :" +
					// start)
                    tab.rows[start].cells[col].rowSpan = count;
                    for (var j = start + 1; j < i; j++) {
                        tab.rows[j].cells[col].style.display = "none";
                    }
                    count = 1;
                }
                val = tab.rows[i].cells[col].innerHTML;
            }
        }
        if (count > 1) { // 合并，最后几行相同的情况下
            start = i - count;
            tab.rows[start].cells[col].rowSpan = count;
            for (var j = start + 1; j < i; j++) {
                tab.rows[j].cells[col].style.display = "none";
            }
        }
    }
}

function deleteRecord(grid_id, url, idName, calback) {
    var row = $(grid_id).datagrid('getSelections');
    if (row.length == 0) {
        msgWarn('请先选择要删除的数据!');
        return false;
    }
    var idArray = new Array();
    for (var i = 0; i < row.length; i++) {
        idArray.push(row[i][idName]);
    }
    alertConfirm("确定删除数据吗？", function (btn) {
        if (btn) {
            $.messager.progress({
                title: '提示',
                text: '数据处理中，请稍候....'
            }); // 显示进度条
            $.ajax({
                url: ctx + "/" + url,
                data: {
                    id: idArray.join(",")
                },
                dataType: 'json',
                success: function (result) {
                    $.messager.progress('close'); // 如果提交成功则隐藏进度条
                    if (result.success) {
                        $(grid_id).datagrid('reload');
                        alertInfo('删除成功');
                        if (calback) {
                            alertInfo(result.msg);
                        }
                    } else {
                        alertInfo(result.msg ? result.msg : "删除失败");
                    }
                }
            });
        }
    });
    return true;
}

function deleteRow(grid_id, index) {
    $(grid_id).datagrid('deleteRow', index);
}

function onClickDel(index, field, grid_id, url, idName, calback) {
    if (field == "_operate" || field == "" || field == null) {
        $(grid_id).datagrid('selectRow', index);
        var row = $(grid_id).datagrid('getSelected');
        if (row[idName]) {
            deleteRecord(grid_id, url, idName, calback);
        } else {
            deleteRow(grid_id, index);
        }
    }
}

/**
 * 可编辑表格增加一行
 *
 * @param gridId列表id
 * @param row增加的行内容
 *            如：var row = { id:"", name:"", code:"", …… }
 */
function addEditRow(gridId, row) {
    if (row) {
        $(gridId).datagrid('appendRow', row);
    } else {
        $(gridId).datagrid('appendRow', {});
    }
    var rows = $(gridId).datagrid('getRows');
    $(gridId).datagrid('scrollTo', rows.length - 1);
    $(gridId).datagrid('selectRow', rows.length - 1);// 必须选择该行
    $(gridId).datagrid('beginEdit', rows.length - 1);
}

/**
 * 数据字典数据查询 dicType: 数据字典中类型编码 func:回调方法名
 */
getDictionaryOfType = function (dicType, func) {
    $.ajax({
        type: "POST",
        async: false,
        dataType: "json",
        data: {dicType: dicType},
        cache: false,
        url: ctx + "/dic/dics.action",
        success: function (result) {
            if (typeof(func) == "function") {
                func(result);
            }
        }
    });
};

function formDetail(formCode, id, title, maximized) {
    var options = {
        title: '查看明细',
        width: 500,
        height: 300,
        maximized: true
    }
    $.extend(options, {
        title: title,
        maximized: maximized,
        contenturl: "/GenForm/form?formcode=" + formCode + "&isdetail=true&id=" + id
    });
    openDetailDialog(options);
}

function closewin() {
    if (navigator.userAgent.indexOf("Firefox") != -1) {
        window.location.href = "about:blank";
        window.close();
    } else if (navigator.userAgent.indexOf("Chrome") != -1) {
        var opened = window.open('about:blank', '_self');
        opened.opener = null;
        opened.close();
    } else {
        window.opener = null;
        window.open("", "_self");
        window.close();
    }
}

/**
 *
 */
function getCodeMirrorEditor(type, title) {
    return function () {
        editjs(type, title, this)
    }
}

function editjs(type, title, that) {
    var mode = "text/javascript";
    if (type == "sql") {
        mode = "text/x-plsql";
    }
    var editor;
    var content = "<textarea class='form-control' id='CodeMirrorEditor' name='CodeMirrorEditor'></textarea>";
    layer.open({
        title: title ? title : '代码编辑',
        content: content,
        btn: ['确定', '取消'],
        btn1: function (index) {
            $(that).textbox('setValue', editor.getValue());
            layer.close(index);
        }, btn2: function (index) {
            layer.close(index);
        },
        area: ['865px', '525px'],
        success: function (layerE) {
            if ($("#CodeMirrorEditor")) {
                editor = CodeMirror.fromTextArea(document.getElementById("CodeMirrorEditor"), {
                    mode: mode,    // 实现js代码高亮
                    lineNumbers: true,	// 显示行号
                    theme: "dracula",	// 设置主题
                    lineWrapping: true,	// 代码折叠
                    extraKeys: {
                        "Alt-/": "autocomplete",
                        "F11": function (cm) {
                            cm.setOption("fullScreen", !cm.getOption("fullScreen"));
                        },
                        "Esc": function (cm) {
                            if (cm.getOption("fullScreen")) cm.setOption("fullScreen", false);
                        },
                        "'a'": this.completeAfter,
                        "'b'": this.completeAfter,
                        "'c'": this.completeAfter,
                        "'d'": this.completeAfter,
                        "'e'": this.completeAfter,
                        "'f'": this.completeAfter,
                        "'g'": this.completeAfter,
                        "'h'": this.completeAfter,
                        "'i'": this.completeAfter,
                        "'j'": this.completeAfter,
                        "'k'": this.completeAfter,
                        "'l'": this.completeAfter,
                        "'m'": this.completeAfter,
                        "'n'": this.completeAfter,
                        "'o'": this.completeAfter,
                        "'p'": this.completeAfter,
                        "'q'": this.completeAfter,
                        "'r'": this.completeAfter,
                        "'s'": this.completeAfter,
                        "'t'": this.completeAfter,
                        "'u'": this.completeAfter,
                        "'v'": this.completeAfter,
                        "'w'": this.completeAfter,
                        "'x'": this.completeAfter,
                        "'y'": this.completeAfter,
                        "'z'": this.completeAfter,
                        "'.'": this.completeAfter,
                        // "'='": this.completeIfInTag,
                        "Ctrl-Enter": "autocomplete"
                    },
                    indentUnit: 2,// 缩进单位，值为空格数，默认为2 。
                    smartIndent: true,// 自动缩进，设置是否根据上下文自动缩进（和上一行相同的缩进量）。默认为true。
                    foldGutter: true,
                    lint: true,
                    autoRefresh: true,
                    gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter", "CodeMirror-lint-markers"],
                    matchBrackets: true	// 括号匹配
                    // readOnly: true, //只读
                });
                editor.setSize('820px', '400px');
                editor.setValue($(that).textbox('getValue'));
            }
        }
    });
}
/**
 * datagrid评分格式化 数字转☆
 */
function gradeFormatter(value, row, index) {
    if (value == +value) {
        var id = generateUUID();
        return "<div id='grade" + id + "' class='gridgrade' ><div><script>layui.use(['rate'], function(){var rate = layui.rate;rate.render({elem: '#grade" + id + "',value: " + value + ",readonly: true,half:true}); })</script>";
    }
    return value;
}

/**
 * 明细查看页面 如果当前登录人有对应待办则打开带待办处理的页面
 *
 * @param {}
 *            title
 * @param {}
 *            formCode
 */

function openFormMsg(title, formCode, id) {
    openDetailDialog({
        title: title,
        maximized: true,
        contenturl: "/GenForm/form?formcode=" + formCode + "&isdetail=true&checkMsg=true&id=" + id
    });
}

function openWebOfficeDialog(){
	// 自身浏览器打开
    var mhtmlHeight = window.screen.availHeight; // 获得窗口的垂直位置;
    var mhtmlWidth = window.screen.availWidth; // 获得窗口的水平位置;
    var iTop = 0; // 获得窗口的垂直位置;
    var iLeft = 0; // 获得窗口的水平位置;
    var recordId=$("#content").val();
    if(recordId==""||recordId==null){
    	recordId = generateUUID();
    	autoSetValue("content",recordId);
    	// $("#content").val(recordId);
    }
    var templateName="";
    if($("#templateName").length>0){
    	templateName=$("#templateName").textbox("getValue");
    }
    if($("#subject").length>0){
    	templateName=$("#subject").textbox("getValue");
    }
    if(templateName==""){
    	templateName="空文件";
    }
    var url=ctx+"/view/doc/iweboffice/addOrEditOffice?recordId="+recordId+"&templateName="+templateName;
    window.open(url, templateName, 'height=' + mhtmlHeight + ',width=' + mhtmlWidth + ',top=' + iTop + ',left=' + iLeft + ',toolbar=no,menubar=yes,scrollbars=no,resizable=yes, location=no,status=no');
}

function getActionIcon(actName){
	if(actName=="退回"){
		return "icon-page-undo";
	}else if(actName=="上报"){
		return "icon-move-up";
	}else if(actName=="通过"){
		return "icon-apply";
	} else {
		return "icon-approve";
	}
}

// 转驼峰
function transformStr3(str){
    var re=/_(\w)/g;
    return str.replace(re,function ($0,$1){
        return $1.toUpperCase();
    });
}

var incons=['about','add','del','del1','add1','password','xls','file','yonghutouxiang','gerenxinxi','7z','flv',
	'ppt','txt','jpg','set','gif','doc','bmp','avi','mov','mp4','pdf','pr','psd','rar','mp3','tif','cdr','svg','zip','Addprofile'];

// 清除对象中没有值的引用，解决表单赋值的时候掩盖掉默认值的问题
function removeElement(obj){
    var param = {};
    if ( obj === null || obj === undefined || obj === "" ) return param;
    for ( var key in obj ){
        if ( obj[key] !== null && obj[key] !== undefined && obj[key] !== "" ){
            param[key] = obj[key];
        }
    }
    return param;
}
//数组删除元素的方法
Array.prototype.indexOf = function(val) {
	for (var i = 0; i < this.length; i++) {
	if (this[i] == val) return i;
	}
	return -1;
};
Array.prototype.remove = function(val) {
	var index = this.indexOf(val);
	if (index > -1) {
	this.splice(index, 1);
	}
};
