StfBusinessProcess.pageAll
===
select 	a.RES_ID,
				a.BUSINESS_TYPE_ID,
				a.DESIGN_NAME,
				a.MEMO,
				a.RES_CREATE_DATE,
				a.RES_CREATOR,
				a.RES_EDIT_DATE,
				a.RES_EDITOR,
				a.FLOW_NAME,
				a.TYPE,
				t.name business_type_name,
				(case when a.TYPE ='subflow' then '子流程' when a.TYPE ='flow' then '主流程' end) type_name	
from stf_business_process a left join stf_business_type t on t.res_id=a.business_type_id
where 1=1
	#if(businessTypeIds)
	    and a.BUSINESS_TYPE_ID in (:businessTypeIds)	
	#end
	#if(type)
		and a.TYPE = :type
	#end
    #if(search)
        and(
         upper(a.RES_ID) like :search  or 
         upper(a.BUSINESS_TYPE_ID) like :search  or
         upper(a.DESIGN_NAME) like :search  or 
         upper(a.MEMO) like :search  or 
         upper(a.RES_CREATE_DATE) like :search  or 
         upper(a.RES_CREATOR) like :search  or 
         upper(a.RES_EDIT_DATE) like :search  or 
         upper(a.RES_EDITOR) like :search  or 
         upper(a.FLOW_NAME) like :search  or 
         upper(a.TYPE) like :search
        )
    #end
order by a.RES_ID desc


StfBusinessProcess.findStfBusinessProcess
===
select @pageTag(){
				   t.processdefid,
			       t.processdefname,
			       t.processchname,
			       t.description,
			       t.currentstate,
			       decode(t.currentstate,0,'未发布',3,'已发布','修改中') currentstateText,
			       t.versionsign,
			       t.limittime,
			       t.createtime,
			       t.creator,
			       t.updatetime,
			       t.updator,
			       '系统管理员' createName
		@}
  from WF_PROCESSDEFINE t
@where(){
	@if(!isEmpty(processdefname)){
			and t.processdefname=#processdefname#
	@}
@}
 
StfBusinessProcess.getflowByFlowCatId
===
select t.design_name as id,
       t.design_name as value,
       t.design_name || '(' || t.flow_name || ')' as text
  from stf_business_process t
 where t.BUSINESS_TYPE_ID in (:flowCatIds)
